/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.storage.loot.functions;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.ProblemReporter;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootCollector;
import net.minecraft.world.level.storage.loot.LootTableInfo;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionConditional;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionType;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctions;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import org.slf4j.Logger;

public class FunctionReference
extends LootItemFunctionConditional {
    private static final Logger b = LogUtils.getLogger();
    public static final MapCodec<FunctionReference> a = RecordCodecBuilder.mapCodec(instance -> FunctionReference.a(instance).and((App)ResourceKey.a(Registries.bA).fieldOf("name").forGetter(functionReference -> functionReference.c)).apply((Applicative)instance, FunctionReference::new));
    private final ResourceKey<LootItemFunction> c;

    private FunctionReference(List<LootItemCondition> predicates, ResourceKey<LootItemFunction> name) {
        super(predicates);
        this.c = name;
    }

    public LootItemFunctionType<FunctionReference> b() {
        return LootItemFunctions.H;
    }

    @Override
    public void a(LootCollector context) {
        if (!context.b()) {
            context.a(new LootCollector.d(this.c));
        } else if (context.a(this.c)) {
            context.a(new LootCollector.c(this.c));
        } else {
            super.a(context);
            context.a().c(this.c).ifPresentOrElse(reference -> ((LootItemFunction)reference.a()).a(context.a(new ProblemReporter.b(this.c), this.c)), () -> context.a(new LootCollector.a(this.c)));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected ItemStack a(ItemStack stack, LootTableInfo context) {
        LootItemFunction lootItemFunction = context.a().c(this.c).map(Holder::a).orElse(null);
        if (lootItemFunction == null) {
            b.warn("Unknown function: {}", (Object)this.c.a());
            return stack;
        }
        LootTableInfo.e<LootItemFunction> visitedEntry = LootTableInfo.a(lootItemFunction);
        if (context.b(visitedEntry)) {
            ItemStack var5;
            try {
                var5 = (ItemStack)lootItemFunction.apply(stack, context);
            }
            finally {
                context.c(visitedEntry);
            }
            return var5;
        }
        b.warn("Detected infinite loop in loot tables");
        return stack;
    }

    public static LootItemFunctionConditional.a<?> a(ResourceKey<LootItemFunction> key) {
        return FunctionReference.a((List<LootItemCondition> list) -> new FunctionReference((List<LootItemCondition>)list, key));
    }
}

