/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.storage.loot.functions;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.INamable;
import org.slf4j.Logger;

public interface ListOperation {
    public static final MapCodec<ListOperation> a = ListOperation.a(Integer.MAX_VALUE);

    public static MapCodec<ListOperation> a(int maxSize) {
        return f.e.dispatchMap("mode", ListOperation::a, type -> type.g).validate(listOperation -> {
            int i2;
            d replaceSection;
            if (listOperation instanceof d && (replaceSection = (d)listOperation).c().isPresent() && (i2 = replaceSection.c().get().intValue()) > maxSize) {
                return DataResult.error(() -> "Size value too large: " + i2 + ", max size is " + maxSize);
            }
            return DataResult.success((Object)listOperation);
        });
    }

    public f a();

    default public <T> List<T> a(List<T> currentValue, List<T> operand) {
        return this.a(currentValue, operand, Integer.MAX_VALUE);
    }

    public <T> List<T> a(List<T> var1, List<T> var2, int var3);

    public static final class f
    extends Enum<f>
    implements INamable {
        public static final /* enum */ f a = new f("replace_all", net.minecraft.world.level.storage.loot.functions.ListOperation$c.c);
        public static final /* enum */ f b = new f("replace_section", net.minecraft.world.level.storage.loot.functions.ListOperation$d.b);
        public static final /* enum */ f c = new f("insert", net.minecraft.world.level.storage.loot.functions.ListOperation$b.b);
        public static final /* enum */ f d = new f("append", net.minecraft.world.level.storage.loot.functions.ListOperation$a.c);
        public static final Codec<f> e;
        private final String f;
        final MapCodec<? extends ListOperation> g;
        private static final /* synthetic */ f[] h;

        public static f[] values() {
            return (f[])h.clone();
        }

        public static f valueOf(String name) {
            return Enum.valueOf(f.class, name);
        }

        private f(String id, MapCodec<? extends ListOperation> mapCodec) {
            this.f = id;
            this.g = mapCodec;
        }

        public MapCodec<? extends ListOperation> a() {
            return this.g;
        }

        @Override
        public String c() {
            return this.f;
        }

        private static /* synthetic */ f[] b() {
            return new f[]{a, b, c, d};
        }

        static {
            h = net.minecraft.world.level.storage.loot.functions.ListOperation$f.b();
            e = INamable.a(f::values);
        }
    }

    public static final class d
    extends Record
    implements ListOperation {
        private final int c;
        private final Optional<Integer> d;
        private static final Logger e = LogUtils.getLogger();
        public static final MapCodec<d> b = RecordCodecBuilder.mapCodec(instance -> instance.group((App)ExtraCodecs.o.optionalFieldOf("offset", (Object)0).forGetter(d::b), (App)ExtraCodecs.o.optionalFieldOf("size").forGetter(d::c)).apply((Applicative)instance, d::new));

        public d(int offset) {
            this(offset, Optional.empty());
        }

        public d(int offset, Optional<Integer> size) {
            this.c = offset;
            this.d = size;
        }

        @Override
        public f a() {
            return f.b;
        }

        @Override
        public <T> List<T> a(List<T> currentValue, List<T> operand, int maxSize) {
            ImmutableList list;
            int size = currentValue.size();
            if (this.c > size) {
                e.error("Cannot replace when offset is out of bounds");
                return currentValue;
            }
            ImmutableList.Builder builder = ImmutableList.builder();
            builder.addAll(currentValue.subList(0, this.c));
            builder.addAll(operand);
            int i2 = this.c + this.d.orElse(operand.size());
            if (i2 < size) {
                builder.addAll(currentValue.subList(i2, size));
            }
            if ((list = builder.build()).size() > maxSize) {
                e.error("Contents overflow in section replacement");
                return currentValue;
            }
            return list;
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{d.class, "offset;size", "c", "d"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{d.class, "offset;size", "c", "d"}, this);
        }

        @Override
        public final boolean equals(Object o2) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{d.class, "offset;size", "c", "d"}, this, o2);
        }

        public int b() {
            return this.c;
        }

        public Optional<Integer> c() {
            return this.d;
        }
    }

    public record e<T>(List<T> a, ListOperation b) {
        public static <T> Codec<e<T>> a(Codec<T> elementCodec, int maxSize) {
            return RecordCodecBuilder.create(instance -> instance.group((App)elementCodec.sizeLimitedListOf(maxSize).fieldOf("values").forGetter(standAlone -> standAlone.a), (App)ListOperation.a(maxSize).forGetter(standAlone -> standAlone.b)).apply((Applicative)instance, e::new));
        }

        public List<T> a(List<T> list) {
            return this.b.a(list, this.a);
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{e.class, "value;operation", "a", "b"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{e.class, "value;operation", "a", "b"}, this);
        }

        @Override
        public final boolean equals(Object o2) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{e.class, "value;operation", "a", "b"}, this, o2);
        }
    }

    public static class c
    implements ListOperation {
        public static final c b = new c();
        public static final MapCodec<c> c = MapCodec.unit(() -> b);

        private c() {
        }

        @Override
        public f a() {
            return f.a;
        }

        @Override
        public <T> List<T> a(List<T> currentValue, List<T> operand, int maxSize) {
            return operand;
        }
    }

    public static final class b
    extends Record
    implements ListOperation {
        private final int c;
        private static final Logger d = LogUtils.getLogger();
        public static final MapCodec<b> b = RecordCodecBuilder.mapCodec(instance -> instance.group((App)ExtraCodecs.o.optionalFieldOf("offset", (Object)0).forGetter(b::b)).apply((Applicative)instance, b::new));

        public b(int offset) {
            this.c = offset;
        }

        @Override
        public f a() {
            return f.c;
        }

        @Override
        public <T> List<T> a(List<T> currentValue, List<T> operand, int maxSize) {
            int size = currentValue.size();
            if (this.c > size) {
                d.error("Cannot insert when offset is out of bounds");
                return currentValue;
            }
            if (size + operand.size() > maxSize) {
                d.error("Contents overflow in section insertion");
                return currentValue;
            }
            ImmutableList.Builder builder = ImmutableList.builder();
            builder.addAll(currentValue.subList(0, this.c));
            builder.addAll(operand);
            builder.addAll(currentValue.subList(this.c, size));
            return builder.build();
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{b.class, "offset", "c"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{b.class, "offset", "c"}, this);
        }

        @Override
        public final boolean equals(Object o2) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{b.class, "offset", "c"}, this, o2);
        }

        public int b() {
            return this.c;
        }
    }

    public static class a
    implements ListOperation {
        private static final Logger d = LogUtils.getLogger();
        public static final a b = new a();
        public static final MapCodec<a> c = MapCodec.unit(() -> b);

        private a() {
        }

        @Override
        public f a() {
            return f.d;
        }

        @Override
        public <T> List<T> a(List<T> currentValue, List<T> operand, int maxSize) {
            if (currentValue.size() + operand.size() > maxSize) {
                d.error("Contents overflow in section append");
                return currentValue;
            }
            return Stream.concat(currentValue.stream(), operand.stream()).toList();
        }
    }
}

