/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.storage.loot.functions;

import com.google.common.collect.ImmutableSet;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.util.context.ContextKey;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.BlockItemStateProperties;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.IBlockState;
import net.minecraft.world.level.storage.loot.LootTableInfo;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionConditional;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionType;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctions;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameters;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;

public class LootItemFunctionCopyState
extends LootItemFunctionConditional {
    public static final MapCodec<LootItemFunctionCopyState> a = RecordCodecBuilder.mapCodec(instance -> LootItemFunctionCopyState.a(instance).and(instance.group((App)BuiltInRegistries.e.r().fieldOf("block").forGetter(copyBlockState -> copyBlockState.b), (App)Codec.STRING.listOf().fieldOf("properties").forGetter(copyBlockState -> copyBlockState.c.stream().map(IBlockState::f).toList()))).apply((Applicative)instance, LootItemFunctionCopyState::new));
    private final Holder<Block> b;
    private final Set<IBlockState<?>> c;

    LootItemFunctionCopyState(List<LootItemCondition> predicates, Holder<Block> block, Set<IBlockState<?>> properties) {
        super(predicates);
        this.b = block;
        this.c = properties;
    }

    private LootItemFunctionCopyState(List<LootItemCondition> predicates, Holder<Block> block, List<String> properties) {
        this(predicates, block, properties.stream().map(block.a().l()::a).filter(Objects::nonNull).collect(Collectors.toSet()));
    }

    public LootItemFunctionType<LootItemFunctionCopyState> b() {
        return LootItemFunctions.D;
    }

    @Override
    public Set<ContextKey<?>> a() {
        return Set.of(LootContextParameters.i);
    }

    @Override
    protected ItemStack a(ItemStack stack, LootTableInfo context) {
        IBlockData blockState = context.c(LootContextParameters.i);
        if (blockState != null) {
            stack.a(DataComponents.aq, BlockItemStateProperties.a, blockItemStateProperties -> {
                for (IBlockState<?> property : this.c) {
                    if (!blockState.b(property)) continue;
                    blockItemStateProperties = blockItemStateProperties.a(property, blockState);
                }
                return blockItemStateProperties;
            });
        }
        return stack;
    }

    public static a a(Block block) {
        return new a(block);
    }

    public static class a
    extends LootItemFunctionConditional.a<a> {
        private final Holder<Block> a;
        private final ImmutableSet.Builder<IBlockState<?>> b = ImmutableSet.builder();

        a(Block block) {
            this.a = block.p();
        }

        public a a(IBlockState<?> property) {
            if (!this.a.a().l().d().contains(property)) {
                throw new IllegalStateException("Property " + String.valueOf(property) + " is not present on block " + String.valueOf(this.a));
            }
            this.b.add(property);
            return this;
        }

        protected a a() {
            return this;
        }

        @Override
        public LootItemFunction b() {
            return new LootItemFunctionCopyState(this.g(), this.a, (Set<IBlockState<?>>)this.b.build());
        }
    }
}

