/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.storage.loot.functions;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Set;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.server.level.WorldServer;
import net.minecraft.tags.StructureTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.context.ContextKey;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemWorldMap;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.saveddata.maps.MapDecorationType;
import net.minecraft.world.level.saveddata.maps.MapDecorationTypes;
import net.minecraft.world.level.saveddata.maps.WorldMap;
import net.minecraft.world.level.storage.loot.LootTableInfo;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionConditional;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionType;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctions;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameters;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.phys.Vec3D;

public class LootItemFunctionExplorationMap
extends LootItemFunctionConditional {
    public static final TagKey<Structure> a = StructureTags.l;
    public static final Holder<MapDecorationType> b = MapDecorationTypes.i;
    public static final byte c = 2;
    public static final int d = 50;
    public static final boolean e = true;
    public static final MapCodec<LootItemFunctionExplorationMap> f = RecordCodecBuilder.mapCodec(instance -> LootItemFunctionExplorationMap.a(instance).and(instance.group((App)TagKey.a(Registries.bm).optionalFieldOf("destination", a).forGetter(explorationMapFunction -> explorationMapFunction.h), (App)MapDecorationType.b.optionalFieldOf("decoration", b).forGetter(explorationMapFunction -> explorationMapFunction.i), (App)Codec.BYTE.optionalFieldOf("zoom", (Object)2).forGetter(explorationMapFunction -> explorationMapFunction.j), (App)Codec.INT.optionalFieldOf("search_radius", (Object)50).forGetter(explorationMapFunction -> explorationMapFunction.k), (App)Codec.BOOL.optionalFieldOf("skip_existing_chunks", (Object)true).forGetter(explorationMapFunction -> explorationMapFunction.l))).apply((Applicative)instance, LootItemFunctionExplorationMap::new));
    private final TagKey<Structure> h;
    private final Holder<MapDecorationType> i;
    private final byte j;
    private final int k;
    private final boolean l;

    LootItemFunctionExplorationMap(List<LootItemCondition> predicates, TagKey<Structure> destination, Holder<MapDecorationType> mapDecoration, byte zoom, int searchRadius, boolean skipKnownStructures) {
        super(predicates);
        this.h = destination;
        this.i = mapDecoration;
        this.j = zoom;
        this.k = searchRadius;
        this.l = skipKnownStructures;
    }

    public LootItemFunctionType<LootItemFunctionExplorationMap> b() {
        return LootItemFunctions.q;
    }

    @Override
    public Set<ContextKey<?>> a() {
        return Set.of(LootContextParameters.h);
    }

    @Override
    public ItemStack a(ItemStack stack, LootTableInfo context) {
        if (!stack.a(Items.wr)) {
            return stack;
        }
        Vec3D vec3 = context.c(LootContextParameters.h);
        if (vec3 != null) {
            WorldServer level = context.d();
            if (!level.paperConfig().environment.treasureMaps.enabled) {
                return stack;
            }
            BlockPosition blockPos = level.a(this.h, BlockPosition.a(vec3), this.k, !level.paperConfig().environment.treasureMaps.findAlreadyDiscoveredLootTable.or(!this.l));
            if (blockPos != null) {
                ItemStack itemStack = ItemWorldMap.a(level, blockPos.u(), blockPos.w(), this.j, true, true);
                ItemWorldMap.a(level, itemStack);
                WorldMap.a(itemStack, blockPos, "+", this.i);
                return itemStack;
            }
        }
        return stack;
    }

    public static a c() {
        return new a();
    }

    public static class a
    extends LootItemFunctionConditional.a<a> {
        private TagKey<Structure> a = a;
        private Holder<MapDecorationType> b = b;
        private byte c = (byte)2;
        private int d = 50;
        private boolean e = true;

        protected a a() {
            return this;
        }

        public a a(TagKey<Structure> destination) {
            this.a = destination;
            return this;
        }

        public a a(Holder<MapDecorationType> mapDecoration) {
            this.b = mapDecoration;
            return this;
        }

        public a a(byte zoom) {
            this.c = zoom;
            return this;
        }

        public a a(int searchRadius) {
            this.d = searchRadius;
            return this;
        }

        public a a(boolean skipKnownStructures) {
            this.e = skipKnownStructures;
            return this;
        }

        @Override
        public LootItemFunction b() {
            return new LootItemFunctionExplorationMap(this.g(), this.a, this.b, this.c, this.d, this.e);
        }
    }
}

