/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.phys.shapes;

import ca.spottedleaf.moonrise.patches.collisions.shape.CachedShapeData;
import ca.spottedleaf.moonrise.patches.collisions.shape.CollisionDiscreteVoxelShape;
import com.mojang.math.PointGroupO;
import java.util.Arrays;
import net.minecraft.core.EnumAxisCycle;
import net.minecraft.core.EnumDirection;
import net.minecraft.world.phys.shapes.VoxelShapeBitSet;

public abstract class VoxelShapeDiscrete
implements CollisionDiscreteVoxelShape {
    private static final EnumDirection.EnumAxis[] d = EnumDirection.EnumAxis.values();
    protected final int a;
    protected final int b;
    protected final int c;
    private CachedShapeData cachedShapeData;

    @Override
    public final CachedShapeData moonrise$getOrCreateCachedShapeData() {
        long[] voxelSet;
        if (this.cachedShapeData != null) {
            return this.cachedShapeData;
        }
        VoxelShapeDiscrete discreteVoxelShape = this;
        int sizeX = discreteVoxelShape.b();
        int sizeY = discreteVoxelShape.c();
        int sizeZ = discreteVoxelShape.d();
        int maxIndex = sizeX * sizeY * sizeZ;
        int longsRequired = maxIndex + 63 >>> 6;
        boolean isEmpty = discreteVoxelShape.a();
        if (discreteVoxelShape instanceof VoxelShapeBitSet) {
            VoxelShapeBitSet bitsetShape = (VoxelShapeBitSet)discreteVoxelShape;
            voxelSet = bitsetShape.d.toLongArray();
            if (voxelSet.length < longsRequired) {
                voxelSet = Arrays.copyOf(voxelSet, longsRequired);
            }
        } else {
            voxelSet = new long[longsRequired];
            if (!isEmpty) {
                int mulX = sizeZ * sizeY;
                for (int x2 = 0; x2 < sizeX; ++x2) {
                    for (int y2 = 0; y2 < sizeY; ++y2) {
                        for (int z2 = 0; z2 < sizeZ; ++z2) {
                            if (!discreteVoxelShape.b(x2, y2, z2)) continue;
                            int index = z2 + y2 * sizeZ + x2 * mulX;
                            int n2 = index >>> 6;
                            voxelSet[n2] = voxelSet[n2] | 1L << index;
                        }
                    }
                }
            }
        }
        boolean hasSingleAABB = sizeX == 1 && sizeY == 1 && sizeZ == 1 && !isEmpty && (voxelSet[0] & 1L) != 0L;
        int minFullX = discreteVoxelShape.a(EnumDirection.EnumAxis.a);
        int minFullY = discreteVoxelShape.a(EnumDirection.EnumAxis.b);
        int minFullZ = discreteVoxelShape.a(EnumDirection.EnumAxis.c);
        int maxFullX = discreteVoxelShape.b(EnumDirection.EnumAxis.a);
        int maxFullY = discreteVoxelShape.b(EnumDirection.EnumAxis.b);
        int maxFullZ = discreteVoxelShape.b(EnumDirection.EnumAxis.c);
        this.cachedShapeData = new CachedShapeData(sizeX, sizeY, sizeZ, voxelSet, minFullX, minFullY, minFullZ, maxFullX, maxFullY, maxFullZ, isEmpty, hasSingleAABB);
        return this.cachedShapeData;
    }

    protected VoxelShapeDiscrete(int xSize, int ySize, int zSize) {
        if (xSize < 0 || ySize < 0 || zSize < 0) {
            throw new IllegalArgumentException("Need all positive sizes: x: " + xSize + ", y: " + ySize + ", z: " + zSize);
        }
        this.a = xSize;
        this.b = ySize;
        this.c = zSize;
    }

    public VoxelShapeDiscrete a(PointGroupO octahedralGroup) {
        if (octahedralGroup == PointGroupO.a) {
            return this;
        }
        EnumDirection.EnumAxis axis = octahedralGroup.b(EnumDirection.EnumAxis.a);
        EnumDirection.EnumAxis axis1 = octahedralGroup.b(EnumDirection.EnumAxis.b);
        EnumDirection.EnumAxis axis2 = octahedralGroup.b(EnumDirection.EnumAxis.c);
        int i2 = axis.a(this.a, this.b, this.c);
        int i1 = axis1.a(this.a, this.b, this.c);
        int i22 = axis2.a(this.a, this.b, this.c);
        boolean flag = octahedralGroup.a(axis);
        boolean flag1 = octahedralGroup.a(axis1);
        boolean flag2 = octahedralGroup.a(axis2);
        boolean flag3 = axis.a(flag, flag1, flag2);
        boolean flag4 = axis1.a(flag, flag1, flag2);
        boolean flag5 = axis2.a(flag, flag1, flag2);
        VoxelShapeBitSet discreteVoxelShape = new VoxelShapeBitSet(i2, i1, i22);
        for (int i3 = 0; i3 < this.a; ++i3) {
            for (int i4 = 0; i4 < this.b; ++i4) {
                for (int i5 = 0; i5 < this.c; ++i5) {
                    if (!this.b(i3, i4, i5)) continue;
                    int i6 = axis.a(i3, i4, i5);
                    int i7 = axis1.a(i3, i4, i5);
                    int i8 = axis2.a(i3, i4, i5);
                    ((VoxelShapeDiscrete)discreteVoxelShape).c(flag3 ? i2 - 1 - i6 : i6, flag4 ? i1 - 1 - i7 : i7, flag5 ? i22 - 1 - i8 : i8);
                }
            }
        }
        return discreteVoxelShape;
    }

    public boolean a(EnumAxisCycle axis, int x2, int y2, int z2) {
        return this.e(axis.a(x2, y2, z2, EnumDirection.EnumAxis.a), axis.a(x2, y2, z2, EnumDirection.EnumAxis.b), axis.a(x2, y2, z2, EnumDirection.EnumAxis.c));
    }

    public boolean e(int x2, int y2, int z2) {
        return x2 >= 0 && y2 >= 0 && z2 >= 0 && x2 < this.a && y2 < this.b && z2 < this.c && this.b(x2, y2, z2);
    }

    public boolean b(EnumAxisCycle rotation, int x2, int y2, int z2) {
        return this.b(rotation.a(x2, y2, z2, EnumDirection.EnumAxis.a), rotation.a(x2, y2, z2, EnumDirection.EnumAxis.b), rotation.a(x2, y2, z2, EnumDirection.EnumAxis.c));
    }

    public abstract boolean b(int var1, int var2, int var3);

    public abstract void c(int var1, int var2, int var3);

    public boolean a() {
        for (EnumDirection.EnumAxis axis : d) {
            if (this.a(axis) < this.b(axis)) continue;
            return true;
        }
        return false;
    }

    public abstract int a(EnumDirection.EnumAxis var1);

    public abstract int b(EnumDirection.EnumAxis var1);

    public int a(EnumDirection.EnumAxis axis, int y2, int z2) {
        int size = this.c(axis);
        if (y2 >= 0 && z2 >= 0) {
            EnumDirection.EnumAxis axis1 = EnumAxisCycle.b.a(axis);
            EnumDirection.EnumAxis axis2 = EnumAxisCycle.c.a(axis);
            if (y2 < this.c(axis1) && z2 < this.c(axis2)) {
                EnumAxisCycle axisCycle = EnumAxisCycle.a(EnumDirection.EnumAxis.a, axis);
                for (int i2 = 0; i2 < size; ++i2) {
                    if (!this.b(axisCycle, i2, y2, z2)) continue;
                    return i2;
                }
                return size;
            }
            return size;
        }
        return size;
    }

    public int b(EnumDirection.EnumAxis axis, int y2, int z2) {
        if (y2 >= 0 && z2 >= 0) {
            EnumDirection.EnumAxis axis1 = EnumAxisCycle.b.a(axis);
            EnumDirection.EnumAxis axis2 = EnumAxisCycle.c.a(axis);
            if (y2 < this.c(axis1) && z2 < this.c(axis2)) {
                int size = this.c(axis);
                EnumAxisCycle axisCycle = EnumAxisCycle.a(EnumDirection.EnumAxis.a, axis);
                for (int i2 = size - 1; i2 >= 0; --i2) {
                    if (!this.b(axisCycle, i2, y2, z2)) continue;
                    return i2 + 1;
                }
                return 0;
            }
            return 0;
        }
        return 0;
    }

    public int c(EnumDirection.EnumAxis axis) {
        return axis.a(this.a, this.b, this.c);
    }

    public int b() {
        return this.c(EnumDirection.EnumAxis.a);
    }

    public int c() {
        return this.c(EnumDirection.EnumAxis.b);
    }

    public int d() {
        return this.c(EnumDirection.EnumAxis.c);
    }

    public void a(b consumer, boolean combine) {
        this.a(consumer, EnumAxisCycle.a, combine);
        this.a(consumer, EnumAxisCycle.b, combine);
        this.a(consumer, EnumAxisCycle.c, combine);
    }

    private void a(b lineConsumer, EnumAxisCycle axis, boolean combine) {
        EnumAxisCycle axisCycle = axis.a();
        int size = this.c(axisCycle.a(EnumDirection.EnumAxis.a));
        int size1 = this.c(axisCycle.a(EnumDirection.EnumAxis.b));
        int size2 = this.c(axisCycle.a(EnumDirection.EnumAxis.c));
        for (int i2 = 0; i2 <= size; ++i2) {
            for (int i1 = 0; i1 <= size1; ++i1) {
                int i22 = -1;
                for (int i3 = 0; i3 <= size2; ++i3) {
                    int i4 = 0;
                    int i5 = 0;
                    for (int i6 = 0; i6 <= 1; ++i6) {
                        for (int i7 = 0; i7 <= 1; ++i7) {
                            if (!this.a(axisCycle, i2 + i6 - 1, i1 + i7 - 1, i3)) continue;
                            ++i4;
                            i5 ^= i6 ^ i7;
                        }
                    }
                    if (i4 == 1 || i4 == 3 || i4 == 2 && !(i5 & true)) {
                        if (combine) {
                            if (i22 != -1) continue;
                            i22 = i3;
                            continue;
                        }
                        lineConsumer.consume(axisCycle.a(i2, i1, i3, EnumDirection.EnumAxis.a), axisCycle.a(i2, i1, i3, EnumDirection.EnumAxis.b), axisCycle.a(i2, i1, i3, EnumDirection.EnumAxis.c), axisCycle.a(i2, i1, i3 + 1, EnumDirection.EnumAxis.a), axisCycle.a(i2, i1, i3 + 1, EnumDirection.EnumAxis.b), axisCycle.a(i2, i1, i3 + 1, EnumDirection.EnumAxis.c));
                        continue;
                    }
                    if (i22 == -1) continue;
                    lineConsumer.consume(axisCycle.a(i2, i1, i22, EnumDirection.EnumAxis.a), axisCycle.a(i2, i1, i22, EnumDirection.EnumAxis.b), axisCycle.a(i2, i1, i22, EnumDirection.EnumAxis.c), axisCycle.a(i2, i1, i3, EnumDirection.EnumAxis.a), axisCycle.a(i2, i1, i3, EnumDirection.EnumAxis.b), axisCycle.a(i2, i1, i3, EnumDirection.EnumAxis.c));
                    i22 = -1;
                }
            }
        }
    }

    public void b(b consumer, boolean combine) {
        VoxelShapeBitSet.a(this, consumer, combine);
    }

    public void a(a faceConsumer) {
        this.a(faceConsumer, EnumAxisCycle.a);
        this.a(faceConsumer, EnumAxisCycle.b);
        this.a(faceConsumer, EnumAxisCycle.c);
    }

    private void a(a faceConsumer, EnumAxisCycle axisRotation) {
        EnumAxisCycle axisCycle = axisRotation.a();
        EnumDirection.EnumAxis axis = axisCycle.a(EnumDirection.EnumAxis.c);
        int size = this.c(axisCycle.a(EnumDirection.EnumAxis.a));
        int size1 = this.c(axisCycle.a(EnumDirection.EnumAxis.b));
        int size2 = this.c(axis);
        EnumDirection direction = EnumDirection.a(axis, EnumDirection.EnumAxisDirection.b);
        EnumDirection direction1 = EnumDirection.a(axis, EnumDirection.EnumAxisDirection.a);
        for (int i2 = 0; i2 < size; ++i2) {
            for (int i1 = 0; i1 < size1; ++i1) {
                boolean flag = false;
                for (int i22 = 0; i22 <= size2; ++i22) {
                    boolean flag1;
                    boolean bl = flag1 = i22 != size2 && this.b(axisCycle, i2, i1, i22);
                    if (!flag && flag1) {
                        faceConsumer.consume(direction, axisCycle.a(i2, i1, i22, EnumDirection.EnumAxis.a), axisCycle.a(i2, i1, i22, EnumDirection.EnumAxis.b), axisCycle.a(i2, i1, i22, EnumDirection.EnumAxis.c));
                    }
                    if (flag && !flag1) {
                        faceConsumer.consume(direction1, axisCycle.a(i2, i1, i22 - 1, EnumDirection.EnumAxis.a), axisCycle.a(i2, i1, i22 - 1, EnumDirection.EnumAxis.b), axisCycle.a(i2, i1, i22 - 1, EnumDirection.EnumAxis.c));
                    }
                    flag = flag1;
                }
            }
        }
    }

    public static interface b {
        public void consume(int var1, int var2, int var3, int var4, int var5, int var6);
    }

    public static interface a {
        public void consume(EnumDirection var1, int var2, int var3, int var4);
    }
}

