/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.scores;

import com.google.common.collect.Lists;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntMaps;
import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.Reference2ObjectMap;
import it.unimi.dsi.fastutil.objects.Reference2ObjectOpenHashMap;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.chat.numbers.NumberFormat;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.scores.DisplaySlot;
import net.minecraft.world.scores.PlayerScoreEntry;
import net.minecraft.world.scores.PlayerScores;
import net.minecraft.world.scores.ReadOnlyScoreInfo;
import net.minecraft.world.scores.ScoreAccess;
import net.minecraft.world.scores.ScoreHolder;
import net.minecraft.world.scores.ScoreboardObjective;
import net.minecraft.world.scores.ScoreboardScore;
import net.minecraft.world.scores.ScoreboardTeam;
import net.minecraft.world.scores.criteria.IScoreboardCriteria;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.slf4j.Logger;

public class Scoreboard {
    public static final String b = "#";
    private static final Logger a = LogUtils.getLogger();
    private final Object2ObjectMap<String, ScoreboardObjective> c = new Object2ObjectOpenHashMap(16, 0.5f);
    private final Reference2ObjectMap<IScoreboardCriteria, List<ScoreboardObjective>> d = new Reference2ObjectOpenHashMap();
    private final Map<String, PlayerScores> e = new Object2ObjectOpenHashMap(16, 0.5f);
    private final Map<DisplaySlot, ScoreboardObjective> f = new EnumMap<DisplaySlot, ScoreboardObjective>(DisplaySlot.class);
    private final Object2ObjectMap<String, ScoreboardTeam> g = new Object2ObjectOpenHashMap();
    private final Object2ObjectMap<String, ScoreboardTeam> h = new Object2ObjectOpenHashMap();

    @Nullable
    public ScoreboardObjective a(@Nullable String name) {
        return (ScoreboardObjective)this.c.get((Object)name);
    }

    public ScoreboardObjective a(String name, IScoreboardCriteria criteria, IChatBaseComponent displayName, IScoreboardCriteria.EnumScoreboardHealthDisplay renderType, boolean displayAutoUpdate, @Nullable NumberFormat numberFormat) {
        if (this.c.containsKey((Object)name)) {
            throw new IllegalArgumentException("An objective with the name '" + name + "' already exists!");
        }
        ScoreboardObjective objective = new ScoreboardObjective(this, name, criteria, displayName, renderType, displayAutoUpdate, numberFormat);
        ((List)this.d.computeIfAbsent((Object)criteria, object -> Lists.newArrayList())).add(objective);
        this.c.put((Object)name, (Object)objective);
        this.a(objective);
        return objective;
    }

    public final void a(IScoreboardCriteria criteria, ScoreHolder scoreHolder, Consumer<ScoreAccess> action) {
        ((List)this.d.getOrDefault((Object)criteria, Collections.emptyList())).forEach(objective -> action.accept(this.a(scoreHolder, (ScoreboardObjective)objective, true)));
    }

    private PlayerScores f(String playerName) {
        return this.e.computeIfAbsent(playerName, string -> new PlayerScores());
    }

    public ScoreAccess c(ScoreHolder scoreHolder, ScoreboardObjective objective) {
        return this.a(scoreHolder, objective, false);
    }

    public ScoreAccess a(final ScoreHolder scoreHolder, final ScoreboardObjective objective, boolean readOnly) {
        final boolean flag = readOnly || !objective.d().e();
        PlayerScores playerInfo = this.f(scoreHolder.cV());
        final MutableBoolean mutableBoolean = new MutableBoolean();
        final ScoreboardScore score = playerInfo.a(objective, (ScoreboardScore score1) -> mutableBoolean.setTrue());
        return new ScoreAccess(){

            @Override
            public int a() {
                return score.a();
            }

            @Override
            public void a(int value) {
                IChatBaseComponent displayName;
                if (!flag) {
                    throw new IllegalStateException("Cannot modify read-only score");
                }
                boolean isTrue = mutableBoolean.isTrue();
                if (objective.f() && (displayName = scoreHolder.S_()) != null && !displayName.equals(score.d())) {
                    score.a(displayName);
                    isTrue = true;
                }
                if (value != score.a()) {
                    score.a(value);
                    isTrue = true;
                }
                if (isTrue) {
                    this.h();
                }
            }

            @Override
            @Nullable
            public IChatBaseComponent g() {
                return score.d();
            }

            @Override
            public void a(@Nullable IChatBaseComponent value) {
                if (mutableBoolean.isTrue() || !Objects.equals(value, score.d())) {
                    score.a(value);
                    this.h();
                }
            }

            @Override
            public void a(@Nullable NumberFormat format) {
                score.b(format);
                this.h();
            }

            @Override
            public boolean d() {
                return score.b();
            }

            @Override
            public void e() {
                this.a(false);
            }

            @Override
            public void f() {
                this.a(true);
            }

            private void a(boolean locked) {
                score.a(locked);
                if (mutableBoolean.isTrue()) {
                    this.h();
                }
                Scoreboard.this.a(scoreHolder, objective);
            }

            private void h() {
                Scoreboard.this.a(scoreHolder, objective, score);
                mutableBoolean.setFalse();
            }
        };
    }

    @Nullable
    public ReadOnlyScoreInfo d(ScoreHolder scoreHolder, ScoreboardObjective objective) {
        PlayerScores playerScores = this.e.get(scoreHolder.cV());
        return playerScores != null ? playerScores.a(objective) : null;
    }

    public Collection<PlayerScoreEntry> i(ScoreboardObjective objective) {
        ArrayList<PlayerScoreEntry> list = new ArrayList<PlayerScoreEntry>();
        this.e.forEach((string, playerScores) -> {
            ScoreboardScore score = playerScores.a(objective);
            if (score != null) {
                list.add(new PlayerScoreEntry((String)string, score.a(), score.d(), score.c()));
            }
        });
        return list;
    }

    public Collection<ScoreboardObjective> b() {
        return this.c.values();
    }

    public Collection<String> c() {
        return this.c.keySet();
    }

    public Collection<ScoreHolder> d() {
        return this.e.keySet().stream().map(ScoreHolder::c).toList();
    }

    public void b(ScoreHolder scoreHolder) {
        PlayerScores playerScores = this.e.remove(scoreHolder.cV());
        if (playerScores != null) {
            this.a(scoreHolder);
        }
    }

    public void e(ScoreHolder scoreHolder, ScoreboardObjective objective) {
        PlayerScores playerScores = this.e.get(scoreHolder.cV());
        if (playerScores != null) {
            boolean flag = playerScores.b(objective);
            if (!playerScores.a()) {
                PlayerScores playerScores1 = this.e.remove(scoreHolder.cV());
                if (playerScores1 != null) {
                    this.a(scoreHolder);
                }
            } else if (flag) {
                this.b(scoreHolder, objective);
            }
        }
    }

    public Object2IntMap<ScoreboardObjective> c(ScoreHolder scoreHolder) {
        PlayerScores playerScores = this.e.get(scoreHolder.cV());
        return playerScores != null ? playerScores.b() : Object2IntMaps.emptyMap();
    }

    public void j(ScoreboardObjective objective) {
        this.c.remove((Object)objective.c());
        for (DisplaySlot displaySlot : DisplaySlot.values()) {
            if (this.a(displaySlot) != objective) continue;
            this.a(displaySlot, null);
        }
        List list = (List)this.d.get((Object)objective.d());
        if (list != null) {
            list.remove(objective);
        }
        for (PlayerScores playerScores : this.e.values()) {
            playerScores.b(objective);
        }
        this.c(objective);
    }

    public void a(DisplaySlot slot, @Nullable ScoreboardObjective objective) {
        this.f.put(slot, objective);
    }

    @Nullable
    public ScoreboardObjective a(DisplaySlot slot) {
        return this.f.get(slot);
    }

    @Nullable
    public ScoreboardTeam b(String name) {
        return (ScoreboardTeam)this.g.get((Object)name);
    }

    public ScoreboardTeam c(String name) {
        ScoreboardTeam playerTeam = this.b(name);
        if (playerTeam != null) {
            a.warn("Requested creation of existing team '{}'", (Object)name);
            return playerTeam;
        }
        playerTeam = new ScoreboardTeam(this, name);
        this.g.put((Object)name, (Object)playerTeam);
        this.a(playerTeam);
        return playerTeam;
    }

    public void d(ScoreboardTeam team) {
        this.g.remove((Object)team.c());
        for (String string : team.h()) {
            this.h.remove((Object)string);
        }
        this.c(team);
    }

    public boolean a(String playerName, ScoreboardTeam team) {
        if (this.e(playerName) != null) {
            this.d(playerName);
        }
        this.h.put((Object)playerName, (Object)team);
        return team.h().add(playerName);
    }

    public boolean d(String playerName) {
        ScoreboardTeam playersTeam = this.e(playerName);
        if (playersTeam != null) {
            this.b(playerName, playersTeam);
            return true;
        }
        return false;
    }

    public void b(String playerName, ScoreboardTeam team) {
        if (this.e(playerName) != team) {
            throw new IllegalStateException("Player is either on another team or not on any team. Cannot remove from team '" + team.c() + "'.");
        }
        this.h.remove((Object)playerName);
        team.h().remove(playerName);
    }

    public Collection<String> e() {
        return this.g.keySet();
    }

    public Collection<ScoreboardTeam> f() {
        return this.g.values();
    }

    @Nullable
    public ScoreboardTeam e(String playerName) {
        return (ScoreboardTeam)this.h.get((Object)playerName);
    }

    public void a(ScoreboardObjective objective) {
    }

    public void b(ScoreboardObjective objective) {
    }

    public void c(ScoreboardObjective objective) {
    }

    protected void a(ScoreHolder scoreHolder, ScoreboardObjective objective, ScoreboardScore score) {
    }

    protected void a(ScoreHolder scoreHolder, ScoreboardObjective objective) {
    }

    public void a(ScoreHolder scoreHolder) {
    }

    public void b(ScoreHolder scoreHolder, ScoreboardObjective objective) {
    }

    public void a(ScoreboardTeam team) {
    }

    public void b(ScoreboardTeam team) {
    }

    public void c(ScoreboardTeam team) {
    }

    public void a(Entity entity) {
        if (!(entity instanceof EntityHuman) && !entity.bX()) {
            this.b(entity);
            this.d(entity.cV());
        }
    }

    protected List<a> g() {
        return this.e.entrySet().stream().flatMap(entry -> {
            String string = (String)entry.getKey();
            return ((PlayerScores)entry.getValue()).c().entrySet().stream().map(entry1 -> new a(string, ((ScoreboardObjective)entry1.getKey()).c(), (ScoreboardScore)entry1.getValue()));
        }).toList();
    }

    protected void a(a score) {
        ScoreboardObjective objective = this.a(score.c);
        if (objective == null) {
            a.error("Unknown objective {} for name {}, ignoring", (Object)score.c, (Object)score.b);
        } else {
            this.f(score.b).a(objective, score.d);
        }
    }

    protected void a(ScoreboardTeam.a packed) {
        ScoreboardTeam playerTeam = this.c(packed.a());
        packed.b().ifPresent(playerTeam::a);
        packed.c().ifPresent(playerTeam::a);
        playerTeam.a(packed.d());
        playerTeam.b(packed.e());
        playerTeam.b(packed.f());
        playerTeam.c(packed.g());
        playerTeam.a(packed.h());
        playerTeam.b(packed.i());
        playerTeam.a(packed.j());
        for (String string : packed.k()) {
            this.a(string, playerTeam);
        }
    }

    protected void a(ScoreboardObjective.a packed) {
        this.a(packed.a(), packed.b(), packed.c(), packed.d(), packed.e(), packed.f().orElse(null));
    }

    public static final class a
    extends Record {
        private final String b;
        private final String c;
        private final ScoreboardScore d;
        public static final Codec<a> a = RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.fieldOf("Name").forGetter(a::a), (App)Codec.STRING.fieldOf("Objective").forGetter(a::b), (App)ScoreboardScore.a.forGetter(a::c)).apply((Applicative)instance, a::new));

        public a(String owner, String objective, ScoreboardScore score) {
            this.b = owner;
            this.c = objective;
            this.d = score;
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{a.class, "owner;objective;score", "b", "c", "d"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{a.class, "owner;objective;score", "b", "c", "d"}, this);
        }

        @Override
        public final boolean equals(Object o2) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{a.class, "owner;objective;score", "b", "c", "d"}, this, o2);
        }

        public String a() {
            return this.b;
        }

        public String b() {
            return this.c;
        }

        public ScoreboardScore c() {
            return this.d;
        }
    }
}

