/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.ticks;

import ca.spottedleaf.moonrise.patches.chunk_system.ticks.ChunkSystemLevelChunkTicks;
import it.unimi.dsi.fastutil.objects.ObjectOpenCustomHashSet;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.PriorityQueue;
import java.util.Queue;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Predicate;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.world.ticks.NextTickListEntry;
import net.minecraft.world.ticks.SerializableTickContainer;
import net.minecraft.world.ticks.TickContainerAccess;
import net.minecraft.world.ticks.TickListChunk;

public class LevelChunkTicks<T>
implements SerializableTickContainer<T>,
TickContainerAccess<T>,
ChunkSystemLevelChunkTicks {
    private final Queue<NextTickListEntry<T>> a = new PriorityQueue(NextTickListEntry.a);
    @Nullable
    private List<TickListChunk<T>> b;
    private final Set<NextTickListEntry<?>> c = new ObjectOpenCustomHashSet(NextTickListEntry.c);
    @Nullable
    private BiConsumer<LevelChunkTicks<T>, NextTickListEntry<T>> d;
    private boolean dirty;
    private long lastSaved = Long.MIN_VALUE;

    @Override
    public final boolean moonrise$isDirty(long tick) {
        return this.dirty || !this.a.isEmpty() && tick != this.lastSaved;
    }

    @Override
    public final void moonrise$clearDirty() {
        this.dirty = false;
    }

    public LevelChunkTicks() {
    }

    public LevelChunkTicks(List<TickListChunk<T>> pendingTicks) {
        this.b = pendingTicks;
        for (TickListChunk<T> savedTick : pendingTicks) {
            this.c.add(NextTickListEntry.a(savedTick.a(), savedTick.b()));
        }
    }

    public void a(@Nullable BiConsumer<LevelChunkTicks<T>, NextTickListEntry<T>> onTickAdded) {
        this.d = onTickAdded;
    }

    @Nullable
    public NextTickListEntry<T> b() {
        return this.a.peek();
    }

    @Nullable
    public NextTickListEntry<T> c() {
        NextTickListEntry<T> scheduledTick = this.a.poll();
        if (scheduledTick != null) {
            this.c.remove(scheduledTick);
            this.dirty = true;
        }
        return scheduledTick;
    }

    @Override
    public void a(NextTickListEntry<T> tick) {
        if (this.c.add(tick)) {
            this.b(tick);
            this.dirty = true;
        }
    }

    private void b(NextTickListEntry<T> tick) {
        this.a.add(tick);
        if (this.d != null) {
            this.d.accept(this, tick);
        }
    }

    @Override
    public boolean a(BlockPosition pos, T type) {
        return this.c.contains(NextTickListEntry.a(type, pos));
    }

    @Override
    public void a(Predicate<NextTickListEntry<T>> predicate) {
        Iterator iterator = this.a.iterator();
        while (iterator.hasNext()) {
            NextTickListEntry scheduledTick = (NextTickListEntry)iterator.next();
            if (!predicate.test(scheduledTick)) continue;
            iterator.remove();
            this.dirty = true;
            this.c.remove(scheduledTick);
        }
    }

    public Stream<NextTickListEntry<T>> d() {
        return this.a.stream();
    }

    @Override
    public int a() {
        return this.a.size() + (this.b != null ? this.b.size() : 0);
    }

    @Override
    public List<TickListChunk<T>> a(long gameTime) {
        this.lastSaved = gameTime;
        ArrayList<TickListChunk<T>> list = new ArrayList<TickListChunk<T>>(this.a.size());
        if (this.b != null) {
            list.addAll(this.b);
        }
        for (NextTickListEntry nextTickListEntry : this.a) {
            list.add(nextTickListEntry.a(gameTime));
        }
        return list;
    }

    public void b(long gameTime) {
        if (this.b != null) {
            this.lastSaved = gameTime;
            int i2 = -this.b.size();
            for (TickListChunk<T> savedTick : this.b) {
                this.b(savedTick.a(gameTime, i2++));
            }
        }
        this.b = null;
    }
}

