/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.waypoints;

import com.mojang.datafixers.util.Either;
import com.mojang.logging.LogUtils;
import io.netty.buffer.ByteBuf;
import java.util.UUID;
import net.minecraft.core.BaseBlockPosition;
import net.minecraft.core.UUIDUtil;
import net.minecraft.network.PacketDataSerializer;
import net.minecraft.network.VarInt;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.MathHelper;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.World;
import net.minecraft.world.phys.Vec3D;
import net.minecraft.world.waypoints.PartialTickSupplier;
import net.minecraft.world.waypoints.Waypoint;
import org.apache.commons.lang3.function.TriFunction;
import org.slf4j.Logger;

public abstract class TrackedWaypoint
implements Waypoint {
    static final Logger c = LogUtils.getLogger();
    public static final StreamCodec<ByteBuf, TrackedWaypoint> a = StreamCodec.a(TrackedWaypoint::a, TrackedWaypoint::c);
    protected final Either<UUID, String> b;
    private final Waypoint.a d;
    private final g e;

    TrackedWaypoint(Either<UUID, String> identifier, Waypoint.a icon, g type) {
        this.b = identifier;
        this.d = icon;
        this.e = type;
    }

    public Either<UUID, String> a() {
        return this.b;
    }

    public abstract void a(TrackedWaypoint var1);

    public void a(ByteBuf buffer) {
        PacketDataSerializer friendlyByteBuf = new PacketDataSerializer(buffer);
        friendlyByteBuf.a(this.b, UUIDUtil.g, PacketDataSerializer::a);
        Waypoint.a.b.encode(friendlyByteBuf, this.d);
        friendlyByteBuf.a(this.e);
        this.b(buffer);
    }

    public abstract void b(ByteBuf var1);

    private static TrackedWaypoint c(ByteBuf buffer) {
        PacketDataSerializer friendlyByteBuf = new PacketDataSerializer(buffer);
        Either<UUID, String> either = friendlyByteBuf.b(UUIDUtil.g, PacketDataSerializer::p);
        Waypoint.a icon = (Waypoint.a)Waypoint.a.b.decode(friendlyByteBuf);
        g type = friendlyByteBuf.b(g.class);
        return (TrackedWaypoint)type.e.apply(either, (Object)icon, (Object)friendlyByteBuf);
    }

    public static TrackedWaypoint a(UUID uuid, Waypoint.a icon, BaseBlockPosition position) {
        return new h(uuid, icon, position);
    }

    public static TrackedWaypoint a(UUID uuid, Waypoint.a icon, ChunkCoordIntPair chunkPos) {
        return new c(uuid, icon, chunkPos);
    }

    public static TrackedWaypoint a(UUID uuid, Waypoint.a icon, float angle) {
        return new a(uuid, icon, angle);
    }

    public static TrackedWaypoint a(UUID uuid) {
        return new d(uuid);
    }

    public abstract double a(World var1, b var2, PartialTickSupplier var3);

    public abstract e a(World var1, f var2, PartialTickSupplier var3);

    public abstract double a(Entity var1);

    public Waypoint.a b() {
        return this.d;
    }

    static final class g
    extends Enum<g> {
        public static final /* enum */ g a = new g((TriFunction<Either<UUID, String>, Waypoint.a, PacketDataSerializer, TrackedWaypoint>)((TriFunction)d::new));
        public static final /* enum */ g b = new g((TriFunction<Either<UUID, String>, Waypoint.a, PacketDataSerializer, TrackedWaypoint>)((TriFunction)h::new));
        public static final /* enum */ g c = new g((TriFunction<Either<UUID, String>, Waypoint.a, PacketDataSerializer, TrackedWaypoint>)((TriFunction)c::new));
        public static final /* enum */ g d = new g((TriFunction<Either<UUID, String>, Waypoint.a, PacketDataSerializer, TrackedWaypoint>)((TriFunction)a::new));
        final TriFunction<Either<UUID, String>, Waypoint.a, PacketDataSerializer, TrackedWaypoint> e;
        private static final /* synthetic */ g[] f;

        public static g[] values() {
            return (g[])f.clone();
        }

        public static g valueOf(String name) {
            return Enum.valueOf(g.class, name);
        }

        private g(TriFunction<Either<UUID, String>, Waypoint.a, PacketDataSerializer, TrackedWaypoint> constructor) {
            this.e = constructor;
        }

        private static /* synthetic */ g[] a() {
            return new g[]{a, b, c, d};
        }

        static {
            f = g.a();
        }
    }

    static class h
    extends TrackedWaypoint {
        private BaseBlockPosition c;

        public h(UUID uuid, Waypoint.a icon, BaseBlockPosition vector) {
            super(Either.left(uuid), icon, g.b);
            this.c = vector;
        }

        public h(Either<UUID, String> identifier, Waypoint.a icon, PacketDataSerializer buffer) {
            super(identifier, icon, g.b);
            this.c = new BaseBlockPosition(buffer.l(), buffer.l(), buffer.l());
        }

        @Override
        public void a(TrackedWaypoint waypoint) {
            if (waypoint instanceof h) {
                h vec3iWaypoint = (h)waypoint;
                this.c = vec3iWaypoint.c;
            } else {
                c.warn("Unsupported Waypoint update operation: {}", waypoint.getClass());
            }
        }

        @Override
        public void b(ByteBuf buffer) {
            VarInt.a(buffer, this.c.u());
            VarInt.a(buffer, this.c.v());
            VarInt.a(buffer, this.c.w());
        }

        private Vec3D a(World level, PartialTickSupplier partialTickGetter) {
            return this.b.left().map(level::d).map(entity -> entity.dF().k(this.c) > 3 ? null : entity.n(partialTickGetter.apply((Entity)entity))).orElseGet(() -> Vec3D.b(this.c));
        }

        @Override
        public double a(World level, b camera, PartialTickSupplier partialTickGetter) {
            Vec3D vec3 = camera.b().d(this.a(level, partialTickGetter)).k();
            float f2 = (float)MathHelper.d(vec3.c(), vec3.a()) * 57.295776f;
            return MathHelper.c(camera.a(), f2);
        }

        @Override
        public e a(World level, f projector, PartialTickSupplier partialTickGetter) {
            double d2;
            Vec3D vec3 = projector.a(this.a(level, partialTickGetter));
            boolean flag = vec3.i > 1.0;
            double d3 = d2 = flag ? -vec3.h : vec3.h;
            if (d2 < -1.0) {
                return net.minecraft.world.waypoints.TrackedWaypoint$e.c;
            }
            if (d2 > 1.0) {
                return net.minecraft.world.waypoints.TrackedWaypoint$e.b;
            }
            if (flag) {
                if (vec3.h > 0.0) {
                    return net.minecraft.world.waypoints.TrackedWaypoint$e.b;
                }
                if (vec3.h < 0.0) {
                    return net.minecraft.world.waypoints.TrackedWaypoint$e.c;
                }
            }
            return net.minecraft.world.waypoints.TrackedWaypoint$e.a;
        }

        @Override
        public double a(Entity entity) {
            return entity.g(Vec3D.b(this.c));
        }
    }

    static class c
    extends TrackedWaypoint {
        private ChunkCoordIntPair c;

        public c(UUID uuid, Waypoint.a icon, ChunkCoordIntPair chunkPos) {
            super(Either.left(uuid), icon, g.c);
            this.c = chunkPos;
        }

        public c(Either<UUID, String> identifier, Waypoint.a icon, PacketDataSerializer buffer) {
            super(identifier, icon, g.c);
            this.c = new ChunkCoordIntPair(buffer.l(), buffer.l());
        }

        @Override
        public void a(TrackedWaypoint waypoint) {
            if (waypoint instanceof c) {
                c chunkWaypoint = (c)waypoint;
                this.c = chunkWaypoint.c;
            } else {
                c.warn("Unsupported Waypoint update operation: {}", waypoint.getClass());
            }
        }

        @Override
        public void b(ByteBuf buffer) {
            VarInt.a(buffer, this.c.h);
            VarInt.a(buffer, this.c.i);
        }

        private Vec3D a(double y2) {
            return Vec3D.b(this.c.c((int)y2));
        }

        @Override
        public double a(World level, b camera, PartialTickSupplier partialTickGetter) {
            Vec3D vec3 = camera.b();
            Vec3D vec31 = vec3.d(this.a(vec3.b())).k();
            float f2 = (float)MathHelper.d(vec31.c(), vec31.a()) * 57.295776f;
            return MathHelper.c(camera.a(), f2);
        }

        @Override
        public e a(World level, f projector, PartialTickSupplier partialTickGetter) {
            double d2 = projector.a();
            if (d2 < -1.0) {
                return net.minecraft.world.waypoints.TrackedWaypoint$e.c;
            }
            return d2 > 1.0 ? net.minecraft.world.waypoints.TrackedWaypoint$e.b : net.minecraft.world.waypoints.TrackedWaypoint$e.a;
        }

        @Override
        public double a(Entity entity) {
            return entity.g(Vec3D.b(this.c.c(entity.dL())));
        }
    }

    static class a
    extends TrackedWaypoint {
        private float c;

        public a(UUID uuid, Waypoint.a icon, float angle) {
            super(Either.left(uuid), icon, g.d);
            this.c = angle;
        }

        public a(Either<UUID, String> identifier, Waypoint.a icon, PacketDataSerializer buffer) {
            super(identifier, icon, g.d);
            this.c = buffer.readFloat();
        }

        @Override
        public void a(TrackedWaypoint waypoint) {
            if (waypoint instanceof a) {
                a azimuthWaypoint = (a)waypoint;
                this.c = azimuthWaypoint.c;
            } else {
                c.warn("Unsupported Waypoint update operation: {}", waypoint.getClass());
            }
        }

        @Override
        public void b(ByteBuf buffer) {
            buffer.writeFloat(this.c);
        }

        @Override
        public double a(World level, b camera, PartialTickSupplier partialTickGetter) {
            return MathHelper.c(camera.a(), this.c * 57.295776f);
        }

        @Override
        public e a(World level, f projector, PartialTickSupplier partialTickGetter) {
            double d2 = projector.a();
            if (d2 < -1.0) {
                return net.minecraft.world.waypoints.TrackedWaypoint$e.c;
            }
            return d2 > 1.0 ? net.minecraft.world.waypoints.TrackedWaypoint$e.b : net.minecraft.world.waypoints.TrackedWaypoint$e.a;
        }

        @Override
        public double a(Entity entity) {
            return Double.POSITIVE_INFINITY;
        }
    }

    static class d
    extends TrackedWaypoint {
        private d(Either<UUID, String> identifier, Waypoint.a icon, PacketDataSerializer buffer) {
            super(identifier, icon, g.a);
        }

        d(UUID uuid) {
            super(Either.left(uuid), Waypoint.a.c, g.a);
        }

        @Override
        public void a(TrackedWaypoint waypoint) {
        }

        @Override
        public void b(ByteBuf buffer) {
        }

        @Override
        public double a(World level, b camera, PartialTickSupplier partialTickGetter) {
            return Double.NaN;
        }

        @Override
        public e a(World level, f projector, PartialTickSupplier partialTickGetter) {
            return net.minecraft.world.waypoints.TrackedWaypoint$e.a;
        }

        @Override
        public double a(Entity entity) {
            return Double.POSITIVE_INFINITY;
        }
    }

    public static interface f {
        public Vec3D a(Vec3D var1);

        public double a();
    }

    public static final class e
    extends Enum<e> {
        public static final /* enum */ e a = new e();
        public static final /* enum */ e b = new e();
        public static final /* enum */ e c = new e();
        private static final /* synthetic */ e[] d;

        public static e[] values() {
            return (e[])d.clone();
        }

        public static e valueOf(String name) {
            return Enum.valueOf(e.class, name);
        }

        private static /* synthetic */ e[] a() {
            return new e[]{a, b, c};
        }

        static {
            d = net.minecraft.world.waypoints.TrackedWaypoint$e.a();
        }
    }

    public static interface b {
        public float a();

        public Vec3D b();
    }
}

