/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R6;

import com.google.common.collect.BiMap;
import com.google.common.collect.EnumBiMap;
import java.util.Locale;
import net.minecraft.SystemUtils;
import net.minecraft.world.EnumHand;
import net.minecraft.world.entity.EnumItemSlot;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.EquipmentSlotGroup;

public final class CraftEquipmentSlot {
    private static final BiMap<EnumItemSlot, EquipmentSlot> BRIDGE = (BiMap)SystemUtils.a(EnumBiMap.create(EnumItemSlot.class, EquipmentSlot.class), data -> {
        data.put((Object)EnumItemSlot.a, (Object)EquipmentSlot.HAND);
        data.put((Object)EnumItemSlot.b, (Object)EquipmentSlot.OFF_HAND);
        data.put((Object)EnumItemSlot.c, (Object)EquipmentSlot.FEET);
        data.put((Object)EnumItemSlot.d, (Object)EquipmentSlot.LEGS);
        data.put((Object)EnumItemSlot.e, (Object)EquipmentSlot.CHEST);
        data.put((Object)EnumItemSlot.f, (Object)EquipmentSlot.HEAD);
        data.put((Object)EnumItemSlot.g, (Object)EquipmentSlot.BODY);
        data.put((Object)EnumItemSlot.h, (Object)EquipmentSlot.SADDLE);
    });

    private CraftEquipmentSlot() {
    }

    public static EquipmentSlot getSlot(EnumItemSlot slot) {
        return (EquipmentSlot)BRIDGE.get((Object)slot);
    }

    public static EquipmentSlotGroup getSlotGroup(net.minecraft.world.entity.EquipmentSlotGroup slotGroup) {
        return EquipmentSlotGroup.getByName((String)slotGroup.c());
    }

    public static EnumItemSlot getNMS(EquipmentSlot slot) {
        return (EnumItemSlot)BRIDGE.inverse().get((Object)slot);
    }

    public static net.minecraft.world.entity.EquipmentSlotGroup getNMSGroup(EquipmentSlotGroup slot) {
        return net.minecraft.world.entity.EquipmentSlotGroup.valueOf(slot.toString().toUpperCase(Locale.ROOT));
    }

    public static EquipmentSlot getHand(EnumHand hand) {
        return hand == EnumHand.a ? EquipmentSlot.HAND : EquipmentSlot.OFF_HAND;
    }

    public static EnumHand getHand(EquipmentSlot hand) {
        if (hand == EquipmentSlot.HAND) {
            return EnumHand.a;
        }
        if (hand == EquipmentSlot.OFF_HAND) {
            return EnumHand.b;
        }
        throw new IllegalArgumentException("EquipmentSlot." + String.valueOf(hand) + " is not a hand");
    }
}

