/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R6;

import com.google.common.base.Preconditions;
import io.papermc.paper.adventure.PaperAdventure;
import io.papermc.paper.registry.RegistryKey;
import io.papermc.paper.util.Holderable;
import net.kyori.adventure.text.Component;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.contents.TranslatableContents;
import net.minecraft.world.item.Instrument;
import org.bukkit.MusicInstrument;
import org.bukkit.NamespacedKey;
import org.bukkit.Sound;
import org.bukkit.craftbukkit.v1_21_R6.CraftRegistry;
import org.bukkit.craftbukkit.v1_21_R6.CraftSound;
import org.jetbrains.annotations.NotNull;

public class CraftMusicInstrument
extends MusicInstrument
implements Holderable<Instrument> {
    private final Holder<Instrument> holder;

    public static MusicInstrument minecraftToBukkit(Instrument minecraft) {
        return (MusicInstrument)CraftRegistry.minecraftToBukkit(minecraft, Registries.bc);
    }

    public static MusicInstrument minecraftHolderToBukkit(Holder<Instrument> minecraft) {
        return (MusicInstrument)CraftRegistry.minecraftHolderToBukkit(minecraft, Registries.bc);
    }

    public static Instrument bukkitToMinecraft(MusicInstrument bukkit) {
        return (Instrument)CraftRegistry.bukkitToMinecraft(bukkit);
    }

    public static Holder<Instrument> bukkitToMinecraftHolder(MusicInstrument bukkit) {
        return CraftRegistry.bukkitToMinecraftHolder(bukkit);
    }

    public static Object bukkitToString(MusicInstrument bukkit) {
        Preconditions.checkArgument((bukkit != null ? 1 : 0) != 0);
        return ((CraftMusicInstrument)bukkit).toBukkitSerializationObject(Instrument.a);
    }

    public static MusicInstrument stringToBukkit(Object string) {
        Preconditions.checkArgument((string != null ? 1 : 0) != 0);
        return (MusicInstrument)Holderable.fromBukkitSerializationObject(string, Instrument.c, RegistryKey.INSTRUMENT);
    }

    public boolean equals(Object o2) {
        return this.implEquals(o2);
    }

    public int hashCode() {
        return this.implHashCode();
    }

    public String toString() {
        return this.implToString();
    }

    public CraftMusicInstrument(Holder<Instrument> holder) {
        this.holder = holder;
    }

    @Override
    public Holder<Instrument> getHolder() {
        return this.holder;
    }

    public float getDuration() {
        return ((Instrument)this.getHandle()).b();
    }

    public float getRange() {
        return ((Instrument)this.getHandle()).c();
    }

    public Component description() {
        return PaperAdventure.asAdventure(((Instrument)this.getHandle()).d());
    }

    public Sound getSound() {
        return CraftSound.minecraftHolderToBukkit(((Instrument)this.getHandle()).a());
    }

    @Override
    @NotNull
    public NamespacedKey getKey() {
        return Holderable.super.getKey();
    }

    @NotNull
    public String translationKey() {
        ComponentContents componentContents = ((Instrument)this.getHandle()).d().b();
        if (!(componentContents instanceof TranslatableContents)) {
            throw new UnsupportedOperationException("Description isn't translatable!");
        }
        TranslatableContents translatableContents = (TranslatableContents)componentContents;
        return translatableContents.b();
    }
}

