/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R6;

import com.destroystokyo.paper.profile.CraftPlayerProfile;
import com.destroystokyo.paper.profile.PlayerProfile;
import io.papermc.paper.persistence.PaperPersistentDataContainerView;
import io.papermc.paper.persistence.PersistentDataContainerView;
import java.io.File;
import java.io.IOException;
import java.time.Duration;
import java.time.Instant;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import net.minecraft.Optionull;
import net.minecraft.SystemUtils;
import net.minecraft.core.BaseBlockPosition;
import net.minecraft.core.GlobalPos;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTCompressedStreamTools;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagDouble;
import net.minecraft.nbt.NBTTagFloat;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.server.players.NameAndId;
import net.minecraft.server.players.WhiteListEntry;
import net.minecraft.stats.ServerStatisticManager;
import net.minecraft.world.level.storage.WorldNBTStorage;
import net.minecraft.world.phys.Vec2F;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.BanEntry;
import org.bukkit.BanList;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.Server;
import org.bukkit.Statistic;
import org.bukkit.World;
import org.bukkit.ban.ProfileBanList;
import org.bukkit.configuration.serialization.ConfigurationSerializable;
import org.bukkit.configuration.serialization.SerializableAs;
import org.bukkit.craftbukkit.v1_21_R6.CraftServer;
import org.bukkit.craftbukkit.v1_21_R6.CraftStatistic;
import org.bukkit.craftbukkit.v1_21_R6.persistence.CraftPersistentDataTypeRegistry;
import org.bukkit.craftbukkit.v1_21_R6.util.CraftLocation;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;

@SerializableAs(value="Player")
public class CraftOfflinePlayer
implements OfflinePlayer,
ConfigurationSerializable {
    private final NameAndId nameAndId;
    private final CraftServer server;
    private final WorldNBTStorage storage;
    private static final CraftPersistentDataTypeRegistry DATA_TYPE_REGISTRY = new CraftPersistentDataTypeRegistry();
    private @MonotonicNonNull PersistentDataContainerView persistentDataContainerView;

    protected CraftOfflinePlayer(CraftServer server, NameAndId nameAndId) {
        this.server = server;
        this.nameAndId = nameAndId;
        this.storage = server.console.h;
    }

    public boolean isOnline() {
        return this.getPlayer() != null;
    }

    public boolean isConnected() {
        return false;
    }

    public String getName() {
        Player player = this.getPlayer();
        if (player != null) {
            return player.getName();
        }
        if (!this.nameAndId.b().isEmpty()) {
            return this.nameAndId.b();
        }
        NBTTagCompound data = this.getBukkitData();
        if (data != null) {
            return data.i("lastKnownName").orElse(null);
        }
        return null;
    }

    public UUID getUniqueId() {
        return this.nameAndId.a();
    }

    public PlayerProfile getPlayerProfile() {
        return CraftPlayerProfile.asBukkitCopy(this.nameAndId.toUncompletedGameProfile());
    }

    public Server getServer() {
        return this.server;
    }

    public boolean isOp() {
        return this.server.getHandle().f(this.nameAndId);
    }

    public void setOp(boolean value) {
        if (value == this.isOp()) {
            return;
        }
        if (value) {
            this.server.getHandle().d(this.nameAndId);
        } else {
            this.server.getHandle().e(this.nameAndId);
        }
    }

    public boolean isBanned() {
        return ((ProfileBanList)this.server.getBanList(BanList.Type.PROFILE)).isBanned((Object)this.getPlayerProfile());
    }

    public BanEntry<PlayerProfile> ban(String reason, Date expires, String source) {
        return ((ProfileBanList)this.server.getBanList(BanList.Type.PROFILE)).addBan(this.getPlayerProfile(), reason, expires, source);
    }

    public BanEntry<PlayerProfile> ban(String reason, Instant expires, String source) {
        return ((ProfileBanList)this.server.getBanList(BanList.Type.PROFILE)).addBan((Object)this.getPlayerProfile(), reason, expires, source);
    }

    public BanEntry<PlayerProfile> ban(String reason, Duration duration, String source) {
        return ((ProfileBanList)this.server.getBanList(BanList.Type.PROFILE)).addBan((Object)this.getPlayerProfile(), reason, duration, source);
    }

    public void setBanned(boolean value) {
        if (value) {
            ((ProfileBanList)this.server.getBanList(BanList.Type.PROFILE)).addBan(this.getPlayerProfile(), null, (Date)null, null);
        } else {
            ((ProfileBanList)this.server.getBanList(BanList.Type.PROFILE)).pardon((Object)this.getPlayerProfile());
        }
    }

    public boolean isWhitelisted() {
        return this.server.getHandle().i().a(this.nameAndId);
    }

    public void setWhitelisted(boolean value) {
        if (value) {
            this.server.getHandle().i().a(new WhiteListEntry(this.nameAndId));
        } else {
            this.server.getHandle().i().b(this.nameAndId);
        }
    }

    public Map<String, Object> serialize() {
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        result.put("UUID", this.nameAndId.a().toString());
        return result;
    }

    public static OfflinePlayer deserialize(Map<String, Object> args) {
        if (args.get("name") != null) {
            return Bukkit.getServer().getOfflinePlayer((String)args.get("name"));
        }
        return Bukkit.getServer().getOfflinePlayer(UUID.fromString((String)args.get("UUID")));
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[UUID=" + String.valueOf(this.nameAndId.a()) + "]";
    }

    public Player getPlayer() {
        return this.server.getPlayer(this.getUniqueId());
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof OfflinePlayer)) {
            return false;
        }
        OfflinePlayer other = (OfflinePlayer)obj;
        return this.getUniqueId().equals(other.getUniqueId());
    }

    public int hashCode() {
        int hash = 5;
        hash = 97 * hash + this.getUniqueId().hashCode();
        return hash;
    }

    private NBTTagCompound getData() {
        return this.storage.a(this.nameAndId).orElse(null);
    }

    private NBTTagCompound getBukkitData() {
        NBTTagCompound result = this.getData();
        if (result != null) {
            result = result.m("bukkit").orElse(null);
        }
        return result;
    }

    private File getDataFile() {
        return new File(this.storage.getPlayerDir(), String.valueOf(this.getUniqueId()) + ".dat");
    }

    public long getFirstPlayed() {
        Player player = this.getPlayer();
        if (player != null) {
            return player.getFirstPlayed();
        }
        NBTTagCompound data = this.getBukkitData();
        if (data != null) {
            return data.f("firstPlayed").orElseGet(() -> {
                File file = this.getDataFile();
                return file.lastModified();
            });
        }
        return 0L;
    }

    public long getLastPlayed() {
        Player player = this.getPlayer();
        if (player != null) {
            return player.getLastPlayed();
        }
        NBTTagCompound data = this.getBukkitData();
        if (data != null) {
            return data.f("lastPlayed").orElseGet(() -> {
                File file = this.getDataFile();
                return file.lastModified();
            });
        }
        return 0L;
    }

    public boolean hasPlayedBefore() {
        return this.getData() != null;
    }

    public long getLastLogin() {
        Player player = this.getPlayer();
        if (player != null) {
            return player.getLastLogin();
        }
        NBTTagCompound data = this.getPaperData();
        if (data != null) {
            return data.f("LastLogin").orElseGet(() -> {
                File file = this.getDataFile();
                return file.lastModified();
            });
        }
        return 0L;
    }

    public long getLastSeen() {
        Player player = this.getPlayer();
        if (player != null) {
            return player.getLastSeen();
        }
        NBTTagCompound data = this.getPaperData();
        if (data != null) {
            return data.f("LastSeen").orElseGet(() -> {
                File file = this.getDataFile();
                return file.lastModified();
            });
        }
        return 0L;
    }

    private NBTTagCompound getPaperData() {
        NBTTagCompound result = this.getData();
        if (result != null) {
            result = result.m("Paper").orElse(null);
        }
        return result;
    }

    public PersistentDataContainerView getPersistentDataContainer() {
        if (this.persistentDataContainerView == null) {
            this.persistentDataContainerView = new PaperPersistentDataContainerView(DATA_TYPE_REGISTRY){

                private NBTTagCompound getPersistentTag() {
                    return Optionull.a(CraftOfflinePlayer.this.getData(), data -> data.m("BukkitValues").orElse(null));
                }

                @Override
                public NBTTagCompound toTagCompound() {
                    return Objects.requireNonNullElseGet(this.getPersistentTag(), NBTTagCompound::new);
                }

                @Override
                public NBTBase getTag(String key) {
                    return Optionull.a(this.getPersistentTag(), tag -> tag.a(key));
                }

                public int getSize() {
                    return this.getPersistentTag().i();
                }
            };
        }
        return this.persistentDataContainerView;
    }

    public Location getLastDeathLocation() {
        NBTTagCompound data = this.getData();
        if (data == null) {
            return null;
        }
        return data.a("LastDeathLocation", GlobalPos.b).map(CraftLocation::fromGlobalPos).orElse(null);
    }

    public Location getLocation() {
        if (this.isOnline()) {
            return this.getPlayer().getLocation();
        }
        NBTTagCompound data = this.getData();
        if (data == null) {
            return null;
        }
        Vec3D pos = data.a("Pos", Vec3D.a).orElse(null);
        Vec2F rot = data.a("Rotation", Vec2F.i).orElse(null);
        if (pos != null && rot != null) {
            Long msb = data.f("WorldUUIDMost").orElse(null);
            Long lsb = data.f("WorldUUIDLeast").orElse(null);
            World world = msb != null && lsb != null ? this.server.getWorld(new UUID(msb, lsb)) : null;
            return new Location(world, pos.a(), pos.b(), pos.c(), rot.j, rot.k);
        }
        return null;
    }

    public Location getRespawnLocation(boolean loadLocationAndValidate) {
        NBTTagCompound data = this.getData();
        if (data == null) {
            return null;
        }
        EntityPlayer.RespawnConfig respawnConfig = data.a("respawn", EntityPlayer.RespawnConfig.a).orElse(null);
        if (respawnConfig == null) {
            return null;
        }
        WorldServer level = this.server.console.a(respawnConfig.a().a());
        if (level == null) {
            return null;
        }
        if (!loadLocationAndValidate) {
            return CraftLocation.toBukkit((BaseBlockPosition)respawnConfig.a().b(), (net.minecraft.world.level.World)level, respawnConfig.a().d(), respawnConfig.a().e());
        }
        return EntityPlayer.a(level, respawnConfig, false).map(resolvedPos -> CraftLocation.toBukkit(resolvedPos.a(), (net.minecraft.world.level.World)level, resolvedPos.b(), resolvedPos.c())).orElse(null);
    }

    private ServerStatisticManager getStatisticManager() {
        return this.server.getHandle().getPlayerStats(this.getUniqueId(), this.getName());
    }

    public void incrementStatistic(Statistic statistic) {
        if (this.isOnline()) {
            this.getPlayer().incrementStatistic(statistic);
        } else {
            ServerStatisticManager manager = this.getStatisticManager();
            CraftStatistic.incrementStatistic(manager, statistic, null);
            manager.a();
        }
    }

    public void decrementStatistic(Statistic statistic) {
        if (this.isOnline()) {
            this.getPlayer().decrementStatistic(statistic);
        } else {
            ServerStatisticManager manager = this.getStatisticManager();
            CraftStatistic.decrementStatistic(manager, statistic, null);
            manager.a();
        }
    }

    public int getStatistic(Statistic statistic) {
        if (this.isOnline()) {
            return this.getPlayer().getStatistic(statistic);
        }
        return CraftStatistic.getStatistic(this.getStatisticManager(), statistic);
    }

    public void incrementStatistic(Statistic statistic, int amount) {
        if (this.isOnline()) {
            this.getPlayer().incrementStatistic(statistic, amount);
        } else {
            ServerStatisticManager manager = this.getStatisticManager();
            CraftStatistic.incrementStatistic(manager, statistic, amount, null);
            manager.a();
        }
    }

    public void decrementStatistic(Statistic statistic, int amount) {
        if (this.isOnline()) {
            this.getPlayer().decrementStatistic(statistic, amount);
        } else {
            ServerStatisticManager manager = this.getStatisticManager();
            CraftStatistic.decrementStatistic(manager, statistic, amount, null);
            manager.a();
        }
    }

    public void setStatistic(Statistic statistic, int newValue) {
        if (this.isOnline()) {
            this.getPlayer().setStatistic(statistic, newValue);
        } else {
            ServerStatisticManager manager = this.getStatisticManager();
            CraftStatistic.setStatistic(manager, statistic, newValue, null);
            manager.a();
        }
    }

    public void incrementStatistic(Statistic statistic, Material material) {
        if (this.isOnline()) {
            this.getPlayer().incrementStatistic(statistic, material);
        } else {
            ServerStatisticManager manager = this.getStatisticManager();
            CraftStatistic.incrementStatistic(manager, statistic, material, null);
            manager.a();
        }
    }

    public void decrementStatistic(Statistic statistic, Material material) {
        if (this.isOnline()) {
            this.getPlayer().decrementStatistic(statistic, material);
        } else {
            ServerStatisticManager manager = this.getStatisticManager();
            CraftStatistic.decrementStatistic(manager, statistic, material, null);
            manager.a();
        }
    }

    public int getStatistic(Statistic statistic, Material material) {
        if (this.isOnline()) {
            return this.getPlayer().getStatistic(statistic, material);
        }
        return CraftStatistic.getStatistic(this.getStatisticManager(), statistic, material);
    }

    public void incrementStatistic(Statistic statistic, Material material, int amount) {
        if (this.isOnline()) {
            this.getPlayer().incrementStatistic(statistic, material, amount);
        } else {
            ServerStatisticManager manager = this.getStatisticManager();
            CraftStatistic.incrementStatistic(manager, statistic, material, amount, null);
            manager.a();
        }
    }

    public void decrementStatistic(Statistic statistic, Material material, int amount) {
        if (this.isOnline()) {
            this.getPlayer().decrementStatistic(statistic, material, amount);
        } else {
            ServerStatisticManager manager = this.getStatisticManager();
            CraftStatistic.decrementStatistic(manager, statistic, material, amount, null);
            manager.a();
        }
    }

    public void setStatistic(Statistic statistic, Material material, int newValue) {
        if (this.isOnline()) {
            this.getPlayer().setStatistic(statistic, material, newValue);
        } else {
            ServerStatisticManager manager = this.getStatisticManager();
            CraftStatistic.setStatistic(manager, statistic, material, newValue, null);
            manager.a();
        }
    }

    public void incrementStatistic(Statistic statistic, EntityType entityType) {
        if (this.isOnline()) {
            this.getPlayer().incrementStatistic(statistic, entityType);
        } else {
            ServerStatisticManager manager = this.getStatisticManager();
            CraftStatistic.incrementStatistic(manager, statistic, entityType, null);
            manager.a();
        }
    }

    public void decrementStatistic(Statistic statistic, EntityType entityType) {
        if (this.isOnline()) {
            this.getPlayer().decrementStatistic(statistic, entityType);
        } else {
            ServerStatisticManager manager = this.getStatisticManager();
            CraftStatistic.decrementStatistic(manager, statistic, entityType, null);
            manager.a();
        }
    }

    public int getStatistic(Statistic statistic, EntityType entityType) {
        if (this.isOnline()) {
            return this.getPlayer().getStatistic(statistic, entityType);
        }
        return CraftStatistic.getStatistic(this.getStatisticManager(), statistic, entityType);
    }

    public void incrementStatistic(Statistic statistic, EntityType entityType, int amount) {
        if (this.isOnline()) {
            this.getPlayer().incrementStatistic(statistic, entityType, amount);
        } else {
            ServerStatisticManager manager = this.getStatisticManager();
            CraftStatistic.incrementStatistic(manager, statistic, entityType, amount, null);
            manager.a();
        }
    }

    public void decrementStatistic(Statistic statistic, EntityType entityType, int amount) {
        if (this.isOnline()) {
            this.getPlayer().decrementStatistic(statistic, entityType, amount);
        } else {
            ServerStatisticManager manager = this.getStatisticManager();
            CraftStatistic.decrementStatistic(manager, statistic, entityType, amount, null);
            manager.a();
        }
    }

    public void setStatistic(Statistic statistic, EntityType entityType, int newValue) {
        if (this.isOnline()) {
            this.getPlayer().setStatistic(statistic, entityType, newValue);
        } else {
            ServerStatisticManager manager = this.getStatisticManager();
            CraftStatistic.setStatistic(manager, statistic, entityType, newValue, null);
            manager.a();
        }
    }

    public boolean getAllowFlight() {
        if (this.isOnline()) {
            return this.getPlayer().getAllowFlight();
        }
        NBTTagCompound data = this.getData();
        if (data == null) {
            return false;
        }
        NBTBase nBTBase = data.a("abilities");
        if (!(nBTBase instanceof NBTTagCompound)) {
            return false;
        }
        NBTTagCompound abilities = (NBTTagCompound)nBTBase;
        return abilities.b("mayfly", (byte)0) == 1;
    }

    public void setAllowFlight(boolean flight) {
        if (this.isOnline()) {
            this.getPlayer().setAllowFlight(flight);
        } else {
            NBTTagCompound data = this.getData();
            if (data == null) {
                return;
            }
            NBTBase nBTBase = data.a("abilities");
            if (!(nBTBase instanceof NBTTagCompound)) {
                return;
            }
            NBTTagCompound abilities = (NBTTagCompound)nBTBase;
            abilities.a("mayfly", (byte)(flight ? 1 : 0));
            data.a("abilities", abilities);
            this.save(data);
        }
    }

    public boolean isFlying() {
        if (this.isOnline()) {
            return this.isFlying();
        }
        NBTTagCompound data = this.getData();
        if (data == null) {
            return false;
        }
        NBTBase nBTBase = data.a("abilities");
        if (!(nBTBase instanceof NBTTagCompound)) {
            return false;
        }
        NBTTagCompound abilities = (NBTTagCompound)nBTBase;
        return abilities.b("flying", (byte)0) == 1;
    }

    public void setFlying(boolean value) {
        if (this.isOnline()) {
            this.getPlayer().setFlying(value);
        } else {
            NBTTagCompound data = this.getData();
            if (data == null) {
                return;
            }
            NBTBase nBTBase = data.a("abilities");
            if (!(nBTBase instanceof NBTTagCompound)) {
                return;
            }
            NBTTagCompound abilities = (NBTTagCompound)nBTBase;
            abilities.a("mayfly", (byte)(value ? 1 : 0));
            data.a("abilities", abilities);
            this.save(data);
        }
    }

    public void setFlySpeed(float value) throws IllegalArgumentException {
        if (value < -1.0f || value > 1.0f) {
            throw new IllegalArgumentException("FlySpeed needs to be between -1 and 1");
        }
        if (this.isOnline()) {
            this.getPlayer().setFlySpeed(value);
        } else {
            NBTTagCompound data = this.getData();
            if (data == null) {
                return;
            }
            NBTBase nBTBase = data.a("abilities");
            if (!(nBTBase instanceof NBTTagCompound)) {
                return;
            }
            NBTTagCompound abilities = (NBTTagCompound)nBTBase;
            abilities.a("flySpeed", value);
            data.a("abilities", abilities);
            this.save(data);
        }
    }

    public float getFlySpeed() {
        if (this.isOnline()) {
            return this.getPlayer().getFlySpeed();
        }
        NBTTagCompound data = this.getData();
        if (data == null) {
            return 0.0f;
        }
        NBTBase nBTBase = data.a("abilities");
        if (!(nBTBase instanceof NBTTagCompound)) {
            return 0.0f;
        }
        NBTTagCompound abilities = (NBTTagCompound)nBTBase;
        return abilities.b("flySpeed", 0.0f);
    }

    public void setWalkSpeed(float value) throws IllegalArgumentException {
        if (value < -1.0f || value > 1.0f) {
            throw new IllegalArgumentException("WalkSpeed needs to be between -1 and 1");
        }
        if (this.isOnline()) {
            this.getPlayer().setWalkSpeed(value);
        } else {
            NBTTagCompound data = this.getData();
            if (data == null) {
                return;
            }
            NBTBase nBTBase = data.a("abilities");
            if (!(nBTBase instanceof NBTTagCompound)) {
                return;
            }
            NBTTagCompound abilities = (NBTTagCompound)nBTBase;
            abilities.a("walkSpeed", value);
            data.a("abilities", abilities);
            this.save(data);
        }
    }

    public float getWalkSpeed() {
        if (this.isOnline()) {
            return this.getPlayer().getWalkSpeed();
        }
        NBTTagCompound data = this.getData();
        if (data == null) {
            return 0.0f;
        }
        NBTBase nBTBase = data.a("abilities");
        if (!(nBTBase instanceof NBTTagCompound)) {
            return 0.0f;
        }
        NBTTagCompound abilities = (NBTTagCompound)nBTBase;
        return abilities.b("walkSpeed", 0.0f);
    }

    public boolean teleportOffline(Location destination) {
        if (this.isOnline()) {
            return this.getPlayer().teleport(destination);
        }
        return this.setLocation(destination);
    }

    public boolean teleportOffline(Location destination, PlayerTeleportEvent.TeleportCause cause) {
        if (this.isOnline()) {
            return this.getPlayer().teleport(destination, cause);
        }
        return this.setLocation(destination);
    }

    public CompletableFuture<Boolean> teleportOfflineAsync(Location destination) {
        if (this.isOnline()) {
            return this.getPlayer().teleportAsync(destination);
        }
        return CompletableFuture.completedFuture(this.setLocation(destination));
    }

    public CompletableFuture<Boolean> teleportOfflineAsync(Location destination, PlayerTeleportEvent.TeleportCause cause) {
        if (this.isOnline()) {
            return this.getPlayer().teleportAsync(destination, cause);
        }
        return CompletableFuture.completedFuture(this.setLocation(destination));
    }

    private boolean setLocation(Location location) {
        NBTTagCompound data = this.getData();
        if (data == null) {
            return false;
        }
        data.a("WorldUUIDMost", location.getWorld().getUID().getMostSignificantBits());
        data.a("WorldUUIDLeast", location.getWorld().getUID().getLeastSignificantBits());
        NBTTagList position = new NBTTagList();
        position.add(NBTTagDouble.a(location.getX()));
        position.add(NBTTagDouble.a(location.getY()));
        position.add(NBTTagDouble.a(location.getZ()));
        data.a("Pos", position);
        NBTTagList rotation = new NBTTagList();
        rotation.add(NBTTagFloat.a(location.getYaw()));
        rotation.add(NBTTagFloat.a(location.getPitch()));
        data.a("Rotation", rotation);
        this.save(data);
        return true;
    }

    private void save(NBTTagCompound compoundTag) {
        File playerDir = this.server.console.h.getPlayerDir();
        try {
            File tempFile = File.createTempFile(String.valueOf(this.getUniqueId()) + "-", ".dat", playerDir);
            NBTCompressedStreamTools.a(compoundTag, tempFile.toPath());
            File playerDataFile = new File(playerDir, String.valueOf(this.getUniqueId()) + ".dat");
            File playerDataFileOld = new File(playerDir, String.valueOf(this.getUniqueId()) + ".dat_old");
            SystemUtils.a(playerDataFile.toPath(), tempFile.toPath(), playerDataFileOld.toPath());
        }
        catch (IOException e2) {
            e2.printStackTrace();
        }
    }
}

