/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R6;

import com.google.common.base.Preconditions;
import io.papermc.paper.block.fluid.FluidData;
import io.papermc.paper.block.fluid.PaperFluidData;
import io.papermc.paper.world.MoonPhase;
import io.papermc.paper.world.flag.FeatureDependant;
import io.papermc.paper.world.flag.PaperFeatureFlagProviderImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.features.TreeFeatures;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.WorldServer;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.GroupDataEntity;
import net.minecraft.world.level.GeneratorAccessSeed;
import net.minecraft.world.level.RayTrace;
import net.minecraft.world.level.WorldAccess;
import net.minecraft.world.level.biome.BiomeBase;
import net.minecraft.world.level.block.BlockChorusFlower;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.feature.WorldGenFeatureConfigured;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.MovingObjectPosition;
import net.minecraft.world.phys.Vec3D;
import net.minecraft.world.phys.shapes.VoxelShapeCollision;
import org.bukkit.FeatureFlag;
import org.bukkit.HeightMap;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.RegionAccessor;
import org.bukkit.TreeType;
import org.bukkit.block.Biome;
import org.bukkit.block.BlockState;
import org.bukkit.block.data.BlockData;
import org.bukkit.craftbukkit.v1_21_R6.CraftHeightMap;
import org.bukkit.craftbukkit.v1_21_R6.block.CraftBiome;
import org.bukkit.craftbukkit.v1_21_R6.block.CraftBlock;
import org.bukkit.craftbukkit.v1_21_R6.block.CraftBlockType;
import org.bukkit.craftbukkit.v1_21_R6.block.data.CraftBlockData;
import org.bukkit.craftbukkit.v1_21_R6.entity.CraftEntity;
import org.bukkit.craftbukkit.v1_21_R6.entity.CraftEntityTypes;
import org.bukkit.craftbukkit.v1_21_R6.util.BlockStateListPopulator;
import org.bukkit.craftbukkit.v1_21_R6.util.CraftLocation;
import org.bukkit.craftbukkit.v1_21_R6.util.CraftNamespacedKey;
import org.bukkit.craftbukkit.v1_21_R6.util.RandomSourceWrapper;
import org.bukkit.entity.AbstractArrow;
import org.bukkit.entity.AbstractCow;
import org.bukkit.entity.AbstractHorse;
import org.bukkit.entity.Arrow;
import org.bukkit.entity.Cow;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Fireball;
import org.bukkit.entity.Horse;
import org.bukkit.entity.LargeFireball;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Minecart;
import org.bukkit.entity.SizedFireball;
import org.bukkit.entity.SplashPotion;
import org.bukkit.entity.ThrownPotion;
import org.bukkit.entity.TippedArrow;
import org.bukkit.entity.minecart.RideableMinecart;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.potion.PotionType;
import org.bukkit.util.BoundingBox;
import org.jetbrains.annotations.NotNull;

public abstract class CraftRegionAccessor
implements RegionAccessor {
    public abstract GeneratorAccessSeed getHandle();

    public boolean isNormalWorld() {
        return this.getHandle() instanceof WorldServer;
    }

    public Biome getBiome(int x2, int y2, int z2) {
        return CraftBiome.minecraftHolderToBukkit(this.getHandle().getNoiseBiome(x2 >> 2, y2 >> 2, z2 >> 2));
    }

    public Biome getComputedBiome(int x2, int y2, int z2) {
        return CraftBiome.minecraftHolderToBukkit(this.getHandle().v(new BlockPosition(x2, y2, z2)));
    }

    public void setBiome(int x2, int y2, int z2, Biome biome) {
        Preconditions.checkArgument((biome != Biome.CUSTOM ? 1 : 0) != 0, (String)"Cannot set the biome to %s", (Object)biome);
        Holder<BiomeBase> biomeBase = CraftBiome.bukkitToMinecraftHolder(biome);
        this.setBiome(x2, y2, z2, biomeBase);
    }

    public abstract void setBiome(int var1, int var2, int var3, Holder<BiomeBase> var4);

    public BlockState getBlockState(int x2, int y2, int z2) {
        return CraftBlock.at(this.getHandle(), new BlockPosition(x2, y2, z2)).getState();
    }

    public FluidData getFluidData(int x2, int y2, int z2) {
        return PaperFluidData.createData(this.getHandle().b_(new BlockPosition(x2, y2, z2)));
    }

    public BlockData getBlockData(int x2, int y2, int z2) {
        return CraftBlockData.fromData(this.getData(x2, y2, z2));
    }

    public Material getType(int x2, int y2, int z2) {
        return CraftBlockType.minecraftToBukkit(this.getData(x2, y2, z2).b());
    }

    private IBlockData getData(int x2, int y2, int z2) {
        return this.getHandle().a_(new BlockPosition(x2, y2, z2));
    }

    public void setBlockData(int x2, int y2, int z2, BlockData blockData) {
        GeneratorAccessSeed world = this.getHandle();
        BlockPosition pos = new BlockPosition(x2, y2, z2);
        IBlockData old = this.getHandle().a_(pos);
        CraftBlock.setBlockState(world, pos, old, ((CraftBlockData)blockData).getState(), true);
    }

    public int getHighestBlockYAt(int x2, int z2) {
        return this.getHighestBlockYAt(x2, z2, HeightMap.MOTION_BLOCKING);
    }

    public int getHighestBlockYAt(Location location) {
        return this.getHighestBlockYAt(location.getBlockX(), location.getBlockZ());
    }

    public int getHighestBlockYAt(int x2, int z2, HeightMap heightMap) {
        return this.getHandle().a(CraftHeightMap.toNMS(heightMap), x2, z2);
    }

    public int getHighestBlockYAt(Location location, HeightMap heightMap) {
        return this.getHighestBlockYAt(location.getBlockX(), location.getBlockZ(), heightMap);
    }

    public boolean generateTree(Location location, Random random, TreeType treeType) {
        BlockPosition pos = CraftLocation.toBlockPosition(location);
        return this.generateTree(this.getHandle(), this.getHandle().getMinecraftWorld().n().g(), pos, new RandomSourceWrapper(random), treeType);
    }

    public boolean generateTree(Location location, Random random, TreeType treeType, Consumer<? super BlockState> consumer) {
        return this.generateTree(location, random, treeType, consumer == null ? null : block -> {
            consumer.accept((BlockState)block);
            return true;
        });
    }

    public boolean generateTree(Location location, Random random, TreeType treeType, Predicate<? super BlockState> predicate) {
        BlockPosition pos = CraftLocation.toBlockPosition(location);
        BlockStateListPopulator populator = new BlockStateListPopulator(this.getHandle());
        boolean result = this.generateTree(populator, this.getHandle().getMinecraftWorld().n().g(), pos, new RandomSourceWrapper(random), treeType);
        populator.placeSomeBlocks(predicate == null ? $ -> true : predicate);
        return result;
    }

    public boolean generateTree(GeneratorAccessSeed access, ChunkGenerator chunkGenerator, BlockPosition pos, RandomSource random, TreeType treeType) {
        ResourceKey<WorldGenFeatureConfigured<?, ?>> gen;
        switch (treeType) {
            case BIG_TREE: {
                gen = TreeFeatures.q;
                break;
            }
            case BIRCH: {
                gen = TreeFeatures.l;
                break;
            }
            case REDWOOD: {
                gen = TreeFeatures.n;
                break;
            }
            case TALL_REDWOOD: {
                gen = TreeFeatures.o;
                break;
            }
            case JUNGLE: {
                gen = TreeFeatures.s;
                break;
            }
            case SMALL_JUNGLE: {
                gen = TreeFeatures.r;
                break;
            }
            case COCOA_TREE: {
                gen = TreeFeatures.p;
                break;
            }
            case JUNGLE_BUSH: {
                gen = TreeFeatures.y;
                break;
            }
            case RED_MUSHROOM: {
                gen = TreeFeatures.f;
                break;
            }
            case BROWN_MUSHROOM: {
                gen = TreeFeatures.e;
                break;
            }
            case SWAMP: {
                gen = TreeFeatures.x;
                break;
            }
            case ACACIA: {
                gen = TreeFeatures.m;
                break;
            }
            case DARK_OAK: {
                gen = TreeFeatures.h;
                break;
            }
            case MEGA_REDWOOD: {
                gen = TreeFeatures.t;
                break;
            }
            case MEGA_PINE: {
                gen = TreeFeatures.u;
                break;
            }
            case TALL_BIRCH: {
                gen = TreeFeatures.v;
                break;
            }
            case CHORUS_PLANT: {
                BlockChorusFlower.a(access, pos, random, 8);
                return true;
            }
            case CRIMSON_FUNGUS: {
                gen = this.isNormalWorld() ? TreeFeatures.b : TreeFeatures.a;
                break;
            }
            case WARPED_FUNGUS: {
                gen = this.isNormalWorld() ? TreeFeatures.d : TreeFeatures.c;
                break;
            }
            case AZALEA: {
                gen = TreeFeatures.z;
                break;
            }
            case MANGROVE: {
                gen = TreeFeatures.A;
                break;
            }
            case TALL_MANGROVE: {
                gen = TreeFeatures.B;
                break;
            }
            case CHERRY: {
                gen = TreeFeatures.C;
                break;
            }
            case PALE_OAK: {
                gen = TreeFeatures.i;
                break;
            }
            case PALE_OAK_CREAKING: {
                gen = TreeFeatures.k;
                break;
            }
            default: {
                gen = TreeFeatures.g;
            }
        }
        Holder holder = access.L_().f(Registries.aS).a(gen).orElse(null);
        return holder != null && ((WorldGenFeatureConfigured)holder.a()).a(access, chunkGenerator, random, pos);
    }

    public Entity spawnEntity(Location loc, EntityType type, boolean randomizeData) {
        return this.spawn(loc, type.getEntityClass(), null, CreatureSpawnEvent.SpawnReason.CUSTOM, randomizeData);
    }

    public List<Entity> getEntities() {
        ArrayList<Entity> list = new ArrayList<Entity>();
        this.getNMSEntities().forEach(entity -> {
            CraftEntity bukkitEntity = entity.getBukkitEntity();
            if (bukkitEntity != null && (!this.isNormalWorld() || bukkitEntity.isValid())) {
                list.add(bukkitEntity);
            }
        });
        return list;
    }

    public List<LivingEntity> getLivingEntities() {
        ArrayList<LivingEntity> list = new ArrayList<LivingEntity>();
        this.getNMSEntities().forEach(entity -> {
            CraftEntity bukkitEntity = entity.getBukkitEntity();
            if (bukkitEntity instanceof LivingEntity && (!this.isNormalWorld() || bukkitEntity.isValid())) {
                list.add((LivingEntity)bukkitEntity);
            }
        });
        return list;
    }

    public <T extends Entity> Collection<T> getEntitiesByClass(Class<T> clazz) {
        ArrayList list = new ArrayList();
        this.getNMSEntities().forEach(entity -> {
            CraftEntity bukkitEntity = entity.getBukkitEntity();
            if (bukkitEntity == null) {
                return;
            }
            Class bukkitClass = bukkitEntity.getClass();
            if (clazz.isAssignableFrom(bukkitClass) && (!this.isNormalWorld() || bukkitEntity.isValid())) {
                list.add(bukkitEntity);
            }
        });
        return list;
    }

    public Collection<Entity> getEntitiesByClasses(Class<?> ... classes) {
        ArrayList<Entity> list = new ArrayList<Entity>();
        this.getNMSEntities().forEach(entity -> {
            CraftEntity bukkitEntity = entity.getBukkitEntity();
            if (bukkitEntity == null) {
                return;
            }
            Class bukkitClass = bukkitEntity.getClass();
            for (Class clazz : classes) {
                if (!clazz.isAssignableFrom(bukkitClass)) continue;
                if (this.isNormalWorld() && !bukkitEntity.isValid()) break;
                list.add(bukkitEntity);
                break;
            }
        });
        return list;
    }

    public abstract Iterable<net.minecraft.world.entity.Entity> getNMSEntities();

    public <T extends Entity> T createEntity(Location location, Class<T> clazz) throws IllegalArgumentException {
        net.minecraft.world.entity.Entity entity = this.createEntity(location, clazz, true);
        if (!this.isNormalWorld()) {
            entity.generation = true;
        }
        return (T)entity.getBukkitEntity();
    }

    public <T extends Entity> T spawn(Location location, Class<T> clazz, Consumer<? super T> function) throws IllegalArgumentException {
        return this.spawn(location, clazz, function, CreatureSpawnEvent.SpawnReason.CUSTOM);
    }

    public <T extends Entity> T spawn(Location location, Class<T> clazz, boolean randomizeData, Consumer<? super T> function) throws IllegalArgumentException {
        return this.spawn(location, clazz, function, CreatureSpawnEvent.SpawnReason.CUSTOM, randomizeData);
    }

    public <T extends Entity> T spawn(Location location, Class<T> clazz, Consumer<? super T> function, CreatureSpawnEvent.SpawnReason reason) throws IllegalArgumentException {
        return this.spawn(location, clazz, function, reason, true);
    }

    public <T extends Entity> T spawn(Location location, Class<T> clazz, Consumer<? super T> function, CreatureSpawnEvent.SpawnReason reason, boolean randomizeData) throws IllegalArgumentException {
        net.minecraft.world.entity.Entity entity = this.createEntity(location, clazz, randomizeData);
        return this.addEntity(entity, reason, function, randomizeData);
    }

    public <T extends Entity> T addEntity(T entity) {
        Preconditions.checkArgument((!entity.isInWorld() ? 1 : 0) != 0, (Object)"Entity has already been added to a world");
        net.minecraft.world.entity.Entity nmsEntity = ((CraftEntity)entity).getHandle();
        if (nmsEntity.an() != this.getHandle().a()) {
            throw new IllegalArgumentException(String.valueOf(entity) + " wasn't created with this world, you must create the entity with the world you want to add it to.");
        }
        this.addEntityWithPassengers(nmsEntity, CreatureSpawnEvent.SpawnReason.CUSTOM);
        return (T)nmsEntity.getBukkitEntity();
    }

    public <T extends Entity> T addEntity(net.minecraft.world.entity.Entity entity, CreatureSpawnEvent.SpawnReason reason) throws IllegalArgumentException {
        return this.addEntity(entity, reason, null, true);
    }

    public <T extends Entity> T addEntity(net.minecraft.world.entity.Entity entity, CreatureSpawnEvent.SpawnReason reason, Consumer<? super T> function, boolean randomizeData) throws IllegalArgumentException {
        Preconditions.checkArgument((entity != null ? 1 : 0) != 0, (Object)"Cannot spawn null entity");
        if (randomizeData && entity instanceof EntityInsentient) {
            ((EntityInsentient)entity).a((WorldAccess)this.getHandle(), this.getHandle().d_(entity.dF()), EntitySpawnReason.n, (GroupDataEntity)null);
        }
        if (!this.isNormalWorld()) {
            entity.generation = true;
        }
        if (function != null) {
            function.accept(entity.getBukkitEntity());
        }
        this.addEntityToWorld(entity, reason);
        return (T)entity.getBukkitEntity();
    }

    public abstract void addEntityToWorld(net.minecraft.world.entity.Entity var1, CreatureSpawnEvent.SpawnReason var2);

    public abstract void addEntityWithPassengers(net.minecraft.world.entity.Entity var1, CreatureSpawnEvent.SpawnReason var2);

    public net.minecraft.world.entity.Entity createEntity(Location location, Class<? extends Entity> clazz, boolean randomizeData) throws IllegalArgumentException {
        Preconditions.checkArgument((location != null ? 1 : 0) != 0, (Object)"Location cannot be null");
        Preconditions.checkArgument((clazz != null ? 1 : 0) != 0, (Object)"Entity class cannot be null");
        Consumer<net.minecraft.world.entity.Entity> runOld = other -> {};
        if (clazz == AbstractArrow.class) {
            clazz = Arrow.class;
        } else if (clazz == AbstractHorse.class) {
            clazz = Horse.class;
        } else if (clazz == AbstractCow.class) {
            clazz = Cow.class;
        } else if (clazz == Fireball.class) {
            clazz = LargeFireball.class;
        } else if (clazz == ThrownPotion.class) {
            clazz = SplashPotion.class;
        } else if (clazz == Minecart.class) {
            clazz = RideableMinecart.class;
        } else if (clazz == SizedFireball.class) {
            clazz = LargeFireball.class;
        } else if (clazz == TippedArrow.class) {
            clazz = Arrow.class;
            runOld = other -> ((Arrow)other.getBukkitEntity()).setBasePotionType(PotionType.WATER);
        }
        CraftEntityTypes.EntityTypeData entityTypeData = CraftEntityTypes.getEntityTypeData(clazz);
        if (entityTypeData == null || entityTypeData.spawnFunction() == null) {
            if (CraftEntity.class.isAssignableFrom(clazz)) {
                throw new IllegalArgumentException(String.format("Cannot spawn an entity from its CraftBukkit implementation class '%s' use the Bukkit class instead. You can get the Bukkit representation via Entity#getType()#getEntityClass()", clazz.getName()));
            }
            throw new IllegalArgumentException("Cannot spawn an entity for " + clazz.getName());
        }
        if (!this.isEnabled((FeatureDependant)entityTypeData.entityType())) {
            throw new IllegalArgumentException("Cannot spawn an entity for " + clazz.getName() + " because it is not an enabled feature");
        }
        net.minecraft.world.entity.Entity entity = (net.minecraft.world.entity.Entity)entityTypeData.spawnFunction().apply(new CraftEntityTypes.SpawnData(this.getHandle(), location, randomizeData, this.isNormalWorld()));
        if (entity != null) {
            runOld.accept(entity);
            return entity;
        }
        throw new IllegalArgumentException("Cannot spawn an entity for " + clazz.getName());
    }

    public MoonPhase getMoonPhase() {
        return MoonPhase.getPhase((long)(this.getHandle().ap() / 24000L));
    }

    public NamespacedKey getKey() {
        return CraftNamespacedKey.fromMinecraft(this.getHandle().a().al().a());
    }

    public boolean lineOfSightExists(Location from, Location to) {
        Preconditions.checkArgument((from != null ? 1 : 0) != 0, (Object)"from parameter in lineOfSightExists cannot be null");
        Preconditions.checkArgument((to != null ? 1 : 0) != 0, (Object)"to parameter in lineOfSightExists cannot be null");
        if (from.getWorld() != to.getWorld()) {
            return false;
        }
        Vec3D start = new Vec3D(from.getX(), from.getY(), from.getZ());
        Vec3D end = new Vec3D(to.getX(), to.getY(), to.getZ());
        if (end.g(start) > MathHelper.l(128.0)) {
            return false;
        }
        return this.getHandle().a(new RayTrace(start, end, RayTrace.BlockCollisionOption.a, RayTrace.FluidCollisionOption.a, VoxelShapeCollision.a())).d() == MovingObjectPosition.EnumMovingObjectType.a;
    }

    public boolean hasCollisionsIn(@NotNull BoundingBox boundingBox) {
        AxisAlignedBB aabb = new AxisAlignedBB(boundingBox.getMinX(), boundingBox.getMinY(), boundingBox.getMinZ(), boundingBox.getMaxX(), boundingBox.getMaxY(), boundingBox.getMaxZ());
        return !this.getHandle().b(aabb);
    }

    public Set<FeatureFlag> getFeatureFlags() {
        return PaperFeatureFlagProviderImpl.fromNms(this.getHandle().O());
    }
}

