/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R6;

import ca.spottedleaf.concurrentutil.util.Priority;
import ca.spottedleaf.moonrise.common.PlatformHooks;
import ca.spottedleaf.moonrise.common.list.ReferenceList;
import ca.spottedleaf.moonrise.common.util.CoordinateUtils;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.mojang.datafixers.util.Pair;
import io.papermc.paper.FeatureHooks;
import io.papermc.paper.adventure.PaperAdventure;
import io.papermc.paper.event.world.WorldGameRuleChangeEvent;
import io.papermc.paper.math.Position;
import io.papermc.paper.raytracing.PositionedRayTraceConfigurationBuilder;
import io.papermc.paper.raytracing.PositionedRayTraceConfigurationBuilderImpl;
import io.papermc.paper.raytracing.RayTraceTarget;
import io.papermc.paper.registry.RegistryAccess;
import io.papermc.paper.registry.RegistryKey;
import io.papermc.paper.util.MCUtil;
import io.papermc.paper.util.StackWalkerUtil;
import io.papermc.paper.util.TraceUtil;
import it.unimi.dsi.fastutil.longs.LongIterator;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.PrimitiveIterator;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.kyori.adventure.identity.Identity;
import net.kyori.adventure.pointer.Pointers;
import net.kyori.adventure.pointer.PointersSupplier;
import net.kyori.adventure.sound.Sound;
import net.kyori.adventure.util.TriState;
import net.minecraft.core.BaseBlockPosition;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.IRegistry;
import net.minecraft.core.particles.ParticleParam;
import net.minecraft.core.particles.Particles;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.PacketPlayOutEntitySound;
import net.minecraft.network.protocol.game.PacketPlayOutNamedSoundEffect;
import net.minecraft.network.protocol.game.PacketPlayOutUpdateTime;
import net.minecraft.network.protocol.game.PacketPlayOutWorldEvent;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ChunkProviderServer;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.PlayerChunk;
import net.minecraft.server.level.PlayerChunkMap;
import net.minecraft.server.level.TicketType;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.util.MathHelper;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EntityLightning;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.item.EntityFallingBlock;
import net.minecraft.world.entity.item.EntityItem;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.projectile.EntityArrow;
import net.minecraft.world.entity.raid.PersistentRaid;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.RayTrace;
import net.minecraft.world.level.ServerExplosion;
import net.minecraft.world.level.World;
import net.minecraft.world.level.biome.BiomeBase;
import net.minecraft.world.level.biome.Climate;
import net.minecraft.world.level.biome.WorldChunkManager;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.chunk.IChunkAccess;
import net.minecraft.world.level.chunk.ProtoChunkExtension;
import net.minecraft.world.level.chunk.status.ChunkStatus;
import net.minecraft.world.level.levelgen.structure.StructureStart;
import net.minecraft.world.level.storage.SavedFile;
import net.minecraft.world.level.storage.WorldData;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.MovingObjectPositionBlock;
import net.minecraft.world.phys.Vec3D;
import net.minecraft.world.phys.shapes.VoxelShapeCollision;
import org.bukkit.BlockChangeDelegate;
import org.bukkit.Bukkit;
import org.bukkit.Chunk;
import org.bukkit.ChunkSnapshot;
import org.bukkit.Color;
import org.bukkit.Difficulty;
import org.bukkit.Effect;
import org.bukkit.FluidCollisionMode;
import org.bukkit.GameEvent;
import org.bukkit.GameRule;
import org.bukkit.HeightMap;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.Particle;
import org.bukkit.Raid;
import org.bukkit.Sound;
import org.bukkit.SoundCategory;
import org.bukkit.StructureType;
import org.bukkit.TreeType;
import org.bukkit.World;
import org.bukkit.WorldBorder;
import org.bukkit.WorldType;
import org.bukkit.block.Biome;
import org.bukkit.block.BlockState;
import org.bukkit.block.data.BlockData;
import org.bukkit.boss.DragonBattle;
import org.bukkit.craftbukkit.v1_21_R6.CraftChunk;
import org.bukkit.craftbukkit.v1_21_R6.CraftEffect;
import org.bukkit.craftbukkit.v1_21_R6.CraftFluidCollisionMode;
import org.bukkit.craftbukkit.v1_21_R6.CraftHeightMap;
import org.bukkit.craftbukkit.v1_21_R6.CraftParticle;
import org.bukkit.craftbukkit.v1_21_R6.CraftRaid;
import org.bukkit.craftbukkit.v1_21_R6.CraftRegionAccessor;
import org.bukkit.craftbukkit.v1_21_R6.CraftRegistry;
import org.bukkit.craftbukkit.v1_21_R6.CraftServer;
import org.bukkit.craftbukkit.v1_21_R6.CraftSound;
import org.bukkit.craftbukkit.v1_21_R6.CraftWorldBorder;
import org.bukkit.craftbukkit.v1_21_R6.block.CraftBiome;
import org.bukkit.craftbukkit.v1_21_R6.block.CraftBlock;
import org.bukkit.craftbukkit.v1_21_R6.block.CraftBlockState;
import org.bukkit.craftbukkit.v1_21_R6.block.CraftBlockType;
import org.bukkit.craftbukkit.v1_21_R6.block.data.CraftBlockData;
import org.bukkit.craftbukkit.v1_21_R6.boss.CraftDragonBattle;
import org.bukkit.craftbukkit.v1_21_R6.entity.CraftEntity;
import org.bukkit.craftbukkit.v1_21_R6.entity.CraftHumanEntity;
import org.bukkit.craftbukkit.v1_21_R6.entity.CraftPlayer;
import org.bukkit.craftbukkit.v1_21_R6.generator.CustomChunkGenerator;
import org.bukkit.craftbukkit.v1_21_R6.generator.CustomWorldChunkManager;
import org.bukkit.craftbukkit.v1_21_R6.generator.structure.CraftGeneratedStructure;
import org.bukkit.craftbukkit.v1_21_R6.generator.structure.CraftStructure;
import org.bukkit.craftbukkit.v1_21_R6.inventory.CraftItemStack;
import org.bukkit.craftbukkit.v1_21_R6.metadata.BlockMetadataStore;
import org.bukkit.craftbukkit.v1_21_R6.persistence.CraftPersistentDataContainer;
import org.bukkit.craftbukkit.v1_21_R6.persistence.CraftPersistentDataTypeRegistry;
import org.bukkit.craftbukkit.v1_21_R6.util.CraftBiomeSearchResult;
import org.bukkit.craftbukkit.v1_21_R6.util.CraftDifficulty;
import org.bukkit.craftbukkit.v1_21_R6.util.CraftLocation;
import org.bukkit.craftbukkit.v1_21_R6.util.CraftNamespacedKey;
import org.bukkit.craftbukkit.v1_21_R6.util.CraftRayTraceResult;
import org.bukkit.craftbukkit.v1_21_R6.util.CraftSpawnCategory;
import org.bukkit.craftbukkit.v1_21_R6.util.CraftStructureSearchResult;
import org.bukkit.craftbukkit.v1_21_R6.util.CraftVector;
import org.bukkit.entity.AbstractArrow;
import org.bukkit.entity.Arrow;
import org.bukkit.entity.Entity;
import org.bukkit.entity.FallingBlock;
import org.bukkit.entity.Item;
import org.bukkit.entity.LightningStrike;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.entity.SpawnCategory;
import org.bukkit.entity.SpectralArrow;
import org.bukkit.entity.TippedArrow;
import org.bukkit.entity.Trident;
import org.bukkit.event.Event;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.weather.LightningStrikeEvent;
import org.bukkit.event.weather.ThunderChangeEvent;
import org.bukkit.event.weather.WeatherChangeEvent;
import org.bukkit.event.world.SpawnChangeEvent;
import org.bukkit.event.world.TimeSkipEvent;
import org.bukkit.generator.BiomeProvider;
import org.bukkit.generator.BlockPopulator;
import org.bukkit.generator.WorldInfo;
import org.bukkit.generator.structure.GeneratedStructure;
import org.bukkit.generator.structure.Structure;
import org.bukkit.inventory.ItemStack;
import org.bukkit.material.MaterialData;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.plugin.messaging.Messenger;
import org.bukkit.plugin.messaging.StandardMessenger;
import org.bukkit.potion.PotionType;
import org.bukkit.util.BiomeSearchResult;
import org.bukkit.util.BoundingBox;
import org.bukkit.util.NumberConversions;
import org.bukkit.util.RayTraceResult;
import org.bukkit.util.StructureSearchResult;
import org.bukkit.util.Vector;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.spigotmc.AsyncCatcher;

public class CraftWorld
extends CraftRegionAccessor
implements World {
    private static final CraftPersistentDataTypeRegistry DATA_TYPE_REGISTRY = new CraftPersistentDataTypeRegistry();
    private static final PointersSupplier<World> POINTERS_SUPPLIER = (PointersSupplier)PointersSupplier.builder().resolving(Identity.NAME, WorldInfo::getName).resolving(Identity.UUID, WorldInfo::getUID).build();
    private final WorldServer world;
    private WorldBorder worldBorder;
    private World.Environment environment;
    private final CraftServer server = (CraftServer)Bukkit.getServer();
    @Nullable
    private final org.bukkit.generator.ChunkGenerator generator;
    @Nullable
    private final BiomeProvider biomeProvider;
    private final List<BlockPopulator> populators = new ArrayList<BlockPopulator>();
    private final BlockMetadataStore blockMetadata = new BlockMetadataStore(this);
    private final Object2IntOpenHashMap<SpawnCategory> spawnCategoryLimit = new Object2IntOpenHashMap();
    private final CraftPersistentDataContainer persistentDataContainer = new CraftPersistentDataContainer(DATA_TYPE_REGISTRY);
    private boolean voidDamageEnabled;
    private float voidDamageAmount;
    private double voidDamageMinBuildHeightOffset;
    private static final Random rand = new Random();
    private Map<String, GameRules.GameRuleKey<?>> gamerules;
    private Map<String, GameRules.GameRuleDefinition<?>> gameruleDefinitions;
    private final World.Spigot spigot = new World.Spigot(){

        public LightningStrike strikeLightning(Location loc, boolean isSilent) {
            return CraftWorld.this.strikeLightning(loc);
        }

        public LightningStrike strikeLightningEffect(Location loc, boolean isSilent) {
            return CraftWorld.this.strikeLightningEffect(loc);
        }
    };

    public boolean isVoidDamageEnabled() {
        return this.voidDamageEnabled;
    }

    public void setVoidDamageEnabled(boolean enabled) {
        this.voidDamageEnabled = enabled;
    }

    public float getVoidDamageAmount() {
        return this.voidDamageAmount;
    }

    public void setVoidDamageAmount(float voidDamageAmount) {
        this.voidDamageAmount = voidDamageAmount;
    }

    public double getVoidDamageMinBuildHeightOffset() {
        return this.voidDamageMinBuildHeightOffset;
    }

    public void setVoidDamageMinBuildHeightOffset(double minBuildHeightOffset) {
        this.voidDamageMinBuildHeightOffset = minBuildHeightOffset;
    }

    public int getEntityCount() {
        int ret = 0;
        for (net.minecraft.world.entity.Entity entity : this.world.K().a()) {
            if (!entity.getBukkitEntity().isValid()) continue;
            ++ret;
        }
        return ret;
    }

    public int getTileEntityCount() {
        int size = 0;
        for (PlayerChunk playerchunk : PlatformHooks.get().getVisibleChunkHolders(this.world)) {
            net.minecraft.world.level.chunk.Chunk chunk = playerchunk.d();
            if (chunk == null) continue;
            size += chunk.j.size();
        }
        return size;
    }

    public int getTickableTileEntityCount() {
        return this.world.r.size();
    }

    public int getChunkCount() {
        return this.world.n().getFullChunksCount();
    }

    public int getPlayerCount() {
        return this.world.C().size();
    }

    public BiomeProvider vanillaBiomeProvider() {
        WorldChunkManager biomeSource;
        ChunkProviderServer serverCache = this.getHandle().H;
        ChunkGenerator gen = serverCache.g();
        if (gen instanceof CustomChunkGenerator) {
            CustomChunkGenerator custom = (CustomChunkGenerator)gen;
            biomeSource = custom.getDelegate().d();
        } else {
            biomeSource = gen.d();
        }
        if (biomeSource instanceof CustomWorldChunkManager) {
            CustomWorldChunkManager customBiomeSource = (CustomWorldChunkManager)biomeSource;
            biomeSource = customBiomeSource.vanillaBiomeSource;
        }
        final WorldChunkManager finalBiomeSource = biomeSource;
        final Climate.Sampler sampler = serverCache.i().b();
        final List<Biome> possibleBiomes = finalBiomeSource.c().stream().map(CraftBiome::minecraftHolderToBukkit).toList();
        return new BiomeProvider(this){

            public Biome getBiome(WorldInfo worldInfo, int x2, int y2, int z2) {
                return CraftBiome.minecraftHolderToBukkit(finalBiomeSource.getNoiseBiome(x2 >> 2, y2 >> 2, z2 >> 2, sampler));
            }

            public List<Biome> getBiomes(WorldInfo worldInfo) {
                return possibleBiomes;
            }
        };
    }

    public boolean hasStructureAt(Position position, Structure structure) {
        return this.world.b().b(MCUtil.toBlockPos(position), CraftStructure.bukkitToMinecraft(structure)).b();
    }

    public CraftWorld(WorldServer world, @Nullable org.bukkit.generator.ChunkGenerator generator, @Nullable BiomeProvider biomeProvider, World.Environment environment) {
        this.world = world;
        this.generator = generator;
        this.biomeProvider = biomeProvider;
        this.environment = environment;
        for (SpawnCategory spawnCategory : SpawnCategory.values()) {
            if (!CraftSpawnCategory.isValidForLimits(spawnCategory)) continue;
            this.setSpawnLimit(spawnCategory, this.world.paperConfig().entities.spawning.spawnLimits.getInt((Object)CraftSpawnCategory.toNMS(spawnCategory)));
        }
        this.voidDamageEnabled = this.world.paperConfig().environment.voidDamageAmount.enabled();
        this.voidDamageMinBuildHeightOffset = this.world.paperConfig().environment.voidDamageMinBuildHeightOffset;
        this.voidDamageAmount = (float)this.world.paperConfig().environment.voidDamageAmount.or(0.0);
    }

    public org.bukkit.block.Block getBlockAt(int x2, int y2, int z2) {
        return CraftBlock.at(this.world, new BlockPosition(x2, y2, z2));
    }

    public Location getSpawnLocation() {
        WorldData.a respawnData = this.world.J.a();
        return CraftLocation.toBukkit((BaseBlockPosition)respawnData.b(), (World)this, respawnData.d(), respawnData.e());
    }

    public boolean setSpawnLocation(Location location) {
        Preconditions.checkArgument((location != null ? 1 : 0) != 0, (Object)"location");
        return this.equals(location.getWorld()) ? this.setSpawnLocation(location.getBlockX(), location.getBlockY(), location.getBlockZ(), location.getYaw(), location.getPitch()) : false;
    }

    private boolean setSpawnLocation(int x2, int y2, int z2, float yaw, float pitch) {
        try {
            Location previousLocation = this.getSpawnLocation();
            this.world.J.a(new WorldData.a(GlobalPos.a(ResourceKey.a(Registries.bx, this.world.al().a()), new BlockPosition(x2, y2, z2)), MathHelper.h(yaw), MathHelper.h(pitch)));
            this.server.getServer().bM();
            new SpawnChangeEvent((World)this, previousLocation).callEvent();
            return true;
        }
        catch (Exception e2) {
            return false;
        }
    }

    public boolean setSpawnLocation(int x2, int y2, int z2, float yaw) {
        return this.setSpawnLocation(x2, y2, z2, yaw, 0.0f);
    }

    private static void warnUnsafeChunk(String reason, int x2, int z2) {
        int max = 1875625;
        if (x2 > max || z2 > max || x2 < -max || z2 < -max) {
            JavaPlugin plugin = StackWalkerUtil.getFirstPluginCaller();
            if (plugin != null) {
                plugin.getLogger().warning("Plugin is %s at (%s, %s), this might cause issues.".formatted(reason, x2, z2));
            }
            if (MinecraftServer.getServer().isDebugging()) {
                TraceUtil.dumpTraceForThread("Dangerous chunk retrieval");
            }
        }
    }

    public Chunk getChunkAt(int x2, int z2) {
        CraftWorld.warnUnsafeChunk("getting a faraway chunk", x2, z2);
        net.minecraft.world.level.chunk.Chunk chunk = (net.minecraft.world.level.chunk.Chunk)this.world.a(x2, z2, ChunkStatus.n, true);
        return new CraftChunk(chunk);
    }

    @NotNull
    public Chunk getChunkAt(int x2, int z2, boolean generate) {
        if (generate) {
            return this.getChunkAt(x2, z2);
        }
        return new CraftChunk(this.getHandle(), x2, z2);
    }

    public Chunk getChunkAt(org.bukkit.block.Block block) {
        Preconditions.checkArgument((block != null ? 1 : 0) != 0, (Object)"null block");
        return this.getChunkAt(block.getX() >> 4, block.getZ() >> 4);
    }

    public boolean isChunkLoaded(int x2, int z2) {
        return this.world.n().isChunkLoaded(x2, z2);
    }

    public boolean isChunkGenerated(int x2, int z2) {
        if (!Bukkit.isPrimaryThread()) {
            return CompletableFuture.supplyAsync(() -> this.isChunkGenerated(x2, z2), this.world.n().g).join();
        }
        IChunkAccess chunk = this.world.n().getChunkAtImmediately(x2, z2);
        if (chunk != null) {
            return chunk instanceof ProtoChunkExtension || chunk instanceof net.minecraft.world.level.chunk.Chunk;
        }
        CompletableFuture future = new CompletableFuture();
        PlatformHooks.get().scheduleChunkLoad(this.world, x2, z2, false, ChunkStatus.c, true, Priority.NORMAL, future::complete);
        this.world.n().g.b(future::isDone);
        return (Boolean)((CompletableFuture)future.thenApply(c2 -> {
            if (c2 != null) {
                return c2.n() == ChunkStatus.n;
            }
            return false;
        })).join();
    }

    public Chunk[] getLoadedChunks() {
        int size;
        ChunkProviderServer serverChunkCache = this.getHandle().H;
        ReferenceList<Chunk> chunks = new ReferenceList<Chunk>(new Chunk[serverChunkCache.fullChunks.size()]);
        PrimitiveIterator.OfLong iterator = serverChunkCache.fullChunks.keyIterator();
        while (iterator.hasNext()) {
            long chunk = iterator.nextLong();
            chunks.add(new CraftChunk(this.world, CoordinateUtils.getChunkX(chunk), CoordinateUtils.getChunkZ(chunk)));
        }
        Chunk[] raw = chunks.getRawDataUnchecked();
        if (raw.length == (size = chunks.size())) {
            return raw;
        }
        return Arrays.copyOf(raw, size);
    }

    public boolean unloadChunk(int x2, int z2, boolean save) {
        return this.unloadChunk0(x2, z2, save);
    }

    public boolean unloadChunkRequest(int x2, int z2) {
        AsyncCatcher.catchOp("chunk unload");
        if (this.isChunkLoaded(x2, z2)) {
            this.world.n().c(TicketType.PLUGIN, new ChunkCoordIntPair(x2, z2), 1);
        }
        return true;
    }

    private boolean unloadChunk0(int x2, int z2, boolean save) {
        AsyncCatcher.catchOp("chunk unload");
        if (!this.isChunkLoaded(x2, z2)) {
            return true;
        }
        net.minecraft.world.level.chunk.Chunk chunk = this.world.d(x2, z2);
        if (!save) {
            chunk.j();
        }
        this.unloadChunkRequest(x2, z2);
        this.world.n().purgeUnload();
        return !this.isChunkLoaded(x2, z2);
    }

    public boolean refreshChunk(int x2, int z2) {
        PlayerChunk playerChunk = this.world.n().a.b(ChunkCoordIntPair.c(x2, z2));
        if (playerChunk == null) {
            return false;
        }
        net.minecraft.world.level.chunk.Chunk chunk = playerChunk.e();
        if (chunk == null) {
            return false;
        }
        List<EntityPlayer> playersInRange = playerChunk.s.a(playerChunk.r(), false);
        if (playersInRange.isEmpty()) {
            return true;
        }
        FeatureHooks.sendChunkRefreshPackets(playersInRange, chunk);
        return true;
    }

    public Collection<Player> getPlayersSeeingChunk(Chunk chunk) {
        Preconditions.checkArgument((chunk != null ? 1 : 0) != 0, (Object)"chunk cannot be null");
        return this.getPlayersSeeingChunk(chunk.getX(), chunk.getZ());
    }

    public Collection<Player> getPlayersSeeingChunk(int x2, int z2) {
        if (!this.isChunkLoaded(x2, z2)) {
            return Collections.emptySet();
        }
        List<EntityPlayer> players = this.world.n().a.a(new ChunkCoordIntPair(x2, z2), false);
        if (players.isEmpty()) {
            return Collections.emptySet();
        }
        return players.stream().filter(Objects::nonNull).map(EntityPlayer::getBukkitEntity).collect(Collectors.toUnmodifiableSet());
    }

    public boolean isChunkInUse(int x2, int z2) {
        return this.isChunkLoaded(x2, z2);
    }

    public boolean loadChunk(int x2, int z2, boolean generate) {
        AsyncCatcher.catchOp("chunk load");
        CraftWorld.warnUnsafeChunk("loading a faraway chunk", x2, z2);
        IChunkAccess chunk = this.world.n().a(x2, z2, generate || this.isChunkGenerated(x2, z2) ? ChunkStatus.n : ChunkStatus.c, true);
        if (chunk instanceof ProtoChunkExtension) {
            chunk = this.world.n().a(x2, z2, ChunkStatus.n, true);
        }
        if (chunk instanceof net.minecraft.world.level.chunk.Chunk) {
            this.world.n().b(TicketType.PLUGIN, new ChunkCoordIntPair(x2, z2), 1);
            return true;
        }
        return false;
    }

    public boolean isChunkLoaded(Chunk chunk) {
        Preconditions.checkArgument((chunk != null ? 1 : 0) != 0, (Object)"null chunk");
        return this.isChunkLoaded(chunk.getX(), chunk.getZ());
    }

    public void loadChunk(Chunk chunk) {
        Preconditions.checkArgument((chunk != null ? 1 : 0) != 0, (Object)"null chunk");
        this.loadChunk(chunk.getX(), chunk.getZ());
    }

    public boolean addPluginChunkTicket(int x2, int z2, Plugin plugin) {
        CraftWorld.warnUnsafeChunk("adding a faraway chunk ticket", x2, z2);
        Preconditions.checkArgument((plugin != null ? 1 : 0) != 0, (Object)"null plugin");
        Preconditions.checkArgument((boolean)plugin.isEnabled(), (Object)"plugin is not enabled");
        PlayerChunkMap.a distanceManager = this.world.n().a.G;
        if (distanceManager.g.addPluginRegionTicket(new ChunkCoordIntPair(x2, z2), plugin)) {
            this.getChunkAt(x2, z2);
            return true;
        }
        return false;
    }

    public boolean removePluginChunkTicket(int x2, int z2, Plugin plugin) {
        Preconditions.checkNotNull((Object)plugin, (Object)"null plugin");
        PlayerChunkMap.a distanceManager = this.world.n().a.G;
        return distanceManager.g.removePluginRegionTicket(new ChunkCoordIntPair(x2, z2), plugin);
    }

    public void removePluginChunkTickets(Plugin plugin) {
        Preconditions.checkNotNull((Object)plugin, (Object)"null plugin");
        PlayerChunkMap.a chunkDistanceManager = this.world.n().a.G;
        chunkDistanceManager.g.removeAllPluginRegionTickets(TicketType.PLUGIN_TICKET, PlayerChunkMap.c, plugin);
    }

    public Collection<Plugin> getPluginChunkTickets(int x2, int z2) {
        return FeatureHooks.getPluginChunkTickets(this.world, x2, z2);
    }

    public Map<Plugin, Collection<Chunk>> getPluginChunkTickets() {
        return FeatureHooks.getPluginChunkTickets(this.world);
    }

    @NotNull
    public Collection<Chunk> getIntersectingChunks(@NotNull BoundingBox boundingBox) {
        ArrayList<Chunk> chunks = new ArrayList<Chunk>();
        int minX = NumberConversions.floor((double)boundingBox.getMinX()) >> 4;
        int maxX = NumberConversions.floor((double)boundingBox.getMaxX()) >> 4;
        int minZ = NumberConversions.floor((double)boundingBox.getMinZ()) >> 4;
        int maxZ = NumberConversions.floor((double)boundingBox.getMaxZ()) >> 4;
        for (int x2 = minX; x2 <= maxX; ++x2) {
            for (int z2 = minZ; z2 <= maxZ; ++z2) {
                chunks.add(this.getChunkAt(x2, z2, false));
            }
        }
        return chunks;
    }

    public boolean isChunkForceLoaded(int x2, int z2) {
        return this.getHandle().B().contains(ChunkCoordIntPair.c(x2, z2));
    }

    public void setChunkForceLoaded(int x2, int z2, boolean forced) {
        CraftWorld.warnUnsafeChunk("forceloading a faraway chunk", x2, z2);
        this.getHandle().a(x2, z2, forced);
    }

    public Collection<Chunk> getForceLoadedChunks() {
        HashSet<CraftChunk> chunks = new HashSet<CraftChunk>();
        LongIterator longIterator = this.getHandle().B().iterator();
        while (longIterator.hasNext()) {
            long coord = (Long)longIterator.next();
            chunks.add(new CraftChunk(this.getHandle(), ChunkCoordIntPair.a(coord), ChunkCoordIntPair.b(coord)));
        }
        return Collections.unmodifiableCollection(chunks);
    }

    @Override
    public WorldServer getHandle() {
        return this.world;
    }

    public Item dropItem(Location location, ItemStack item, Consumer<? super Item> function) {
        Preconditions.checkArgument((location != null ? 1 : 0) != 0, (Object)"Location cannot be null");
        Preconditions.checkArgument((item != null ? 1 : 0) != 0, (Object)"ItemStack cannot be null");
        EntityItem entity = new EntityItem(this.world, location.getX(), location.getY(), location.getZ(), CraftItemStack.asNMSCopy(item));
        Item itemEntity = (Item)entity.getBukkitEntity();
        entity.l = 10;
        if (function != null) {
            function.accept((Item)itemEntity);
        }
        this.world.addFreshEntity(entity, CreatureSpawnEvent.SpawnReason.CUSTOM);
        return itemEntity;
    }

    public Item dropItemNaturally(Location location, ItemStack item, Consumer<? super Item> function) {
        Preconditions.checkArgument((location != null ? 1 : 0) != 0, (Object)"Location cannot be null");
        Preconditions.checkArgument((item != null ? 1 : 0) != 0, (Object)"ItemStack cannot be null");
        double xs = MathHelper.a(this.world.z, -0.25, 0.25);
        double ys = MathHelper.a(this.world.z, -0.25, 0.25) - (double)EntityTypes.au.m() / 2.0;
        double zs = MathHelper.a(this.world.z, -0.25, 0.25);
        location = location.clone().add(xs, ys, zs);
        return this.dropItem(location, item, function);
    }

    public <T extends AbstractArrow> T spawnArrow(Location location, Vector direction, float speed, float spread, Class<T> clazz) {
        EntityArrow arrow;
        Preconditions.checkArgument((location != null ? 1 : 0) != 0, (Object)"Location cannot be null");
        Preconditions.checkArgument((direction != null ? 1 : 0) != 0, (Object)"Vector cannot be null");
        Preconditions.checkArgument((clazz != null ? 1 : 0) != 0, (Object)"clazz Entity for the arrow cannot be null");
        if (TippedArrow.class.isAssignableFrom(clazz)) {
            arrow = EntityTypes.i.a(this.world, EntitySpawnReason.n);
            ((Arrow)arrow.getBukkitEntity()).setBasePotionType(PotionType.WATER);
        } else {
            arrow = SpectralArrow.class.isAssignableFrom(clazz) ? (EntityArrow)EntityTypes.bs.a(this.world, EntitySpawnReason.n) : (Trident.class.isAssignableFrom(clazz) ? (EntityArrow)EntityTypes.bE.a(this.world, EntitySpawnReason.n) : (EntityArrow)EntityTypes.i.a(this.world, EntitySpawnReason.n));
        }
        arrow.b(location.getX(), location.getY(), location.getZ(), location.getYaw(), location.getPitch());
        arrow.c(direction.getX(), direction.getY(), direction.getZ(), speed, spread);
        this.world.b(arrow);
        return (T)((AbstractArrow)arrow.getBukkitEntity());
    }

    public LightningStrike strikeLightning(Location loc) {
        return this.strikeLightning0(loc, false);
    }

    public LightningStrike strikeLightningEffect(Location loc) {
        return this.strikeLightning0(loc, true);
    }

    private LightningStrike strikeLightning0(Location loc, boolean isVisual) {
        Preconditions.checkArgument((loc != null ? 1 : 0) != 0, (Object)"Location cannot be null");
        EntityLightning lightning = EntityTypes.aA.a(this.world, EntitySpawnReason.n);
        lightning.d(loc.getX(), loc.getY(), loc.getZ());
        lightning.isEffect = isVisual;
        this.world.strikeLightning(lightning, LightningStrikeEvent.Cause.CUSTOM);
        return (LightningStrike)lightning.getBukkitEntity();
    }

    public Location findLightningRod(Location location) {
        return this.world.G(CraftLocation.toBlockPosition(location)).map(blockPos -> CraftLocation.toBukkit((BaseBlockPosition)blockPos, (net.minecraft.world.level.World)this.world).subtract(0.0, 1.0, 0.0)).orElse(null);
    }

    public Location findLightningTarget(Location location) {
        BlockPosition pos = this.world.findLightningTargetAround(CraftLocation.toBlockPosition(location), true);
        return pos == null ? null : CraftLocation.toBukkit((BaseBlockPosition)pos, (net.minecraft.world.level.World)this.world);
    }

    public boolean generateTree(Location loc, TreeType type) {
        return this.generateTree(loc, rand, type);
    }

    public boolean generateTree(Location loc, TreeType type, BlockChangeDelegate delegate) {
        this.world.captureTreeGeneration = true;
        this.world.captureBlockStates = true;
        boolean grownTree = this.generateTree(loc, type);
        this.world.captureBlockStates = false;
        this.world.captureTreeGeneration = false;
        if (grownTree) {
            for (BlockState blockState : this.world.capturedBlockStates.values()) {
                BlockPosition position = ((CraftBlockState)blockState).getPosition();
                IBlockData oldBlock = this.world.a_(position);
                int flags = ((CraftBlockState)blockState).getFlags();
                delegate.setBlockData(blockState.getX(), blockState.getY(), blockState.getZ(), blockState.getBlockData());
                IBlockData newBlock = this.world.a_(position);
                this.world.notifyAndUpdatePhysics(position, null, oldBlock, newBlock, newBlock, flags, 512);
            }
            this.world.capturedBlockStates.clear();
            return true;
        }
        this.world.capturedBlockStates.clear();
        return false;
    }

    public String getName() {
        return this.world.J.d();
    }

    public UUID getUID() {
        return this.world.uuid;
    }

    @Override
    public NamespacedKey getKey() {
        return CraftNamespacedKey.fromMinecraft(this.world.al().a());
    }

    public String toString() {
        return "CraftWorld{name=" + this.getName() + "}";
    }

    public long getTime() {
        long time = this.getFullTime() % 24000L;
        if (time < 0L) {
            time += 24000L;
        }
        return time;
    }

    public void setTime(long time) {
        long margin = (time - this.getFullTime()) % 24000L;
        if (margin < 0L) {
            margin += 24000L;
        }
        this.setFullTime(this.getFullTime() + margin);
    }

    public long getFullTime() {
        return this.world.ah();
    }

    public void setFullTime(long time) {
        TimeSkipEvent event = new TimeSkipEvent((World)this, TimeSkipEvent.SkipReason.CUSTOM, time - this.world.ah());
        this.server.getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            return;
        }
        this.world.b(this.world.ah() + event.getSkipAmount());
        for (Player p2 : this.getPlayers()) {
            CraftPlayer cp = (CraftPlayer)p2;
            if (cp.getHandle().g == null) continue;
            cp.getHandle().g.b(new PacketPlayOutUpdateTime(cp.getHandle().A().ag(), cp.getHandle().getPlayerTime(), cp.getHandle().relativeTime && cp.getHandle().A().S().c(GameRules.m)));
        }
    }

    public boolean isDayTime() {
        return this.getHandle().aa();
    }

    public long getGameTime() {
        return this.world.A.b();
    }

    public boolean createExplosion(double x2, double y2, double z2, float power, boolean setFire, boolean breakBlocks, Entity source) {
        return this.createExplosion(x2, y2, z2, power, setFire, breakBlocks, source, null);
    }

    private boolean createExplosion(double x2, double y2, double z2, float power, boolean setFire, boolean breakBlocks, Entity source, Consumer<ServerExplosion> configurator) {
        World.a explosionType = !breakBlocks ? World.a.a : (source == null ? World.a.STANDARD : World.a.c);
        net.minecraft.world.entity.Entity entity = source == null ? null : ((CraftEntity)source).getHandle();
        return !this.world.explode0((net.minecraft.world.entity.Entity)entity, (DamageSource)Explosion.a((net.minecraft.world.level.World)this.world, (net.minecraft.world.entity.Entity)entity), null, (double)x2, (double)y2, (double)z2, (float)power, (boolean)setFire, (World.a)explosionType, (ParticleParam)Particles.x, (ParticleParam)Particles.w, net.minecraft.world.level.World.a, SoundEffects.lw, configurator).wasCanceled;
    }

    public boolean createExplosion(Entity source, Location loc, float power, boolean setFire, boolean breakBlocks, boolean excludeSourceFromDamage) {
        return this.createExplosion(loc.x(), loc.getY(), loc.getZ(), power, setFire, breakBlocks, source, e2 -> {
            e2.excludeSourceFromDamage = excludeSourceFromDamage;
        });
    }

    public boolean createExplosion(Location loc, float power, boolean setFire, boolean breakBlocks, Entity source) {
        Preconditions.checkArgument((loc != null ? 1 : 0) != 0, (Object)"Location is null");
        Preconditions.checkArgument((boolean)this.equals(loc.getWorld()), (Object)"Location not in world");
        return this.createExplosion(loc.getX(), loc.getY(), loc.getZ(), power, setFire, breakBlocks, source);
    }

    @NotNull
    public World.Environment getEnvironment() {
        return this.environment;
    }

    @Nullable
    public org.bukkit.generator.ChunkGenerator getGenerator() {
        return this.generator;
    }

    @Nullable
    public BiomeProvider getBiomeProvider() {
        return this.biomeProvider;
    }

    public List<BlockPopulator> getPopulators() {
        return this.populators;
    }

    @NotNull
    public <T extends LivingEntity> T spawn(@NotNull Location location, @NotNull Class<T> clazz, @NotNull CreatureSpawnEvent.SpawnReason spawnReason, boolean randomizeData, @Nullable Consumer<? super T> function) throws IllegalArgumentException {
        Preconditions.checkArgument((spawnReason != null ? 1 : 0) != 0, (Object)"Spawn reason cannot be null");
        return (T)((LivingEntity)this.spawn(location, clazz, function, spawnReason, randomizeData));
    }

    @Override
    public int getHighestBlockYAt(int x2, int z2, HeightMap heightMap) {
        CraftWorld.warnUnsafeChunk("getting a faraway chunk", x2 >> 4, z2 >> 4);
        return this.world.d(x2 >> 4, z2 >> 4).a(CraftHeightMap.toNMS(heightMap), x2, z2);
    }

    public void setBiome(int x2, int z2, Biome bio) {
        for (int y2 = this.getMinHeight(); y2 < this.getMaxHeight(); ++y2) {
            this.setBiome(x2, y2, z2, bio);
        }
    }

    @Override
    public void setBiome(int x2, int y2, int z2, Holder<BiomeBase> bb) {
        BlockPosition pos = new BlockPosition(x2, 0, z2);
        if (this.world.D(pos)) {
            net.minecraft.world.level.chunk.Chunk chunk = this.world.m(pos);
            chunk.setBiome(x2 >> 2, y2 >> 2, z2 >> 2, bb);
            chunk.i();
        }
    }

    public double getTemperature(int x2, int y2, int z2) {
        BlockPosition pos = new BlockPosition(x2, y2, z2);
        return this.world.getNoiseBiome(x2 >> 2, y2 >> 2, z2 >> 2).a().f(pos, this.world.T());
    }

    public double getHumidity(int x2, int y2, int z2) {
        return this.world.getNoiseBiome((int)(x2 >> 2), (int)(y2 >> 2), (int)(z2 >> 2)).a().i.d();
    }

    @Deprecated
    public <T extends Entity> Collection<T> getEntitiesByClass(Class<T> ... classes) {
        return this.getEntitiesByClasses(classes);
    }

    @Override
    public Iterable<net.minecraft.world.entity.Entity> getNMSEntities() {
        return this.getHandle().K().a();
    }

    @Override
    public void addEntityToWorld(net.minecraft.world.entity.Entity entity, CreatureSpawnEvent.SpawnReason reason) {
        this.getHandle().addFreshEntity(entity, reason);
    }

    @Override
    public void addEntityWithPassengers(net.minecraft.world.entity.Entity entity, CreatureSpawnEvent.SpawnReason reason) {
        this.getHandle().tryAddFreshEntityWithPassengers(entity, reason);
    }

    public Collection<Entity> getNearbyEntities(Location location, double x2, double y2, double z2, Predicate<? super Entity> filter) {
        Preconditions.checkArgument((location != null ? 1 : 0) != 0, (Object)"Location cannot be null");
        Preconditions.checkArgument((boolean)this.equals(location.getWorld()), (Object)"Location cannot be in a different world");
        BoundingBox aabb = BoundingBox.of((Location)location, (double)x2, (double)y2, (double)z2);
        return this.getNearbyEntities(aabb, filter);
    }

    public Collection<Entity> getNearbyEntities(BoundingBox boundingBox, Predicate<? super Entity> filter) {
        AsyncCatcher.catchOp("getNearbyEntities");
        Preconditions.checkArgument((boundingBox != null ? 1 : 0) != 0, (Object)"BoundingBox cannot be null");
        AxisAlignedBB bb = new AxisAlignedBB(boundingBox.getMinX(), boundingBox.getMinY(), boundingBox.getMinZ(), boundingBox.getMaxX(), boundingBox.getMaxY(), boundingBox.getMaxZ());
        List<net.minecraft.world.entity.Entity> entityList = this.getHandle().a((net.minecraft.world.entity.Entity)null, bb, (Predicate<? super net.minecraft.world.entity.Entity>)Predicates.alwaysTrue());
        ArrayList<Entity> bukkitEntityList = new ArrayList<Entity>(entityList.size());
        for (net.minecraft.world.entity.Entity entity : entityList) {
            CraftEntity bukkitEntity = entity.getBukkitEntity();
            if (filter != null && !filter.test(bukkitEntity)) continue;
            bukkitEntityList.add(bukkitEntity);
        }
        return bukkitEntityList;
    }

    public RayTraceResult rayTraceEntities(Position start, Vector direction, double maxDistance, double raySize, Predicate<? super Entity> filter) {
        Location location;
        Preconditions.checkArgument((start != null ? 1 : 0) != 0, (Object)"Location start cannot be null");
        Preconditions.checkArgument((!(start instanceof Location) || this.equals((location = (Location)start).getWorld()) ? 1 : 0) != 0, (Object)"Location start cannot be in a different world");
        Preconditions.checkArgument((boolean)start.isFinite(), (Object)"Location start is not finite");
        Preconditions.checkArgument((direction != null ? 1 : 0) != 0, (Object)"Vector direction cannot be null");
        direction.checkFinite();
        Preconditions.checkArgument((direction.lengthSquared() > 0.0 ? 1 : 0) != 0, (String)"Direction's magnitude (%s) need to be greater than 0", (Object)direction.lengthSquared());
        if (maxDistance < 0.0) {
            return null;
        }
        Vector startPos = start.toVector();
        Vector dir = direction.clone().normalize().multiply(maxDistance);
        BoundingBox aabb = BoundingBox.of((Vector)startPos, (Vector)startPos).expandDirectional(dir).expand(raySize);
        Collection<Entity> entities = this.getNearbyEntities(aabb, filter);
        Entity nearestHitEntity = null;
        RayTraceResult nearestHitResult = null;
        double nearestDistanceSq = Double.MAX_VALUE;
        for (Entity entity : entities) {
            double distanceSq;
            BoundingBox boundingBox = entity.getBoundingBox().expand(raySize);
            RayTraceResult hitResult = boundingBox.rayTrace(startPos, direction, maxDistance);
            if (hitResult == null || !((distanceSq = startPos.distanceSquared(hitResult.getHitPosition())) < nearestDistanceSq)) continue;
            nearestHitEntity = entity;
            nearestHitResult = hitResult;
            nearestDistanceSq = distanceSq;
        }
        return nearestHitEntity == null ? null : new RayTraceResult(nearestHitResult.getHitPosition(), nearestHitEntity, nearestHitResult.getHitBlockFace());
    }

    public RayTraceResult rayTraceBlocks(Position start, Vector direction, double maxDistance, FluidCollisionMode fluidCollisionMode, boolean ignorePassableBlocks, Predicate<? super org.bukkit.block.Block> canCollide) {
        Location location;
        Preconditions.checkArgument((start != null ? 1 : 0) != 0, (Object)"Location start cannot be null");
        Preconditions.checkArgument((!(start instanceof Location) || this.equals((location = (Location)start).getWorld()) ? 1 : 0) != 0, (Object)"Location start cannot be in a different world");
        Preconditions.checkArgument((boolean)start.isFinite(), (Object)"Location start is not finite");
        Preconditions.checkArgument((direction != null ? 1 : 0) != 0, (Object)"Vector direction cannot be null");
        direction.checkFinite();
        Preconditions.checkArgument((direction.lengthSquared() > 0.0 ? 1 : 0) != 0, (String)"Direction's magnitude (%s) need to be greater than 0", (Object)direction.lengthSquared());
        Preconditions.checkArgument((fluidCollisionMode != null ? 1 : 0) != 0, (Object)"FluidCollisionMode cannot be null");
        if (maxDistance < 0.0) {
            return null;
        }
        Vector dir = direction.clone().normalize().multiply(maxDistance);
        Vec3D startPos = MCUtil.toVec3(start);
        Vec3D endPos = startPos.b(dir.getX(), dir.getY(), dir.getZ());
        MovingObjectPositionBlock hitResult = this.getHandle().clip(new RayTrace(startPos, endPos, ignorePassableBlocks ? RayTrace.BlockCollisionOption.a : RayTrace.BlockCollisionOption.b, CraftFluidCollisionMode.toFluid(fluidCollisionMode), VoxelShapeCollision.a()), canCollide);
        return CraftRayTraceResult.convertFromInternal(this.getHandle(), hitResult);
    }

    public RayTraceResult rayTrace(Position start, Vector direction, double maxDistance, FluidCollisionMode fluidCollisionMode, boolean ignorePassableBlocks, double raySize, Predicate<? super Entity> filter, Predicate<? super org.bukkit.block.Block> canCollide) {
        RayTraceResult blockHit = this.rayTraceBlocks(start, direction, maxDistance, fluidCollisionMode, ignorePassableBlocks, canCollide);
        Vector startVec = null;
        double blockHitDistance = maxDistance;
        if (blockHit != null) {
            startVec = start.toVector();
            blockHitDistance = startVec.distance(blockHit.getHitPosition());
        }
        RayTraceResult entityHit = this.rayTraceEntities(start, direction, blockHitDistance, raySize, filter);
        if (blockHit == null) {
            return entityHit;
        }
        if (entityHit == null) {
            return blockHit;
        }
        double entityHitDistanceSquared = startVec.distanceSquared(entityHit.getHitPosition());
        if (entityHitDistanceSquared < blockHitDistance * blockHitDistance) {
            return entityHit;
        }
        return blockHit;
    }

    public RayTraceResult rayTrace(Consumer<PositionedRayTraceConfigurationBuilder> builderConsumer) {
        PositionedRayTraceConfigurationBuilderImpl builder = new PositionedRayTraceConfigurationBuilderImpl();
        builderConsumer.accept(builder);
        Preconditions.checkArgument((builder.start != null ? 1 : 0) != 0, (Object)"Start location cannot be null");
        Preconditions.checkArgument((builder.direction != null ? 1 : 0) != 0, (Object)"Direction vector cannot be null");
        Preconditions.checkArgument((boolean)builder.maxDistance.isPresent(), (Object)"Max distance must be set");
        Preconditions.checkArgument((!builder.targets.isEmpty() ? 1 : 0) != 0, (Object)"At least one target");
        double maxDistance = builder.maxDistance.getAsDouble();
        if (builder.targets.contains(RayTraceTarget.ENTITY)) {
            if (builder.targets.contains(RayTraceTarget.BLOCK)) {
                return this.rayTrace((Position)builder.start, builder.direction, maxDistance, builder.fluidCollisionMode, builder.ignorePassableBlocks, builder.raySize, builder.entityFilter, builder.blockFilter);
            }
            return this.rayTraceEntities(builder.start, builder.direction, maxDistance, builder.raySize, builder.entityFilter);
        }
        return this.rayTraceBlocks((Position)builder.start, builder.direction, maxDistance, builder.fluidCollisionMode, builder.ignorePassableBlocks, builder.blockFilter);
    }

    public List<Player> getPlayers() {
        ArrayList<Player> list = new ArrayList<Player>(this.world.C().size());
        for (EntityHuman entityHuman : this.world.C()) {
            CraftHumanEntity bukkitEntity = entityHuman.getBukkitEntity();
            if (bukkitEntity == null || !(bukkitEntity instanceof Player)) continue;
            list.add((Player)bukkitEntity);
        }
        return list;
    }

    public Entity getEntity(UUID uuid) {
        Preconditions.checkArgument((uuid != null ? 1 : 0) != 0, (Object)"UUID cannot be null");
        net.minecraft.world.entity.Entity entity = this.world.d(uuid);
        return entity == null ? null : entity.getBukkitEntity();
    }

    public void save(boolean flush) {
        AsyncCatcher.catchOp("world save");
        this.server.checkSaveState();
        boolean oldSave = this.world.e;
        this.world.e = false;
        this.world.a(null, flush, false);
        this.world.e = oldSave;
    }

    public boolean isAutoSave() {
        return !this.world.e;
    }

    public void setAutoSave(boolean value) {
        this.world.e = !value;
    }

    public void setDifficulty(Difficulty difficulty) {
        this.getHandle().q().setDifficulty(this.getHandle(), CraftDifficulty.toMinecraft(difficulty), null, true);
    }

    public Difficulty getDifficulty() {
        return CraftDifficulty.toBukkit(this.getHandle().aq());
    }

    public int getViewDistance() {
        return FeatureHooks.getViewDistance(this.world);
    }

    public int getSimulationDistance() {
        return FeatureHooks.getSimulationDistance(this.world);
    }

    public BlockMetadataStore getBlockMetadata() {
        return this.blockMetadata;
    }

    public boolean hasStorm() {
        return this.world.A.h();
    }

    public void setStorm(boolean hasStorm) {
        this.world.J.setRaining(hasStorm, WeatherChangeEvent.Cause.PLUGIN);
        this.setWeatherDuration(0);
        this.setClearWeatherDuration(0);
    }

    public int getWeatherDuration() {
        return this.world.J.i();
    }

    public void setWeatherDuration(int duration) {
        this.world.J.c(duration);
    }

    public boolean isThundering() {
        return this.world.A.f();
    }

    public void setThundering(boolean thundering) {
        this.world.J.setThundering(thundering, ThunderChangeEvent.Cause.PLUGIN);
        this.setThunderDuration(0);
        this.setClearWeatherDuration(0);
    }

    public int getThunderDuration() {
        return this.world.J.g();
    }

    public void setThunderDuration(int duration) {
        this.world.J.b(duration);
    }

    public boolean isClearWeather() {
        return !this.hasStorm() && !this.isThundering();
    }

    public void setClearWeatherDuration(int duration) {
        this.world.J.a(duration);
    }

    public int getClearWeatherDuration() {
        return this.world.J.e();
    }

    public long getSeed() {
        return this.world.H();
    }

    public boolean getPVP() {
        return this.world.pvpMode.toBooleanOrElseGet(() -> this.world.S().c(GameRules.ae));
    }

    public void setPVP(boolean pvp) {
        if (this.world.S().c(GameRules.ae) == pvp) {
            return;
        }
        this.world.pvpMode = TriState.byBoolean((boolean)pvp);
    }

    public <T> void playEffect(Location loc, Effect effect, T data, int radius) {
        if (data != null) {
            Preconditions.checkArgument((effect.getData() != null ? 1 : 0) != 0, (String)"Effect.%s does not have a valid Data", (Object)effect);
            Preconditions.checkArgument((boolean)effect.isApplicable(data), (String)"%s data cannot be used for the %s effect", (Object)data.getClass().getName(), (Object)effect);
        } else {
            Preconditions.checkArgument((effect.getData() == null || effect == Effect.ELECTRIC_SPARK ? 1 : 0) != 0, (String)"Wrong kind of data for the %s effect", (Object)effect);
        }
        int datavalue = CraftEffect.getDataValue(effect, data);
        this.playEffect(loc, effect, datavalue, radius);
    }

    public void playEffect(Location location, Effect effect, int data, int radius) {
        Preconditions.checkArgument((effect != null ? 1 : 0) != 0, (Object)"Effect cannot be null");
        Preconditions.checkArgument((location != null ? 1 : 0) != 0, (Object)"Location cannot be null");
        Preconditions.checkArgument((location.getWorld() != null ? 1 : 0) != 0, (Object)"World of Location cannot be null");
        int packetData = effect.getId();
        PacketPlayOutWorldEvent packet = new PacketPlayOutWorldEvent(packetData, CraftLocation.toBlockPosition(location), data, false);
        radius *= radius;
        for (Player player : this.getPlayers()) {
            int distance;
            if (((CraftPlayer)player).getHandle().g == null || !location.getWorld().equals((Object)player.getWorld()) || (distance = (int)player.getLocation().distanceSquared(location)) > radius) continue;
            ((CraftPlayer)player).getHandle().g.b(packet);
        }
    }

    public FallingBlock spawnFallingBlock(Location location, MaterialData data) throws IllegalArgumentException {
        Preconditions.checkArgument((data != null ? 1 : 0) != 0, (Object)"MaterialData cannot be null");
        return this.spawnFallingBlock(location, data.getItemType(), data.getData());
    }

    public FallingBlock spawnFallingBlock(Location location, Material material, byte data) throws IllegalArgumentException {
        Preconditions.checkArgument((location != null ? 1 : 0) != 0, (Object)"Location cannot be null");
        Preconditions.checkArgument((material != null ? 1 : 0) != 0, (Object)"Material cannot be null");
        Preconditions.checkArgument((boolean)material.isBlock(), (String)"Material.%s must be a block", (Object)material);
        EntityFallingBlock entity = new EntityFallingBlock(this.world, location.getX(), location.getY(), location.getZ(), CraftBlockType.bukkitToMinecraft(material).m());
        entity.a = 1;
        this.world.addFreshEntity(entity, CreatureSpawnEvent.SpawnReason.CUSTOM);
        return (FallingBlock)entity.getBukkitEntity();
    }

    public FallingBlock spawnFallingBlock(Location location, BlockData data) throws IllegalArgumentException {
        Preconditions.checkArgument((location != null ? 1 : 0) != 0, (Object)"Location cannot be null");
        Preconditions.checkArgument((data != null ? 1 : 0) != 0, (Object)"BlockData cannot be null");
        EntityFallingBlock entity = new EntityFallingBlock(this.world, location.getX(), location.getY(), location.getZ(), ((CraftBlockData)data).getState());
        entity.a = 1;
        this.world.addFreshEntity(entity, CreatureSpawnEvent.SpawnReason.CUSTOM);
        return (FallingBlock)entity.getBukkitEntity();
    }

    public ChunkSnapshot getEmptyChunkSnapshot(int x2, int z2, boolean includeBiome, boolean includeBiomeTempRain) {
        return CraftChunk.getEmptyChunkSnapshot(x2, z2, this, includeBiome, includeBiomeTempRain);
    }

    public void setSpawnFlags(boolean allowMonsters, boolean allowAnimals) {
        this.world.n().setSpawnSettings(allowMonsters, allowAnimals);
    }

    public boolean getAllowAnimals() {
        return this.world.n().spawnFriendlies;
    }

    public boolean getAllowMonsters() {
        return this.world.n().k;
    }

    public int getMinHeight() {
        return this.world.M_();
    }

    public int getMaxHeight() {
        return this.world.ar() + 1;
    }

    public int getMaxY() {
        return this.world.ar();
    }

    public int getLogicalHeight() {
        return this.world.H_().p();
    }

    public boolean isNatural() {
        return this.world.H_().j();
    }

    public boolean isBedWorks() {
        return this.world.H_().l();
    }

    public boolean hasSkyLight() {
        return this.world.H_().g();
    }

    public boolean hasCeiling() {
        return this.world.H_().h();
    }

    public boolean isPiglinSafe() {
        return this.world.H_().b();
    }

    public boolean isRespawnAnchorWorks() {
        return this.world.H_().m();
    }

    public boolean hasRaids() {
        return this.world.H_().c();
    }

    public boolean isUltraWarm() {
        return this.world.H_().i();
    }

    public int getSeaLevel() {
        return this.world.T();
    }

    public int hashCode() {
        return this.getUID().hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CraftWorld other = (CraftWorld)obj;
        return this.getUID() == other.getUID();
    }

    public Path getWorldPath() {
        return this.world.levelStorageAccess.a(SavedFile.l).getParent();
    }

    public void sendPluginMessage(Plugin source, String channel, byte[] message) {
        StandardMessenger.validatePluginMessage((Messenger)this.server.getMessenger(), (Plugin)source, (String)channel, (byte[])message);
        for (Player player : this.getPlayers()) {
            player.sendPluginMessage(source, channel, message);
        }
    }

    public Set<String> getListeningPluginChannels() {
        HashSet<String> result = new HashSet<String>();
        for (Player player : this.getPlayers()) {
            result.addAll(player.getListeningPluginChannels());
        }
        return result;
    }

    public WorldType getWorldType() {
        return this.world.G() ? WorldType.FLAT : WorldType.NORMAL;
    }

    public boolean canGenerateStructures() {
        return this.world.J.x().d();
    }

    public boolean hasBonusChest() {
        return this.world.J.x().e();
    }

    public boolean isHardcore() {
        return this.world.F_().k();
    }

    public void setHardcore(boolean hardcore) {
        this.world.J.g.c = hardcore;
    }

    public void setTicksPerSpawns(SpawnCategory spawnCategory, int ticksPerCategorySpawn) {
        Preconditions.checkArgument((spawnCategory != null ? 1 : 0) != 0, (Object)"SpawnCategory cannot be null");
        Preconditions.checkArgument((boolean)CraftSpawnCategory.isValidForLimits(spawnCategory), (String)"SpawnCategory.%s are not supported", (Object)spawnCategory);
        this.world.ticksPerSpawnCategory.put((Object)spawnCategory, (long)ticksPerCategorySpawn);
    }

    public long getTicksPerSpawns(SpawnCategory spawnCategory) {
        Preconditions.checkArgument((spawnCategory != null ? 1 : 0) != 0, (Object)"SpawnCategory cannot be null");
        Preconditions.checkArgument((boolean)CraftSpawnCategory.isValidForLimits(spawnCategory), (String)"SpawnCategory.%s are not supported", (Object)spawnCategory);
        return this.world.ticksPerSpawnCategory.getLong((Object)spawnCategory);
    }

    public void setMetadata(String metadataKey, MetadataValue newMetadataValue) {
        this.server.getWorldMetadata().setMetadata(this, metadataKey, newMetadataValue);
    }

    public List<MetadataValue> getMetadata(String metadataKey) {
        return this.server.getWorldMetadata().getMetadata(this, metadataKey);
    }

    public boolean hasMetadata(String metadataKey) {
        return this.server.getWorldMetadata().hasMetadata(this, metadataKey);
    }

    public void removeMetadata(String metadataKey, Plugin owningPlugin) {
        this.server.getWorldMetadata().removeMetadata(this, metadataKey, owningPlugin);
    }

    public int getSpawnLimit(SpawnCategory spawnCategory) {
        Preconditions.checkArgument((spawnCategory != null ? 1 : 0) != 0, (Object)"SpawnCategory cannot be null");
        Preconditions.checkArgument((boolean)CraftSpawnCategory.isValidForLimits(spawnCategory), (String)"SpawnCategory.%s are not supported", (Object)spawnCategory);
        return this.getSpawnLimitUnsafe(spawnCategory);
    }

    public final int getSpawnLimitUnsafe(SpawnCategory spawnCategory) {
        int limit = this.spawnCategoryLimit.getOrDefault((Object)spawnCategory, -1);
        if (limit < 0) {
            limit = this.server.getSpawnLimitUnsafe(spawnCategory);
        }
        return limit;
    }

    public void setSpawnLimit(SpawnCategory spawnCategory, int limit) {
        Preconditions.checkArgument((spawnCategory != null ? 1 : 0) != 0, (Object)"SpawnCategory cannot be null");
        Preconditions.checkArgument((boolean)CraftSpawnCategory.isValidForLimits(spawnCategory), (String)"SpawnCategory.%s are not supported", (Object)spawnCategory);
        this.spawnCategoryLimit.put((Object)spawnCategory, limit);
    }

    public void playSound(Location loc, Sound sound, SoundCategory category, float volume, float pitch) {
        this.playSound(loc, sound, category, volume, pitch, this.getHandle().z.g());
    }

    public void playSound(Location loc, String sound, SoundCategory category, float volume, float pitch) {
        this.playSound(loc, sound, category, volume, pitch, this.getHandle().z.g());
    }

    public void playSound(Location loc, Sound sound, SoundCategory category, float volume, float pitch, long seed) {
        AsyncCatcher.catchOp("play sound");
        if (loc == null || sound == null || category == null) {
            return;
        }
        double x2 = loc.getX();
        double y2 = loc.getY();
        double z2 = loc.getZ();
        this.getHandle().a(null, x2, y2, z2, CraftSound.bukkitToMinecraft(sound), net.minecraft.sounds.SoundCategory.valueOf(category.name()), volume, pitch, seed);
    }

    public void playSound(Location loc, String sound, SoundCategory category, float volume, float pitch, long seed) {
        AsyncCatcher.catchOp("play sound");
        if (loc == null || sound == null || category == null) {
            return;
        }
        double x2 = loc.getX();
        double y2 = loc.getY();
        double z2 = loc.getZ();
        PacketPlayOutNamedSoundEffect packet = new PacketPlayOutNamedSoundEffect(Holder.a(SoundEffect.a(MinecraftKey.a(sound))), net.minecraft.sounds.SoundCategory.valueOf(category.name()), x2, y2, z2, volume, pitch, seed);
        this.world.q().am().a(null, x2, y2, z2, volume > 1.0f ? (double)(16.0f * volume) : 16.0, this.world.al(), packet);
    }

    public void playSound(Entity entity, Sound sound, SoundCategory category, float volume, float pitch) {
        this.playSound(entity, sound, category, volume, pitch, this.getHandle().z.g());
    }

    public void playSound(Entity entity, String sound, SoundCategory category, float volume, float pitch) {
        this.playSound(entity, sound, category, volume, pitch, this.getHandle().z.g());
    }

    public void playSound(Entity entity, Sound sound, SoundCategory category, float volume, float pitch, long seed) {
        CraftEntity craftEntity;
        block5: {
            block4: {
                AsyncCatcher.catchOp("play sound");
                if (!(entity instanceof CraftEntity)) break block4;
                craftEntity = (CraftEntity)entity;
                if (entity.getWorld() == this && sound != null && category != null) break block5;
            }
            return;
        }
        PacketPlayOutEntitySound packet = new PacketPlayOutEntitySound(CraftSound.bukkitToMinecraftHolder(sound), net.minecraft.sounds.SoundCategory.valueOf(category.name()), craftEntity.getHandle(), volume, pitch, seed);
        PlayerChunkMap.EntityTracker entityTracker = (PlayerChunkMap.EntityTracker)this.getHandle().n().a.J.get(entity.getEntityId());
        if (entityTracker != null) {
            entityTracker.b(packet);
        }
    }

    public void playSound(net.kyori.adventure.sound.Sound sound) {
        AsyncCatcher.catchOp("play sound");
        long seed = sound.seed().orElseGet(this.world.I_()::g);
        for (EntityPlayer player : this.getHandle().C()) {
            player.g.b(PaperAdventure.asSoundPacket(sound, player.dK(), player.dM(), player.dQ(), seed, null));
        }
    }

    public void playSound(Entity entity, String sound, SoundCategory category, float volume, float pitch, long seed) {
        CraftEntity craftEntity;
        block5: {
            block4: {
                AsyncCatcher.catchOp("play sound");
                if (!(entity instanceof CraftEntity)) break block4;
                craftEntity = (CraftEntity)entity;
                if (entity.getWorld() == this && sound != null && category != null) break block5;
            }
            return;
        }
        PacketPlayOutEntitySound packet = new PacketPlayOutEntitySound(Holder.a(SoundEffect.a(MinecraftKey.a(sound))), net.minecraft.sounds.SoundCategory.valueOf(category.name()), craftEntity.getHandle(), volume, pitch, seed);
        PlayerChunkMap.EntityTracker entityTracker = (PlayerChunkMap.EntityTracker)this.getHandle().n().a.J.get(entity.getEntityId());
        if (entityTracker != null) {
            entityTracker.b(packet);
        }
    }

    public void playSound(net.kyori.adventure.sound.Sound sound, double x2, double y2, double z2) {
        AsyncCatcher.catchOp("play sound");
        PaperAdventure.asSoundPacket(sound, x2, y2, z2, sound.seed().orElseGet(this.world.I_()::g), this.playSound0(x2, y2, z2));
    }

    public void playSound(net.kyori.adventure.sound.Sound sound, Sound.Emitter emitter) {
        AsyncCatcher.catchOp("play sound");
        long seed = sound.seed().orElseGet(this.getHandle().I_()::g);
        if (emitter == Sound.Emitter.self()) {
            for (EntityPlayer player : this.getHandle().C()) {
                player.g.b(PaperAdventure.asSoundPacket(sound, player, seed, null));
            }
        } else if (emitter instanceof CraftEntity) {
            CraftEntity craftEntity = (CraftEntity)emitter;
            net.minecraft.world.entity.Entity entity = craftEntity.getHandle();
            PaperAdventure.asSoundPacket(sound, entity, seed, this.playSound0(entity.dK(), entity.dM(), entity.dQ()));
        } else {
            throw new IllegalArgumentException("Sound emitter must be an Entity or self(), but was: " + String.valueOf(emitter));
        }
    }

    private BiConsumer<Packet<?>, Float> playSound0(double x2, double y2, double z2) {
        return (packet, distance) -> this.world.q().am().a(null, x2, y2, z2, distance.floatValue(), this.world.al(), (Packet<?>)packet);
    }

    public synchronized Map<String, GameRules.GameRuleKey<?>> getGameRulesNMS() {
        if (this.gamerules != null) {
            return this.gamerules;
        }
        this.gamerules = CraftWorld.getGameRulesNMS(this.getHandle().S());
        return this.gamerules;
    }

    public static Map<String, GameRules.GameRuleKey<?>> getGameRulesNMS(GameRules gameRules) {
        final HashMap gamerules = new HashMap();
        gameRules.a(new GameRules.GameRuleVisitor(){

            @Override
            public <T extends GameRules.GameRuleValue<T>> void a(GameRules.GameRuleKey<T> key, GameRules.GameRuleDefinition<T> type) {
                gamerules.put(key.a(), key);
            }
        });
        return gamerules;
    }

    public synchronized Map<String, GameRules.GameRuleDefinition<?>> getGameRuleDefinitions() {
        if (this.gameruleDefinitions != null) {
            return this.gameruleDefinitions;
        }
        final HashMap gameruleDefinitions = new HashMap();
        this.getHandle().S().a(new GameRules.GameRuleVisitor(){

            @Override
            public <T extends GameRules.GameRuleValue<T>> void a(GameRules.GameRuleKey<T> key, GameRules.GameRuleDefinition<T> type) {
                gameruleDefinitions.put(key.a(), type);
            }
        });
        this.gameruleDefinitions = gameruleDefinitions;
        return this.gameruleDefinitions;
    }

    public String getGameRuleValue(String rule) {
        if (rule == null) {
            return null;
        }
        Object value = this.getHandle().S().b(this.getGameRulesNMS().get(rule));
        return value != null ? ((GameRules.GameRuleValue)value).toString() : "";
    }

    public boolean setGameRuleValue(String rule, String value) {
        if (rule == null || value == null) {
            return false;
        }
        if (!this.isGameRule(rule)) {
            return false;
        }
        GameRule gameRule = GameRule.getByName((String)rule);
        WorldGameRuleChangeEvent event = new WorldGameRuleChangeEvent((World)this, null, gameRule, value);
        if (!event.callEvent()) {
            return false;
        }
        Object handle = this.getHandle().S().b(this.getGameRulesNMS().get(rule));
        ((GameRules.GameRuleValue)handle).a(event.getValue());
        ((GameRules.GameRuleValue)handle).onChanged(this.getHandle());
        return true;
    }

    public String[] getGameRules() {
        return this.getGameRulesNMS().keySet().toArray(new String[this.getGameRulesNMS().size()]);
    }

    public boolean isGameRule(String rule) {
        Preconditions.checkArgument((rule != null ? 1 : 0) != 0, (Object)"String rule cannot be null");
        Preconditions.checkArgument((!rule.isEmpty() ? 1 : 0) != 0, (Object)"String rule cannot be empty");
        return this.getGameRulesNMS().containsKey(rule);
    }

    public <T> T getGameRuleValue(GameRule<T> rule) {
        Preconditions.checkArgument((rule != null ? 1 : 0) != 0, (Object)"GameRule cannot be null");
        GameRules.GameRuleKey<?> key = this.getGameRulesNMS().get(rule.getName());
        Preconditions.checkArgument((key != null ? 1 : 0) != 0, (String)"GameRule '%s' is not available", (Object)rule.getName());
        return this.getGameRuleResult(rule, (GameRules.GameRuleValue<?>)this.getHandle().S().b(key));
    }

    public <T> T getGameRuleDefault(GameRule<T> rule) {
        Preconditions.checkArgument((rule != null ? 1 : 0) != 0, (Object)"GameRule cannot be null");
        GameRules.GameRuleDefinition<?> type = this.getGameRuleDefinitions().get(rule.getName());
        Preconditions.checkArgument((type != null ? 1 : 0) != 0, (String)"GameRule '%s' is not available", (Object)rule.getName());
        return this.getGameRuleResult(rule, (GameRules.GameRuleValue<?>)type.a());
    }

    public <T> boolean setGameRule(GameRule<T> rule, T newValue) {
        Preconditions.checkArgument((rule != null ? 1 : 0) != 0, (Object)"GameRule cannot be null");
        Preconditions.checkArgument((newValue != null ? 1 : 0) != 0, (Object)"GameRule value cannot be null");
        if (!this.isGameRule(rule.getName())) {
            return false;
        }
        WorldGameRuleChangeEvent event = new WorldGameRuleChangeEvent((World)this, null, rule, String.valueOf(newValue));
        if (!event.callEvent()) {
            return false;
        }
        Object handle = this.getHandle().S().b(this.getGameRulesNMS().get(rule.getName()));
        ((GameRules.GameRuleValue)handle).a(event.getValue());
        ((GameRules.GameRuleValue)handle).onChanged(this.getHandle());
        return true;
    }

    private <T> T getGameRuleResult(GameRule<T> rule, GameRules.GameRuleValue<?> value) {
        if (value == null) {
            return null;
        }
        if (value instanceof GameRules.GameRuleBoolean) {
            return rule.getType().cast(((GameRules.GameRuleBoolean)value).a());
        }
        if (value instanceof GameRules.GameRuleInt) {
            return rule.getType().cast(value.c());
        }
        throw new IllegalArgumentException("Invalid GameRule type (" + String.valueOf(value) + ") for GameRule " + rule.getName());
    }

    public WorldBorder getWorldBorder() {
        if (this.worldBorder == null) {
            this.worldBorder = new CraftWorldBorder(this);
        }
        return this.worldBorder;
    }

    public <T> void spawnParticle(Particle particle, double x2, double y2, double z2, int count, double offsetX, double offsetY, double offsetZ, double extra, T data) {
        this.spawnParticle(particle, x2, y2, z2, count, offsetX, offsetY, offsetZ, extra, data, false);
    }

    public <T> void spawnParticle(Particle particle, List<Player> receivers, Player sender, double x2, double y2, double z2, int count, double offsetX, double offsetY, double offsetZ, double extra, T data, boolean force) {
        if ((data = CraftParticle.convertLegacy(data)) != null) {
            Preconditions.checkArgument((boolean)particle.getDataType().isInstance(data), (String)"data (%s) should be %s", data.getClass(), (Object)particle.getDataType());
        }
        this.getHandle().sendParticlesSource(receivers == null ? this.getHandle().C() : Lists.transform(receivers, player -> ((CraftPlayer)player).getHandle()), sender != null ? ((CraftPlayer)sender).getHandle() : null, CraftParticle.createParticleParam(particle, data), force, false, x2, y2, z2, count, offsetX, offsetY, offsetZ, extra);
    }

    @Deprecated
    public Location locateNearestStructure(Location origin, StructureType structureType, int radius, boolean findUnexplored) {
        StructureSearchResult result = null;
        if (StructureType.MINESHAFT == structureType) {
            result = this.locateNearestStructure(origin, org.bukkit.generator.structure.StructureType.MINESHAFT, radius, findUnexplored);
        } else if (StructureType.VILLAGE == structureType) {
            result = this.locateNearestStructure(origin, List.of(Structure.VILLAGE_DESERT, Structure.VILLAGE_PLAINS, Structure.VILLAGE_SAVANNA, Structure.VILLAGE_SNOWY, Structure.VILLAGE_TAIGA), radius, findUnexplored);
        } else if (StructureType.NETHER_FORTRESS == structureType) {
            result = this.locateNearestStructure(origin, org.bukkit.generator.structure.StructureType.FORTRESS, radius, findUnexplored);
        } else if (StructureType.STRONGHOLD == structureType) {
            result = this.locateNearestStructure(origin, org.bukkit.generator.structure.StructureType.STRONGHOLD, radius, findUnexplored);
        } else if (StructureType.JUNGLE_PYRAMID == structureType) {
            result = this.locateNearestStructure(origin, org.bukkit.generator.structure.StructureType.JUNGLE_TEMPLE, radius, findUnexplored);
        } else if (StructureType.OCEAN_RUIN == structureType) {
            result = this.locateNearestStructure(origin, org.bukkit.generator.structure.StructureType.OCEAN_RUIN, radius, findUnexplored);
        } else if (StructureType.DESERT_PYRAMID == structureType) {
            result = this.locateNearestStructure(origin, org.bukkit.generator.structure.StructureType.DESERT_PYRAMID, radius, findUnexplored);
        } else if (StructureType.IGLOO == structureType) {
            result = this.locateNearestStructure(origin, org.bukkit.generator.structure.StructureType.IGLOO, radius, findUnexplored);
        } else if (StructureType.SWAMP_HUT == structureType) {
            result = this.locateNearestStructure(origin, org.bukkit.generator.structure.StructureType.SWAMP_HUT, radius, findUnexplored);
        } else if (StructureType.OCEAN_MONUMENT == structureType) {
            result = this.locateNearestStructure(origin, org.bukkit.generator.structure.StructureType.OCEAN_MONUMENT, radius, findUnexplored);
        } else if (StructureType.END_CITY == structureType) {
            result = this.locateNearestStructure(origin, org.bukkit.generator.structure.StructureType.END_CITY, radius, findUnexplored);
        } else if (StructureType.WOODLAND_MANSION == structureType) {
            result = this.locateNearestStructure(origin, org.bukkit.generator.structure.StructureType.WOODLAND_MANSION, radius, findUnexplored);
        } else if (StructureType.BURIED_TREASURE == structureType) {
            result = this.locateNearestStructure(origin, org.bukkit.generator.structure.StructureType.BURIED_TREASURE, radius, findUnexplored);
        } else if (StructureType.SHIPWRECK == structureType) {
            result = this.locateNearestStructure(origin, org.bukkit.generator.structure.StructureType.SHIPWRECK, radius, findUnexplored);
        } else if (StructureType.PILLAGER_OUTPOST == structureType) {
            result = this.locateNearestStructure(origin, Structure.PILLAGER_OUTPOST, radius, findUnexplored);
        } else if (StructureType.NETHER_FOSSIL == structureType) {
            result = this.locateNearestStructure(origin, org.bukkit.generator.structure.StructureType.NETHER_FOSSIL, radius, findUnexplored);
        } else if (StructureType.RUINED_PORTAL == structureType) {
            result = this.locateNearestStructure(origin, org.bukkit.generator.structure.StructureType.RUINED_PORTAL, radius, findUnexplored);
        } else if (StructureType.BASTION_REMNANT == structureType) {
            result = this.locateNearestStructure(origin, Structure.BASTION_REMNANT, radius, findUnexplored);
        }
        return result == null ? null : result.getLocation();
    }

    public StructureSearchResult locateNearestStructure(Location origin, org.bukkit.generator.structure.StructureType structureType, int radius, boolean findUnexplored) {
        ArrayList<Structure> structures = new ArrayList<Structure>();
        for (Structure structure : RegistryAccess.registryAccess().getRegistry(RegistryKey.STRUCTURE)) {
            if (structure.getStructureType() != structureType) continue;
            structures.add(structure);
        }
        return this.locateNearestStructure(origin, structures, radius, findUnexplored);
    }

    public StructureSearchResult locateNearestStructure(Location origin, Structure structure, int radius, boolean findUnexplored) {
        return this.locateNearestStructure(origin, List.of(structure), radius, findUnexplored);
    }

    private StructureSearchResult locateNearestStructure(Location origin, List<Structure> structures, int radius, boolean findUnexplored) {
        BlockPosition originPos = BlockPosition.a(origin.getX(), origin.getY(), origin.getZ());
        ArrayList<Holder<net.minecraft.world.level.levelgen.structure.Structure>> holders = new ArrayList<Holder<net.minecraft.world.level.levelgen.structure.Structure>>();
        for (Structure structure : structures) {
            holders.add(Holder.a(CraftStructure.bukkitToMinecraft(structure)));
        }
        Pair<BlockPosition, Holder<net.minecraft.world.level.levelgen.structure.Structure>> found = this.getHandle().n().g().a(this.getHandle(), HolderSet.a(holders), originPos, radius, findUnexplored);
        if (found == null) {
            return null;
        }
        return new CraftStructureSearchResult(CraftStructure.minecraftToBukkit((net.minecraft.world.level.levelgen.structure.Structure)((Holder)found.getSecond()).a()), CraftLocation.toBukkit((BaseBlockPosition)found.getFirst(), (World)this));
    }

    public double getCoordinateScale() {
        return this.getHandle().H_().k();
    }

    public boolean isFixedTime() {
        return this.getHandle().H_().a();
    }

    public Collection<Material> getInfiniburn() {
        return Sets.newHashSet((Iterator)Iterators.transform(BuiltInRegistries.e.c(this.getHandle().H_().q()).iterator(), blockHolder -> CraftBlockType.minecraftToBukkit((Block)blockHolder.a())));
    }

    public void sendGameEvent(Entity sourceEntity, GameEvent gameEvent, Vector position) {
        this.getHandle().a(sourceEntity != null ? ((CraftEntity)sourceEntity).getHandle() : null, (Holder<net.minecraft.world.level.gameevent.GameEvent>)BuiltInRegistries.a.c(CraftNamespacedKey.toMinecraft(gameEvent.getKey())).orElseThrow(), CraftVector.toBlockPos(position));
    }

    public BiomeSearchResult locateNearestBiome(Location origin, int radius, int horizontalInterval, int verticalInterval, Biome ... biomes) {
        BlockPosition originPos = BlockPosition.a(origin.getX(), origin.getY(), origin.getZ());
        HashSet<Holder<BiomeBase>> holders = new HashSet<Holder<BiomeBase>>();
        for (Biome biome : biomes) {
            holders.add(CraftBiome.bukkitToMinecraftHolder(biome));
        }
        Climate.Sampler sampler = this.getHandle().n().i().b();
        Pair<BlockPosition, Holder<BiomeBase>> found = this.getHandle().n().g().d().a(originPos, radius, horizontalInterval, verticalInterval, holders::contains, sampler, this.getHandle());
        if (found == null) {
            return null;
        }
        return new CraftBiomeSearchResult(CraftBiome.minecraftHolderToBukkit((Holder)found.getSecond()), CraftLocation.toBukkit((BaseBlockPosition)found.getFirst(), (World)this));
    }

    public Raid locateNearestRaid(Location location, int radius) {
        Preconditions.checkArgument((location != null ? 1 : 0) != 0, (Object)"Location cannot be null");
        Preconditions.checkArgument((radius >= 0 ? 1 : 0) != 0, (String)"Radius value (%s) cannot be negative", (int)radius);
        PersistentRaid persistentRaid = this.world.E();
        net.minecraft.world.entity.raid.Raid raid = persistentRaid.a(CraftLocation.toBlockPosition(location), radius * radius);
        return raid == null ? null : new CraftRaid(raid, this.world);
    }

    @Nullable
    public Raid getRaid(int id) {
        @Nullable net.minecraft.world.entity.raid.Raid nmsRaid = (net.minecraft.world.entity.raid.Raid)this.world.E().e.get(id);
        return nmsRaid != null ? new CraftRaid(nmsRaid, this.world) : null;
    }

    public List<Raid> getRaids() {
        PersistentRaid persistentRaid = this.world.E();
        return persistentRaid.e.values().stream().map(raid -> new CraftRaid((net.minecraft.world.entity.raid.Raid)raid, this.world)).collect(Collectors.toList());
    }

    public DragonBattle getEnderDragonBattle() {
        return this.getHandle().I() == null ? null : new CraftDragonBattle(this.getHandle().I());
    }

    public float getLocalDifficultyAt(Location location) {
        return this.getHandle().d_(CraftLocation.toBlockPosition(location)).b();
    }

    public void sendBlockHighlight(Location location, int duration) {
        this.sendBlockHighlight(location, duration, "", 1677786880);
    }

    public void sendBlockHighlight(Location location, int duration, int argb) {
        this.sendBlockHighlight(location, duration, "", argb);
    }

    public void sendBlockHighlight(Location location, int duration, String text) {
        this.sendBlockHighlight(location, duration, text, 1677786880);
    }

    public void sendBlockHighlight(Location location, int duration, String text, int argb) {
    }

    public void sendBlockHighlight(Location location, int duration, Color color, int transparency) {
        this.sendBlockHighlight(location, duration, "", color, transparency);
    }

    public void sendBlockHighlight(Location location, int duration, String text, Color color, int transparency) {
        if (transparency < 0 || transparency > 255) {
            throw new IllegalArgumentException("transparency is outside of 0-255 range");
        }
        this.sendBlockHighlight(location, duration, text, transparency << 24 | color.asRGB());
    }

    public void clearBlockHighlights() {
    }

    public Collection<GeneratedStructure> getStructures(int x2, int z2) {
        return this.getStructures(x2, z2, (net.minecraft.world.level.levelgen.structure.Structure struct) -> true);
    }

    public Collection<GeneratedStructure> getStructures(int x2, int z2, Structure structure) {
        Preconditions.checkArgument((structure != null ? 1 : 0) != 0, (Object)"Structure cannot be null");
        IRegistry<net.minecraft.world.level.levelgen.structure.Structure> registry = CraftRegistry.getMinecraftRegistry(Registries.bm);
        MinecraftKey key = registry.b(CraftStructure.bukkitToMinecraft(structure));
        return this.getStructures(x2, z2, (net.minecraft.world.level.levelgen.structure.Structure struct) -> registry.b((net.minecraft.world.level.levelgen.structure.Structure)struct).equals(key));
    }

    private List<GeneratedStructure> getStructures(int x2, int z2, Predicate<net.minecraft.world.level.levelgen.structure.Structure> predicate) {
        ArrayList<GeneratedStructure> structures = new ArrayList<GeneratedStructure>();
        for (StructureStart start : this.getHandle().b().a(new ChunkCoordIntPair(x2, z2), predicate)) {
            structures.add(new CraftGeneratedStructure(start));
        }
        return structures;
    }

    public PersistentDataContainer getPersistentDataContainer() {
        return this.persistentDataContainer;
    }

    public void storeBukkitValues(NBTTagCompound tag) {
        if (!this.persistentDataContainer.isEmpty()) {
            tag.a("BukkitValues", this.persistentDataContainer.toTagCompound());
        }
    }

    public void readBukkitValues(NBTBase tag) {
        if (tag instanceof NBTTagCompound) {
            NBTTagCompound compoundTag = (NBTTagCompound)tag;
            this.persistentDataContainer.putAll(compoundTag);
        }
    }

    public World.Spigot spigot() {
        return this.spigot;
    }

    public void getChunkAtAsync(int x2, int z2, boolean gen, boolean urgent, @NotNull Consumer<? super Chunk> cb) {
        CraftWorld.warnUnsafeChunk("getting a faraway chunk async", x2, z2);
        PlatformHooks.get().scheduleChunkLoad(this.getHandle(), x2, z2, gen, ChunkStatus.n, true, urgent ? Priority.HIGHER : Priority.NORMAL, chunk -> cb.accept(chunk == null ? null : new CraftChunk((net.minecraft.world.level.chunk.Chunk)chunk)));
    }

    public void getChunksAtAsync(int minX, int minZ, int maxX, int maxZ, boolean urgent, Runnable cb) {
        CraftWorld.warnUnsafeChunk("getting a faraway chunk async", minX, minZ);
        CraftWorld.warnUnsafeChunk("getting a faraway chunk async", maxX, maxZ);
        this.getHandle().loadChunks(minX, minZ, maxX, maxZ, urgent ? Priority.HIGHER : Priority.NORMAL, chunks -> cb.run());
    }

    public void setViewDistance(int viewDistance) {
        FeatureHooks.setViewDistance(this.world, viewDistance);
    }

    public void setSimulationDistance(int simulationDistance) {
        FeatureHooks.setSimulationDistance(this.world, simulationDistance);
    }

    public int getSendViewDistance() {
        return FeatureHooks.getSendViewDistance(this.world);
    }

    public void setSendViewDistance(int viewDistance) {
        FeatureHooks.setSendViewDistance(this.world, viewDistance);
    }

    public Pointers pointers() {
        return POINTERS_SUPPLIER.view((Object)this);
    }
}

