/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R6.attribute;

import com.google.common.base.Preconditions;
import io.papermc.paper.registry.RegistryKey;
import io.papermc.paper.util.OldEnumHolderable;
import java.util.Locale;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.world.entity.ai.attributes.AttributeBase;
import org.bukkit.NamespacedKey;
import org.bukkit.attribute.Attribute;
import org.bukkit.craftbukkit.v1_21_R6.CraftRegistry;
import org.bukkit.craftbukkit.v1_21_R6.legacy.FieldRename;
import org.bukkit.craftbukkit.v1_21_R6.util.ApiVersion;

public class CraftAttribute
extends OldEnumHolderable<Attribute, AttributeBase>
implements Attribute {
    private static int count = 0;

    public static Attribute minecraftToBukkit(AttributeBase minecraft) {
        return (Attribute)CraftRegistry.minecraftToBukkit(minecraft, Registries.c);
    }

    public static Attribute minecraftHolderToBukkit(Holder<AttributeBase> minecraft) {
        return (Attribute)CraftRegistry.minecraftHolderToBukkit(minecraft, Registries.c);
    }

    public static Attribute stringToBukkit(String string) {
        Preconditions.checkArgument((string != null ? 1 : 0) != 0);
        string = FieldRename.convertAttributeName(ApiVersion.CURRENT, string);
        string = string.toLowerCase(Locale.ROOT);
        NamespacedKey key = NamespacedKey.fromString((String)string);
        if (key == null) {
            return null;
        }
        return (Attribute)CraftRegistry.get(RegistryKey.ATTRIBUTE, key, ApiVersion.CURRENT);
    }

    public static AttributeBase bukkitToMinecraft(Attribute bukkit) {
        return (AttributeBase)CraftRegistry.bukkitToMinecraft(bukkit);
    }

    public static Holder<AttributeBase> bukkitToMinecraftHolder(Attribute bukkit) {
        return CraftRegistry.bukkitToMinecraftHolder(bukkit);
    }

    public static String bukkitToString(Attribute bukkit) {
        Preconditions.checkArgument((bukkit != null ? 1 : 0) != 0);
        return bukkit.getKey().toString();
    }

    public CraftAttribute(Holder<AttributeBase> holder) {
        super(holder, count++);
    }

    public Attribute.Sentiment getSentiment() {
        return Attribute.Sentiment.valueOf((String)((AttributeBase)this.getHandle()).f.name());
    }

    public String getTranslationKey() {
        return ((AttributeBase)this.getHandle()).c();
    }

    public String translationKey() {
        return ((AttributeBase)this.getHandle()).c();
    }
}

