/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R6.block;

import io.papermc.paper.adventure.PaperAdventure;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import net.kyori.adventure.text.Component;
import net.minecraft.advancements.critereon.CriterionConditionItem;
import net.minecraft.advancements.critereon.CriterionConditionValue;
import net.minecraft.advancements.critereon.DataComponentMatchers;
import net.minecraft.core.component.DataComponentExactPredicate;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.world.ChestLock;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.entity.TileEntityBeacon;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.block.Beacon;
import org.bukkit.craftbukkit.v1_21_R6.block.CraftBlockEntityState;
import org.bukkit.craftbukkit.v1_21_R6.inventory.CraftItemStack;
import org.bukkit.craftbukkit.v1_21_R6.potion.CraftPotionEffectType;
import org.bukkit.craftbukkit.v1_21_R6.util.CraftChatMessage;
import org.bukkit.entity.LivingEntity;
import org.bukkit.inventory.ItemStack;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;

public class CraftBeacon
extends CraftBlockEntityState<TileEntityBeacon>
implements Beacon {
    public CraftBeacon(World world, TileEntityBeacon blockEntity) {
        super(world, blockEntity);
    }

    protected CraftBeacon(CraftBeacon state, Location location) {
        super(state, location);
    }

    public Collection<LivingEntity> getEntitiesInRange() {
        this.ensureNoWorldGeneration();
        TileEntity blockEntity = this.getBlockEntityFromWorld();
        if (blockEntity instanceof TileEntityBeacon) {
            TileEntityBeacon beacon = (TileEntityBeacon)blockEntity;
            List<EntityHuman> nms = TileEntityBeacon.getHumansInRange(beacon.j(), beacon.aD_(), beacon.q, beacon);
            ArrayList<LivingEntity> bukkit = new ArrayList<LivingEntity>(nms.size());
            for (EntityHuman human : nms) {
                bukkit.add(human.getBukkitEntity());
            }
            return bukkit;
        }
        return new ArrayList<LivingEntity>();
    }

    public int getTier() {
        return ((TileEntityBeacon)this.getSnapshot()).q;
    }

    public PotionEffect getPrimaryEffect() {
        return ((TileEntityBeacon)this.getSnapshot()).getPrimaryEffect();
    }

    public void setPrimaryEffect(PotionEffectType effect) {
        ((TileEntityBeacon)this.getSnapshot()).s = effect != null ? CraftPotionEffectType.bukkitToMinecraftHolder(effect) : null;
    }

    public PotionEffect getSecondaryEffect() {
        return ((TileEntityBeacon)this.getSnapshot()).getSecondaryEffect();
    }

    public void setSecondaryEffect(PotionEffectType effect) {
        ((TileEntityBeacon)this.getSnapshot()).t = effect != null ? CraftPotionEffectType.bukkitToMinecraftHolder(effect) : null;
    }

    public Component customName() {
        TileEntityBeacon beacon = (TileEntityBeacon)this.getSnapshot();
        return beacon.u != null ? PaperAdventure.asAdventure(beacon.u) : null;
    }

    public void customName(Component customName) {
        ((TileEntityBeacon)this.getSnapshot()).a(customName != null ? PaperAdventure.asVanilla(customName) : null);
    }

    public String getCustomName() {
        TileEntityBeacon beacon = (TileEntityBeacon)this.getSnapshot();
        return beacon.u != null ? CraftChatMessage.fromComponent(beacon.u) : null;
    }

    public void setCustomName(String name) {
        ((TileEntityBeacon)this.getSnapshot()).a(CraftChatMessage.fromStringOrNull(name));
    }

    public boolean isLocked() {
        return ((TileEntityBeacon)this.getSnapshot()).v != ChestLock.a;
    }

    public String getLock() {
        Optional<IChatBaseComponent> customName = ((TileEntityBeacon)this.getSnapshot()).v.a().c().b().d().a(DataComponents.g);
        return customName != null ? customName.map(CraftChatMessage::fromComponent).orElse("") : "";
    }

    public void setLock(String key) {
        if (key == null) {
            ((TileEntityBeacon)this.getSnapshot()).v = ChestLock.a;
        } else {
            DataComponentExactPredicate predicate = DataComponentExactPredicate.a().a(DataComponents.g, CraftChatMessage.fromStringOrNull(key)).a();
            ((TileEntityBeacon)this.getSnapshot()).v = new ChestLock(new CriterionConditionItem(Optional.empty(), CriterionConditionValue.IntegerRange.c, new DataComponentMatchers(predicate, Collections.emptyMap())));
        }
    }

    public void setLockItem(ItemStack key) {
        ((TileEntityBeacon)this.getSnapshot()).v = key == null ? ChestLock.a : new ChestLock(CraftItemStack.asCriterionConditionItem(key));
    }

    @Override
    public CraftBeacon copy() {
        return new CraftBeacon(this, null);
    }

    @Override
    public CraftBeacon copy(Location location) {
        return new CraftBeacon(this, location);
    }

    public double getEffectRange() {
        return ((TileEntityBeacon)this.getSnapshot()).getEffectRange();
    }

    public void setEffectRange(double range) {
        ((TileEntityBeacon)this.getSnapshot()).setEffectRange(range);
    }

    public void resetEffectRange() {
        ((TileEntityBeacon)this.getSnapshot()).resetEffectRange();
    }
}

