/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R6.block;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BaseBlockPosition;
import net.minecraft.core.BlockPosition;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.block.entity.TileEntityBeehive;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.block.Beehive;
import org.bukkit.block.EntityBlockStorage;
import org.bukkit.craftbukkit.v1_21_R6.block.CraftBlockEntityState;
import org.bukkit.craftbukkit.v1_21_R6.entity.CraftBee;
import org.bukkit.craftbukkit.v1_21_R6.util.CraftLocation;
import org.bukkit.entity.Bee;
import org.purpurmc.purpur.entity.PurpurStoredBee;
import org.purpurmc.purpur.entity.StoredEntity;

public class CraftBeehive
extends CraftBlockEntityState<TileEntityBeehive>
implements Beehive {
    private final List<StoredEntity<Bee>> storage = new ArrayList<StoredEntity<Bee>>();

    public CraftBeehive(World world, TileEntityBeehive blockEntity) {
        super(world, blockEntity);
        for (TileEntityBeehive.HiveBee data : blockEntity.getStored()) {
            this.storage.add(new PurpurStoredBee(data, (EntityBlockStorage<Bee>)this, blockEntity));
        }
    }

    protected CraftBeehive(CraftBeehive state, Location location) {
        super(state, location);
    }

    public Location getFlower() {
        BlockPosition flower = ((TileEntityBeehive)this.getSnapshot()).j;
        return flower == null ? null : CraftLocation.toBukkit((BaseBlockPosition)flower, this.getWorld());
    }

    public void setFlower(Location location) {
        Preconditions.checkArgument((location == null || this.getWorld().equals((Object)location.getWorld()) ? 1 : 0) != 0, (Object)"Flower must be in same world");
        ((TileEntityBeehive)this.getSnapshot()).j = location == null ? null : CraftLocation.toBlockPosition(location);
    }

    public boolean isFull() {
        return ((TileEntityBeehive)this.getSnapshot()).d();
    }

    public boolean isSedated() {
        return this.isPlaced() && ((TileEntityBeehive)this.getBlockEntity()).h();
    }

    public int getEntityCount() {
        return ((TileEntityBeehive)this.getSnapshot()).f();
    }

    public int getMaxEntities() {
        return ((TileEntityBeehive)this.getSnapshot()).maxBees;
    }

    public void setMaxEntities(int max) {
        Preconditions.checkArgument((max > 0 ? 1 : 0) != 0, (Object)"Max bees must be more than 0");
        ((TileEntityBeehive)this.getSnapshot()).maxBees = max;
    }

    public List<Bee> releaseEntities() {
        this.ensureNoWorldGeneration();
        ArrayList<Bee> bees = new ArrayList<Bee>();
        if (this.isPlaced()) {
            TileEntityBeehive beehive = (TileEntityBeehive)this.getBlockEntityFromWorld();
            for (Entity bee : beehive.releaseBees(this.getHandle(), TileEntityBeehive.ReleaseStatus.b, true)) {
                bees.add((Bee)bee.getBukkitEntity());
            }
        }
        this.storage.clear();
        return bees;
    }

    public Bee releaseEntity(StoredEntity<Bee> entity) {
        this.ensureNoWorldGeneration();
        if (!this.getEntities().contains(entity)) {
            return null;
        }
        if (this.isPlaced()) {
            TileEntityBeehive beehive = (TileEntityBeehive)this.getBlockEntityFromWorld();
            TileEntityBeehive.HiveBee data = ((PurpurStoredBee)entity).getHandle();
            List<Entity> list = beehive.releaseBee(this.getHandle(), data, TileEntityBeehive.ReleaseStatus.b, true);
            if (list.size() == 1) {
                this.storage.remove(entity);
                return (Bee)list.get(0).getBukkitEntity();
            }
        }
        return null;
    }

    public List<StoredEntity<Bee>> getEntities() {
        return new ArrayList<StoredEntity<Bee>>(this.storage);
    }

    public void addEntity(Bee entity) {
        Preconditions.checkArgument((entity != null ? 1 : 0) != 0, (Object)"Entity must not be null");
        int length = ((TileEntityBeehive)this.getSnapshot()).getStored().size();
        ((TileEntityBeehive)this.getSnapshot()).a(((CraftBee)entity).getHandle());
        List<TileEntityBeehive.HiveBee> storedBeeData = ((TileEntityBeehive)this.getSnapshot()).getStored();
        if (length < storedBeeData.size()) {
            this.storage.add(new PurpurStoredBee(storedBeeData.getLast(), (EntityBlockStorage<Bee>)this, (TileEntityBeehive)this.getBlockEntity()));
        }
    }

    @Override
    public CraftBeehive copy() {
        return new CraftBeehive(this, null);
    }

    @Override
    public CraftBeehive copy(Location location) {
        return new CraftBeehive(this, location);
    }

    public void clearEntities() {
        ((TileEntityBeehive)this.getSnapshot()).clearBees();
        this.storage.clear();
    }
}

