/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R6.block;

import com.google.common.base.Preconditions;
import net.minecraft.world.level.block.BlockBell;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.entity.TileEntityBell;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.block.Bell;
import org.bukkit.block.BlockFace;
import org.bukkit.craftbukkit.v1_21_R6.block.CraftBlock;
import org.bukkit.craftbukkit.v1_21_R6.block.CraftBlockEntityState;
import org.bukkit.craftbukkit.v1_21_R6.entity.CraftEntity;
import org.bukkit.entity.Entity;

public class CraftBell
extends CraftBlockEntityState<TileEntityBell>
implements Bell {
    public CraftBell(World world, TileEntityBell blockEntity) {
        super(world, blockEntity);
    }

    protected CraftBell(CraftBell state, Location location) {
        super(state, location);
    }

    public boolean ring(Entity entity, BlockFace direction) {
        Preconditions.checkArgument((direction == null || direction.isCartesian() ? 1 : 0) != 0, (String)"direction must be cartesian, given %s", (Object)direction);
        TileEntity blockEntity = this.getBlockEntityFromWorld();
        if (blockEntity == null) {
            return false;
        }
        net.minecraft.world.entity.Entity nmsEntity = entity != null ? ((CraftEntity)entity).getHandle() : null;
        return ((BlockBell)Blocks.pa).a(nmsEntity, (net.minecraft.world.level.World)this.world.getHandle(), this.getPosition(), CraftBlock.blockFaceToNotch(direction));
    }

    public boolean isShaking() {
        return ((TileEntityBell)this.getSnapshot()).b;
    }

    public int getShakingTicks() {
        return ((TileEntityBell)this.getSnapshot()).a;
    }

    public boolean isResonating() {
        return ((TileEntityBell)this.getSnapshot()).q;
    }

    public int getResonatingTicks() {
        return this.isResonating() ? ((TileEntityBell)this.getSnapshot()).a : 0;
    }

    @Override
    public CraftBell copy() {
        return new CraftBell(this, null);
    }

    @Override
    public CraftBell copy(Location location) {
        return new CraftBell(this, location);
    }
}

