/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R6.block;

import io.papermc.paper.util.OldEnumHolderable;
import java.util.Objects;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.world.level.biome.BiomeBase;
import org.bukkit.NamespacedKey;
import org.bukkit.block.Biome;
import org.bukkit.craftbukkit.v1_21_R6.CraftRegistry;
import org.jetbrains.annotations.ApiStatus;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

@NullMarked
public class CraftBiome
extends OldEnumHolderable<Biome, BiomeBase>
implements Biome {
    private static int count = 0;

    public static Biome minecraftToBukkit(BiomeBase minecraft) {
        return (Biome)CraftRegistry.minecraftToBukkit(minecraft, Registries.aN);
    }

    public static Biome minecraftHolderToBukkit(Holder<BiomeBase> minecraft) {
        return (Biome)CraftRegistry.minecraftHolderToBukkit(minecraft, Registries.aN);
    }

    public static @Nullable BiomeBase bukkitToMinecraft(Biome bukkit) {
        if (bukkit == Biome.CUSTOM) {
            return null;
        }
        return (BiomeBase)CraftRegistry.bukkitToMinecraft(bukkit);
    }

    public static @Nullable Holder<BiomeBase> bukkitToMinecraftHolder(Biome bukkit) {
        if (bukkit == Biome.CUSTOM) {
            return null;
        }
        return CraftRegistry.bukkitToMinecraftHolder(bukkit);
    }

    public CraftBiome(Holder<BiomeBase> holder) {
        super(holder, count++);
    }

    @Deprecated(forRemoval=true, since="1.21.5")
    @ApiStatus.ScheduledForRemoval(inVersion="1.22")
    public static class LegacyCustomBiomeImpl
    implements Biome {
        private static final NamespacedKey LEGACY_CUSTOM_KEY = new NamespacedKey("minecraft", "custom");
        private final int ordinal = count++;

        public NamespacedKey getKey() {
            return LEGACY_CUSTOM_KEY;
        }

        public int compareTo(Biome other) {
            return this.ordinal - other.ordinal();
        }

        public String name() {
            return "CUSTOM";
        }

        public int ordinal() {
            return this.ordinal;
        }

        public boolean equals(Object object) {
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            LegacyCustomBiomeImpl that = (LegacyCustomBiomeImpl)object;
            return this.ordinal == that.ordinal;
        }

        public int hashCode() {
            return Objects.hashCode(this.ordinal);
        }

        public String toString() {
            return "CUSTOM";
        }
    }
}

