/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R6.block;

import java.util.ArrayList;
import java.util.Collection;
import net.minecraft.core.BlockPosition;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityReference;
import net.minecraft.world.level.block.entity.TileEntityConduit;
import net.minecraft.world.phys.AxisAlignedBB;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.Conduit;
import org.bukkit.craftbukkit.v1_21_R6.block.CraftBlock;
import org.bukkit.craftbukkit.v1_21_R6.block.CraftBlockEntityState;
import org.bukkit.craftbukkit.v1_21_R6.entity.CraftLivingEntity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.util.BoundingBox;

public class CraftConduit
extends CraftBlockEntityState<TileEntityConduit>
implements Conduit {
    public CraftConduit(World world, TileEntityConduit blockEntity) {
        super(world, blockEntity);
    }

    protected CraftConduit(CraftConduit state, Location location) {
        super(state, location);
    }

    @Override
    public CraftConduit copy() {
        return new CraftConduit(this, null);
    }

    @Override
    public CraftConduit copy(Location location) {
        return new CraftConduit(this, location);
    }

    public boolean isActive() {
        this.ensureNoWorldGeneration();
        TileEntityConduit conduit = (TileEntityConduit)this.getBlockEntityFromWorld();
        return conduit != null && conduit.c();
    }

    public boolean isHunting() {
        this.ensureNoWorldGeneration();
        TileEntityConduit conduit = (TileEntityConduit)this.getBlockEntityFromWorld();
        return conduit != null && conduit.d();
    }

    public Collection<Block> getFrameBlocks() {
        this.ensureNoWorldGeneration();
        ArrayList<Block> blocks = new ArrayList<Block>();
        TileEntityConduit conduit = (TileEntityConduit)this.getBlockEntityFromWorld();
        if (conduit != null) {
            for (BlockPosition position : conduit.l) {
                blocks.add(CraftBlock.at(this.getWorldHandle(), position));
            }
        }
        return blocks;
    }

    public int getFrameBlockCount() {
        this.ensureNoWorldGeneration();
        TileEntityConduit conduit = (TileEntityConduit)this.getBlockEntityFromWorld();
        return conduit != null ? conduit.l.size() : 0;
    }

    public int getRange() {
        this.ensureNoWorldGeneration();
        TileEntityConduit conduit = (TileEntityConduit)this.getBlockEntityFromWorld();
        return conduit != null ? TileEntityConduit.getRange(conduit.l, this.world.getHandle()) : 0;
    }

    public boolean setTarget(LivingEntity target) {
        TileEntityConduit conduit = (TileEntityConduit)this.getBlockEntityFromWorld();
        if (conduit == null) {
            return false;
        }
        EntityReference<EntityLiving> currentTarget = conduit.m;
        if (target == null) {
            if (currentTarget == null) {
                return false;
            }
            conduit.m = null;
        } else {
            if (currentTarget != null && target.getUniqueId().equals(currentTarget.c())) {
                return false;
            }
            conduit.m = EntityReference.a(((CraftLivingEntity)target).getHandle());
        }
        TileEntityConduit.updateAndAttackTarget(conduit.j().getMinecraftWorld(), this.getPosition(), this.data, conduit, conduit.l.size() >= 42, false);
        return true;
    }

    public LivingEntity getTarget() {
        TileEntityConduit conduit = (TileEntityConduit)this.getBlockEntityFromWorld();
        if (conduit == null) {
            return null;
        }
        EntityLiving nmsEntity = EntityReference.a(conduit.m, this.getWorldHandle().getMinecraftWorld(), EntityLiving.class);
        return nmsEntity == null ? null : nmsEntity.getBukkitLivingEntity();
    }

    public boolean hasTarget() {
        TileEntityConduit conduit = (TileEntityConduit)this.getBlockEntityFromWorld();
        if (conduit == null) {
            return false;
        }
        EntityLiving destroyTarget = EntityReference.a(conduit.m, this.getWorldHandle().getMinecraftWorld(), EntityLiving.class);
        return destroyTarget != null && destroyTarget.bX();
    }

    public BoundingBox getHuntingArea() {
        AxisAlignedBB bounds = TileEntityConduit.a(this.getPosition());
        return new BoundingBox(bounds.a, bounds.b, bounds.c, bounds.d, bounds.e, bounds.f);
    }
}

