/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R6.block;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import io.papermc.paper.util.MCUtil;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.item.crafting.IRecipe;
import net.minecraft.world.item.crafting.RecipeCooking;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.block.BlockFurnace;
import net.minecraft.world.level.block.entity.TileEntityFurnace;
import net.minecraft.world.level.block.state.IBlockData;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.NamespacedKey;
import org.bukkit.World;
import org.bukkit.block.Furnace;
import org.bukkit.craftbukkit.v1_21_R6.block.CraftContainer;
import org.bukkit.craftbukkit.v1_21_R6.inventory.CraftInventoryFurnace;
import org.bukkit.craftbukkit.v1_21_R6.util.CraftNamespacedKey;
import org.bukkit.inventory.CookingRecipe;
import org.bukkit.inventory.FurnaceInventory;
import org.bukkit.inventory.Recipe;

public abstract class CraftFurnace<T extends TileEntityFurnace>
extends CraftContainer<T>
implements Furnace {
    public CraftFurnace(World world, T blockEntity) {
        super(world, blockEntity);
    }

    protected CraftFurnace(CraftFurnace<T> state, Location location) {
        super(state, location);
    }

    public FurnaceInventory getSnapshotInventory() {
        return new CraftInventoryFurnace((TileEntityFurnace)this.getSnapshot());
    }

    public FurnaceInventory getInventory() {
        if (!this.isPlaced()) {
            return this.getSnapshotInventory();
        }
        return new CraftInventoryFurnace((TileEntityFurnace)this.getBlockEntity());
    }

    public short getBurnTime() {
        return (short)((TileEntityFurnace)this.getSnapshot()).y;
    }

    public void setBurnTime(short burnTime) {
        ((TileEntityFurnace)this.getSnapshot()).y = burnTime;
        this.data = (IBlockData)this.data.c(BlockFurnace.b, burnTime > 0);
    }

    public short getCookTime() {
        return (short)((TileEntityFurnace)this.getSnapshot()).A;
    }

    public void setCookTime(short cookTime) {
        ((TileEntityFurnace)this.getSnapshot()).A = cookTime;
    }

    public int getCookTimeTotal() {
        return ((TileEntityFurnace)this.getSnapshot()).B;
    }

    public void setCookTimeTotal(int cookTimeTotal) {
        ((TileEntityFurnace)this.getSnapshot()).B = cookTimeTotal;
    }

    public Map<CookingRecipe<?>, Integer> getRecipesUsed() {
        ImmutableMap.Builder recipesUsed = ImmutableMap.builder();
        ((TileEntityFurnace)this.getSnapshot()).C.reference2IntEntrySet().fastForEach(entrySet -> {
            Recipe recipe = Bukkit.getRecipe((NamespacedKey)CraftNamespacedKey.fromMinecraft(((ResourceKey)entrySet.getKey()).a()));
            if (recipe instanceof CookingRecipe) {
                CookingRecipe cookingRecipe = (CookingRecipe)recipe;
                recipesUsed.put((Object)cookingRecipe, (Object)entrySet.getValue());
            }
        });
        return recipesUsed.build();
    }

    @Override
    public abstract CraftFurnace<T> copy();

    @Override
    public abstract CraftFurnace<T> copy(Location var1);

    public double getCookSpeedMultiplier() {
        return ((TileEntityFurnace)this.getSnapshot()).cookSpeedMultiplier;
    }

    public void setCookSpeedMultiplier(double multiplier) {
        Preconditions.checkArgument((multiplier >= 0.0 ? 1 : 0) != 0, (Object)"Furnace speed multiplier cannot be negative");
        Preconditions.checkArgument((multiplier <= 200.0 ? 1 : 0) != 0, (Object)"Furnace speed multiplier cannot more than 200");
        TileEntityFurnace snapshot = (TileEntityFurnace)this.getSnapshot();
        snapshot.cookSpeedMultiplier = multiplier;
        snapshot.B = TileEntityFurnace.getTotalCookTime(this.isPlaced() ? this.world.getHandle() : null, snapshot, snapshot.recipeType, snapshot.cookSpeedMultiplier);
    }

    public int getRecipeUsedCount(NamespacedKey furnaceRecipe) {
        return ((TileEntityFurnace)this.getSnapshot()).C.getInt(MCUtil.toResourceKey(Registries.bD, furnaceRecipe));
    }

    public boolean hasRecipeUsedCount(NamespacedKey furnaceRecipe) {
        return ((TileEntityFurnace)this.getSnapshot()).C.containsKey(MCUtil.toResourceKey(Registries.bD, furnaceRecipe));
    }

    public void setRecipeUsedCount(CookingRecipe<?> furnaceRecipe, int count) {
        ResourceKey<IRecipe<?>> location = MCUtil.toResourceKey(Registries.bD, furnaceRecipe.getKey());
        Optional<RecipeHolder<?>> nmsRecipe = (this.isPlaced() ? this.world.getHandle().v() : MinecraftServer.getServer().aN()).b(location);
        Preconditions.checkArgument((nmsRecipe.isPresent() && nmsRecipe.get().b() instanceof RecipeCooking ? 1 : 0) != 0, (Object)(String.valueOf(furnaceRecipe.getKey()) + " is not recognized as a valid and registered furnace recipe"));
        if (count > 0) {
            ((TileEntityFurnace)this.getSnapshot()).C.put(location, count);
        } else {
            ((TileEntityFurnace)this.getSnapshot()).C.removeInt(location);
        }
    }

    public void setRecipesUsed(Map<CookingRecipe<?>, Integer> recipesUsed) {
        ((TileEntityFurnace)this.getSnapshot()).C.clear();
        recipesUsed.forEach((recipe, integer) -> {
            if (integer != null) {
                this.setRecipeUsedCount((CookingRecipe<?>)recipe, (int)integer);
            }
        });
    }
}

