/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R6.block.impl;

import com.google.common.base.Preconditions;
import io.papermc.paper.annotation.GeneratedClass;
import net.minecraft.world.level.block.BlockBanner;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockStateInteger;
import net.minecraft.world.level.block.state.properties.RotationSegment;
import org.bukkit.block.BlockFace;
import org.bukkit.block.data.Rotatable;
import org.bukkit.craftbukkit.v1_21_R6.block.data.CraftBlockData;
import org.bukkit.util.Vector;
import org.jspecify.annotations.NullMarked;

@NullMarked
@GeneratedClass
public class CraftBanner
extends CraftBlockData
implements Rotatable {
    private static final BlockStateInteger ROTATION = BlockBanner.b;

    public CraftBanner(IBlockData state) {
        super(state);
    }

    public BlockFace getRotation() {
        return CraftBlockData.ROTATION_CYCLE[this.get(ROTATION)];
    }

    public void setRotation(BlockFace blockFace) {
        Preconditions.checkArgument((blockFace != null ? 1 : 0) != 0, (Object)"blockFace cannot be null!");
        Preconditions.checkArgument((blockFace != BlockFace.SELF && blockFace.getModY() == 0 ? 1 : 0) != 0, (Object)"Invalid face, only horizontal face are allowed for this property!");
        Vector dir = blockFace.getDirection();
        float angle = (float)(-Math.toDegrees(Math.atan2(dir.getX(), dir.getZ())));
        this.set(ROTATION, RotationSegment.a(angle));
    }
}

