/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R6.block.impl;

import com.google.common.base.Preconditions;
import io.papermc.paper.annotation.GeneratedClass;
import java.util.Set;
import net.minecraft.core.EnumDirection;
import net.minecraft.world.level.block.BlockDoor;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockPropertyDoorHinge;
import net.minecraft.world.level.block.state.properties.BlockPropertyDoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.BlockStateBoolean;
import net.minecraft.world.level.block.state.properties.BlockStateEnum;
import org.bukkit.block.BlockFace;
import org.bukkit.block.data.Bisected;
import org.bukkit.block.data.type.Door;
import org.bukkit.craftbukkit.v1_21_R6.block.data.CraftBlockData;
import org.jspecify.annotations.NullMarked;

@NullMarked
@GeneratedClass
public class CraftDoor
extends CraftBlockData
implements Door {
    private static final BlockStateEnum<EnumDirection> FACING = BlockDoor.b;
    private static final BlockStateEnum<BlockPropertyDoubleBlockHalf> HALF = BlockDoor.c;
    private static final BlockStateEnum<BlockPropertyDoorHinge> HINGE = BlockDoor.d;
    private static final BlockStateBoolean OPEN = BlockDoor.e;
    private static final BlockStateBoolean POWERED = BlockDoor.f;

    public CraftDoor(IBlockData state) {
        super(state);
    }

    public BlockFace getFacing() {
        return this.get(FACING, BlockFace.class);
    }

    public void setFacing(BlockFace blockFace) {
        Preconditions.checkArgument((blockFace != null ? 1 : 0) != 0, (Object)"blockFace cannot be null!");
        Preconditions.checkArgument((blockFace.isCartesian() && blockFace.getModY() == 0 ? 1 : 0) != 0, (Object)"Invalid face, only cartesian horizontal face are allowed for this property!");
        this.set(FACING, blockFace);
    }

    public Set<BlockFace> getFaces() {
        return this.getValues(FACING, BlockFace.class);
    }

    public Bisected.Half getHalf() {
        return this.get(HALF, Bisected.Half.class);
    }

    public void setHalf(Bisected.Half half) {
        Preconditions.checkArgument((half != null ? 1 : 0) != 0, (Object)"half cannot be null!");
        this.set(HALF, half);
    }

    public Door.Hinge getHinge() {
        return this.get(HINGE, Door.Hinge.class);
    }

    public void setHinge(Door.Hinge hinge) {
        Preconditions.checkArgument((hinge != null ? 1 : 0) != 0, (Object)"hinge cannot be null!");
        this.set(HINGE, hinge);
    }

    public boolean isOpen() {
        return this.get(OPEN);
    }

    public void setOpen(boolean open) {
        this.set(OPEN, open);
    }

    public boolean isPowered() {
        return this.get(POWERED);
    }

    public void setPowered(boolean powered) {
        this.set(POWERED, powered);
    }
}

