/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R6.block.impl;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import io.papermc.paper.annotation.GeneratedClass;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.core.EnumDirection;
import net.minecraft.world.level.block.BlockFire;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockStateBoolean;
import net.minecraft.world.level.block.state.properties.BlockStateInteger;
import org.bukkit.block.BlockFace;
import org.bukkit.block.data.type.Fire;
import org.bukkit.craftbukkit.v1_21_R6.block.CraftBlock;
import org.bukkit.craftbukkit.v1_21_R6.block.data.CraftBlockData;
import org.jspecify.annotations.NullMarked;

@NullMarked
@GeneratedClass
public class CraftFire
extends CraftBlockData
implements Fire {
    private static final BlockStateInteger AGE = BlockFire.d;
    private static final Map<BlockFace, BlockStateBoolean> PROPERTY_BY_DIRECTION = BlockFire.D.entrySet().stream().collect(Collectors.toMap(entry -> CraftBlock.notchToBlockFace((EnumDirection)entry.getKey()), entry -> (BlockStateBoolean)entry.getValue()));

    public CraftFire(IBlockData state) {
        super(state);
    }

    public int getAge() {
        return this.get(AGE);
    }

    public void setAge(int age) {
        this.set(AGE, age);
    }

    public int getMaximumAge() {
        return CraftFire.AGE.c;
    }

    public boolean hasFace(BlockFace blockFace) {
        Preconditions.checkArgument((blockFace != null ? 1 : 0) != 0, (Object)"blockFace cannot be null!");
        BlockStateBoolean property = PROPERTY_BY_DIRECTION.get(blockFace);
        Preconditions.checkArgument((property != null ? 1 : 0) != 0, (String)"Invalid blockFace, only %s are allowed!", (Object)PROPERTY_BY_DIRECTION.keySet().stream().map(Enum::name).collect(Collectors.joining(", ")));
        return this.get(property);
    }

    public void setFace(BlockFace blockFace, boolean face) {
        Preconditions.checkArgument((blockFace != null ? 1 : 0) != 0, (Object)"blockFace cannot be null!");
        BlockStateBoolean property = PROPERTY_BY_DIRECTION.get(blockFace);
        Preconditions.checkArgument((property != null ? 1 : 0) != 0, (String)"Invalid blockFace, only %s are allowed!", (Object)PROPERTY_BY_DIRECTION.keySet().stream().map(Enum::name).collect(Collectors.joining(", ")));
        this.set(property, face);
    }

    public Set<BlockFace> getFaces() {
        ImmutableSet.Builder faces = ImmutableSet.builder();
        for (Map.Entry<BlockFace, BlockStateBoolean> entry : PROPERTY_BY_DIRECTION.entrySet()) {
            if (!((Boolean)this.get(entry.getValue())).booleanValue()) continue;
            faces.add((Object)entry.getKey());
        }
        return faces.build();
    }

    public Set<BlockFace> getAllowedFaces() {
        return Collections.unmodifiableSet(PROPERTY_BY_DIRECTION.keySet());
    }
}

