/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R6.block.impl;

import com.google.common.base.Preconditions;
import io.papermc.paper.annotation.GeneratedClass;
import java.util.Set;
import net.minecraft.core.EnumDirection;
import net.minecraft.world.level.block.BlockDiodeAbstract;
import net.minecraft.world.level.block.BlockFacingHorizontal;
import net.minecraft.world.level.block.BlockRepeater;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockStateBoolean;
import net.minecraft.world.level.block.state.properties.BlockStateEnum;
import net.minecraft.world.level.block.state.properties.BlockStateInteger;
import org.bukkit.block.BlockFace;
import org.bukkit.block.data.type.Repeater;
import org.bukkit.craftbukkit.v1_21_R6.block.data.CraftBlockData;
import org.jspecify.annotations.NullMarked;

@NullMarked
@GeneratedClass
public class CraftRepeater
extends CraftBlockData
implements Repeater {
    private static final BlockStateInteger DELAY = BlockRepeater.d;
    private static final BlockStateEnum<EnumDirection> FACING = BlockFacingHorizontal.f;
    private static final BlockStateBoolean LOCKED = BlockRepeater.b;
    private static final BlockStateBoolean POWERED = BlockDiodeAbstract.c;

    public CraftRepeater(IBlockData state) {
        super(state);
    }

    public int getDelay() {
        return this.get(DELAY);
    }

    public void setDelay(int delay) {
        this.set(DELAY, delay);
    }

    public int getMinimumDelay() {
        return CraftRepeater.DELAY.b;
    }

    public int getMaximumDelay() {
        return CraftRepeater.DELAY.c;
    }

    public BlockFace getFacing() {
        return this.get(FACING, BlockFace.class);
    }

    public void setFacing(BlockFace blockFace) {
        Preconditions.checkArgument((blockFace != null ? 1 : 0) != 0, (Object)"blockFace cannot be null!");
        Preconditions.checkArgument((blockFace.isCartesian() && blockFace.getModY() == 0 ? 1 : 0) != 0, (Object)"Invalid face, only cartesian horizontal face are allowed for this property!");
        this.set(FACING, blockFace);
    }

    public Set<BlockFace> getFaces() {
        return this.getValues(FACING, BlockFace.class);
    }

    public boolean isLocked() {
        return this.get(LOCKED);
    }

    public void setLocked(boolean locked) {
        this.set(LOCKED, locked);
    }

    public boolean isPowered() {
        return this.get(POWERED);
    }

    public void setPowered(boolean powered) {
        this.set(POWERED, powered);
    }
}

