/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R6.block.impl;

import com.google.common.base.Preconditions;
import io.papermc.paper.annotation.GeneratedClass;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.core.EnumDirection;
import net.minecraft.world.level.block.BlockCobbleWall;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockPropertyWallHeight;
import net.minecraft.world.level.block.state.properties.BlockStateBoolean;
import net.minecraft.world.level.block.state.properties.BlockStateEnum;
import org.bukkit.block.BlockFace;
import org.bukkit.block.data.type.Wall;
import org.bukkit.craftbukkit.v1_21_R6.block.CraftBlock;
import org.bukkit.craftbukkit.v1_21_R6.block.data.CraftBlockData;
import org.jspecify.annotations.NullMarked;

@NullMarked
@GeneratedClass
public class CraftWall
extends CraftBlockData
implements Wall {
    private static final BlockStateBoolean UP = BlockCobbleWall.b;
    private static final BlockStateBoolean WATERLOGGED = BlockCobbleWall.h;
    private static final Map<BlockFace, BlockStateEnum<BlockPropertyWallHeight>> PROPERTY_BY_DIRECTION = BlockCobbleWall.g.entrySet().stream().collect(Collectors.toMap(entry -> CraftBlock.notchToBlockFace((EnumDirection)entry.getKey()), entry -> (BlockStateEnum)entry.getValue()));

    public CraftWall(IBlockData state) {
        super(state);
    }

    public boolean isUp() {
        return this.get(UP);
    }

    public void setUp(boolean up) {
        this.set(UP, up);
    }

    public boolean isWaterlogged() {
        return this.get(WATERLOGGED);
    }

    public void setWaterlogged(boolean waterlogged) {
        this.set(WATERLOGGED, waterlogged);
    }

    public Wall.Height getHeight(BlockFace blockFace) {
        Preconditions.checkArgument((blockFace != null ? 1 : 0) != 0, (Object)"blockFace cannot be null!");
        BlockStateEnum<BlockPropertyWallHeight> property = PROPERTY_BY_DIRECTION.get(blockFace);
        Preconditions.checkArgument((property != null ? 1 : 0) != 0, (String)"Invalid blockFace, only %s are allowed!", (Object)PROPERTY_BY_DIRECTION.keySet().stream().map(Enum::name).collect(Collectors.joining(", ")));
        return this.get(property, Wall.Height.class);
    }

    public void setHeight(BlockFace blockFace, Wall.Height height) {
        Preconditions.checkArgument((blockFace != null ? 1 : 0) != 0, (Object)"blockFace cannot be null!");
        Preconditions.checkArgument((height != null ? 1 : 0) != 0, (Object)"height cannot be null!");
        BlockStateEnum<BlockPropertyWallHeight> property = PROPERTY_BY_DIRECTION.get(blockFace);
        Preconditions.checkArgument((property != null ? 1 : 0) != 0, (String)"Invalid blockFace, only %s are allowed!", (Object)PROPERTY_BY_DIRECTION.keySet().stream().map(Enum::name).collect(Collectors.joining(", ")));
        this.set(property, height);
    }
}

