/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R6.block.impl;

import com.google.common.base.Preconditions;
import io.papermc.paper.annotation.GeneratedClass;
import java.util.Set;
import net.minecraft.core.EnumDirection;
import net.minecraft.world.level.block.BlockStairs;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockPropertyHalf;
import net.minecraft.world.level.block.state.properties.BlockPropertyStairsShape;
import net.minecraft.world.level.block.state.properties.BlockStateBoolean;
import net.minecraft.world.level.block.state.properties.BlockStateEnum;
import org.bukkit.block.BlockFace;
import org.bukkit.block.data.Bisected;
import org.bukkit.block.data.type.Stairs;
import org.bukkit.craftbukkit.v1_21_R6.block.data.CraftBlockData;
import org.jspecify.annotations.NullMarked;

@NullMarked
@GeneratedClass
public class CraftWeatheringCopperStair
extends CraftBlockData
implements Stairs {
    private static final BlockStateEnum<EnumDirection> FACING = BlockStairs.b;
    private static final BlockStateEnum<BlockPropertyHalf> HALF = BlockStairs.c;
    private static final BlockStateEnum<BlockPropertyStairsShape> SHAPE = BlockStairs.d;
    private static final BlockStateBoolean WATERLOGGED = BlockStairs.e;

    public CraftWeatheringCopperStair(IBlockData state) {
        super(state);
    }

    public BlockFace getFacing() {
        return this.get(FACING, BlockFace.class);
    }

    public void setFacing(BlockFace blockFace) {
        Preconditions.checkArgument((blockFace != null ? 1 : 0) != 0, (Object)"blockFace cannot be null!");
        Preconditions.checkArgument((blockFace.isCartesian() && blockFace.getModY() == 0 ? 1 : 0) != 0, (Object)"Invalid face, only cartesian horizontal face are allowed for this property!");
        this.set(FACING, blockFace);
    }

    public Set<BlockFace> getFaces() {
        return this.getValues(FACING, BlockFace.class);
    }

    public Bisected.Half getHalf() {
        return this.get(HALF, Bisected.Half.class);
    }

    public void setHalf(Bisected.Half half) {
        Preconditions.checkArgument((half != null ? 1 : 0) != 0, (Object)"half cannot be null!");
        this.set(HALF, half);
    }

    public Stairs.Shape getShape() {
        return this.get(SHAPE, Stairs.Shape.class);
    }

    public void setShape(Stairs.Shape shape) {
        Preconditions.checkArgument((shape != null ? 1 : 0) != 0, (Object)"shape cannot be null!");
        this.set(SHAPE, shape);
    }

    public boolean isWaterlogged() {
        return this.get(WATERLOGGED);
    }

    public void setWaterlogged(boolean waterlogged) {
        this.set(WATERLOGGED, waterlogged);
    }
}

