/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R6.boss;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.network.protocol.game.PacketPlayOutBoss;
import net.minecraft.server.level.BossBattleServer;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.world.BossBattle;
import org.bukkit.boss.BarColor;
import org.bukkit.boss.BarFlag;
import org.bukkit.boss.BarStyle;
import org.bukkit.boss.BossBar;
import org.bukkit.craftbukkit.v1_21_R6.entity.CraftPlayer;
import org.bukkit.craftbukkit.v1_21_R6.util.CraftChatMessage;
import org.bukkit.entity.Player;

public class CraftBossBar
implements BossBar {
    private final BossBattleServer handle;
    private Map<BarFlag, FlagContainer> flags;

    public CraftBossBar(String title, BarColor color, BarStyle style, BarFlag ... flags) {
        this.handle = new BossBattleServer(CraftChatMessage.fromString(title, true)[0], this.convertColor(color), this.convertStyle(style));
        this.initialize();
        for (BarFlag flag : flags) {
            this.addFlag(flag);
        }
        this.setColor(color);
        this.setStyle(style);
    }

    public CraftBossBar(BossBattleServer bossBattleServer) {
        this.handle = bossBattleServer;
        this.initialize();
    }

    private void initialize() {
        this.flags = new HashMap<BarFlag, FlagContainer>();
        this.flags.put(BarFlag.DARKEN_SKY, new FlagContainer(this, this.handle::n, this.handle::a));
        this.flags.put(BarFlag.PLAY_BOSS_MUSIC, new FlagContainer(this, this.handle::o, this.handle::b));
        this.flags.put(BarFlag.CREATE_FOG, new FlagContainer(this, this.handle::p, this.handle::c));
    }

    private BarColor convertColor(BossBattle.BarColor color) {
        return BarColor.valueOf((String)color.name());
    }

    private BossBattle.BarColor convertColor(BarColor color) {
        return BossBattle.BarColor.valueOf(color.name());
    }

    private BossBattle.BarStyle convertStyle(BarStyle style) {
        return switch (style) {
            default -> throw new MatchException(null, null);
            case BarStyle.SOLID -> BossBattle.BarStyle.a;
            case BarStyle.SEGMENTED_6 -> BossBattle.BarStyle.b;
            case BarStyle.SEGMENTED_10 -> BossBattle.BarStyle.c;
            case BarStyle.SEGMENTED_12 -> BossBattle.BarStyle.d;
            case BarStyle.SEGMENTED_20 -> BossBattle.BarStyle.e;
        };
    }

    private BarStyle convertStyle(BossBattle.BarStyle style) {
        return switch (style) {
            default -> throw new MatchException(null, null);
            case BossBattle.BarStyle.a -> BarStyle.SOLID;
            case BossBattle.BarStyle.b -> BarStyle.SEGMENTED_6;
            case BossBattle.BarStyle.c -> BarStyle.SEGMENTED_10;
            case BossBattle.BarStyle.d -> BarStyle.SEGMENTED_12;
            case BossBattle.BarStyle.e -> BarStyle.SEGMENTED_20;
        };
    }

    public String getTitle() {
        return CraftChatMessage.fromComponent(this.handle.a);
    }

    public void setTitle(String title) {
        this.handle.a = CraftChatMessage.fromString(title, true)[0];
        this.handle.a(PacketPlayOutBoss::c);
    }

    public BarColor getColor() {
        return this.convertColor(this.handle.c);
    }

    public void setColor(BarColor color) {
        this.handle.c = this.convertColor(color);
        this.handle.a(PacketPlayOutBoss::d);
    }

    public BarStyle getStyle() {
        return this.convertStyle(this.handle.d);
    }

    public void setStyle(BarStyle style) {
        this.handle.d = this.convertStyle(style);
        this.handle.a(PacketPlayOutBoss::d);
    }

    public void addFlag(BarFlag flag) {
        FlagContainer flagContainer = this.flags.get(flag);
        if (flagContainer != null) {
            flagContainer.set.accept(true);
        }
    }

    public void removeFlag(BarFlag flag) {
        FlagContainer flagContainer = this.flags.get(flag);
        if (flagContainer != null) {
            flagContainer.set.accept(false);
        }
    }

    public boolean hasFlag(BarFlag flag) {
        FlagContainer flagContainer = this.flags.get(flag);
        if (flagContainer != null) {
            return flagContainer.get.get();
        }
        return false;
    }

    public void setProgress(double progress) {
        Preconditions.checkArgument((progress >= 0.0 && progress <= 1.0 ? 1 : 0) != 0, (String)"Progress must be between 0.0 and 1.0 (%s)", (Object)progress);
        this.handle.a((float)progress);
    }

    public double getProgress() {
        return this.handle.k();
    }

    public void addPlayer(Player player) {
        Preconditions.checkArgument((player != null ? 1 : 0) != 0, (Object)"player == null");
        Preconditions.checkArgument((((CraftPlayer)player).getHandle().g != null ? 1 : 0) != 0, (Object)"player is not fully connected (wait for PlayerJoinEvent)");
        this.handle.a(((CraftPlayer)player).getHandle());
    }

    public void removePlayer(Player player) {
        Preconditions.checkArgument((player != null ? 1 : 0) != 0, (Object)"player == null");
        this.handle.b(((CraftPlayer)player).getHandle());
    }

    public List<Player> getPlayers() {
        ImmutableList.Builder players = ImmutableList.builder();
        for (EntityPlayer p2 : this.handle.h()) {
            players.add((Object)p2.getBukkitEntity());
        }
        return players.build();
    }

    public void setVisible(boolean visible) {
        this.handle.d(visible);
    }

    public boolean isVisible() {
        return this.handle.j;
    }

    public void show() {
        this.handle.d(true);
    }

    public void hide() {
        this.handle.d(false);
    }

    public void removeAll() {
        for (Player player : this.getPlayers()) {
            this.removePlayer(player);
        }
    }

    public BossBattleServer getHandle() {
        return this.handle;
    }

    private final class FlagContainer {
        private final Supplier<Boolean> get;
        private final Consumer<Boolean> set;

        private FlagContainer(CraftBossBar craftBossBar, Supplier<Boolean> get, Consumer<Boolean> set) {
            this.get = get;
            this.set = set;
        }
    }
}

