/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R6.command;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.mojang.brigadier.ParseResults;
import com.mojang.brigadier.tree.CommandNode;
import io.papermc.paper.commands.FeedbackForwardingSender;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.commands.CommandDispatcher;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.WorldServer;
import org.bukkit.Location;
import org.bukkit.command.BlockCommandSender;
import org.bukkit.command.CommandSender;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.command.ProxiedCommandSender;
import org.bukkit.command.RemoteConsoleCommandSender;
import org.bukkit.command.defaults.BukkitCommand;
import org.bukkit.craftbukkit.v1_21_R6.CraftServer;
import org.bukkit.craftbukkit.v1_21_R6.command.CraftBlockCommandSender;
import org.bukkit.craftbukkit.v1_21_R6.command.CraftRemoteConsoleCommandSender;
import org.bukkit.craftbukkit.v1_21_R6.command.ProxiedNativeCommandSender;
import org.bukkit.craftbukkit.v1_21_R6.entity.CraftEntity;
import org.bukkit.craftbukkit.v1_21_R6.entity.CraftMinecartCommand;
import org.bukkit.craftbukkit.v1_21_R6.entity.CraftPlayer;
import org.bukkit.entity.minecart.CommandMinecart;

public class VanillaCommandWrapper
extends BukkitCommand {
    public final CommandNode<CommandListenerWrapper> vanillaCommand;
    public final String helpCommandNamespace;

    public VanillaCommandWrapper(String name, String description, String usageMessage, List<String> aliases, CommandNode<CommandListenerWrapper> vanillaCommand, String helpCommandNamespace) {
        super(name, description, usageMessage, aliases);
        this.vanillaCommand = vanillaCommand;
        this.helpCommandNamespace = helpCommandNamespace;
    }

    CommandDispatcher commands() {
        return MinecraftServer.getServer().aJ();
    }

    public VanillaCommandWrapper(CommandNode<CommandListenerWrapper> vanillaCommand) {
        super(vanillaCommand.getName(), "A Mojang provided command.", vanillaCommand.getUsageText(), Collections.emptyList());
        this.vanillaCommand = vanillaCommand;
        this.setPermission(VanillaCommandWrapper.getPermission(vanillaCommand));
        this.helpCommandNamespace = "Minecraft";
    }

    public boolean execute(CommandSender sender, String commandLabel, String[] args) {
        if (!this.testPermission(sender)) {
            return true;
        }
        CommandListenerWrapper source = VanillaCommandWrapper.getListener(sender);
        this.commands().a(source, this.toDispatcher(args, this.getName()));
        return true;
    }

    public List<String> tabComplete(CommandSender sender, String alias, String[] args, Location location) throws IllegalArgumentException {
        Preconditions.checkArgument((sender != null ? 1 : 0) != 0, (Object)"Sender cannot be null");
        Preconditions.checkArgument((args != null ? 1 : 0) != 0, (Object)"Arguments cannot be null");
        Preconditions.checkArgument((alias != null ? 1 : 0) != 0, (Object)"Alias cannot be null");
        CommandListenerWrapper source = VanillaCommandWrapper.getListener(sender);
        ParseResults<CommandListenerWrapper> parsed = this.commands().a().parse(this.toDispatcher(args, this.getName()), source);
        ArrayList<String> results = new ArrayList<String>();
        this.commands().a().getCompletionSuggestions(parsed).thenAccept(suggestions -> suggestions.getList().forEach(s2 -> results.add(s2.getText())));
        return results;
    }

    public static CommandListenerWrapper getListener(CommandSender sender) {
        if (sender instanceof CraftEntity) {
            CraftEntity entity = (CraftEntity)sender;
            if (sender instanceof CommandMinecart) {
                return ((CraftMinecartCommand)sender).getHandle().e().a(((CraftMinecartCommand)sender).getHandle().e().d());
            }
            if (sender instanceof CraftPlayer) {
                CraftPlayer player = (CraftPlayer)sender;
                return player.getHandle().C();
            }
            return entity.getHandle().d((WorldServer)entity.getHandle().an());
        }
        if (sender instanceof BlockCommandSender) {
            return ((CraftBlockCommandSender)sender).getWrapper();
        }
        if (sender instanceof RemoteConsoleCommandSender) {
            return ((CraftRemoteConsoleCommandSender)sender).getListener().g();
        }
        if (sender instanceof ConsoleCommandSender) {
            return ((CraftServer)sender.getServer()).getServer().aK();
        }
        if (sender instanceof ProxiedCommandSender) {
            return ((ProxiedNativeCommandSender)sender).getHandle();
        }
        if (sender instanceof FeedbackForwardingSender) {
            FeedbackForwardingSender feedback = (FeedbackForwardingSender)sender;
            return feedback.asVanilla();
        }
        throw new IllegalArgumentException("Cannot make " + String.valueOf(sender) + " a vanilla command listener");
    }

    public static String getPermission(CommandNode<CommandListenerWrapper> vanillaCommand) {
        while (vanillaCommand.getRedirect() != null) {
            vanillaCommand = vanillaCommand.getRedirect();
        }
        String commandName = vanillaCommand.getName();
        return "minecraft.command." + VanillaCommandWrapper.stripDefaultNamespace(commandName);
    }

    private static String stripDefaultNamespace(String maybeNamespaced) {
        String prefix = "minecraft:";
        if (maybeNamespaced.startsWith("minecraft:")) {
            return maybeNamespaced.substring("minecraft:".length());
        }
        return maybeNamespaced;
    }

    private String toDispatcher(String[] args, String name) {
        return name + (String)(args.length > 0 ? " " + Joiner.on((char)' ').join((Object[])args) : "");
    }

    public boolean canBeOverriden() {
        return true;
    }

    public boolean isRegistered() {
        return true;
    }
}

