/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R6.damage;

import java.util.Objects;
import net.minecraft.Optionull;
import net.minecraft.core.Holder;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.craftbukkit.v1_21_R6.damage.CraftDamageType;
import org.bukkit.craftbukkit.v1_21_R6.entity.CraftEntity;
import org.bukkit.craftbukkit.v1_21_R6.util.CraftLocation;
import org.bukkit.entity.Entity;

public class CraftDamageSource
implements org.bukkit.damage.DamageSource {
    private final DamageSource damageSource;
    private final org.bukkit.damage.DamageType damageType;

    public CraftDamageSource(DamageSource damageSource) {
        this.damageSource = damageSource;
        this.damageType = CraftDamageType.minecraftHolderToBukkit(damageSource.l());
    }

    public DamageSource getHandle() {
        return this.damageSource;
    }

    public World getCausingEntityWorld() {
        return Optionull.a(this.getCausingEntity(), Entity::getWorld);
    }

    public org.bukkit.damage.DamageType getDamageType() {
        return this.damageType;
    }

    public Entity getCausingEntity() {
        return Optionull.a(this.getHandle().d(), net.minecraft.world.entity.Entity::getBukkitEntity);
    }

    public Entity getDirectEntity() {
        return Optionull.a(this.getHandle().c(), net.minecraft.world.entity.Entity::getBukkitEntity);
    }

    public Location getDamageLocation() {
        return Optionull.a(this.getHandle().j(), sourcePos -> CraftLocation.toBukkit(sourcePos, this.getCausingEntityWorld()));
    }

    public Location getSourceLocation() {
        return Optionull.a(this.getHandle().i(), sourcePos -> CraftLocation.toBukkit(sourcePos, this.getCausingEntityWorld()));
    }

    public boolean isIndirect() {
        return !this.getHandle().b();
    }

    public float getFoodExhaustion() {
        return this.getHandle().a();
    }

    public boolean scalesWithDifficulty() {
        return this.getHandle().g();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof org.bukkit.damage.DamageSource)) {
            return false;
        }
        org.bukkit.damage.DamageSource other = (org.bukkit.damage.DamageSource)obj;
        return Objects.equals(this.getDamageType(), other.getDamageType()) && Objects.equals(this.getCausingEntity(), other.getCausingEntity()) && Objects.equals(this.getDirectEntity(), other.getDirectEntity()) && Objects.equals(this.getDamageLocation(), other.getDamageLocation());
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + this.damageType.hashCode();
        result = 31 * result + Objects.hashCode(this.getCausingEntity());
        result = 31 * result + Objects.hashCode(this.getDirectEntity());
        result = 31 * result + Objects.hashCode(this.getDamageLocation());
        return result;
    }

    public String toString() {
        return "DamageSource{damageType=" + String.valueOf(this.getDamageType()) + ", causingEntity=" + String.valueOf(this.getCausingEntity()) + ", directEntity=" + String.valueOf(this.getDirectEntity()) + ", damageLocation=" + String.valueOf(this.getDamageLocation()) + "}";
    }

    public static org.bukkit.damage.DamageSource buildFromBukkit(org.bukkit.damage.DamageType damageType, Entity causingEntity, Entity directEntity, Location damageLocation) {
        Holder<DamageType> holderDamageType = CraftDamageType.bukkitToMinecraftHolder(damageType);
        net.minecraft.world.entity.Entity nmsCausingEntity = null;
        if (causingEntity instanceof CraftEntity) {
            CraftEntity craftCausingEntity = (CraftEntity)causingEntity;
            nmsCausingEntity = craftCausingEntity.getHandle();
        }
        net.minecraft.world.entity.Entity nmsDirectEntity = null;
        if (directEntity instanceof CraftEntity) {
            CraftEntity craftDirectEntity = (CraftEntity)directEntity;
            nmsDirectEntity = craftDirectEntity.getHandle();
        }
        Vec3D sourcePos = damageLocation == null ? null : CraftLocation.toVec3(damageLocation);
        return new CraftDamageSource(new DamageSource(holderDamageType, nmsDirectEntity, nmsCausingEntity, sourcePos));
    }
}

