/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R6.entity;

import io.papermc.paper.entity.PaperLeashable;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.vehicle.AbstractBoat;
import org.bukkit.Material;
import org.bukkit.TreeSpecies;
import org.bukkit.craftbukkit.v1_21_R6.CraftServer;
import org.bukkit.craftbukkit.v1_21_R6.entity.CraftVehicle;
import org.bukkit.craftbukkit.v1_21_R6.util.CraftMagicNumbers;
import org.bukkit.entity.Boat;

public abstract class CraftBoat
extends CraftVehicle
implements Boat,
PaperLeashable {
    public CraftBoat(CraftServer server, AbstractBoat entity) {
        super(server, entity);
    }

    @Override
    public AbstractBoat getHandle() {
        return (AbstractBoat)this.entity;
    }

    public TreeSpecies getWoodType() {
        return CraftBoat.getTreeSpecies(this.getHandle().ax());
    }

    public void setWoodType(TreeSpecies species) {
        throw new UnsupportedOperationException("Not supported - you must spawn a new entity to change boat type.");
    }

    public Boat.Type getBoatType() {
        return CraftBoat.boatTypeFromNms(this.getHandle().ax());
    }

    public void setBoatType(Boat.Type type) {
        throw new UnsupportedOperationException("Not supported - you must spawn a new entity to change boat type.");
    }

    public double getMaxSpeed() {
        return this.getHandle().maxSpeed;
    }

    public void setMaxSpeed(double speed) {
        if (speed >= 0.0) {
            this.getHandle().maxSpeed = speed;
        }
    }

    public double getOccupiedDeceleration() {
        return this.getHandle().occupiedDeceleration;
    }

    public void setOccupiedDeceleration(double speed) {
        if (speed >= 0.0) {
            this.getHandle().occupiedDeceleration = speed;
        }
    }

    public double getUnoccupiedDeceleration() {
        return this.getHandle().unoccupiedDeceleration;
    }

    public void setUnoccupiedDeceleration(double speed) {
        this.getHandle().unoccupiedDeceleration = speed;
    }

    public boolean getWorkOnLand() {
        return this.getHandle().landBoats;
    }

    public void setWorkOnLand(boolean workOnLand) {
        this.getHandle().landBoats = workOnLand;
    }

    public Material getBoatMaterial() {
        return CraftMagicNumbers.getMaterial(this.getHandle().p());
    }

    public Boat.Status getStatus() {
        AbstractBoat handle = this.getHandle();
        if (handle.aY == null) {
            if (handle.valid) {
                return CraftBoat.boatStatusFromNms(handle.K());
            }
            return Boat.Status.NOT_IN_WORLD;
        }
        return CraftBoat.boatStatusFromNms(this.getHandle().aY);
    }

    public static Boat.Type boatTypeFromNms(EntityTypes<?> boatType) {
        if (boatType == EntityTypes.aL || boatType == EntityTypes.aM) {
            return Boat.Type.OAK;
        }
        if (boatType == EntityTypes.o || boatType == EntityTypes.p) {
            return Boat.Type.BIRCH;
        }
        if (boatType == EntityTypes.c || boatType == EntityTypes.d) {
            return Boat.Type.ACACIA;
        }
        if (boatType == EntityTypes.y || boatType == EntityTypes.z) {
            return Boat.Type.CHERRY;
        }
        if (boatType == EntityTypes.ax || boatType == EntityTypes.ay) {
            return Boat.Type.JUNGLE;
        }
        if (boatType == EntityTypes.bu || boatType == EntityTypes.bv) {
            return Boat.Type.SPRUCE;
        }
        if (boatType == EntityTypes.I || boatType == EntityTypes.J) {
            return Boat.Type.DARK_OAK;
        }
        if (boatType == EntityTypes.aE || boatType == EntityTypes.aF) {
            return Boat.Type.MANGROVE;
        }
        if (boatType == EntityTypes.l || boatType == EntityTypes.k) {
            return Boat.Type.BAMBOO;
        }
        throw new EnumConstantNotPresentException(Boat.Type.class, boatType.toString());
    }

    public static Boat.Status boatStatusFromNms(AbstractBoat.EnumStatus enumStatus) {
        return switch (enumStatus) {
            default -> throw new EnumConstantNotPresentException(Boat.Status.class, enumStatus.name());
            case AbstractBoat.EnumStatus.e -> Boat.Status.IN_AIR;
            case AbstractBoat.EnumStatus.d -> Boat.Status.ON_LAND;
            case AbstractBoat.EnumStatus.b -> Boat.Status.UNDER_WATER;
            case AbstractBoat.EnumStatus.c -> Boat.Status.UNDER_FLOWING_WATER;
            case AbstractBoat.EnumStatus.a -> Boat.Status.IN_WATER;
        };
    }

    @Deprecated
    public static TreeSpecies getTreeSpecies(EntityTypes<?> boatType) {
        if (boatType == EntityTypes.bu || boatType == EntityTypes.bv) {
            return TreeSpecies.REDWOOD;
        }
        if (boatType == EntityTypes.o || boatType == EntityTypes.p) {
            return TreeSpecies.BIRCH;
        }
        if (boatType == EntityTypes.ax || boatType == EntityTypes.ay) {
            return TreeSpecies.JUNGLE;
        }
        if (boatType == EntityTypes.c || boatType == EntityTypes.d) {
            return TreeSpecies.ACACIA;
        }
        if (boatType == EntityTypes.I || boatType == EntityTypes.J) {
            return TreeSpecies.DARK_OAK;
        }
        return TreeSpecies.GENERIC;
    }
}

