/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R6.entity;

import com.google.common.base.Preconditions;
import io.papermc.paper.util.OldEnumHolderable;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.world.entity.animal.CatVariant;
import net.minecraft.world.entity.animal.EntityCat;
import net.minecraft.world.item.EnumColor;
import org.bukkit.DyeColor;
import org.bukkit.craftbukkit.v1_21_R6.CraftRegistry;
import org.bukkit.craftbukkit.v1_21_R6.CraftServer;
import org.bukkit.craftbukkit.v1_21_R6.entity.CraftTameableAnimal;
import org.bukkit.entity.Cat;

public class CraftCat
extends CraftTameableAnimal
implements Cat {
    public CraftCat(CraftServer server, EntityCat entity) {
        super(server, entity);
    }

    @Override
    public EntityCat getHandle() {
        return (EntityCat)this.entity;
    }

    public Cat.Type getCatType() {
        return CraftType.minecraftHolderToBukkit(this.getHandle().gU());
    }

    public void setCatType(Cat.Type type) {
        Preconditions.checkArgument((type != null ? 1 : 0) != 0, (Object)"type cannot be null");
        this.getHandle().b(CraftType.bukkitToMinecraftHolder(type));
    }

    public DyeColor getCollarColor() {
        return DyeColor.getByWoolData((byte)((byte)this.getHandle().gW().a()));
    }

    public void setCollarColor(DyeColor color) {
        this.getHandle().a(EnumColor.a(color.getWoolData()));
    }

    public void setLyingDown(boolean lyingDown) {
        this.getHandle().A(lyingDown);
    }

    public boolean isLyingDown() {
        return this.getHandle().gV();
    }

    public void setHeadUp(boolean headUp) {
        this.getHandle().B(headUp);
    }

    public boolean isHeadUp() {
        return this.getHandle().hb();
    }

    public static class CraftType
    extends OldEnumHolderable<Cat.Type, CatVariant>
    implements Cat.Type {
        private static int count = 0;

        public static Cat.Type minecraftToBukkit(CatVariant minecraft) {
            return (Cat.Type)CraftRegistry.minecraftToBukkit(minecraft, Registries.aO);
        }

        public static Cat.Type minecraftHolderToBukkit(Holder<CatVariant> minecraft) {
            return (Cat.Type)CraftRegistry.minecraftHolderToBukkit(minecraft, Registries.aO);
        }

        public static CatVariant bukkitToMinecraft(Cat.Type bukkit) {
            return (CatVariant)CraftRegistry.bukkitToMinecraft(bukkit);
        }

        public static Holder<CatVariant> bukkitToMinecraftHolder(Cat.Type bukkit) {
            return CraftRegistry.bukkitToMinecraftHolder(bukkit);
        }

        public CraftType(Holder<CatVariant> holder) {
            super(holder, count++);
        }
    }
}

