/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R6.entity;

import com.google.common.base.Preconditions;
import io.papermc.paper.registry.HolderableBase;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.world.entity.animal.ChickenVariant;
import net.minecraft.world.entity.animal.EntityChicken;
import org.bukkit.craftbukkit.v1_21_R6.CraftRegistry;
import org.bukkit.craftbukkit.v1_21_R6.CraftServer;
import org.bukkit.craftbukkit.v1_21_R6.entity.CraftAnimals;
import org.bukkit.entity.Chicken;
import org.jspecify.annotations.NullMarked;

@NullMarked
public class CraftChicken
extends CraftAnimals
implements Chicken {
    public CraftChicken(CraftServer server, EntityChicken entity) {
        super(server, entity);
    }

    @Override
    public EntityChicken getHandle() {
        return (EntityChicken)this.entity;
    }

    public Chicken.Variant getVariant() {
        return CraftVariant.minecraftHolderToBukkit(this.getHandle().n());
    }

    public void setVariant(Chicken.Variant variant) {
        Preconditions.checkArgument((variant != null ? 1 : 0) != 0, (Object)"variant cannot be null");
        this.getHandle().b(CraftVariant.bukkitToMinecraftHolder(variant));
    }

    public boolean isChickenJockey() {
        return this.getHandle().s();
    }

    public void setIsChickenJockey(boolean isChickenJockey) {
        this.getHandle().x(isChickenJockey);
    }

    public int getEggLayTime() {
        return this.getHandle().cz;
    }

    public void setEggLayTime(int eggLayTime) {
        this.getHandle().cz = eggLayTime;
    }

    public static class CraftVariant
    extends HolderableBase<ChickenVariant>
    implements Chicken.Variant {
        public static Chicken.Variant minecraftToBukkit(ChickenVariant minecraft) {
            return (Chicken.Variant)CraftRegistry.minecraftToBukkit(minecraft, Registries.aQ);
        }

        public static Chicken.Variant minecraftHolderToBukkit(Holder<ChickenVariant> minecraft) {
            return (Chicken.Variant)CraftRegistry.minecraftHolderToBukkit(minecraft, Registries.aQ);
        }

        public static ChickenVariant bukkitToMinecraft(Chicken.Variant bukkit) {
            return (ChickenVariant)CraftRegistry.bukkitToMinecraft(bukkit);
        }

        public static Holder<ChickenVariant> bukkitToMinecraftHolder(Chicken.Variant bukkit) {
            return CraftRegistry.bukkitToMinecraftHolder(bukkit);
        }

        public CraftVariant(Holder<ChickenVariant> holder) {
            super(holder);
        }
    }
}

