/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R6.entity;

import com.google.common.base.Preconditions;
import net.minecraft.world.entity.monster.EntityCreeper;
import org.bukkit.craftbukkit.v1_21_R6.CraftServer;
import org.bukkit.craftbukkit.v1_21_R6.entity.CraftEntity;
import org.bukkit.craftbukkit.v1_21_R6.entity.CraftMonster;
import org.bukkit.entity.Creeper;
import org.bukkit.entity.Entity;
import org.bukkit.event.Event;
import org.bukkit.event.entity.CreeperPowerEvent;

public class CraftCreeper
extends CraftMonster
implements Creeper {
    public CraftCreeper(CraftServer server, EntityCreeper entity) {
        super(server, entity);
    }

    @Override
    public EntityCreeper getHandle() {
        return (EntityCreeper)this.entity;
    }

    public boolean isPowered() {
        return this.getHandle().m();
    }

    public void setPowered(boolean powered) {
        CreeperPowerEvent.PowerCause cause;
        CreeperPowerEvent.PowerCause powerCause = cause = powered ? CreeperPowerEvent.PowerCause.SET_ON : CreeperPowerEvent.PowerCause.SET_OFF;
        if (this.getHandle().generation || !this.callPowerEvent(cause)) {
            this.getHandle().setPowered(powered);
        }
    }

    private boolean callPowerEvent(CreeperPowerEvent.PowerCause cause) {
        CreeperPowerEvent event = new CreeperPowerEvent((Creeper)this.getHandle().getBukkitEntity(), cause);
        this.server.getPluginManager().callEvent((Event)event);
        return event.isCancelled();
    }

    public void setMaxFuseTicks(int ticks) {
        Preconditions.checkArgument((ticks >= 0 ? 1 : 0) != 0, (Object)"ticks < 0");
        this.getHandle().cw = ticks;
    }

    public int getMaxFuseTicks() {
        return this.getHandle().cw;
    }

    public void setFuseTicks(int ticks) {
        Preconditions.checkArgument((ticks >= 0 ? 1 : 0) != 0, (Object)"ticks < 0");
        Preconditions.checkArgument((ticks <= this.getMaxFuseTicks() ? 1 : 0) != 0, (Object)"ticks > maxFuseTicks");
        this.getHandle().cv = ticks;
    }

    public int getFuseTicks() {
        return this.getHandle().cv;
    }

    public void setExplosionRadius(int radius) {
        Preconditions.checkArgument((radius >= 0 ? 1 : 0) != 0, (Object)"radius < 0");
        this.getHandle().cx = radius;
    }

    public int getExplosionRadius() {
        return this.getHandle().cx;
    }

    public void explode() {
        this.getHandle().gJ();
    }

    public void ignite(Entity entity) {
        Preconditions.checkNotNull((Object)entity, (Object)"entity cannot be null");
        this.getHandle().entityIgniter = ((CraftEntity)entity).getHandle();
        this.getHandle().gI();
    }

    public void ignite() {
        this.getHandle().gI();
    }

    public Entity getIgniter() {
        return this.getHandle().entityIgniter != null ? this.getHandle().entityIgniter.getBukkitEntity() : null;
    }

    public void setIgnited(boolean ignited) {
        this.getHandle().setIgnited(ignited);
    }

    public boolean isIgnited() {
        return this.getHandle().s();
    }
}

