/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R6.entity;

import com.destroystokyo.paper.block.TargetBlockInfo;
import com.destroystokyo.paper.entity.TargetEntityInfo;
import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import io.papermc.paper.world.damagesource.CombatTracker;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.Consumer;
import net.kyori.adventure.util.TriState;
import net.minecraft.Optionull;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.protocol.game.ClientboundHurtAnimationPacket;
import net.minecraft.network.protocol.game.PacketPlayOutEntityStatus;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.world.EnumHand;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.decoration.EntityArmorStand;
import net.minecraft.world.entity.decoration.Mannequin;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.projectile.EntityArrow;
import net.minecraft.world.entity.projectile.EntityDragonFireball;
import net.minecraft.world.entity.projectile.EntityEgg;
import net.minecraft.world.entity.projectile.EntityEnderPearl;
import net.minecraft.world.entity.projectile.EntityFireworks;
import net.minecraft.world.entity.projectile.EntityFishingHook;
import net.minecraft.world.entity.projectile.EntityLargeFireball;
import net.minecraft.world.entity.projectile.EntityLlamaSpit;
import net.minecraft.world.entity.projectile.EntityProjectile;
import net.minecraft.world.entity.projectile.EntityShulkerBullet;
import net.minecraft.world.entity.projectile.EntitySmallFireball;
import net.minecraft.world.entity.projectile.EntitySnowball;
import net.minecraft.world.entity.projectile.EntitySpectralArrow;
import net.minecraft.world.entity.projectile.EntityThrownExpBottle;
import net.minecraft.world.entity.projectile.EntityThrownTrident;
import net.minecraft.world.entity.projectile.EntityTippedArrow;
import net.minecraft.world.entity.projectile.EntityWitherSkull;
import net.minecraft.world.entity.projectile.IProjectile;
import net.minecraft.world.entity.projectile.ThrownLingeringPotion;
import net.minecraft.world.entity.projectile.ThrownSplashPotion;
import net.minecraft.world.entity.projectile.windcharge.AbstractWindCharge;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.Consumable;
import net.minecraft.world.level.RayTrace;
import net.minecraft.world.level.World;
import net.minecraft.world.phys.MovingObjectPosition;
import net.minecraft.world.phys.MovingObjectPositionEntity;
import net.minecraft.world.phys.Vec3D;
import net.minecraft.world.phys.shapes.VoxelShapeCollision;
import org.bukkit.FluidCollisionMode;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.attribute.Attribute;
import org.bukkit.attribute.AttributeInstance;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.craftbukkit.v1_21_R6.CraftEquipmentSlot;
import org.bukkit.craftbukkit.v1_21_R6.CraftServer;
import org.bukkit.craftbukkit.v1_21_R6.CraftSound;
import org.bukkit.craftbukkit.v1_21_R6.CraftWorld;
import org.bukkit.craftbukkit.v1_21_R6.damage.CraftDamageSource;
import org.bukkit.craftbukkit.v1_21_R6.entity.CraftEntity;
import org.bukkit.craftbukkit.v1_21_R6.entity.CraftHumanEntity;
import org.bukkit.craftbukkit.v1_21_R6.entity.CraftItem;
import org.bukkit.craftbukkit.v1_21_R6.entity.CraftPlayer;
import org.bukkit.craftbukkit.v1_21_R6.entity.memory.CraftMemoryKey;
import org.bukkit.craftbukkit.v1_21_R6.entity.memory.CraftMemoryMapper;
import org.bukkit.craftbukkit.v1_21_R6.inventory.CraftEntityEquipment;
import org.bukkit.craftbukkit.v1_21_R6.inventory.CraftItemStack;
import org.bukkit.craftbukkit.v1_21_R6.potion.CraftPotionEffectType;
import org.bukkit.craftbukkit.v1_21_R6.potion.CraftPotionUtil;
import org.bukkit.craftbukkit.v1_21_R6.util.CraftVector;
import org.bukkit.damage.DamageSource;
import org.bukkit.entity.AbstractArrow;
import org.bukkit.entity.Arrow;
import org.bukkit.entity.BreezeWindCharge;
import org.bukkit.entity.DragonFireball;
import org.bukkit.entity.Egg;
import org.bukkit.entity.EnderPearl;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityCategory;
import org.bukkit.entity.Fireball;
import org.bukkit.entity.Firework;
import org.bukkit.entity.FishHook;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Item;
import org.bukkit.entity.LingeringPotion;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.LlamaSpit;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.entity.ShulkerBullet;
import org.bukkit.entity.SmallFireball;
import org.bukkit.entity.Snowball;
import org.bukkit.entity.SpectralArrow;
import org.bukkit.entity.ThrownExpBottle;
import org.bukkit.entity.ThrownPotion;
import org.bukkit.entity.TippedArrow;
import org.bukkit.entity.Trident;
import org.bukkit.entity.WitherSkull;
import org.bukkit.entity.memory.MemoryKey;
import org.bukkit.event.entity.EntityPotionEffectEvent;
import org.bukkit.event.entity.EntityRegainHealthEvent;
import org.bukkit.inventory.EntityEquipment;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.potion.PotionType;
import org.bukkit.util.BlockIterator;
import org.bukkit.util.RayTraceResult;
import org.bukkit.util.Vector;
import org.jetbrains.annotations.NotNull;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.jspecify.annotations.NonNull;
import org.spigotmc.AsyncCatcher;

public class CraftLivingEntity
extends CraftEntity
implements LivingEntity {
    private CraftEntityEquipment equipment;

    public CraftLivingEntity(CraftServer server, EntityLiving entity) {
        super(server, entity);
        if (entity instanceof EntityInsentient || entity instanceof EntityArmorStand || entity instanceof Mannequin) {
            this.equipment = new CraftEntityEquipment(this);
        }
    }

    @Override
    public EntityLiving getHandle() {
        return (EntityLiving)this.entity;
    }

    public double getHealth() {
        return Math.min((double)Math.max(0.0f, this.getHandle().eU()), this.getMaxHealth());
    }

    public void setHealth(double health) {
        Preconditions.checkArgument(((health = (double)((float)health)) >= 0.0 && health <= this.getMaxHealth() ? 1 : 0) != 0, (String)"Health value (%s) must be between 0 and %s. (attribute base value: %s%s)", (Object)health, (Object)this.getMaxHealth(), (Object)this.getHandle().h(GenericAttributes.t).b(), (Object)(this instanceof CraftPlayer ? ", player: " + this.getName() : ""));
        if (this.getHandle().generation && health == 0.0) {
            this.getHandle().discard(null);
            return;
        }
        this.getHandle().x((float)health);
        if (health == 0.0) {
            this.getHandle().a(this.getHandle().ei().p());
        }
    }

    public void heal(double amount, EntityRegainHealthEvent.RegainReason reason) {
        this.getHandle().heal((float)amount, reason);
    }

    public double getAbsorptionAmount() {
        return this.getHandle().fM();
    }

    public void setAbsorptionAmount(double amount) {
        Preconditions.checkArgument((amount >= 0.0 && Double.isFinite(amount) ? 1 : 0) != 0, (Object)"amount < 0 or non-finite");
        this.getHandle().E((float)amount);
    }

    public double getMaxHealth() {
        return this.getHandle().fj();
    }

    public void setMaxHealth(double amount) {
        Preconditions.checkArgument((amount > 0.0 ? 1 : 0) != 0, (String)"Max health amount (%s) must be greater than 0", (Object)amount);
        this.getHandle().h(GenericAttributes.t).a(amount);
        if (this.getHealth() > amount) {
            this.setHealth(amount);
        }
    }

    public void resetMaxHealth() {
        this.setMaxHealth(this.getHandle().h(GenericAttributes.t).a().a().a());
    }

    public double getEyeHeight() {
        return this.getHandle().df();
    }

    public double getEyeHeight(boolean ignorePose) {
        return this.getEyeHeight();
    }

    private List<Block> getLineOfSight(Set<Material> transparent, int maxDistance, int maxLength) {
        Preconditions.checkState((!this.getHandle().generation ? 1 : 0) != 0, (Object)"Cannot get line of sight during world generation");
        if (transparent == null) {
            transparent = Sets.newHashSet((Object[])new Material[]{Material.AIR, Material.CAVE_AIR, Material.VOID_AIR});
        }
        if (maxDistance > 120) {
            maxDistance = 120;
        }
        ArrayList<Block> blocks = new ArrayList<Block>();
        BlockIterator itr = new BlockIterator((LivingEntity)this, maxDistance);
        while (itr.hasNext()) {
            Material material;
            Block block = (Block)itr.next();
            blocks.add(block);
            if (maxLength != 0 && blocks.size() > maxLength) {
                blocks.remove(0);
            }
            if (transparent.contains(material = block.getType())) continue;
            break;
        }
        return blocks;
    }

    public List<Block> getLineOfSight(Set<Material> transparent, int maxDistance) {
        return this.getLineOfSight(transparent, maxDistance, 0);
    }

    public Block getTargetBlock(Set<Material> transparent, int maxDistance) {
        List<Block> blocks = this.getLineOfSight(transparent, maxDistance, 1);
        return blocks.get(0);
    }

    public Block getTargetBlock(int maxDistance, TargetBlockInfo.FluidMode fluidMode) {
        return this.getTargetBlockExact(maxDistance, fluidMode.bukkit);
    }

    public BlockFace getTargetBlockFace(int maxDistance, TargetBlockInfo.FluidMode fluidMode) {
        return this.getTargetBlockFace(maxDistance, fluidMode.bukkit);
    }

    public BlockFace getTargetBlockFace(int maxDistance, FluidCollisionMode fluidMode) {
        RayTraceResult result = this.rayTraceBlocks(maxDistance, fluidMode);
        return result != null ? result.getHitBlockFace() : null;
    }

    public TargetBlockInfo getTargetBlockInfo(int maxDistance, TargetBlockInfo.FluidMode fluidMode) {
        RayTraceResult result = this.rayTraceBlocks(maxDistance, fluidMode.bukkit);
        if (result != null && result.getHitBlock() != null && result.getHitBlockFace() != null) {
            return new TargetBlockInfo(result.getHitBlock(), result.getHitBlockFace());
        }
        return null;
    }

    public Entity getTargetEntity(int maxDistance, boolean ignoreBlocks) {
        MovingObjectPositionEntity rayTrace = this.rayTraceEntity(maxDistance, ignoreBlocks);
        return rayTrace == null ? null : rayTrace.a().getBukkitEntity();
    }

    public TargetEntityInfo getTargetEntityInfo(int maxDistance, boolean ignoreBlocks) {
        MovingObjectPositionEntity rayTrace = this.rayTraceEntity(maxDistance, ignoreBlocks);
        return rayTrace == null ? null : new TargetEntityInfo((Entity)rayTrace.a().getBukkitEntity(), new Vector(rayTrace.g().g, rayTrace.g().h, rayTrace.g().i));
    }

    public RayTraceResult rayTraceEntities(int maxDistance, boolean ignoreBlocks) {
        MovingObjectPositionEntity rayTrace = this.rayTraceEntity(maxDistance, ignoreBlocks);
        return rayTrace == null ? null : new RayTraceResult(CraftVector.toBukkit(rayTrace.g()), (Entity)rayTrace.a().getBukkitEntity());
    }

    public MovingObjectPositionEntity rayTraceEntity(int maxDistance, boolean ignoreBlocks) {
        Vec3D eye;
        MovingObjectPosition rayTraceBlocks;
        MovingObjectPositionEntity rayTrace = this.getHandle().getTargetEntity(maxDistance);
        if (rayTrace == null) {
            return null;
        }
        if (!ignoreBlocks && (rayTraceBlocks = this.getHandle().getRayTrace(maxDistance, RayTrace.FluidCollisionOption.a)) != null && (eye = this.getHandle().n(1.0f)).g(rayTraceBlocks.g()) <= eye.g(rayTrace.g())) {
            return null;
        }
        return rayTrace;
    }

    public List<Block> getLastTwoTargetBlocks(Set<Material> transparent, int maxDistance) {
        return this.getLineOfSight(transparent, maxDistance, 2);
    }

    public Block getTargetBlockExact(int maxDistance, FluidCollisionMode fluidCollisionMode) {
        RayTraceResult hitResult = this.rayTraceBlocks(maxDistance, fluidCollisionMode);
        return hitResult != null ? hitResult.getHitBlock() : null;
    }

    public RayTraceResult rayTraceBlocks(double maxDistance, FluidCollisionMode fluidCollisionMode) {
        Preconditions.checkState((!this.getHandle().generation ? 1 : 0) != 0, (Object)"Cannot ray tray blocks during world generation");
        Location eyeLocation = this.getEyeLocation();
        Vector direction = eyeLocation.getDirection();
        return this.getWorld().rayTraceBlocks(eyeLocation, direction, maxDistance, fluidCollisionMode, false);
    }

    public int getRemainingAir() {
        return this.getHandle().cF();
    }

    public void setRemainingAir(int ticks) {
        this.getHandle().j(ticks);
    }

    public int getMaximumAir() {
        return this.getHandle().maxAirTicks;
    }

    public void setMaximumAir(int ticks) {
        this.getHandle().maxAirTicks = ticks;
    }

    public ItemStack getItemInUse() {
        net.minecraft.world.item.ItemStack item = this.getHandle().fQ();
        return item.f() ? null : CraftItemStack.asCraftMirror(item);
    }

    public int getItemInUseTicks() {
        return this.getHandle().fR();
    }

    public void setItemInUseTicks(int ticks) {
        this.getHandle().bT = ticks;
    }

    public int getArrowCooldown() {
        return this.getHandle().br;
    }

    public void setArrowCooldown(int ticks) {
        Preconditions.checkArgument((ticks >= 0 ? 1 : 0) != 0, (Object)"Amount of ticks before next arrow removal must be non-negative");
        this.getHandle().br = ticks;
    }

    public int getArrowsInBody() {
        return this.getHandle().fl();
    }

    public void setArrowsInBody(int count, boolean fireEvent) {
        Preconditions.checkArgument((count >= 0 ? 1 : 0) != 0, (Object)"New arrow amount must be non-negative");
        if (!fireEvent) {
            this.getHandle().aC().a(EntityLiving.ce, count);
        } else {
            this.getHandle().o(count);
        }
    }

    @Override
    public boolean isInvulnerable() {
        return this.getHandle().a((WorldServer)this.getHandle().an(), this.getHandle().ei().p());
    }

    public int getBeeStingerCooldown() {
        return this.getHandle().bs;
    }

    public void setBeeStingerCooldown(int ticks) {
        Preconditions.checkArgument((ticks >= 0 ? 1 : 0) != 0, (Object)"New amount of ticks before next bee stinger removal must be non-negative");
        this.getHandle().bs = ticks;
    }

    public int getBeeStingersInBody() {
        return this.getHandle().fm();
    }

    public void setBeeStingersInBody(int count) {
        Preconditions.checkArgument((count >= 0 ? 1 : 0) != 0, (Object)"New bee stinger amount must be >= 0");
        this.getHandle().p(count);
    }

    public void damage(double amount) {
        this.damage(amount, this.getHandle().ei().p());
    }

    public void damage(double amount, Entity source) {
        net.minecraft.world.damagesource.DamageSource reason = this.getHandle().ei().p();
        if (source instanceof HumanEntity) {
            reason = this.getHandle().ei().a(((CraftHumanEntity)source).getHandle());
        } else if (source instanceof LivingEntity) {
            reason = this.getHandle().ei().b(((CraftLivingEntity)source).getHandle());
        }
        this.damage(amount, reason);
    }

    public void damage(double amount, DamageSource damageSource) {
        Preconditions.checkArgument((damageSource != null ? 1 : 0) != 0, (Object)"damageSource cannot be null");
        this.damage(amount, ((CraftDamageSource)damageSource).getHandle());
    }

    private void damage(double amount, net.minecraft.world.damagesource.DamageSource damageSource) {
        Preconditions.checkArgument((damageSource != null ? 1 : 0) != 0, (Object)"damageSource cannot be null");
        Preconditions.checkState((!this.getHandle().generation ? 1 : 0) != 0, (Object)"Cannot damage entity during world generation");
        this.entity.a(damageSource, (float)amount);
    }

    public Location getEyeLocation() {
        Location loc = this.getLocation();
        loc.setY(loc.getY() + this.getEyeHeight());
        return loc;
    }

    public int getMaximumNoDamageTicks() {
        return this.getHandle().bA;
    }

    public void setMaximumNoDamageTicks(int ticks) {
        this.getHandle().bA = ticks;
    }

    public double getLastDamage() {
        return this.getHandle().bK;
    }

    public void setLastDamage(double damage) {
        this.getHandle().bK = (float)damage;
    }

    public int getNoDamageTicks() {
        return this.getHandle().ax;
    }

    public void setNoDamageTicks(int ticks) {
        this.getHandle().ax = ticks;
    }

    public int getNoActionTicks() {
        return this.getHandle().eK();
    }

    public void setNoActionTicks(int ticks) {
        Preconditions.checkArgument((ticks >= 0 ? 1 : 0) != 0, (Object)"ticks must be >= 0");
        this.getHandle().n(ticks);
    }

    public Player getKiller() {
        return Optionull.a(this.getHandle().eG(), player -> (Player)player.getBukkitEntity());
    }

    public void setKiller(Player killer) {
        EntityPlayer nmsKiller = killer == null ? null : ((CraftPlayer)killer).getHandle();
        this.getHandle().a((EntityLiving)nmsKiller);
        if (nmsKiller != null) {
            this.getHandle().a((EntityHuman)nmsKiller, this.getHandle().an().purpurConfig.mobLastHurtByPlayerTime);
        } else {
            this.getHandle().bG = null;
            this.getHandle().bH = 0;
        }
    }

    public boolean addPotionEffect(PotionEffect effect, boolean force) {
        AsyncCatcher.catchOp("effect add");
        this.getHandle().addEffect(CraftPotionUtil.fromBukkit(effect), EntityPotionEffectEvent.Cause.PLUGIN);
        return true;
    }

    public boolean addPotionEffects(Collection<PotionEffect> effects) {
        boolean success = true;
        for (PotionEffect effect : effects) {
            success &= this.addPotionEffect(effect);
        }
        return success;
    }

    public boolean hasPotionEffect(PotionEffectType type) {
        return this.getHandle().d(CraftPotionEffectType.bukkitToMinecraftHolder(type));
    }

    public PotionEffect getPotionEffect(PotionEffectType type) {
        MobEffect handle = this.getHandle().e(CraftPotionEffectType.bukkitToMinecraftHolder(type));
        return handle == null ? null : CraftPotionUtil.toBukkit(handle);
    }

    public void removePotionEffect(PotionEffectType type) {
        this.getHandle().removeEffect(CraftPotionEffectType.bukkitToMinecraftHolder(type), EntityPotionEffectEvent.Cause.PLUGIN);
    }

    public Collection<PotionEffect> getActivePotionEffects() {
        ArrayList<PotionEffect> effects = new ArrayList<PotionEffect>();
        for (MobEffect handle : this.getHandle().cl.values()) {
            effects.add(CraftPotionUtil.toBukkit(handle));
        }
        return effects;
    }

    public boolean clearActivePotionEffects() {
        return this.getHandle().removeAllEffects(EntityPotionEffectEvent.Cause.PLUGIN);
    }

    public <T extends Projectile> T launchProjectile(Class<? extends T> projectile, Vector velocity, Consumer<? super T> function) {
        Preconditions.checkState((!this.getHandle().generation ? 1 : 0) != 0, (Object)"Cannot launch projectile during world generation");
        WorldServer world = ((CraftWorld)this.getWorld()).getHandle();
        IProjectile launch = null;
        if (Snowball.class.isAssignableFrom(projectile)) {
            launch = new EntitySnowball(world, this.getHandle(), new net.minecraft.world.item.ItemStack(Items.so));
            ((EntityProjectile)launch).a(this.getHandle(), this.getHandle().dZ(), this.getHandle().dX(), 0.0f, 1.5f, 1.0f);
        } else if (Egg.class.isAssignableFrom(projectile)) {
            launch = new EntityEgg(world, this.getHandle(), new net.minecraft.world.item.ItemStack(Items.sD));
            ((EntityProjectile)launch).a(this.getHandle(), this.getHandle().dZ(), this.getHandle().dX(), 0.0f, 1.5f, 1.0f);
        } else if (EnderPearl.class.isAssignableFrom(projectile)) {
            launch = new EntityEnderPearl(world, this.getHandle(), new net.minecraft.world.item.ItemStack(Items.uj));
            ((EntityProjectile)launch).a(this.getHandle(), this.getHandle().dZ(), this.getHandle().dX(), 0.0f, 1.5f, 1.0f);
        } else if (AbstractArrow.class.isAssignableFrom(projectile)) {
            if (TippedArrow.class.isAssignableFrom(projectile)) {
                launch = new EntityTippedArrow(world, this.getHandle(), new net.minecraft.world.item.ItemStack(Items.pX), null);
                ((Arrow)launch.getBukkitEntity()).setBasePotionType(PotionType.WATER);
            } else {
                launch = SpectralArrow.class.isAssignableFrom(projectile) ? new EntitySpectralArrow(world, this.getHandle(), new net.minecraft.world.item.ItemStack(Items.xz), null) : (Trident.class.isAssignableFrom(projectile) ? new EntityThrownTrident(world, this.getHandle(), new net.minecraft.world.item.ItemStack(Items.yf)) : new EntityTippedArrow(world, this.getHandle(), new net.minecraft.world.item.ItemStack(Items.pX), null));
            }
            ((EntityArrow)launch).a(this.getHandle(), this.getHandle().dZ(), this.getHandle().dX(), 0.0f, Trident.class.isAssignableFrom(projectile) ? 2.5f : 3.0f, 1.0f);
        } else if (ThrownPotion.class.isAssignableFrom(projectile)) {
            launch = LingeringPotion.class.isAssignableFrom(projectile) ? new ThrownLingeringPotion(world, this.getHandle(), new net.minecraft.world.item.ItemStack(Items.xB)) : new ThrownSplashPotion(world, this.getHandle(), new net.minecraft.world.item.ItemStack(Items.xy));
            ((EntityProjectile)launch).a(this.getHandle(), this.getHandle().dZ(), this.getHandle().dX(), -20.0f, 0.5f, 1.0f);
        } else if (ThrownExpBottle.class.isAssignableFrom(projectile)) {
            launch = new EntityThrownExpBottle(world, this.getHandle(), new net.minecraft.world.item.ItemStack(Items.wd));
            ((EntityProjectile)launch).a(this.getHandle(), this.getHandle().dZ(), this.getHandle().dX(), -20.0f, 0.7f, 1.0f);
        } else if (FishHook.class.isAssignableFrom(projectile) && this.getHandle() instanceof EntityHuman) {
            launch = new EntityFishingHook((EntityHuman)this.getHandle(), (World)world, 0, 0);
        } else if (Fireball.class.isAssignableFrom(projectile)) {
            Location location = this.getEyeLocation();
            Vector direction = location.getDirection().multiply(10);
            Vec3D vec = new Vec3D(direction.getX(), direction.getY(), direction.getZ());
            if (SmallFireball.class.isAssignableFrom(projectile)) {
                launch = new EntitySmallFireball(world, this.getHandle(), vec);
            } else if (WitherSkull.class.isAssignableFrom(projectile)) {
                launch = new EntityWitherSkull(world, this.getHandle(), vec);
            } else if (DragonFireball.class.isAssignableFrom(projectile)) {
                launch = new EntityDragonFireball(world, this.getHandle(), vec);
            } else if (org.bukkit.entity.AbstractWindCharge.class.isAssignableFrom(projectile)) {
                launch = BreezeWindCharge.class.isAssignableFrom(projectile) ? EntityTypes.u.a(world, EntitySpawnReason.k) : EntityTypes.bM.a(world, EntitySpawnReason.k);
                ((AbstractWindCharge)launch).c(this.getHandle());
                ((AbstractWindCharge)launch).a(this.getHandle(), this.getHandle().dZ(), this.getHandle().dX(), 0.0f, 1.5f, 1.0f);
            } else {
                launch = new EntityLargeFireball(world, this.getHandle(), vec, 1);
            }
            launch.projectileSource = this;
            launch.b(location.getX(), location.getY(), location.getZ(), location.getYaw(), location.getPitch());
        } else if (LlamaSpit.class.isAssignableFrom(projectile)) {
            Location location = this.getEyeLocation();
            Vector direction = location.getDirection();
            launch = EntityTypes.aC.a(world, EntitySpawnReason.k);
            ((EntityLlamaSpit)launch).c(this.getHandle());
            ((EntityLlamaSpit)launch).c(direction.getX(), direction.getY(), direction.getZ(), 1.5f, 10.0f);
            launch.b(location.getX(), location.getY(), location.getZ(), location.getYaw(), location.getPitch());
        } else if (ShulkerBullet.class.isAssignableFrom(projectile)) {
            Location location = this.getEyeLocation();
            launch = new EntityShulkerBullet(world, this.getHandle(), null, null);
            launch.b(location.getX(), location.getY(), location.getZ(), location.getYaw(), location.getPitch());
        } else if (Firework.class.isAssignableFrom(projectile)) {
            Location location = this.getEyeLocation();
            launch = new EntityFireworks(world, EntityFireworks.n(), this.getHandle(), location.getX(), location.getY() - (double)0.15f, location.getZ(), true);
            float f2 = 0.0f;
            int projectileSize = 1;
            int i2 = 0;
            float f3 = projectileSize == 1 ? 0.0f : 2.0f * f2 / (float)(projectileSize - 1);
            float f4 = (float)((projectileSize - 1) % 2) * f3 / 2.0f;
            float f5 = 1.0f;
            float yaw = f4 + f5 * (float)((i2 + 1) / 2) * f3;
            Vec3D vec3 = this.getHandle().m(1.0f);
            Quaternionf quaternionf = new Quaternionf().setAngleAxis((double)(yaw * ((float)Math.PI / 180)), vec3.g, vec3.h, vec3.i);
            Vec3D vec32 = this.getHandle().h(1.0f);
            Vector3f vector3f = vec32.l().rotate((Quaternionfc)quaternionf);
            ((EntityFireworks)launch).c(vector3f.x(), vector3f.y(), vector3f.z(), 1.6f, 1.0f);
        }
        Preconditions.checkArgument((launch != null ? 1 : 0) != 0, (String)"Projectile (%s) not supported", (Object)projectile.getName());
        if (velocity != null) {
            launch.getBukkitEntity().setVelocity(velocity);
        }
        if (function != null) {
            function.accept((Projectile)launch.getBukkitEntity());
        }
        world.b(launch);
        return (T)((Projectile)launch.getBukkitEntity());
    }

    public boolean hasLineOfSight(Entity other) {
        Preconditions.checkState((!this.getHandle().generation ? 1 : 0) != 0, (Object)"Cannot check line of sight during world generation");
        return this.getHandle().F(((CraftEntity)other).getHandle());
    }

    public boolean hasLineOfSight(Location loc) {
        if (this.getHandle().an() != ((CraftWorld)loc.getWorld()).getHandle()) {
            return false;
        }
        Vec3D start = new Vec3D(this.getHandle().dK(), this.getHandle().dO(), this.getHandle().dQ());
        Vec3D end = new Vec3D(loc.getX(), loc.getY(), loc.getZ());
        if (end.g(start) > 16384.0) {
            return false;
        }
        return this.getHandle().an().clipDirect(start, end, VoxelShapeCollision.a(this.getHandle())) == MovingObjectPosition.EnumMovingObjectType.a;
    }

    public boolean getRemoveWhenFarAway() {
        return this.getHandle() instanceof EntityInsentient && !((EntityInsentient)this.getHandle()).gr();
    }

    public void setRemoveWhenFarAway(boolean remove) {
        if (this.getHandle() instanceof EntityInsentient) {
            ((EntityInsentient)this.getHandle()).setPersistenceRequired(!remove);
        }
    }

    public @NonNull EntityEquipment getEquipment() {
        return this.equipment;
    }

    public void setCanPickupItems(boolean pickup) {
        if (this.getHandle() instanceof EntityInsentient) {
            ((EntityInsentient)this.getHandle()).a_(pickup);
        } else {
            this.getHandle().bukkitPickUpLoot = pickup;
        }
    }

    public boolean getCanPickupItems() {
        if (this.getHandle() instanceof EntityInsentient) {
            return this.getHandle().gc();
        }
        return this.getHandle().bukkitPickUpLoot;
    }

    public boolean isLeashed() {
        return false;
    }

    public Entity getLeashHolder() throws IllegalStateException {
        throw new IllegalStateException("Entity not leashed");
    }

    public boolean setLeashHolder(Entity holder) {
        return false;
    }

    public boolean isGliding() {
        return this.getHandle().fY();
    }

    public void setGliding(boolean gliding) {
        this.getHandle().b(7, gliding);
    }

    public boolean isSwimming() {
        return this.getHandle().cw();
    }

    public void setSwimming(boolean swimming) {
        this.getHandle().j(swimming);
    }

    public boolean isRiptiding() {
        return this.getHandle().fL();
    }

    public void setRiptiding(boolean riptiding) {
        this.getHandle().c(4, riptiding);
    }

    public boolean isSleeping() {
        return this.getHandle().gg();
    }

    public boolean isClimbing() {
        Preconditions.checkState((!this.getHandle().generation ? 1 : 0) != 0, (Object)"Cannot check if climbing during world generation");
        return this.getHandle().fe();
    }

    public AttributeInstance getAttribute(Attribute attribute) {
        return this.getHandle().craftAttributes.getAttribute(attribute);
    }

    public void registerAttribute(Attribute attribute) {
        this.getHandle().craftAttributes.registerAttribute(attribute);
    }

    public void setAI(boolean ai) {
        if (this.getHandle() instanceof EntityInsentient) {
            ((EntityInsentient)this.getHandle()).u(!ai);
        }
    }

    public boolean hasAI() {
        return this.getHandle() instanceof EntityInsentient ? !((EntityInsentient)this.getHandle()).gx() : false;
    }

    public void attack(Entity target) {
        Preconditions.checkArgument((target != null ? 1 : 0) != 0, (Object)"target == null");
        Preconditions.checkState((!this.getHandle().generation ? 1 : 0) != 0, (Object)"Cannot attack during world generation");
        if (this.getHandle() instanceof EntityHuman) {
            ((EntityHuman)this.getHandle()).e(((CraftEntity)target).getHandle());
        } else {
            this.getHandle().c((WorldServer)((CraftEntity)target).getHandle().an(), ((CraftEntity)target).getHandle());
        }
    }

    public void swingMainHand() {
        Preconditions.checkState((!this.getHandle().generation ? 1 : 0) != 0, (Object)"Cannot swing hand during world generation");
        this.getHandle().a(EnumHand.a, true);
    }

    public void swingOffHand() {
        Preconditions.checkState((!this.getHandle().generation ? 1 : 0) != 0, (Object)"Cannot swing hand during world generation");
        this.getHandle().a(EnumHand.b, true);
    }

    public void playHurtAnimation(float yaw) {
        World world = this.getHandle().an();
        if (world instanceof WorldServer) {
            WorldServer world2 = (WorldServer)world;
            float actualYaw = yaw + 90.0f;
            ClientboundHurtAnimationPacket packet = new ClientboundHurtAnimationPacket(this.getEntityId(), actualYaw);
            world2.n().a(this.getHandle(), packet);
        }
    }

    public void setCollidable(boolean collidable) {
        this.getHandle().collides = collidable;
    }

    public boolean isCollidable() {
        return this.getHandle().collides;
    }

    public Set<UUID> getCollidableExemptions() {
        return this.getHandle().collidableExemptions;
    }

    public <T> T getMemory(MemoryKey<T> memoryKey) {
        Optional<Object> memory = this.getHandle().eq().d(CraftMemoryKey.bukkitToMinecraft(memoryKey));
        return memory != null ? memory.map(CraftMemoryMapper::fromNms).orElse(null) : null;
    }

    public <T> void setMemory(MemoryKey<T> memoryKey, T t2) {
        this.getHandle().eq().a(CraftMemoryKey.bukkitToMinecraft(memoryKey), CraftMemoryMapper.toNms(t2));
    }

    public Sound getHurtSound() {
        SoundEffect sound = this.getHandle().e(this.getHandle().ei().p());
        return sound != null ? CraftSound.minecraftToBukkit(sound) : null;
    }

    public Sound getDeathSound() {
        SoundEffect sound = this.getHandle().f_();
        return sound != null ? CraftSound.minecraftToBukkit(sound) : null;
    }

    public Sound getFallDamageSound(int fallHeight) {
        return CraftSound.minecraftToBukkit(this.getHandle().q(fallHeight));
    }

    public Sound getFallDamageSoundSmall() {
        return CraftSound.minecraftToBukkit(this.getHandle().fc().a());
    }

    public Sound getFallDamageSoundBig() {
        return CraftSound.minecraftToBukkit(this.getHandle().fc().b());
    }

    public Sound getDrinkingSound(ItemStack itemStack) {
        return this.getEatingSound(itemStack);
    }

    public Sound getEatingSound(ItemStack itemStack) {
        Preconditions.checkArgument((itemStack != null ? 1 : 0) != 0, (Object)"itemStack must not be null");
        net.minecraft.world.item.ItemStack nms = CraftItemStack.asNMSCopy(itemStack);
        Consumable consumable = nms.a(DataComponents.w);
        SoundEffect soundeffect = SoundEffects.lu.a();
        if (consumable != null) {
            EntityLiving entityLiving = this.getHandle();
            if (entityLiving instanceof Consumable.b) {
                Consumable.b consumable_b = (Consumable.b)((Object)entityLiving);
                soundeffect = consumable_b.j(nms);
            } else {
                soundeffect = consumable.e().a();
            }
        }
        return CraftSound.minecraftToBukkit(soundeffect);
    }

    public boolean canBreatheUnderwater() {
        return this.getHandle().et();
    }

    public EntityCategory getCategory() {
        throw new UnsupportedOperationException("Method no longer applicable. Use Tags instead.");
    }

    public float getSidewaysMovement() {
        return this.getHandle().bM;
    }

    public float getForwardsMovement() {
        return this.getHandle().bO;
    }

    public float getUpwardsMovement() {
        return this.getHandle().bN;
    }

    public void startUsingItem(EquipmentSlot hand) {
        Preconditions.checkArgument((hand != null ? 1 : 0) != 0, (Object)"hand must not be null");
        this.getHandle().c(CraftEquipmentSlot.getHand(hand));
    }

    public void completeUsingActiveItem() {
        this.getHandle().R_();
    }

    public ItemStack getActiveItem() {
        return this.getHandle().fQ().asBukkitMirror();
    }

    public void clearActiveItem() {
        this.getHandle().fU();
    }

    public int getActiveItemRemainingTime() {
        return this.getHandle().fR();
    }

    public void setActiveItemRemainingTime(int ticks) {
        Preconditions.checkArgument((ticks >= 0 ? 1 : 0) != 0, (Object)"ticks must be >= 0");
        Preconditions.checkArgument((ticks <= this.getHandle().fQ().a(this.getHandle()) ? 1 : 0) != 0, (Object)"ticks must be <= item use duration");
        this.getHandle().bT = ticks;
    }

    public int getActiveItemUsedTime() {
        return this.getHandle().fS();
    }

    public boolean hasActiveItem() {
        return this.getHandle().fO();
    }

    public EquipmentSlot getActiveItemHand() {
        return CraftEquipmentSlot.getHand(this.getHandle().fP());
    }

    public boolean isJumping() {
        return this.getHandle().bL;
    }

    public void setJumping(boolean jumping) {
        this.getHandle().t(jumping);
        if (jumping && this.getHandle() instanceof EntityInsentient) {
            ((EntityInsentient)this.getHandle()).R().a();
        }
    }

    public void playPickupItemAnimation(Item item, int quantity) {
        this.getHandle().a((net.minecraft.world.entity.Entity)((CraftItem)item).getHandle(), quantity);
    }

    public float getHurtDirection() {
        return this.getHandle().fa();
    }

    public void setHurtDirection(float hurtDirection) {
        throw new UnsupportedOperationException("Cannot set the hurt direction on a non player");
    }

    public void knockback(double strength, double directionX, double directionZ) {
        Preconditions.checkArgument((strength > 0.0 ? 1 : 0) != 0, (Object)"Knockback strength must be > 0");
        this.getHandle().o(strength, directionX, directionZ);
    }

    public void broadcastSlotBreak(EquipmentSlot slot) {
        this.getHandle().an().a((net.minecraft.world.entity.Entity)this.getHandle(), EntityLiving.g(CraftEquipmentSlot.getNMS(slot)));
    }

    public void broadcastSlotBreak(EquipmentSlot slot, Collection<Player> players) {
        if (players.isEmpty()) {
            return;
        }
        PacketPlayOutEntityStatus packet = new PacketPlayOutEntityStatus(this.getHandle(), EntityLiving.g(CraftEquipmentSlot.getNMS(slot)));
        players.forEach(player -> ((CraftPlayer)player).getHandle().g.b(packet));
    }

    public ItemStack damageItemStack(ItemStack stack, int amount) {
        net.minecraft.world.item.ItemStack nmsStack;
        if (stack instanceof CraftItemStack) {
            CraftItemStack craftItemStack = (CraftItemStack)stack;
            if (craftItemStack.handle == null || craftItemStack.handle.f()) {
                return stack;
            }
            nmsStack = craftItemStack.handle;
        } else {
            nmsStack = CraftItemStack.asNMSCopy(stack);
            stack = CraftItemStack.asCraftMirror(nmsStack);
        }
        this.damageItemStack0(nmsStack, amount, null);
        return stack;
    }

    public void damageItemStack(EquipmentSlot slot, int amount) {
        EnumItemSlot nmsSlot = CraftEquipmentSlot.getNMS(slot);
        this.damageItemStack0(this.getHandle().a(nmsSlot), amount, nmsSlot);
    }

    private void damageItemStack0(net.minecraft.world.item.ItemStack nmsStack, int amount, EnumItemSlot slot) {
        nmsStack.hurtAndBreak(amount, this.getHandle(), slot, true);
    }

    @NotNull
    public TriState getFrictionState() {
        return this.getHandle().frictionState;
    }

    public void setFrictionState(@NotNull TriState state) {
        Preconditions.checkArgument((state != null ? 1 : 0) != 0, (Object)"state may not be null");
        this.getHandle().frictionState = state;
    }

    public float getBodyYaw() {
        return this.getHandle().dY();
    }

    public void setBodyYaw(float bodyYaw) {
        this.getHandle().s(bodyYaw);
    }

    public boolean canUseEquipmentSlot(EquipmentSlot slot) {
        return this.getHandle().e(CraftEquipmentSlot.getNMS(slot));
    }

    public CombatTracker getCombatTracker() {
        return this.getHandle().fh().paperCombatTracker;
    }

    public boolean shouldBurnInDay() {
        return this.getHandle().shouldBurnInDay();
    }

    public void setShouldBurnInDay(boolean shouldBurnInDay) {
        this.getHandle().setShouldBurnInDay(shouldBurnInDay);
    }
}

