/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R6.entity;

import com.destroystokyo.paper.entity.CraftRangedEntity;
import com.google.common.base.Preconditions;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.animal.horse.EntityLlama;
import org.bukkit.craftbukkit.v1_21_R6.CraftServer;
import org.bukkit.craftbukkit.v1_21_R6.entity.CraftChestedHorse;
import org.bukkit.craftbukkit.v1_21_R6.inventory.CraftInventoryLlama;
import org.bukkit.entity.Horse;
import org.bukkit.entity.Llama;
import org.bukkit.inventory.LlamaInventory;
import org.jetbrains.annotations.NotNull;

public class CraftLlama
extends CraftChestedHorse
implements Llama,
CraftRangedEntity<EntityLlama> {
    public CraftLlama(CraftServer server, EntityLlama entity) {
        super(server, entity);
    }

    @Override
    public EntityLlama getHandle() {
        return (EntityLlama)this.entity;
    }

    public Llama.Color getColor() {
        return Llama.Color.values()[this.getHandle().gV().ordinal()];
    }

    public void setColor(Llama.Color color) {
        Preconditions.checkArgument((color != null ? 1 : 0) != 0, (Object)"color");
        this.getHandle().a(EntityLlama.Variant.a(color.ordinal()));
    }

    public LlamaInventory getInventory() {
        return new CraftInventoryLlama(this.getHandle().cK, this.getHandle().h(EnumItemSlot.g), this.getHandle().h(EnumItemSlot.h));
    }

    public int getStrength() {
        return this.getHandle().gM();
    }

    public void setStrength(int strength) {
        Preconditions.checkArgument((1 <= strength && strength <= 5 ? 1 : 0) != 0, (Object)"strength must be [1,5]");
        if (strength == this.getStrength()) {
            return;
        }
        this.getHandle().x(strength);
        this.getHandle().hg();
    }

    public Horse.Variant getVariant() {
        return Horse.Variant.LLAMA;
    }

    public boolean inCaravan() {
        return this.getHandle().hs();
    }

    public void joinCaravan(@NotNull Llama llama) {
        this.getHandle().a(((CraftLlama)llama).getHandle());
    }

    public void leaveCaravan() {
        this.getHandle().gX();
    }

    public boolean hasCaravanTail() {
        return this.getHandle().gY();
    }

    public Llama getCaravanHead() {
        return this.getHandle().ht() == null ? null : (Llama)this.getHandle().ht().getBukkitEntity();
    }

    public Llama getCaravanTail() {
        return this.getHandle().cA == null ? null : (Llama)this.getHandle().cA.getBukkitEntity();
    }

    public boolean shouldJoinCaravan() {
        return this.getHandle().shouldJoinCaravan;
    }

    public void setShouldJoinCaravan(boolean shouldJoinCaravan) {
        this.getHandle().shouldJoinCaravan = shouldJoinCaravan;
    }
}

