/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R6.entity;

import com.destroystokyo.paper.PaperSkinParts;
import com.destroystokyo.paper.SkinParts;
import com.google.common.base.Preconditions;
import io.papermc.paper.adventure.PaperAdventure;
import io.papermc.paper.datacomponent.item.PaperResolvableProfile;
import io.papermc.paper.datacomponent.item.ResolvableProfile;
import net.kyori.adventure.text.Component;
import net.minecraft.Optionull;
import net.minecraft.world.entity.Avatar;
import net.minecraft.world.entity.EntityPose;
import net.minecraft.world.entity.EnumMainHand;
import org.bukkit.craftbukkit.v1_21_R6.CraftServer;
import org.bukkit.craftbukkit.v1_21_R6.entity.CraftLivingEntity;
import org.bukkit.entity.Mannequin;
import org.bukkit.entity.Pose;
import org.bukkit.inventory.MainHand;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

@NullMarked
public class CraftMannequin
extends CraftLivingEntity
implements Mannequin {
    public CraftMannequin(CraftServer server, net.minecraft.world.entity.decoration.Mannequin entity) {
        super(server, entity);
    }

    @Override
    public net.minecraft.world.entity.decoration.Mannequin getHandle() {
        return (net.minecraft.world.entity.decoration.Mannequin)this.entity;
    }

    @Override
    public void setPose(Pose pose, boolean fixed) {
        Preconditions.checkArgument((pose != null ? 1 : 0) != 0, (Object)"pose cannot be null");
        EntityPose internalPose = EntityPose.values()[pose.ordinal()];
        if (!net.minecraft.world.entity.decoration.Mannequin.h.contains(internalPose)) {
            throw new IllegalArgumentException("Invalid pose '%s', expected one of: %s".formatted(pose.name(), net.minecraft.world.entity.decoration.Mannequin.h.stream().map(p2 -> Pose.values()[p2.ordinal()]).toList()));
        }
        this.setPose0(internalPose, fixed);
    }

    public ResolvableProfile getProfile() {
        return new PaperResolvableProfile(this.getHandle().k());
    }

    public void setProfile(ResolvableProfile profile) {
        Preconditions.checkArgument((profile != null ? 1 : 0) != 0, (Object)"profile cannot be null");
        this.getHandle().a(((PaperResolvableProfile)profile).getHandle());
    }

    public SkinParts.Mutable getSkinParts() {
        return new PaperSkinParts.Mutable(this.getHandle().aC().a(Avatar.t).byteValue());
    }

    public void setSkinParts(SkinParts parts) {
        Preconditions.checkArgument((parts != null ? 1 : 0) != 0, (Object)"parts cannot be null");
        this.getHandle().aC().a(Avatar.t, (byte)parts.getRaw());
    }

    public boolean isImmovable() {
        return this.getHandle().n();
    }

    public void setImmovable(boolean immovable) {
        this.getHandle().a(immovable);
    }

    public @Nullable Component getDescription() {
        return Optionull.a(this.getHandle().m(), PaperAdventure::asAdventure);
    }

    public void setDescription(@Nullable Component description) {
        if (description == null) {
            this.getHandle().b(true);
        } else {
            this.getHandle().a(PaperAdventure.asVanilla(description));
            this.getHandle().b(false);
        }
    }

    public MainHand getMainHand() {
        return this.getHandle().as() == EnumMainHand.a ? MainHand.LEFT : MainHand.RIGHT;
    }

    public void setMainHand(MainHand hand) {
        Preconditions.checkArgument((hand != null ? 1 : 0) != 0, (Object)"hand cannot be null");
        this.getHandle().a(hand == MainHand.LEFT ? EnumMainHand.a : EnumMainHand.b);
    }
}

