/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R6.entity;

import com.google.common.base.Preconditions;
import io.papermc.paper.registry.HolderableBase;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.animal.EntityPig;
import net.minecraft.world.entity.animal.PigVariant;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import org.bukkit.Material;
import org.bukkit.craftbukkit.v1_21_R6.CraftRegistry;
import org.bukkit.craftbukkit.v1_21_R6.CraftServer;
import org.bukkit.craftbukkit.v1_21_R6.entity.CraftAnimals;
import org.bukkit.entity.Pig;
import org.jspecify.annotations.NullMarked;

@NullMarked
public class CraftPig
extends CraftAnimals
implements Pig {
    public CraftPig(CraftServer server, EntityPig entity) {
        super(server, entity);
    }

    @Override
    public EntityPig getHandle() {
        return (EntityPig)this.entity;
    }

    public boolean hasSaddle() {
        return this.getHandle().am();
    }

    public void setSaddle(boolean saddled) {
        this.getHandle().a(EnumItemSlot.h, saddled ? new ItemStack(Items.oR) : ItemStack.l);
    }

    public int getBoostTicks() {
        return this.getHandle().cv.e ? this.getHandle().cv.d() : 0;
    }

    public void setBoostTicks(int ticks) {
        Preconditions.checkArgument((ticks >= 0 ? 1 : 0) != 0, (Object)"ticks must be >= 0");
        this.getHandle().cv.setBoostTicks(ticks);
    }

    public int getCurrentBoostTicks() {
        return this.getHandle().cv.e ? this.getHandle().cv.f : 0;
    }

    public void setCurrentBoostTicks(int ticks) {
        if (!this.getHandle().cv.e) {
            return;
        }
        int max = this.getHandle().cv.d();
        Preconditions.checkArgument((ticks >= 0 && ticks <= max ? 1 : 0) != 0, (String)"boost ticks must not exceed 0 or %s (inclusive)", (int)max);
        this.getHandle().cv.f = ticks;
    }

    public Material getSteerMaterial() {
        return Material.CARROT_ON_A_STICK;
    }

    public Pig.Variant getVariant() {
        return CraftVariant.minecraftHolderToBukkit(this.getHandle().n());
    }

    public void setVariant(Pig.Variant variant) {
        Preconditions.checkArgument((variant != null ? 1 : 0) != 0, (Object)"variant cannot be null");
        this.getHandle().b(CraftVariant.bukkitToMinecraftHolder(variant));
    }

    public static class CraftVariant
    extends HolderableBase<PigVariant>
    implements Pig.Variant {
        public static Pig.Variant minecraftToBukkit(PigVariant minecraft) {
            return (Pig.Variant)CraftRegistry.minecraftToBukkit(minecraft, Registries.bi);
        }

        public static Pig.Variant minecraftHolderToBukkit(Holder<PigVariant> minecraft) {
            return (Pig.Variant)CraftRegistry.minecraftHolderToBukkit(minecraft, Registries.bi);
        }

        public static PigVariant bukkitToMinecraft(Pig.Variant bukkit) {
            return (PigVariant)CraftRegistry.bukkitToMinecraft(bukkit);
        }

        public static Holder<PigVariant> bukkitToMinecraftHolder(Pig.Variant bukkit) {
            return CraftRegistry.bukkitToMinecraftHolder(bukkit);
        }

        public CraftVariant(Holder<PigVariant> holder) {
            super(holder);
        }
    }
}

