/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R6.entity;

import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.stream.Collectors;
import net.minecraft.core.BaseBlockPosition;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.GlobalPos;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.animal.sniffer.Sniffer;
import net.minecraft.world.level.World;
import org.bukkit.Location;
import org.bukkit.craftbukkit.v1_21_R6.CraftServer;
import org.bukkit.craftbukkit.v1_21_R6.CraftWorld;
import org.bukkit.craftbukkit.v1_21_R6.entity.CraftAnimals;
import org.bukkit.craftbukkit.v1_21_R6.util.CraftLocation;
import org.bukkit.entity.Sniffer;

public class CraftSniffer
extends CraftAnimals
implements Sniffer {
    public CraftSniffer(CraftServer server, net.minecraft.world.entity.animal.sniffer.Sniffer entity) {
        super(server, entity);
    }

    @Override
    public net.minecraft.world.entity.animal.sniffer.Sniffer getHandle() {
        return (net.minecraft.world.entity.animal.sniffer.Sniffer)this.entity;
    }

    public Collection<Location> getExploredLocations() {
        return this.getHandle().ha().map(blockPosition -> CraftLocation.toBukkit((BaseBlockPosition)blockPosition.b(), (World)this.server.getServer().a(blockPosition.a()))).collect(Collectors.toList());
    }

    public void removeExploredLocation(Location location) {
        Preconditions.checkArgument((location != null ? 1 : 0) != 0, (Object)"location cannot be null");
        BlockPosition pos = CraftLocation.toBlockPosition(location);
        World level = location.getWorld() != null ? ((CraftWorld)location.getWorld()).getHandle() : this.getHandle().an();
        GlobalPos globalPos = GlobalPos.a(level.al(), pos);
        this.getHandle().eq().a(MemoryModuleType.aU, this.getHandle().ha().filter(blockPositionExplored -> !blockPositionExplored.equals(globalPos)).collect(Collectors.toList()));
    }

    public void addExploredLocation(Location location) {
        Preconditions.checkArgument((location != null ? 1 : 0) != 0, (Object)"location cannot be null");
        if (location.getWorld() != this.getWorld()) {
            return;
        }
        this.getHandle().i(CraftLocation.toBlockPosition(location));
    }

    public Sniffer.State getState() {
        return this.stateToBukkit(this.getHandle().gV());
    }

    public void setState(Sniffer.State state) {
        Preconditions.checkArgument((state != null ? 1 : 0) != 0, (Object)"state cannot be null");
        this.getHandle().a(this.stateToNMS(state));
    }

    public Location findPossibleDigLocation() {
        return this.getHandle().gK().map(blockPosition -> CraftLocation.toBukkit((BaseBlockPosition)blockPosition, this.getLocation().getWorld())).orElse(null);
    }

    public boolean canDig() {
        return this.getHandle().gL();
    }

    private Sniffer.State stateToNMS(Sniffer.State state) {
        return switch (state) {
            default -> throw new MatchException(null, null);
            case Sniffer.State.IDLING -> Sniffer.State.a;
            case Sniffer.State.FEELING_HAPPY -> Sniffer.State.b;
            case Sniffer.State.SCENTING -> Sniffer.State.c;
            case Sniffer.State.SNIFFING -> Sniffer.State.d;
            case Sniffer.State.SEARCHING -> Sniffer.State.e;
            case Sniffer.State.DIGGING -> Sniffer.State.f;
            case Sniffer.State.RISING -> Sniffer.State.g;
        };
    }

    private Sniffer.State stateToBukkit(Sniffer.State state) {
        return switch (state) {
            default -> throw new MatchException(null, null);
            case Sniffer.State.a -> Sniffer.State.IDLING;
            case Sniffer.State.b -> Sniffer.State.FEELING_HAPPY;
            case Sniffer.State.c -> Sniffer.State.SCENTING;
            case Sniffer.State.d -> Sniffer.State.SNIFFING;
            case Sniffer.State.e -> Sniffer.State.SEARCHING;
            case Sniffer.State.f -> Sniffer.State.DIGGING;
            case Sniffer.State.g -> Sniffer.State.RISING;
        };
    }
}

