/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R6.entity;

import com.destroystokyo.paper.entity.villager.Reputation;
import com.destroystokyo.paper.entity.villager.ReputationType;
import com.google.common.base.Preconditions;
import io.papermc.paper.util.OldEnumHolderable;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.EnumMap;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.world.entity.ai.gossip.Reputation;
import net.minecraft.world.entity.monster.EntityZombie;
import net.minecraft.world.entity.monster.EntityZombieVillager;
import net.minecraft.world.entity.npc.EntityVillager;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.entity.npc.VillagerTrades;
import net.minecraft.world.entity.npc.VillagerType;
import net.minecraft.world.level.block.BlockBed;
import net.minecraft.world.level.block.state.IBlockData;
import org.bukkit.Location;
import org.bukkit.craftbukkit.v1_21_R6.CraftRegistry;
import org.bukkit.craftbukkit.v1_21_R6.CraftServer;
import org.bukkit.craftbukkit.v1_21_R6.entity.CraftAbstractVillager;
import org.bukkit.craftbukkit.v1_21_R6.util.CraftLocation;
import org.bukkit.entity.Villager;
import org.bukkit.entity.ZombieVillager;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.entity.EntityTransformEvent;

public class CraftVillager
extends CraftAbstractVillager
implements Villager {
    public CraftVillager(CraftServer server, EntityVillager entity) {
        super(server, entity);
    }

    @Override
    public EntityVillager getHandle() {
        return (EntityVillager)this.entity;
    }

    @Override
    public void remove() {
        this.getHandle().hl();
        super.remove();
    }

    public Villager.Profession getProfession() {
        return CraftProfession.minecraftHolderToBukkit(this.getHandle().gR().b());
    }

    public void setProfession(Villager.Profession profession) {
        Preconditions.checkArgument((profession != null ? 1 : 0) != 0, (Object)"Profession cannot be null");
        this.getHandle().a(this.getHandle().gR().b(CraftProfession.bukkitToMinecraftHolder(profession)));
    }

    public Villager.Type getVillagerType() {
        return CraftType.minecraftHolderToBukkit(this.getHandle().gR().a());
    }

    public void setVillagerType(Villager.Type type) {
        Preconditions.checkArgument((type != null ? 1 : 0) != 0, (Object)"Type cannot be null");
        this.getHandle().a(this.getHandle().gR().a(CraftType.bukkitToMinecraftHolder(type)));
    }

    public int getVillagerLevel() {
        return this.getHandle().gR().c();
    }

    public void setVillagerLevel(int level) {
        Preconditions.checkArgument((1 <= level && level <= 5 ? 1 : 0) != 0, (String)"level (%s) must be between [1, 5]", (int)level);
        this.getHandle().a(this.getHandle().gR().a(level));
    }

    public int getVillagerExperience() {
        return this.getHandle().s();
    }

    public void setVillagerExperience(int experience) {
        Preconditions.checkArgument((experience >= 0 ? 1 : 0) != 0, (String)"Experience (%s) must be positive", (int)experience);
        this.getHandle().t(experience);
    }

    public boolean increaseLevel(int amount) {
        Preconditions.checkArgument((amount > 0 ? 1 : 0) != 0, (Object)"Level earned must be positive");
        int supposedFinalLevel = this.getVillagerLevel() + amount;
        Preconditions.checkArgument((1 <= supposedFinalLevel && supposedFinalLevel <= 5 ? 1 : 0) != 0, (Object)"Final level reached after the donation (%d) must be between [%d, %d]".formatted(supposedFinalLevel, 1, 5));
        Int2ObjectMap<VillagerTrades.IMerchantRecipeOption[]> trades = VillagerTrades.a.get(this.getHandle().gR().b().e().orElseThrow());
        if (trades == null || trades.isEmpty()) {
            this.getHandle().a(this.getHandle().gR().a(supposedFinalLevel));
            return false;
        }
        while (amount > 0) {
            this.getHandle().hp();
            --amount;
        }
        return true;
    }

    public boolean addTrades(int amount) {
        Preconditions.checkArgument((amount > 0 ? 1 : 0) != 0, (Object)"Number of trades unlocked must be positive");
        return this.getHandle().updateTrades(amount);
    }

    public int getRestocksToday() {
        return this.getHandle().da;
    }

    public void setRestocksToday(int restocksToday) {
        this.getHandle().da = restocksToday;
    }

    public boolean sleep(Location location) {
        Preconditions.checkArgument((location != null ? 1 : 0) != 0, (Object)"Location cannot be null");
        Preconditions.checkArgument((location.getWorld() != null ? 1 : 0) != 0, (Object)"Location needs to be in a world");
        Preconditions.checkArgument((boolean)location.getWorld().equals((Object)this.getWorld()), (Object)"Cannot sleep across worlds");
        Preconditions.checkState((!this.getHandle().generation ? 1 : 0) != 0, (Object)"Cannot sleep during world generation");
        BlockPosition position = CraftLocation.toBlockPosition(location);
        IBlockData state = this.getHandle().an().a_(position);
        if (!(state.b() instanceof BlockBed)) {
            return false;
        }
        this.getHandle().b(position);
        return true;
    }

    public void wakeup() {
        Preconditions.checkState((boolean)this.isSleeping(), (Object)"Cannot wakeup if not sleeping");
        Preconditions.checkState((!this.getHandle().generation ? 1 : 0) != 0, (Object)"Cannot wakeup during world generation");
        this.getHandle().gh();
    }

    public void shakeHead() {
        this.getHandle().he();
    }

    public ZombieVillager zombify() {
        EntityZombieVillager entityzombievillager = EntityZombie.convertVillagerToZombieVillager(this.getHandle().an().getMinecraftWorld(), this.getHandle(), this.getHandle().dF(), this.isSilent(), EntityTransformEvent.TransformReason.INFECTION, CreatureSpawnEvent.SpawnReason.CUSTOM);
        return entityzombievillager != null ? (ZombieVillager)entityzombievillager.getBukkitEntity() : null;
    }

    public Reputation getReputation(UUID uniqueId) {
        Reputation.a rep = this.getHandle().hd().c.get(uniqueId);
        if (rep == null) {
            return new Reputation(new EnumMap(ReputationType.class));
        }
        return rep.getPaperReputation();
    }

    public Map<UUID, Reputation> getReputations() {
        return this.getHandle().hd().c.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> ((Reputation.a)entry.getValue()).getPaperReputation()));
    }

    public void setReputation(UUID uniqueId, Reputation reputation) {
        Reputation.a nmsReputation = this.getHandle().hd().c.computeIfAbsent(uniqueId, key -> new Reputation.a());
        nmsReputation.assignFromPaperReputation(reputation);
    }

    public void setReputations(Map<UUID, Reputation> reputations) {
        for (Map.Entry<UUID, Reputation> entry : reputations.entrySet()) {
            this.setReputation(entry.getKey(), entry.getValue());
        }
    }

    public void clearReputations() {
        this.getHandle().hd().c.clear();
    }

    public void updateDemand() {
        this.getHandle().hk();
    }

    public void restock() {
        this.getHandle().gV();
    }

    public boolean isLobotomized() {
        return this.getHandle().isLobotomized();
    }

    public static class CraftProfession
    extends OldEnumHolderable<Villager.Profession, VillagerProfession>
    implements Villager.Profession {
        private static int count = 0;

        public static Villager.Profession minecraftHolderToBukkit(Holder<VillagerProfession> minecraft) {
            return (Villager.Profession)CraftRegistry.minecraftHolderToBukkit(minecraft, Registries.aI);
        }

        public static Holder<VillagerProfession> bukkitToMinecraftHolder(Villager.Profession bukkit) {
            return CraftRegistry.bukkitToMinecraftHolder(bukkit);
        }

        public static Villager.Profession minecraftToBukkit(VillagerProfession minecraft) {
            return (Villager.Profession)CraftRegistry.minecraftToBukkit(minecraft, Registries.aI);
        }

        public static VillagerProfession bukkitToMinecraft(Villager.Profession bukkit) {
            return (VillagerProfession)CraftRegistry.bukkitToMinecraft(bukkit);
        }

        public CraftProfession(Holder<VillagerProfession> holder) {
            super(holder, count++);
        }
    }

    public static class CraftType
    extends OldEnumHolderable<Villager.Type, VillagerType>
    implements Villager.Type {
        private static int count = 0;

        public static Villager.Type minecraftToBukkit(VillagerType minecraft) {
            return (Villager.Type)CraftRegistry.minecraftToBukkit(minecraft, Registries.aJ);
        }

        public static Villager.Type minecraftHolderToBukkit(Holder<VillagerType> minecraft) {
            return (Villager.Type)CraftRegistry.minecraftHolderToBukkit(minecraft, Registries.aJ);
        }

        public static VillagerType bukkitToMinecraft(Villager.Type bukkit) {
            return (VillagerType)CraftRegistry.bukkitToMinecraft(bukkit);
        }

        public static Holder<VillagerType> bukkitToMinecraftHolder(Villager.Type bukkit) {
            return CraftRegistry.bukkitToMinecraftHolder(bukkit);
        }

        public CraftType(Holder<VillagerType> holder) {
            super(holder, count++);
        }
    }
}

