/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R6.entity;

import com.google.common.base.Preconditions;
import io.papermc.paper.registry.HolderableBase;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.world.entity.animal.wolf.EntityWolf;
import net.minecraft.world.entity.animal.wolf.WolfSoundVariant;
import net.minecraft.world.entity.animal.wolf.WolfVariant;
import net.minecraft.world.item.EnumColor;
import org.bukkit.DyeColor;
import org.bukkit.craftbukkit.v1_21_R6.CraftRegistry;
import org.bukkit.craftbukkit.v1_21_R6.CraftServer;
import org.bukkit.craftbukkit.v1_21_R6.entity.CraftTameableAnimal;
import org.bukkit.entity.Wolf;

public class CraftWolf
extends CraftTameableAnimal
implements Wolf {
    public CraftWolf(CraftServer server, EntityWolf wolf) {
        super(server, wolf);
    }

    @Override
    public EntityWolf getHandle() {
        return (EntityWolf)this.entity;
    }

    public boolean isAngry() {
        return this.getHandle().ae_();
    }

    public void setAngry(boolean angry) {
        if (angry) {
            this.getHandle().c();
        } else {
            this.getHandle().i();
        }
    }

    public DyeColor getCollarColor() {
        return DyeColor.getByWoolData((byte)((byte)this.getHandle().gX().a()));
    }

    public void setCollarColor(DyeColor color) {
        this.getHandle().a(EnumColor.a(color.getWoolData()));
    }

    public boolean isWet() {
        return this.getHandle().cK;
    }

    public float getTailAngle() {
        return this.getHandle().gW();
    }

    public boolean isInterested() {
        return this.getHandle().gY();
    }

    public void setInterested(boolean interested) {
        this.getHandle().A(interested);
    }

    public Wolf.Variant getVariant() {
        return CraftVariant.minecraftHolderToBukkit(this.getHandle().gZ());
    }

    public void setVariant(Wolf.Variant variant) {
        Preconditions.checkArgument((variant != null ? 1 : 0) != 0, (Object)"variant cannot be null");
        this.getHandle().b(CraftVariant.bukkitToMinecraftHolder(variant));
    }

    public Wolf.SoundVariant getSoundVariant() {
        return CraftSoundVariant.minecraftHolderToBukkit(this.getHandle().ha());
    }

    public void setSoundVariant(Wolf.SoundVariant soundVariant) {
        Preconditions.checkArgument((soundVariant != null ? 1 : 0) != 0, (Object)"soundVariant cannot be null");
        this.getHandle().k(CraftSoundVariant.bukkitToMinecraftHolder(soundVariant));
    }

    public boolean isRabid() {
        return this.getHandle().isRabid();
    }

    public void setRabid(boolean isRabid) {
        this.getHandle().setRabid(isRabid);
    }

    public static class CraftVariant
    extends HolderableBase<WolfVariant>
    implements Wolf.Variant {
        public static Wolf.Variant minecraftToBukkit(WolfVariant minecraft) {
            return (Wolf.Variant)CraftRegistry.minecraftToBukkit(minecraft, Registries.bu);
        }

        public static Wolf.Variant minecraftHolderToBukkit(Holder<WolfVariant> minecraft) {
            return (Wolf.Variant)CraftRegistry.minecraftHolderToBukkit(minecraft, Registries.bu);
        }

        public static WolfVariant bukkitToMinecraft(Wolf.Variant bukkit) {
            return (WolfVariant)CraftRegistry.bukkitToMinecraft(bukkit);
        }

        public static Holder<WolfVariant> bukkitToMinecraftHolder(Wolf.Variant bukkit) {
            return CraftRegistry.bukkitToMinecraftHolder(bukkit);
        }

        public CraftVariant(Holder<WolfVariant> holder) {
            super(holder);
        }
    }

    public static class CraftSoundVariant
    extends HolderableBase<WolfSoundVariant>
    implements Wolf.SoundVariant {
        public static Wolf.SoundVariant minecraftToBukkit(WolfSoundVariant minecraft) {
            return (Wolf.SoundVariant)CraftRegistry.minecraftToBukkit(minecraft, Registries.bv);
        }

        public static Wolf.SoundVariant minecraftHolderToBukkit(Holder<WolfSoundVariant> minecraft) {
            return (Wolf.SoundVariant)CraftRegistry.minecraftHolderToBukkit(minecraft, Registries.bv);
        }

        public static WolfSoundVariant bukkitToMinecraft(Wolf.SoundVariant bukkit) {
            return (WolfSoundVariant)CraftRegistry.bukkitToMinecraft(bukkit);
        }

        public static Holder<WolfSoundVariant> bukkitToMinecraftHolder(Wolf.SoundVariant bukkit) {
            return CraftRegistry.bukkitToMinecraftHolder(bukkit);
        }

        public CraftSoundVariant(Holder<WolfSoundVariant> holder) {
            super(holder);
        }
    }
}

