/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R6.event;

import com.destroystokyo.paper.event.entity.EntityKnockbackByEntityEvent;
import com.destroystokyo.paper.event.entity.EntityZapEvent;
import com.destroystokyo.paper.event.entity.ExperienceOrbMergeEvent;
import com.destroystokyo.paper.event.entity.ProjectileCollideEvent;
import com.destroystokyo.paper.event.entity.WitchReadyPotionEvent;
import com.destroystokyo.paper.event.inventory.PrepareResultEvent;
import com.destroystokyo.paper.event.player.PlayerUseUnknownEntityEvent;
import com.google.common.base.Functions;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.util.concurrent.Runnables;
import com.mojang.authlib.GameProfile;
import com.mojang.datafixers.util.Either;
import com.mojang.datafixers.util.Pair;
import io.papermc.paper.adventure.PaperAdventure;
import io.papermc.paper.connection.HorriblePlayerLoginEventHack;
import io.papermc.paper.connection.PlayerConnection;
import io.papermc.paper.event.block.BellRingEvent;
import io.papermc.paper.event.block.BlockFailedDispenseEvent;
import io.papermc.paper.event.block.BlockPreDispenseEvent;
import io.papermc.paper.event.connection.PlayerConnectionValidateLoginEvent;
import io.papermc.paper.event.entity.EntityFertilizeEggEvent;
import io.papermc.paper.event.entity.EntityKnockbackEvent;
import io.papermc.paper.event.entity.ItemTransportingEntityValidateTargetEvent;
import io.papermc.paper.event.entity.WaterBottleSplashEvent;
import io.papermc.paper.util.TransformingRandomAccessList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.kyori.adventure.text.Component;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.dispenser.IDispenseBehavior;
import net.minecraft.core.dispenser.SourceBlock;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.protocol.game.PacketPlayInCloseWindow;
import net.minecraft.network.protocol.game.PacketPlayInUseEntity;
import net.minecraft.network.protocol.game.PacketPlayOutAttachEntity;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.server.players.PlayerList;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.util.Unit;
import net.minecraft.world.EnumHand;
import net.minecraft.world.IInventory;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityAreaEffectCloud;
import net.minecraft.world.entity.EntityCreature;
import net.minecraft.world.entity.EntityExperienceOrb;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.Leashable;
import net.minecraft.world.entity.animal.EntityAnimal;
import net.minecraft.world.entity.animal.EntityFish;
import net.minecraft.world.entity.item.EntityItem;
import net.minecraft.world.entity.monster.EntityIllagerWizard;
import net.minecraft.world.entity.monster.EntityStrider;
import net.minecraft.world.entity.monster.EntityWitch;
import net.minecraft.world.entity.monster.piglin.EntityPiglin;
import net.minecraft.world.entity.npc.EntityVillager;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.projectile.EntityFireworks;
import net.minecraft.world.entity.projectile.EntityPotion;
import net.minecraft.world.entity.projectile.IProjectile;
import net.minecraft.world.entity.projectile.ThrownLingeringPotion;
import net.minecraft.world.entity.projectile.ThrownSplashPotion;
import net.minecraft.world.entity.raid.EntityRaider;
import net.minecraft.world.inventory.Container;
import net.minecraft.world.inventory.ContainerMerchant;
import net.minecraft.world.inventory.InventoryCrafting;
import net.minecraft.world.inventory.RecipeBookType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.ItemActionContext;
import net.minecraft.world.item.crafting.RecipeCrafting;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.block.BlockDispenser;
import net.minecraft.world.level.block.entity.TileEntitySign;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockPropertyInstrument;
import net.minecraft.world.level.storage.loot.LootTableInfo;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameters;
import net.minecraft.world.phys.MovingObjectPosition;
import net.minecraft.world.phys.MovingObjectPositionBlock;
import net.minecraft.world.phys.MovingObjectPositionEntity;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.Bukkit;
import org.bukkit.Chunk;
import org.bukkit.Instrument;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Note;
import org.bukkit.PortalType;
import org.bukkit.Raid;
import org.bukkit.SoundCategory;
import org.bukkit.Statistic;
import org.bukkit.World;
import org.bukkit.attribute.Attribute;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.BlockState;
import org.bukkit.block.CreatureSpawner;
import org.bukkit.block.Sign;
import org.bukkit.block.TrialSpawner;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.sign.Side;
import org.bukkit.craftbukkit.v1_21_R6.CraftChunk;
import org.bukkit.craftbukkit.v1_21_R6.CraftEquipmentSlot;
import org.bukkit.craftbukkit.v1_21_R6.CraftExplosionResult;
import org.bukkit.craftbukkit.v1_21_R6.CraftLootTable;
import org.bukkit.craftbukkit.v1_21_R6.CraftRaid;
import org.bukkit.craftbukkit.v1_21_R6.CraftServer;
import org.bukkit.craftbukkit.v1_21_R6.CraftSound;
import org.bukkit.craftbukkit.v1_21_R6.CraftStatistic;
import org.bukkit.craftbukkit.v1_21_R6.CraftWorld;
import org.bukkit.craftbukkit.v1_21_R6.block.CraftBlock;
import org.bukkit.craftbukkit.v1_21_R6.block.CraftBlockState;
import org.bukkit.craftbukkit.v1_21_R6.block.CraftBlockStates;
import org.bukkit.craftbukkit.v1_21_R6.block.data.CraftBlockData;
import org.bukkit.craftbukkit.v1_21_R6.damage.CraftDamageSource;
import org.bukkit.craftbukkit.v1_21_R6.entity.CraftEntity;
import org.bukkit.craftbukkit.v1_21_R6.entity.CraftHumanEntity;
import org.bukkit.craftbukkit.v1_21_R6.entity.CraftItem;
import org.bukkit.craftbukkit.v1_21_R6.entity.CraftLivingEntity;
import org.bukkit.craftbukkit.v1_21_R6.entity.CraftPlayer;
import org.bukkit.craftbukkit.v1_21_R6.entity.CraftSpellcaster;
import org.bukkit.craftbukkit.v1_21_R6.event.PortalEventResult;
import org.bukkit.craftbukkit.v1_21_R6.inventory.CraftInventoryCrafting;
import org.bukkit.craftbukkit.v1_21_R6.inventory.CraftItemStack;
import org.bukkit.craftbukkit.v1_21_R6.inventory.CraftItemType;
import org.bukkit.craftbukkit.v1_21_R6.potion.CraftPotionUtil;
import org.bukkit.craftbukkit.v1_21_R6.util.CraftNamespacedKey;
import org.bukkit.craftbukkit.v1_21_R6.util.CraftVector;
import org.bukkit.damage.DamageSource;
import org.bukkit.entity.AbstractHorse;
import org.bukkit.entity.AnimalTamer;
import org.bukkit.entity.Animals;
import org.bukkit.entity.AreaEffectCloud;
import org.bukkit.entity.Bat;
import org.bukkit.entity.Creeper;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.ExperienceOrb;
import org.bukkit.entity.Explosive;
import org.bukkit.entity.Firework;
import org.bukkit.entity.Fish;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Item;
import org.bukkit.entity.LightningStrike;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Pig;
import org.bukkit.entity.PigZombie;
import org.bukkit.entity.Piglin;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.entity.Raider;
import org.bukkit.entity.Spellcaster;
import org.bukkit.entity.Strider;
import org.bukkit.entity.TNTPrimed;
import org.bukkit.entity.ThrownExpBottle;
import org.bukkit.entity.ThrownPotion;
import org.bukkit.entity.Vehicle;
import org.bukkit.entity.Villager;
import org.bukkit.entity.Witch;
import org.bukkit.event.Cancellable;
import org.bukkit.event.Event;
import org.bukkit.event.block.Action;
import org.bukkit.event.block.BellResonateEvent;
import org.bukkit.event.block.BlockDamageAbortEvent;
import org.bukkit.event.block.BlockDamageEvent;
import org.bukkit.event.block.BlockDispenseEvent;
import org.bukkit.event.block.BlockDispenseLootEvent;
import org.bukkit.event.block.BlockDropItemEvent;
import org.bukkit.event.block.BlockExplodeEvent;
import org.bukkit.event.block.BlockFadeEvent;
import org.bukkit.event.block.BlockFormEvent;
import org.bukkit.event.block.BlockGrowEvent;
import org.bukkit.event.block.BlockIgniteEvent;
import org.bukkit.event.block.BlockMultiPlaceEvent;
import org.bukkit.event.block.BlockPhysicsEvent;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.event.block.BlockRedstoneEvent;
import org.bukkit.event.block.BlockShearEntityEvent;
import org.bukkit.event.block.BlockSpreadEvent;
import org.bukkit.event.block.CrafterCraftEvent;
import org.bukkit.event.block.EntityBlockFormEvent;
import org.bukkit.event.block.FluidLevelChangeEvent;
import org.bukkit.event.block.MoistureChangeEvent;
import org.bukkit.event.block.NotePlayEvent;
import org.bukkit.event.block.TNTPrimeEvent;
import org.bukkit.event.block.VaultDisplayItemEvent;
import org.bukkit.event.entity.AreaEffectCloudApplyEvent;
import org.bukkit.event.entity.ArrowBodyCountChangeEvent;
import org.bukkit.event.entity.BatToggleSleepEvent;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.entity.CreeperPowerEvent;
import org.bukkit.event.entity.EntityBreakDoorEvent;
import org.bukkit.event.entity.EntityBreedEvent;
import org.bukkit.event.entity.EntityChangeBlockEvent;
import org.bukkit.event.entity.EntityDamageByBlockEvent;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.event.entity.EntityEnterLoveModeEvent;
import org.bukkit.event.entity.EntityExhaustionEvent;
import org.bukkit.event.entity.EntityExplodeEvent;
import org.bukkit.event.entity.EntityInteractEvent;
import org.bukkit.event.entity.EntityKnockbackEvent;
import org.bukkit.event.entity.EntityPickupItemEvent;
import org.bukkit.event.entity.EntityPlaceEvent;
import org.bukkit.event.entity.EntityPortalEvent;
import org.bukkit.event.entity.EntityPotionEffectEvent;
import org.bukkit.event.entity.EntityRemoveEvent;
import org.bukkit.event.entity.EntityShootBowEvent;
import org.bukkit.event.entity.EntitySpawnEvent;
import org.bukkit.event.entity.EntitySpellCastEvent;
import org.bukkit.event.entity.EntityTameEvent;
import org.bukkit.event.entity.EntityTargetEvent;
import org.bukkit.event.entity.EntityTargetLivingEntityEvent;
import org.bukkit.event.entity.EntityTeleportEvent;
import org.bukkit.event.entity.EntityToggleGlideEvent;
import org.bukkit.event.entity.EntityToggleSwimEvent;
import org.bukkit.event.entity.EntityTransformEvent;
import org.bukkit.event.entity.ExpBottleEvent;
import org.bukkit.event.entity.ExplosionPrimeEvent;
import org.bukkit.event.entity.FireworkExplodeEvent;
import org.bukkit.event.entity.FoodLevelChangeEvent;
import org.bukkit.event.entity.HorseJumpEvent;
import org.bukkit.event.entity.ItemDespawnEvent;
import org.bukkit.event.entity.ItemMergeEvent;
import org.bukkit.event.entity.ItemSpawnEvent;
import org.bukkit.event.entity.LingeringPotionSplashEvent;
import org.bukkit.event.entity.PigZapEvent;
import org.bukkit.event.entity.PiglinBarterEvent;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.event.entity.PlayerLeashEntityEvent;
import org.bukkit.event.entity.PotionSplashEvent;
import org.bukkit.event.entity.ProjectileHitEvent;
import org.bukkit.event.entity.ProjectileLaunchEvent;
import org.bukkit.event.entity.SpawnerSpawnEvent;
import org.bukkit.event.entity.StriderTemperatureChangeEvent;
import org.bukkit.event.entity.TrialSpawnerSpawnEvent;
import org.bukkit.event.entity.VillagerCareerChangeEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.inventory.InventoryOpenEvent;
import org.bukkit.event.inventory.PrepareAnvilEvent;
import org.bukkit.event.inventory.PrepareGrindstoneEvent;
import org.bukkit.event.inventory.PrepareItemCraftEvent;
import org.bukkit.event.inventory.PrepareSmithingEvent;
import org.bukkit.event.inventory.TradeSelectEvent;
import org.bukkit.event.player.PlayerBedEnterEvent;
import org.bukkit.event.player.PlayerBucketEmptyEvent;
import org.bukkit.event.player.PlayerBucketEntityEvent;
import org.bukkit.event.player.PlayerBucketFillEvent;
import org.bukkit.event.player.PlayerBucketFishEvent;
import org.bukkit.event.player.PlayerEditBookEvent;
import org.bukkit.event.player.PlayerEvent;
import org.bukkit.event.player.PlayerExpChangeEvent;
import org.bukkit.event.player.PlayerExpCooldownChangeEvent;
import org.bukkit.event.player.PlayerHarvestBlockEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerItemBreakEvent;
import org.bukkit.event.player.PlayerItemMendEvent;
import org.bukkit.event.player.PlayerLevelChangeEvent;
import org.bukkit.event.player.PlayerLoginEvent;
import org.bukkit.event.player.PlayerPortalEvent;
import org.bukkit.event.player.PlayerRecipeBookClickEvent;
import org.bukkit.event.player.PlayerRecipeBookSettingsChangeEvent;
import org.bukkit.event.player.PlayerRecipeDiscoverEvent;
import org.bukkit.event.player.PlayerRiptideEvent;
import org.bukkit.event.player.PlayerShearEntityEvent;
import org.bukkit.event.player.PlayerSignOpenEvent;
import org.bukkit.event.player.PlayerStatisticIncrementEvent;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.event.player.PlayerUnleashEntityEvent;
import org.bukkit.event.raid.RaidFinishEvent;
import org.bukkit.event.raid.RaidSpawnWaveEvent;
import org.bukkit.event.raid.RaidStopEvent;
import org.bukkit.event.raid.RaidTriggerEvent;
import org.bukkit.event.vehicle.VehicleCreateEvent;
import org.bukkit.event.weather.LightningStrikeEvent;
import org.bukkit.event.world.EntitiesLoadEvent;
import org.bukkit.event.world.EntitiesUnloadEvent;
import org.bukkit.event.world.LootGenerateEvent;
import org.bukkit.inventory.AnvilInventory;
import org.bukkit.inventory.CraftingInventory;
import org.bukkit.inventory.CraftingRecipe;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.GrindstoneInventory;
import org.bukkit.inventory.InventoryView;
import org.bukkit.inventory.Recipe;
import org.bukkit.inventory.SmithingInventory;
import org.bukkit.inventory.meta.BookMeta;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.view.AnvilView;
import org.bukkit.inventory.view.MerchantView;
import org.bukkit.loot.LootTable;
import org.bukkit.potion.PotionEffect;
import org.bukkit.util.Vector;
import org.jetbrains.annotations.Nullable;

public class CraftEventFactory {
    public static BlockPosition sourceBlockOverride = null;
    private static final Function<org.bukkit.inventory.ItemStack, Entity.DefaultDrop> FROM_FUNCTION = stack -> {
        if (stack == null) {
            return null;
        }
        return new Entity.DefaultDrop(CraftItemType.bukkitToMinecraft(stack.getType()), (org.bukkit.inventory.ItemStack)stack, null);
    };
    private static final com.google.common.base.Function<? super Double, Double> ZERO = Functions.constant((Object)-0.0);

    private static boolean canBuild(net.minecraft.world.level.World world, Player player, int x2, int z2) {
        return world.a((net.minecraft.world.entity.Entity)((CraftPlayer)player).getHandle(), new BlockPosition(x2, 0, z2));
    }

    public static boolean callPlayerSignOpenEvent(EntityHuman player, TileEntitySign signBlockEntity, boolean front, PlayerSignOpenEvent.Cause cause) {
        CraftBlock block = CraftBlock.at(signBlockEntity.j(), signBlockEntity.aD_());
        Sign sign = (Sign)CraftBlockStates.getBlockState(block);
        Side side = front ? Side.FRONT : Side.BACK;
        return CraftEventFactory.callPlayerSignOpenEvent((Player)player.getBukkitEntity(), sign, side, cause);
    }

    public static boolean callPlayerSignOpenEvent(Player player, Sign sign, Side side, PlayerSignOpenEvent.Cause cause) {
        PlayerSignOpenEvent event = new PlayerSignOpenEvent(player, sign, side, cause);
        Bukkit.getPluginManager().callEvent((Event)event);
        return !event.isCancelled();
    }

    public static Either<EntityHuman.EnumBedResult, Unit> callPlayerBedEnterEvent(EntityHuman player, BlockPosition bed, Either<EntityHuman.EnumBedResult, Unit> nmsBedResult) {
        PlayerBedEnterEvent.BedEnterResult bedEnterResult = (PlayerBedEnterEvent.BedEnterResult)nmsBedResult.mapBoth(sleepingProblem -> switch (sleepingProblem) {
            case EntityHuman.EnumBedResult.a -> PlayerBedEnterEvent.BedEnterResult.NOT_POSSIBLE_HERE;
            case EntityHuman.EnumBedResult.b -> PlayerBedEnterEvent.BedEnterResult.NOT_POSSIBLE_NOW;
            case EntityHuman.EnumBedResult.c -> PlayerBedEnterEvent.BedEnterResult.TOO_FAR_AWAY;
            case EntityHuman.EnumBedResult.f -> PlayerBedEnterEvent.BedEnterResult.NOT_SAFE;
            case EntityHuman.EnumBedResult.d -> PlayerBedEnterEvent.BedEnterResult.OBSTRUCTED;
            default -> PlayerBedEnterEvent.BedEnterResult.OTHER_PROBLEM;
        }, t2 -> PlayerBedEnterEvent.BedEnterResult.OK).map(Function.identity(), Function.identity());
        PlayerBedEnterEvent event = new PlayerBedEnterEvent((Player)player.getBukkitEntity(), (Block)CraftBlock.at(player.an(), bed), bedEnterResult);
        Bukkit.getServer().getPluginManager().callEvent((Event)event);
        Event.Result result = event.useBed();
        if (result == Event.Result.ALLOW) {
            return Either.right(Unit.a);
        }
        if (result == Event.Result.DENY) {
            return Either.left(EntityHuman.EnumBedResult.e);
        }
        return nmsBedResult;
    }

    public static EntityEnterLoveModeEvent callEntityEnterLoveModeEvent(EntityHuman entityHuman, EntityAnimal entityAnimal, int loveTicks) {
        EntityEnterLoveModeEvent entityEnterLoveModeEvent = new EntityEnterLoveModeEvent((Animals)entityAnimal.getBukkitEntity(), (HumanEntity)(entityHuman != null ? entityHuman.getBukkitEntity() : null), loveTicks);
        Bukkit.getPluginManager().callEvent((Event)entityEnterLoveModeEvent);
        return entityEnterLoveModeEvent;
    }

    public static PlayerHarvestBlockEvent callPlayerHarvestBlockEvent(net.minecraft.world.level.World world, BlockPosition pos, EntityHuman player, EnumHand hand, List<ItemStack> itemsToHarvest) {
        ArrayList bukkitItemsToHarvest = new ArrayList(itemsToHarvest.stream().map(CraftItemStack::asBukkitCopy).collect(Collectors.toList()));
        PlayerHarvestBlockEvent playerHarvestBlockEvent = new PlayerHarvestBlockEvent((Player)player.getBukkitEntity(), (Block)CraftBlock.at(world, pos), CraftEquipmentSlot.getHand(hand), bukkitItemsToHarvest);
        Bukkit.getPluginManager().callEvent((Event)playerHarvestBlockEvent);
        return playerHarvestBlockEvent;
    }

    public static PlayerBucketEntityEvent callPlayerFishBucketEvent(EntityLiving fish, EntityHuman entityHuman, ItemStack originalBucket, ItemStack entityBucket, EnumHand hand) {
        Player player = (Player)entityHuman.getBukkitEntity();
        EquipmentSlot handSlot = CraftEquipmentSlot.getHand(hand);
        Object event = fish instanceof EntityFish ? new PlayerBucketFishEvent(player, (Fish)fish.getBukkitEntity(), CraftItemStack.asBukkitCopy(originalBucket), CraftItemStack.asBukkitCopy(entityBucket), handSlot) : new PlayerBucketEntityEvent(player, (Entity)fish.getBukkitEntity(), CraftItemStack.asBukkitCopy(originalBucket), CraftItemStack.asBukkitCopy(entityBucket), handSlot);
        Bukkit.getPluginManager().callEvent((Event)event);
        return event;
    }

    public static TradeSelectEvent callTradeSelectEvent(int newIndex, ContainerMerchant merchant) {
        TradeSelectEvent tradeSelectEvent = new TradeSelectEvent((MerchantView)merchant.getBukkitView(), newIndex);
        Bukkit.getPluginManager().callEvent((Event)tradeSelectEvent);
        return tradeSelectEvent;
    }

    public static boolean handleBellRingEvent(net.minecraft.world.level.World world, BlockPosition position, EnumDirection direction, net.minecraft.world.entity.Entity entity) {
        CraftBlock block = CraftBlock.at(world, position);
        BlockFace bukkitDirection = CraftBlock.notchToBlockFace(direction);
        BellRingEvent event = new BellRingEvent((Block)block, bukkitDirection, (Entity)(entity != null ? entity.getBukkitEntity() : null));
        Bukkit.getPluginManager().callEvent((Event)event);
        return !event.isCancelled();
    }

    public static Stream<EntityLiving> handleBellResonateEvent(net.minecraft.world.level.World world, BlockPosition position, List<LivingEntity> bukkitEntities) {
        CraftBlock block = CraftBlock.at(world, position);
        BellResonateEvent event = new BellResonateEvent((Block)block, bukkitEntities);
        Bukkit.getPluginManager().callEvent((Event)event);
        return event.getResonatedEntities().stream().map(bukkitEntity -> ((CraftLivingEntity)bukkitEntity).getHandle());
    }

    public static BlockMultiPlaceEvent callBlockMultiPlaceEvent(WorldServer level, EntityHuman player, EnumHand hand, List<BlockState> blockStates, BlockPosition clickedPos) {
        Player cplayer = (Player)player.getBukkitEntity();
        CraftBlock clickedBlock = CraftBlock.at(level, clickedPos);
        boolean canBuild = true;
        for (BlockState blockState : blockStates) {
            if (CraftEventFactory.canBuild(level, cplayer, blockState.getX(), blockState.getZ())) continue;
            canBuild = false;
            break;
        }
        EquipmentSlot handSlot = CraftEquipmentSlot.getHand(hand);
        BlockMultiPlaceEvent event = new BlockMultiPlaceEvent(blockStates, (Block)clickedBlock, cplayer.getInventory().getItem(handSlot), cplayer, canBuild, handSlot);
        event.callEvent();
        return event;
    }

    public static BlockPlaceEvent callBlockPlaceEvent(WorldServer level, EntityHuman player, EnumHand hand, BlockState replacedSnapshot, BlockPosition clickedPos) {
        Player cplayer = (Player)player.getBukkitEntity();
        CraftBlock clickedBlock = CraftBlock.at(level, clickedPos);
        Block placedBlock = replacedSnapshot.getBlock();
        boolean canBuild = CraftEventFactory.canBuild(level, cplayer, placedBlock.getX(), placedBlock.getZ());
        EquipmentSlot handSlot = CraftEquipmentSlot.getHand(hand);
        BlockPlaceEvent event = new BlockPlaceEvent(placedBlock, replacedSnapshot, (Block)clickedBlock, cplayer.getInventory().getItem(handSlot), cplayer, canBuild, handSlot);
        event.callEvent();
        return event;
    }

    public static void handleBlockDropItemEvent(Block block, BlockState state, EntityPlayer player, List<EntityItem> items) {
        ArrayList<Item> list = new ArrayList<Item>();
        for (EntityItem item : items) {
            list.add((Item)item.getBukkitEntity());
        }
        BlockDropItemEvent event = new BlockDropItemEvent(block, state, (Player)player.getBukkitEntity(), list);
        Bukkit.getPluginManager().callEvent((Event)event);
        if (!event.isCancelled()) {
            for (Item bukkit : list) {
                if (bukkit.isValid()) continue;
                EntityItem item = ((CraftItem)bukkit).getHandle();
                item.an().b(item);
            }
        } else {
            for (Item bukkit : list) {
                if (!bukkit.isValid()) continue;
                bukkit.remove();
            }
        }
    }

    public static EntityPlaceEvent callEntityPlaceEvent(ItemActionContext context, net.minecraft.world.entity.Entity entity) {
        return CraftEventFactory.callEntityPlaceEvent(context.q(), context.a(), context.k(), context.o(), entity, context.p());
    }

    public static EntityPlaceEvent callEntityPlaceEvent(net.minecraft.world.level.World world, BlockPosition clickedPos, EnumDirection clickedFace, EntityHuman player, net.minecraft.world.entity.Entity entity, EnumHand hand) {
        Player cplayer = player == null ? null : (Player)player.getBukkitEntity();
        CraftBlock clickedBlock = CraftBlock.at(world, clickedPos);
        BlockFace blockFace = CraftBlock.notchToBlockFace(clickedFace);
        EntityPlaceEvent event = new EntityPlaceEvent((Entity)entity.getBukkitEntity(), cplayer, (Block)clickedBlock, blockFace, CraftEquipmentSlot.getHand(hand));
        entity.an().getCraftServer().getPluginManager().callEvent((Event)event);
        return event;
    }

    public static PlayerBucketEmptyEvent callPlayerBucketEmptyEvent(net.minecraft.world.level.World world, EntityHuman player, BlockPosition changed, BlockPosition clicked, EnumDirection clickedFace, ItemStack itemInHand, EnumHand hand) {
        return (PlayerBucketEmptyEvent)CraftEventFactory.getPlayerBucketEvent(false, world, player, changed, clicked, clickedFace, itemInHand, Items.sk, hand);
    }

    public static PlayerBucketFillEvent callPlayerBucketFillEvent(net.minecraft.world.level.World world, EntityHuman player, BlockPosition changed, BlockPosition clicked, EnumDirection clickedFace, ItemStack itemInHand, net.minecraft.world.item.Item bucket, EnumHand hand) {
        return (PlayerBucketFillEvent)CraftEventFactory.getPlayerBucketEvent(true, world, player, clicked, changed, clickedFace, itemInHand, bucket, hand);
    }

    private static PlayerEvent getPlayerBucketEvent(boolean isFilling, net.minecraft.world.level.World world, EntityHuman player, BlockPosition changed, BlockPosition clicked, EnumDirection clickedFace, ItemStack bucket, net.minecraft.world.item.Item item, EnumHand hand) {
        PlayerBucketFillEvent event;
        Player cplayer = (Player)player.getBukkitEntity();
        CraftItemStack itemInHand = CraftItemStack.asNewCraftStack(item);
        Material bucketItem = CraftItemType.minecraftToBukkit(bucket.h());
        CraftBlock block = CraftBlock.at(world, changed);
        CraftBlock clickedBlock = CraftBlock.at(world, clicked);
        BlockFace blockFace = CraftBlock.notchToBlockFace(clickedFace);
        EquipmentSlot handSlot = CraftEquipmentSlot.getHand(hand);
        if (isFilling) {
            event = new PlayerBucketFillEvent(cplayer, (Block)block, (Block)clickedBlock, blockFace, bucketItem, (org.bukkit.inventory.ItemStack)itemInHand, handSlot);
            event.setCancelled(!CraftEventFactory.canBuild(world, cplayer, changed.u(), changed.w()));
        } else {
            event = new PlayerBucketEmptyEvent(cplayer, (Block)block, (Block)clickedBlock, blockFace, bucketItem, (org.bukkit.inventory.ItemStack)itemInHand, handSlot);
            ((PlayerBucketEmptyEvent)event).setCancelled(!CraftEventFactory.canBuild(world, cplayer, changed.u(), changed.w()));
        }
        event.callEvent();
        return event;
    }

    public static PlayerInteractEvent callPlayerInteractEvent(EntityHuman player, Action action, ItemStack item, EnumHand hand) {
        if (action != Action.LEFT_CLICK_AIR && action != Action.RIGHT_CLICK_AIR) {
            throw new AssertionError((Object)String.format("%s performing %s with %s", player, action, item));
        }
        return CraftEventFactory.callPlayerInteractEvent(player, action, null, EnumDirection.d, item, hand);
    }

    public static PlayerInteractEvent callPlayerInteractEvent(EntityHuman player, Action action, BlockPosition pos, EnumDirection direction, ItemStack item, EnumHand hand) {
        return CraftEventFactory.callPlayerInteractEvent(player, action, pos, direction, item, false, hand, null);
    }

    public static PlayerInteractEvent callPlayerInteractEvent(EntityHuman player, Action action, BlockPosition pos, EnumDirection direction, ItemStack item, boolean cancelledBlock, EnumHand hand, Vec3D targetPos) {
        return CraftEventFactory.callPlayerInteractEvent(player, action, pos, direction, item, cancelledBlock, false, hand, targetPos);
    }

    public static PlayerInteractEvent callPlayerInteractEvent(EntityHuman player, Action action, BlockPosition pos, EnumDirection direction, ItemStack item, boolean cancelledBlock, boolean cancelledItem, EnumHand hand, Vec3D targetPos) {
        Player cplayer = player == null ? null : (Player)player.getBukkitEntity();
        CraftItemStack itemInHand = CraftItemStack.asCraftMirror(item);
        Vector clickedPos = null;
        if (pos != null && targetPos != null) {
            clickedPos = CraftVector.toBukkit(targetPos.d(Vec3D.a(pos)));
        }
        CraftServer craftServer = (CraftServer)cplayer.getServer();
        CraftBlock clickedBlock = null;
        if (pos != null) {
            clickedBlock = CraftBlock.at(player.an(), pos);
        } else {
            switch (action) {
                case LEFT_CLICK_BLOCK: {
                    action = Action.LEFT_CLICK_AIR;
                    break;
                }
                case RIGHT_CLICK_BLOCK: {
                    action = Action.RIGHT_CLICK_AIR;
                }
            }
        }
        BlockFace blockFace = CraftBlock.notchToBlockFace(direction);
        if (itemInHand.isEmpty()) {
            itemInHand = null;
        }
        PlayerInteractEvent event = new PlayerInteractEvent(cplayer, action, (org.bukkit.inventory.ItemStack)itemInHand, (Block)clickedBlock, blockFace, hand == null ? null : (hand == EnumHand.b ? EquipmentSlot.OFF_HAND : EquipmentSlot.HAND), clickedPos);
        if (cancelledBlock) {
            event.setUseInteractedBlock(Event.Result.DENY);
        }
        if (cancelledItem) {
            event.setUseItemInHand(Event.Result.DENY);
        }
        craftServer.getPluginManager().callEvent((Event)event);
        if (player != null) {
            switch (action) {
                case LEFT_CLICK_BLOCK: 
                case LEFT_CLICK_AIR: {
                    player.processClick(EnumHand.a);
                    break;
                }
                case RIGHT_CLICK_BLOCK: 
                case RIGHT_CLICK_AIR: {
                    player.processClick(EnumHand.b);
                }
            }
        }
        return event;
    }

    public static EntityTransformEvent callEntityTransformEvent(EntityLiving original, EntityLiving converted, EntityTransformEvent.TransformReason transformReason) {
        return CraftEventFactory.callEntityTransformEvent(original, Collections.singletonList(converted), transformReason);
    }

    public static EntityTransformEvent callEntityTransformEvent(EntityLiving original, List<EntityLiving> convertedList, EntityTransformEvent.TransformReason convertType) {
        ArrayList<CraftEntity> list = new ArrayList<CraftEntity>();
        for (EntityLiving entityLiving : convertedList) {
            list.add(entityLiving.getBukkitEntity());
        }
        EntityTransformEvent event = new EntityTransformEvent((Entity)original.getBukkitEntity(), list, convertType);
        Bukkit.getPluginManager().callEvent((Event)event);
        return event;
    }

    public static EntityShootBowEvent callEntityShootBowEvent(EntityLiving entity, ItemStack bow, ItemStack consumableItem, net.minecraft.world.entity.Entity entityArrow, EnumHand hand, float force, boolean consumeItem) {
        LivingEntity shooter = (LivingEntity)entity.getBukkitEntity();
        CraftItemStack itemInHand = CraftItemStack.asCraftMirror(bow);
        CraftItemStack itemConsumable = CraftItemStack.asCraftMirror(consumableItem);
        CraftEntity arrow = entityArrow.getBukkitEntity();
        if (itemInHand.isEmpty()) {
            itemInHand = null;
        }
        EntityShootBowEvent event = new EntityShootBowEvent(shooter, (org.bukkit.inventory.ItemStack)itemInHand, (org.bukkit.inventory.ItemStack)itemConsumable, (Entity)arrow, CraftEquipmentSlot.getHand(hand), force, consumeItem);
        Bukkit.getPluginManager().callEvent((Event)event);
        return event;
    }

    public static VillagerCareerChangeEvent callVillagerCareerChangeEvent(EntityVillager villager, Villager.Profession future, VillagerCareerChangeEvent.ChangeReason reason) {
        VillagerCareerChangeEvent event = new VillagerCareerChangeEvent((Villager)villager.getBukkitEntity(), future, reason);
        Bukkit.getPluginManager().callEvent((Event)event);
        return event;
    }

    public static BlockDamageEvent callBlockDamageEvent(EntityPlayer player, BlockPosition pos, EnumDirection direction, ItemStack item, boolean instaBreak) {
        CraftItemStack itemInHand = CraftItemStack.asCraftMirror(item);
        CraftBlock clickedBlock = CraftBlock.at(player.A(), pos);
        BlockDamageEvent event = new BlockDamageEvent((Player)player.getBukkitEntity(), (Block)clickedBlock, CraftBlock.notchToBlockFace(direction), (org.bukkit.inventory.ItemStack)itemInHand, instaBreak);
        event.callEvent();
        return event;
    }

    public static BlockDamageAbortEvent callBlockDamageAbortEvent(EntityPlayer player, BlockPosition pos, ItemStack item) {
        CraftItemStack itemInHand = CraftItemStack.asCraftMirror(item);
        CraftBlock clickedBlock = CraftBlock.at(player.A(), pos);
        BlockDamageAbortEvent event = new BlockDamageAbortEvent((Player)player.getBukkitEntity(), (Block)clickedBlock, (org.bukkit.inventory.ItemStack)itemInHand);
        event.callEvent();
        return event;
    }

    public static boolean doEntityAddEventCalling(net.minecraft.world.level.World world, net.minecraft.world.entity.Entity entity, CreatureSpawnEvent.SpawnReason spawnReason) {
        if (entity == null) {
            return false;
        }
        ItemSpawnEvent event = null;
        if (entity instanceof EntityLiving && !(entity instanceof EntityPlayer)) {
            event = CraftEventFactory.callCreatureSpawnEvent((EntityLiving)entity, spawnReason);
        } else if (entity instanceof EntityItem) {
            event = CraftEventFactory.callItemSpawnEvent((EntityItem)entity);
        } else if (entity.getBukkitEntity() instanceof Projectile) {
            event = CraftEventFactory.callProjectileLaunchEvent(entity);
        } else if (entity.getBukkitEntity() instanceof Vehicle) {
            event = CraftEventFactory.callVehicleCreateEvent(entity);
        } else if (entity.getBukkitEntity() instanceof LightningStrike) {
            LightningStrikeEvent.Cause cause;
            switch (spawnReason) {
                case COMMAND: {
                    LightningStrikeEvent.Cause cause2 = LightningStrikeEvent.Cause.COMMAND;
                    break;
                }
                case CUSTOM: {
                    LightningStrikeEvent.Cause cause2 = LightningStrikeEvent.Cause.CUSTOM;
                    break;
                }
                case SPAWNER: {
                    LightningStrikeEvent.Cause cause2 = LightningStrikeEvent.Cause.SPAWNER;
                    break;
                }
                default: {
                    LightningStrikeEvent.Cause cause2 = cause = LightningStrikeEvent.Cause.UNKNOWN;
                }
            }
            if (cause == LightningStrikeEvent.Cause.UNKNOWN && spawnReason == CreatureSpawnEvent.SpawnReason.DEFAULT) {
                return true;
            }
            event = CraftEventFactory.callLightningStrikeEvent((LightningStrike)entity.getBukkitEntity(), cause);
        } else if (!(entity instanceof EntityPlayer)) {
            event = CraftEventFactory.callEntitySpawnEvent(entity);
        }
        if (event != null && (event.isCancelled() || entity.ec())) {
            net.minecraft.world.entity.Entity vehicle = entity.du();
            if (vehicle != null) {
                vehicle.discard(null);
            }
            for (net.minecraft.world.entity.Entity passenger : entity.dm()) {
                passenger.discard(null);
            }
            entity.discard(null);
            return false;
        }
        if (entity instanceof EntityExperienceOrb) {
            EntityExperienceOrb xp = (EntityExperienceOrb)entity;
            double radius = world.spigotConfig.expMerge;
            event = CraftEventFactory.callEntitySpawnEvent(entity);
            if (radius > 0.0 && !event.isCancelled() && !entity.ec()) {
                boolean mergeUnconditionally;
                long maxValue = world.paperConfig().entities.behavior.experienceMergeMaxValue;
                boolean bl = mergeUnconditionally = maxValue <= 0L;
                if (mergeUnconditionally || (long)xp.e() < maxValue) {
                    List<net.minecraft.world.entity.Entity> entities = world.a_(entity, entity.de().c(radius, radius, radius));
                    for (net.minecraft.world.entity.Entity e2 : entities) {
                        long newTotal;
                        EntityExperienceOrb loopItem;
                        if (!(e2 instanceof EntityExperienceOrb) || (loopItem = (EntityExperienceOrb)e2).ec() || xp.m != loopItem.m || !mergeUnconditionally && (long)loopItem.e() >= maxValue || !new ExperienceOrbMergeEvent((ExperienceOrb)entity.getBukkitEntity(), (ExperienceOrb)loopItem.getBukkitEntity()).callEvent() || (int)(newTotal = (long)xp.e() + (long)loopItem.e()) < 0) continue;
                        if (!mergeUnconditionally && newTotal > maxValue) {
                            loopItem.c((int)(newTotal - maxValue));
                            xp.c((int)maxValue);
                            continue;
                        }
                        xp.c(xp.e() + loopItem.e());
                        loopItem.discard(null);
                    }
                }
            }
        }
        return true;
    }

    public static EntitySpawnEvent callEntitySpawnEvent(net.minecraft.world.entity.Entity entity) {
        CraftEntity bukkitEntity = entity.getBukkitEntity();
        EntitySpawnEvent event = new EntitySpawnEvent((Entity)bukkitEntity);
        bukkitEntity.getServer().getPluginManager().callEvent((Event)event);
        return event;
    }

    public static CreatureSpawnEvent callCreatureSpawnEvent(EntityLiving entityliving, CreatureSpawnEvent.SpawnReason spawnReason) {
        LivingEntity entity = (LivingEntity)entityliving.getBukkitEntity();
        CraftServer craftServer = (CraftServer)entity.getServer();
        CreatureSpawnEvent event = new CreatureSpawnEvent(entity, spawnReason);
        craftServer.getPluginManager().callEvent((Event)event);
        return event;
    }

    public static EntityTameEvent callEntityTameEvent(EntityInsentient entity, EntityHuman tamer) {
        CraftEntity bukkitEntity = entity.getBukkitEntity();
        CraftHumanEntity bukkitTamer = tamer != null ? tamer.getBukkitEntity() : null;
        CraftServer craftServer = (CraftServer)bukkitEntity.getServer();
        EntityTameEvent event = new EntityTameEvent((LivingEntity)bukkitEntity, (AnimalTamer)bukkitTamer);
        craftServer.getPluginManager().callEvent((Event)event);
        return event;
    }

    public static ItemSpawnEvent callItemSpawnEvent(EntityItem entityitem) {
        Item entity = (Item)entityitem.getBukkitEntity();
        CraftServer craftServer = (CraftServer)entity.getServer();
        ItemSpawnEvent event = new ItemSpawnEvent(entity);
        craftServer.getPluginManager().callEvent((Event)event);
        return event;
    }

    public static ItemDespawnEvent callItemDespawnEvent(EntityItem entityitem) {
        Item entity = (Item)entityitem.getBukkitEntity();
        ItemDespawnEvent event = new ItemDespawnEvent(entity, entity.getLocation());
        entity.getServer().getPluginManager().callEvent((Event)event);
        return event;
    }

    public static boolean callItemMergeEvent(EntityItem merging, EntityItem mergingWith) {
        Item entityMerging = (Item)merging.getBukkitEntity();
        Item entityMergingWith = (Item)mergingWith.getBukkitEntity();
        ItemMergeEvent event = new ItemMergeEvent(entityMerging, entityMergingWith);
        Bukkit.getPluginManager().callEvent((Event)event);
        return !event.isCancelled();
    }

    public static PotionSplashEvent callPotionSplashEvent(ThrownSplashPotion potion, @Nullable MovingObjectPosition position, Map<LivingEntity, Double> affectedEntities) {
        ThrownPotion thrownPotion = (ThrownPotion)potion.getBukkitEntity();
        CraftBlock hitBlock = null;
        BlockFace hitFace = null;
        if (position != null && position.d() == MovingObjectPosition.EnumMovingObjectType.b) {
            MovingObjectPositionBlock positionBlock = (MovingObjectPositionBlock)position;
            hitBlock = CraftBlock.at(potion.an(), positionBlock.b());
            hitFace = CraftBlock.notchToBlockFace(positionBlock.c());
        }
        CraftEntity hitEntity = null;
        if (position != null && position.d() == MovingObjectPosition.EnumMovingObjectType.c) {
            hitEntity = ((MovingObjectPositionEntity)position).a().getBukkitEntity();
        }
        PotionSplashEvent event = new PotionSplashEvent(thrownPotion, hitEntity, hitBlock, hitFace, affectedEntities);
        Bukkit.getPluginManager().callEvent((Event)event);
        return event;
    }

    public static LingeringPotionSplashEvent callLingeringPotionSplashEvent(ThrownLingeringPotion potion, @Nullable MovingObjectPosition position, EntityAreaEffectCloud cloud) {
        ThrownPotion thrownPotion = (ThrownPotion)potion.getBukkitEntity();
        AreaEffectCloud effectCloud = (AreaEffectCloud)cloud.getBukkitEntity();
        CraftBlock hitBlock = null;
        BlockFace hitFace = null;
        if (position != null && position.d() == MovingObjectPosition.EnumMovingObjectType.b) {
            MovingObjectPositionBlock positionBlock = (MovingObjectPositionBlock)position;
            hitBlock = CraftBlock.at(potion.an(), positionBlock.b());
            hitFace = CraftBlock.notchToBlockFace(positionBlock.c());
        }
        CraftEntity hitEntity = null;
        if (position != null && position.d() == MovingObjectPosition.EnumMovingObjectType.c) {
            hitEntity = ((MovingObjectPositionEntity)position).a().getBukkitEntity();
        }
        LingeringPotionSplashEvent event = new LingeringPotionSplashEvent(thrownPotion, hitEntity, hitBlock, hitFace, effectCloud);
        Bukkit.getPluginManager().callEvent((Event)event);
        return event;
    }

    public static WaterBottleSplashEvent callWaterBottleSplashEvent(EntityPotion potion, @Nullable MovingObjectPosition hitResult, Map<LivingEntity, Double> affectedEntities, Set<LivingEntity> rehydrate, Set<LivingEntity> extinguish) {
        ThrownPotion thrownPotion = (ThrownPotion)potion.getBukkitEntity();
        CraftBlock hitBlock = null;
        BlockFace hitFace = null;
        CraftEntity hitEntity = null;
        if (hitResult != null) {
            if (hitResult.d() == MovingObjectPosition.EnumMovingObjectType.b) {
                MovingObjectPositionBlock blockHitResult = (MovingObjectPositionBlock)hitResult;
                hitBlock = CraftBlock.at(potion.an(), blockHitResult.b());
                hitFace = CraftBlock.notchToBlockFace(blockHitResult.c());
            } else if (hitResult.d() == MovingObjectPosition.EnumMovingObjectType.c) {
                hitEntity = ((MovingObjectPositionEntity)hitResult).a().getBukkitEntity();
            }
        }
        WaterBottleSplashEvent event = new WaterBottleSplashEvent(thrownPotion, hitEntity, hitBlock, hitFace, affectedEntities, rehydrate, extinguish);
        event.callEvent();
        return event;
    }

    public static BlockFadeEvent callBlockFadeEvent(GeneratorAccess world, BlockPosition pos, IBlockData state) {
        CraftBlockState snapshot = CraftBlockStates.getBlockState(world, pos);
        snapshot.setData(state);
        BlockFadeEvent event = new BlockFadeEvent((Block)snapshot.getBlock(), (BlockState)snapshot);
        Bukkit.getPluginManager().callEvent((Event)event);
        return event;
    }

    public static boolean handleMoistureChangeEvent(net.minecraft.world.level.World world, BlockPosition pos, IBlockData state, int flags) {
        CraftBlockState snapshot = CraftBlockStates.getBlockState(world, pos);
        snapshot.setData(state);
        MoistureChangeEvent event = new MoistureChangeEvent((Block)snapshot.getBlock(), (BlockState)snapshot);
        if (event.callEvent()) {
            snapshot.place(flags);
            return true;
        }
        return false;
    }

    public static boolean handleBlockSpreadEvent(GeneratorAccess world, BlockPosition source, BlockPosition target, IBlockData state, int flags) {
        return CraftEventFactory.handleBlockSpreadEvent(world, source, target, state, flags, false);
    }

    public static boolean handleBlockSpreadEvent(GeneratorAccess world, BlockPosition source, BlockPosition target, IBlockData state, int flags, boolean checkSetResult) {
        if (!(world instanceof net.minecraft.world.level.World)) {
            boolean result = world.a(target, state, flags);
            return !checkSetResult || result;
        }
        CraftBlockState snapshot = CraftBlockStates.getBlockState(world, target);
        snapshot.setData(state);
        BlockSpreadEvent event = new BlockSpreadEvent((Block)snapshot.getBlock(), (Block)CraftBlock.at(world, sourceBlockOverride != null ? sourceBlockOverride : source), (BlockState)snapshot);
        if (event.callEvent()) {
            boolean result = snapshot.place(flags);
            return !checkSetResult || result;
        }
        return false;
    }

    public static EntityDeathEvent callEntityDeathEvent(EntityLiving victim, net.minecraft.world.damagesource.DamageSource damageSource) {
        return CraftEventFactory.callEntityDeathEvent(victim, damageSource, new ArrayList<Entity.DefaultDrop>(0));
    }

    public static EntityDeathEvent callEntityDeathEvent(EntityLiving victim, net.minecraft.world.damagesource.DamageSource damageSource, List<Entity.DefaultDrop> drops) {
        return CraftEventFactory.callEntityDeathEvent(victim, damageSource, drops, Runnables.doNothing());
    }

    public static EntityDeathEvent callEntityDeathEvent(EntityLiving victim, net.minecraft.world.damagesource.DamageSource damageSource, List<Entity.DefaultDrop> drops, Runnable lootCheck) {
        CraftLivingEntity entity = (CraftLivingEntity)victim.getBukkitEntity();
        CraftDamageSource bukkitDamageSource = new CraftDamageSource(damageSource);
        CraftWorld world = (CraftWorld)entity.getWorld();
        EntityDeathEvent event = new EntityDeathEvent((LivingEntity)entity, (DamageSource)bukkitDamageSource, (List)new TransformingRandomAccessList(drops, Entity.DefaultDrop::stack, FROM_FUNCTION), victim.getExpReward(world.getHandle(), damageSource.d()));
        CraftEventFactory.populateFields(victim, event);
        Bukkit.getServer().getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            return event;
        }
        CraftEventFactory.playDeathSound(victim, event, damageSource);
        victim.expToDrop = event.getDroppedExp();
        lootCheck.run();
        for (Entity.DefaultDrop drop : drops) {
            org.bukkit.inventory.ItemStack stack;
            if (drop == null || (stack = drop.stack()) == null || stack.getType() == Material.AIR || stack.getAmount() == 0) continue;
            drop.runConsumer(s2 -> world.dropItem(entity.getLocation(), (org.bukkit.inventory.ItemStack)s2));
            if (!(stack instanceof CraftItemStack)) continue;
            stack.setAmount(0);
        }
        return event;
    }

    public static PlayerDeathEvent callPlayerDeathEvent(EntityPlayer victim, net.minecraft.world.damagesource.DamageSource damageSource, List<Entity.DefaultDrop> drops, Component deathMessage, boolean showDeathMessages, boolean keepInventory) {
        CraftPlayer entity = victim.getBukkitEntity();
        CraftDamageSource bukkitDamageSource = new CraftDamageSource(damageSource);
        PlayerDeathEvent event = new PlayerDeathEvent((Player)entity, (DamageSource)bukkitDamageSource, (List)new TransformingRandomAccessList(drops, Entity.DefaultDrop::stack, FROM_FUNCTION), victim.getExpReward(victim.A(), damageSource.d()), 0, deathMessage, showDeathMessages);
        event.setKeepInventory(keepInventory);
        event.setKeepLevel(victim.keepLevel);
        CraftEventFactory.populateFields(victim, (EntityDeathEvent)event);
        Bukkit.getServer().getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            return event;
        }
        CraftEventFactory.playDeathSound(victim, (EntityDeathEvent)event, damageSource);
        victim.keepLevel = event.getKeepLevel();
        victim.newLevel = event.getNewLevel();
        victim.newTotalExp = event.getNewTotalExp();
        victim.expToDrop = event.getDroppedExp();
        victim.newExp = event.getNewExp();
        for (Entity.DefaultDrop drop : drops) {
            org.bukkit.inventory.ItemStack stack;
            if (drop == null || (stack = drop.stack()) == null || stack.getType() == Material.AIR) continue;
            drop.runConsumer(s2 -> victim.a(CraftItemStack.unwrap(s2), true, false));
        }
        return event;
    }

    private static void populateFields(EntityLiving victim, EntityDeathEvent event) {
        event.setReviveHealth(event.getEntity().getAttribute(Attribute.MAX_HEALTH).getValue());
        event.setShouldPlayDeathSound(!victim.silentDeath && !victim.bm());
        SoundEffect soundEffect = victim.f_();
        event.setDeathSound(soundEffect != null ? CraftSound.minecraftToBukkit(soundEffect) : null);
        event.setDeathSoundCategory(SoundCategory.valueOf((String)victim.dw().name()));
        event.setDeathSoundVolume(victim.ft());
        event.setDeathSoundPitch(victim.fu());
    }

    private static void playDeathSound(EntityLiving victim, EntityDeathEvent event, net.minecraft.world.damagesource.DamageSource damageSource) {
        if (event.shouldPlayDeathSound() && event.getDeathSound() != null && event.getDeathSoundCategory() != null) {
            EntityHuman source = victim instanceof EntityHuman ? (EntityHuman)victim : null;
            double x2 = event.getEntity().getLocation().getX();
            double y2 = event.getEntity().getLocation().getY();
            double z2 = event.getEntity().getLocation().getZ();
            SoundEffect soundEffect = CraftSound.bukkitToMinecraft(event.getDeathSound());
            net.minecraft.sounds.SoundCategory soundCategory = net.minecraft.sounds.SoundCategory.valueOf(event.getDeathSoundCategory().name());
            victim.an().a((net.minecraft.world.entity.Entity)source, x2, y2, z2, soundEffect, soundCategory, event.getDeathSoundVolume(), event.getDeathSoundPitch());
            victim.i(damageSource);
        }
    }

    private static EntityDamageEvent handleEntityDamageEvent(net.minecraft.world.entity.Entity entity, net.minecraft.world.damagesource.DamageSource source, Map<EntityDamageEvent.DamageModifier, Double> modifiers, Map<EntityDamageEvent.DamageModifier, com.google.common.base.Function<? super Double, Double>> modifierFunctions) {
        return CraftEventFactory.handleEntityDamageEvent(entity, source, modifiers, modifierFunctions, false);
    }

    private static EntityDamageEvent handleEntityDamageEvent(net.minecraft.world.entity.Entity entity, net.minecraft.world.damagesource.DamageSource source, Map<EntityDamageEvent.DamageModifier, Double> modifiers, Map<EntityDamageEvent.DamageModifier, com.google.common.base.Function<? super Double, Double>> modifierFunctions, boolean cancelled) {
        net.minecraft.world.entity.Entity damager;
        CraftDamageSource bukkitDamageSource = new CraftDamageSource(source);
        net.minecraft.world.entity.Entity entity2 = damager = source.eventEntityDamager() != null ? source.eventEntityDamager() : source.c();
        if (source.a(DamageTypeTags.l)) {
            if (damager == null) {
                return CraftEventFactory.callEntityDamageEvent(source.eventBlockDamager(), source.causingBlockSnapshot(), entity, EntityDamageEvent.DamageCause.BLOCK_EXPLOSION, bukkitDamageSource, modifiers, modifierFunctions, cancelled);
            }
            EntityDamageEvent.DamageCause damageCause = damager.getBukkitEntity() instanceof TNTPrimed ? EntityDamageEvent.DamageCause.BLOCK_EXPLOSION : EntityDamageEvent.DamageCause.ENTITY_EXPLOSION;
            return CraftEventFactory.callEntityDamageEvent(damager, entity, damageCause, bukkitDamageSource, modifiers, modifierFunctions, cancelled, source.isCritical());
        }
        if (damager != null || source.c() != null) {
            EntityDamageEvent.DamageCause cause = EntityDamageEvent.DamageCause.ENTITY_ATTACK;
            if (source.knownCause() != null) {
                cause = source.knownCause();
            } else if (damager instanceof IProjectile) {
                if (damager.getBukkitEntity() instanceof ThrownPotion) {
                    cause = EntityDamageEvent.DamageCause.MAGIC;
                } else if (damager.getBukkitEntity() instanceof Projectile) {
                    cause = EntityDamageEvent.DamageCause.PROJECTILE;
                }
            } else if (source.a(DamageTypes.P)) {
                cause = EntityDamageEvent.DamageCause.THORNS;
            } else if (source.a(DamageTypes.S)) {
                cause = EntityDamageEvent.DamageCause.SONIC_BOOM;
            } else if (source.a(DamageTypes.z) || source.a(DamageTypes.x) || source.a(DamageTypes.y)) {
                cause = EntityDamageEvent.DamageCause.FALLING_BLOCK;
            } else if (source.a(DamageTypes.c)) {
                cause = EntityDamageEvent.DamageCause.LIGHTNING;
            } else if (source.a(DamageTypes.l)) {
                cause = EntityDamageEvent.DamageCause.FALL;
            } else if (source.a(DamageTypes.s)) {
                cause = EntityDamageEvent.DamageCause.DRAGON_BREATH;
            } else if (source.a(DamageTypes.q)) {
                cause = EntityDamageEvent.DamageCause.MAGIC;
            }
            return CraftEventFactory.callEntityDamageEvent(damager, entity, cause, bukkitDamageSource, modifiers, modifierFunctions, cancelled, source.isCritical());
        }
        if (source.a(DamageTypes.o)) {
            return CraftEventFactory.callEntityDamageEvent(source.eventBlockDamager(), source.causingBlockSnapshot(), entity, EntityDamageEvent.DamageCause.VOID, bukkitDamageSource, modifiers, modifierFunctions, cancelled);
        }
        if (source.a(DamageTypes.e)) {
            return CraftEventFactory.callEntityDamageEvent(source.eventBlockDamager(), source.causingBlockSnapshot(), entity, EntityDamageEvent.DamageCause.LAVA, bukkitDamageSource, modifiers, modifierFunctions, cancelled);
        }
        if (source.eventBlockDamager() != null) {
            EntityDamageEvent.DamageCause cause = source.knownCause() != null ? source.knownCause() : (source.a(DamageTypes.k) || source.a(DamageTypes.u) || source.a(DamageTypes.w) || source.a(DamageTypes.z) || source.a(DamageTypes.y) ? EntityDamageEvent.DamageCause.CONTACT : (source.a(DamageTypes.f) ? EntityDamageEvent.DamageCause.HOT_FLOOR : (source.a(DamageTypes.q) ? EntityDamageEvent.DamageCause.MAGIC : (source.a(DamageTypes.a) ? EntityDamageEvent.DamageCause.FIRE : (source.a(DamageTypes.b) ? EntityDamageEvent.DamageCause.CAMPFIRE : EntityDamageEvent.DamageCause.CUSTOM)))));
            return CraftEventFactory.callEntityDamageEvent(source.eventBlockDamager(), source.causingBlockSnapshot(), entity, cause, bukkitDamageSource, modifiers, modifierFunctions, cancelled);
        }
        EntityDamageEvent.DamageCause cause = source.knownCause() != null ? source.knownCause() : (source.a(DamageTypes.a) ? EntityDamageEvent.DamageCause.FIRE : (source.a(DamageTypes.j) ? EntityDamageEvent.DamageCause.STARVATION : (source.a(DamageTypes.r) ? EntityDamageEvent.DamageCause.WITHER : (source.a(DamageTypes.g) ? EntityDamageEvent.DamageCause.SUFFOCATION : (source.a(DamageTypes.i) ? EntityDamageEvent.DamageCause.DROWNING : (source.a(DamageTypes.d) ? EntityDamageEvent.DamageCause.FIRE_TICK : (source.a(DamageTypes.q) ? EntityDamageEvent.DamageCause.MAGIC : (source.a(DamageTypes.l) ? EntityDamageEvent.DamageCause.FALL : (source.a(DamageTypes.n) ? EntityDamageEvent.DamageCause.FLY_INTO_WALL : (source.a(DamageTypes.h) ? EntityDamageEvent.DamageCause.CRAMMING : (source.a(DamageTypes.t) ? EntityDamageEvent.DamageCause.DRYOUT : (source.a(DamageTypes.v) ? EntityDamageEvent.DamageCause.FREEZE : (source.a(DamageTypes.V) ? EntityDamageEvent.DamageCause.KILL : (source.a(DamageTypes.U) ? EntityDamageEvent.DamageCause.WORLD_BORDER : EntityDamageEvent.DamageCause.CUSTOM))))))))))))));
        return CraftEventFactory.callEntityDamageEvent(null, entity, cause, bukkitDamageSource, modifiers, modifierFunctions, cancelled, source.isCritical());
    }

    private static EntityDamageEvent callEntityDamageEvent(net.minecraft.world.entity.Entity damager, net.minecraft.world.entity.Entity damagee, EntityDamageEvent.DamageCause cause, DamageSource bukkitDamageSource, Map<EntityDamageEvent.DamageModifier, Double> modifiers, Map<EntityDamageEvent.DamageModifier, com.google.common.base.Function<? super Double, Double>> modifierFunctions, boolean cancelled, boolean critical) {
        EntityDamageEvent event;
        if (damager != null) {
            event = new EntityDamageByEntityEvent((Entity)damager.getBukkitEntity(), (Entity)damagee.getBukkitEntity(), cause, bukkitDamageSource, modifiers, modifierFunctions, critical);
            damager.processClick(EnumHand.a);
        } else {
            event = new EntityDamageEvent((Entity)damagee.getBukkitEntity(), cause, bukkitDamageSource, modifiers, modifierFunctions);
        }
        return CraftEventFactory.callEntityDamageEvent(event, damagee, cancelled);
    }

    private static EntityDamageEvent callEntityDamageEvent(Block damager, BlockState damagerState, net.minecraft.world.entity.Entity damagee, EntityDamageEvent.DamageCause cause, DamageSource bukkitDamageSource, Map<EntityDamageEvent.DamageModifier, Double> modifiers, Map<EntityDamageEvent.DamageModifier, com.google.common.base.Function<? super Double, Double>> modifierFunctions, boolean cancelled) {
        EntityDamageByBlockEvent event = new EntityDamageByBlockEvent(damager, damagerState, (Entity)damagee.getBukkitEntity(), cause, bukkitDamageSource, modifiers, modifierFunctions);
        return CraftEventFactory.callEntityDamageEvent((EntityDamageEvent)event, damagee, cancelled);
    }

    private static EntityDamageEvent callEntityDamageEvent(EntityDamageEvent event, net.minecraft.world.entity.Entity damagee, boolean cancelled) {
        event.setCancelled(cancelled);
        event.callEvent();
        if (!event.isCancelled()) {
            event.getEntity().setLastDamageCause(event);
        } else {
            damagee.lastDamageCancelled = true;
        }
        return event;
    }

    public static EntityDamageEvent handleLivingEntityDamageEvent(net.minecraft.world.entity.Entity damagee, net.minecraft.world.damagesource.DamageSource source, double rawDamage, double freezingModifier, double hardHatModifier, double blockingModifier, double armorModifier, double resistanceModifier, double magicModifier, double absorptionModifier, com.google.common.base.Function<Double, Double> freezing, com.google.common.base.Function<Double, Double> hardHat, com.google.common.base.Function<Double, Double> blocking, com.google.common.base.Function<Double, Double> armor, com.google.common.base.Function<Double, Double> resistance, com.google.common.base.Function<Double, Double> magic, com.google.common.base.Function<Double, Double> absorption) {
        return CraftEventFactory.handleLivingEntityDamageEvent(damagee, source, rawDamage, freezingModifier, hardHatModifier, blockingModifier, armorModifier, resistanceModifier, magicModifier, absorptionModifier, freezing, hardHat, blocking, armor, resistance, magic, absorption, null);
    }

    public static EntityDamageEvent handleLivingEntityDamageEvent(net.minecraft.world.entity.Entity damagee, net.minecraft.world.damagesource.DamageSource source, double rawDamage, double freezingModifier, double hardHatModifier, double blockingModifier, double armorModifier, double resistanceModifier, double magicModifier, double absorptionModifier, com.google.common.base.Function<Double, Double> freezing, com.google.common.base.Function<Double, Double> hardHat, com.google.common.base.Function<Double, Double> blocking, com.google.common.base.Function<Double, Double> armor, com.google.common.base.Function<Double, Double> resistance, com.google.common.base.Function<Double, Double> magic, com.google.common.base.Function<Double, Double> absorption, BiConsumer<Map<EntityDamageEvent.DamageModifier, Double>, Map<EntityDamageEvent.DamageModifier, com.google.common.base.Function<? super Double, Double>>> callback) {
        EnumMap<EntityDamageEvent.DamageModifier, Double> modifiers = new EnumMap<EntityDamageEvent.DamageModifier, Double>(EntityDamageEvent.DamageModifier.class);
        EnumMap<EntityDamageEvent.DamageModifier, com.google.common.base.Function<? super Double, Double>> modifierFunctions = new EnumMap<EntityDamageEvent.DamageModifier, com.google.common.base.Function<? super Double, Double>>(EntityDamageEvent.DamageModifier.class);
        modifiers.put(EntityDamageEvent.DamageModifier.BASE, rawDamage);
        modifierFunctions.put(EntityDamageEvent.DamageModifier.BASE, ZERO);
        if (source.a(DamageTypeTags.o)) {
            modifiers.put(EntityDamageEvent.DamageModifier.FREEZING, freezingModifier);
            modifierFunctions.put(EntityDamageEvent.DamageModifier.FREEZING, freezing);
        }
        if (source.a(DamageTypeTags.a)) {
            modifiers.put(EntityDamageEvent.DamageModifier.HARD_HAT, hardHatModifier);
            modifierFunctions.put(EntityDamageEvent.DamageModifier.HARD_HAT, hardHat);
        }
        if (damagee instanceof EntityHuman) {
            modifiers.put(EntityDamageEvent.DamageModifier.BLOCKING, blockingModifier);
            modifierFunctions.put(EntityDamageEvent.DamageModifier.BLOCKING, blocking);
        }
        modifiers.put(EntityDamageEvent.DamageModifier.ARMOR, armorModifier);
        modifierFunctions.put(EntityDamageEvent.DamageModifier.ARMOR, armor);
        modifiers.put(EntityDamageEvent.DamageModifier.RESISTANCE, resistanceModifier);
        modifierFunctions.put(EntityDamageEvent.DamageModifier.RESISTANCE, resistance);
        modifiers.put(EntityDamageEvent.DamageModifier.MAGIC, magicModifier);
        modifierFunctions.put(EntityDamageEvent.DamageModifier.MAGIC, magic);
        modifiers.put(EntityDamageEvent.DamageModifier.ABSORPTION, absorptionModifier);
        modifierFunctions.put(EntityDamageEvent.DamageModifier.ABSORPTION, absorption);
        if (callback != null) {
            callback.accept(modifiers, modifierFunctions);
        }
        return CraftEventFactory.handleEntityDamageEvent(damagee, source, modifiers, modifierFunctions);
    }

    public static boolean handleNonLivingEntityDamageEvent(net.minecraft.world.entity.Entity entity, net.minecraft.world.damagesource.DamageSource source, double damage) {
        return CraftEventFactory.handleNonLivingEntityDamageEvent(entity, source, damage, true);
    }

    public static boolean handleNonLivingEntityDamageEvent(net.minecraft.world.entity.Entity entity, net.minecraft.world.damagesource.DamageSource source, double damage, boolean cancelOnZeroDamage) {
        return CraftEventFactory.handleNonLivingEntityDamageEvent(entity, source, damage, cancelOnZeroDamage, false);
    }

    public static EntityDamageEvent callNonLivingEntityDamageEvent(net.minecraft.world.entity.Entity entity, net.minecraft.world.damagesource.DamageSource source, double damage, boolean cancelled) {
        EnumMap<EntityDamageEvent.DamageModifier, Double> modifiers = new EnumMap<EntityDamageEvent.DamageModifier, Double>(EntityDamageEvent.DamageModifier.class);
        EnumMap<EntityDamageEvent.DamageModifier, com.google.common.base.Function<? super Double, Double>> functions = new EnumMap<EntityDamageEvent.DamageModifier, com.google.common.base.Function<? super Double, Double>>(EntityDamageEvent.DamageModifier.class);
        modifiers.put(EntityDamageEvent.DamageModifier.BASE, damage);
        functions.put(EntityDamageEvent.DamageModifier.BASE, ZERO);
        return CraftEventFactory.handleEntityDamageEvent(entity, source, modifiers, functions, cancelled);
    }

    public static boolean handleNonLivingEntityDamageEvent(net.minecraft.world.entity.Entity entity, net.minecraft.world.damagesource.DamageSource source, double damage, boolean cancelOnZeroDamage, boolean cancelled) {
        EntityDamageEvent event = CraftEventFactory.callNonLivingEntityDamageEvent(entity, source, damage, cancelled);
        if (event == null) {
            return false;
        }
        return event.isCancelled() || cancelOnZeroDamage && event.getDamage() == 0.0;
    }

    public static PlayerLevelChangeEvent callPlayerLevelChangeEvent(Player player, int oldLevel, int newLevel) {
        PlayerLevelChangeEvent event = new PlayerLevelChangeEvent(player, oldLevel, newLevel);
        Bukkit.getPluginManager().callEvent((Event)event);
        return event;
    }

    public static PlayerExpCooldownChangeEvent callPlayerXpCooldownEvent(EntityHuman entity, int newCooldown, PlayerExpCooldownChangeEvent.ChangeReason changeReason) {
        Player player = (Player)entity.getBukkitEntity();
        PlayerExpCooldownChangeEvent event = new PlayerExpCooldownChangeEvent(player, newCooldown, changeReason);
        Bukkit.getPluginManager().callEvent((Event)event);
        return event;
    }

    public static PlayerItemMendEvent callPlayerItemMendEvent(EntityHuman entity, EntityExperienceOrb orb, ItemStack nmsMendedItem, EnumItemSlot slot, int repairAmount, int consumedExperience) {
        Player player = (Player)entity.getBukkitEntity();
        CraftItemStack bukkitStack = CraftItemStack.asCraftMirror(nmsMendedItem);
        PlayerItemMendEvent event = new PlayerItemMendEvent(player, (org.bukkit.inventory.ItemStack)bukkitStack, CraftEquipmentSlot.getSlot(slot), (ExperienceOrb)orb.getBukkitEntity(), repairAmount, consumedExperience);
        Bukkit.getPluginManager().callEvent((Event)event);
        return event;
    }

    public static PlayerExpChangeEvent callPlayerExpChangeEvent(EntityHuman entity, EntityExperienceOrb entityOrb, int expAmount) {
        Player player = (Player)entity.getBukkitEntity();
        ExperienceOrb source = (ExperienceOrb)entityOrb.getBukkitEntity();
        PlayerExpChangeEvent event = new PlayerExpChangeEvent(player, (Entity)source, expAmount);
        Bukkit.getPluginManager().callEvent((Event)event);
        return event;
    }

    public static boolean handleBlockGrowEvent(net.minecraft.world.level.World world, BlockPosition pos, IBlockData state, int flags) {
        CraftBlockState snapshot = CraftBlockStates.getBlockState(world, pos);
        snapshot.setData(state);
        BlockGrowEvent event = new BlockGrowEvent((Block)snapshot.getBlock(), (BlockState)snapshot);
        if (event.callEvent()) {
            snapshot.place(flags);
            return true;
        }
        return false;
    }

    public static FluidLevelChangeEvent callFluidLevelChangeEvent(net.minecraft.world.level.World world, BlockPosition block, IBlockData newData) {
        FluidLevelChangeEvent event = new FluidLevelChangeEvent((Block)CraftBlock.at(world, block), (BlockData)CraftBlockData.fromData(newData));
        world.getCraftServer().getPluginManager().callEvent((Event)event);
        return event;
    }

    public static FoodLevelChangeEvent callFoodLevelChangeEvent(EntityHuman entity, int level) {
        return CraftEventFactory.callFoodLevelChangeEvent(entity, level, null);
    }

    public static FoodLevelChangeEvent callFoodLevelChangeEvent(EntityHuman entity, int level, ItemStack item) {
        FoodLevelChangeEvent event = new FoodLevelChangeEvent((HumanEntity)entity.getBukkitEntity(), level, item == null ? null : CraftItemStack.asBukkitCopy(item));
        entity.getBukkitEntity().getServer().getPluginManager().callEvent((Event)event);
        return event;
    }

    public static PigZapEvent callPigZapEvent(net.minecraft.world.entity.Entity pig, net.minecraft.world.entity.Entity lightning, net.minecraft.world.entity.Entity pigzombie) {
        PigZapEvent event = new PigZapEvent((Pig)pig.getBukkitEntity(), (LightningStrike)lightning.getBukkitEntity(), (PigZombie)pigzombie.getBukkitEntity());
        pig.getBukkitEntity().getServer().getPluginManager().callEvent((Event)event);
        return event;
    }

    public static boolean callHorseJumpEvent(net.minecraft.world.entity.Entity horse, float power) {
        HorseJumpEvent event = new HorseJumpEvent((AbstractHorse)horse.getBukkitEntity(), power);
        horse.getBukkitEntity().getServer().getPluginManager().callEvent((Event)event);
        return !event.isCancelled();
    }

    public static EntityZapEvent callEntityZapEvent(net.minecraft.world.entity.Entity entity, net.minecraft.world.entity.Entity lightning, net.minecraft.world.entity.Entity changedEntity) {
        EntityZapEvent event = new EntityZapEvent((Entity)entity.getBukkitEntity(), (LightningStrike)lightning.getBukkitEntity(), (Entity)changedEntity.getBukkitEntity());
        entity.getBukkitEntity().getServer().getPluginManager().callEvent((Event)event);
        return event;
    }

    public static boolean callEntityChangeBlockEvent(net.minecraft.world.entity.Entity entity, BlockPosition pos, IBlockData newState) {
        return CraftEventFactory.callEntityChangeBlockEvent(entity, pos, newState, false);
    }

    public static boolean callEntityChangeBlockEvent(net.minecraft.world.entity.Entity entity, BlockPosition pos, IBlockData newState, boolean cancelled) {
        CraftBlock block = CraftBlock.at(entity.an(), pos);
        EntityChangeBlockEvent event = new EntityChangeBlockEvent((Entity)entity.getBukkitEntity(), (Block)block, (BlockData)CraftBlockData.fromData(newState));
        event.setCancelled(cancelled);
        event.getEntity().getServer().getPluginManager().callEvent((Event)event);
        return !event.isCancelled();
    }

    public static CreeperPowerEvent callCreeperPowerEvent(net.minecraft.world.entity.Entity creeper, net.minecraft.world.entity.Entity lightning, CreeperPowerEvent.PowerCause cause) {
        CreeperPowerEvent event = new CreeperPowerEvent((Creeper)creeper.getBukkitEntity(), (LightningStrike)lightning.getBukkitEntity(), cause);
        creeper.getBukkitEntity().getServer().getPluginManager().callEvent((Event)event);
        return event;
    }

    public static EntityTargetEvent callEntityTargetEvent(net.minecraft.world.entity.Entity entity, net.minecraft.world.entity.Entity target, EntityTargetEvent.TargetReason reason) {
        EntityTargetEvent event = new EntityTargetEvent((Entity)entity.getBukkitEntity(), (Entity)(target == null ? null : target.getBukkitEntity()), reason);
        entity.getBukkitEntity().getServer().getPluginManager().callEvent((Event)event);
        return event;
    }

    public static EntityTargetLivingEntityEvent callEntityTargetLivingEvent(net.minecraft.world.entity.Entity entity, EntityLiving target, EntityTargetEvent.TargetReason reason) {
        EntityTargetLivingEntityEvent event = new EntityTargetLivingEntityEvent((Entity)entity.getBukkitEntity(), target == null ? null : (LivingEntity)target.getBukkitEntity(), reason);
        entity.getBukkitEntity().getServer().getPluginManager().callEvent((Event)event);
        return event;
    }

    public static EntityBreakDoorEvent callEntityBreakDoorEvent(net.minecraft.world.entity.Entity entity, BlockPosition pos, IBlockData newState) {
        CraftEntity entity1 = entity.getBukkitEntity();
        CraftBlock block = CraftBlock.at(entity.an(), pos);
        EntityBreakDoorEvent event = new EntityBreakDoorEvent((LivingEntity)entity1, (Block)block, (BlockData)newState.createCraftBlockData());
        entity1.getServer().getPluginManager().callEvent((Event)event);
        return event;
    }

    public static Container callInventoryOpenEvent(EntityPlayer player, Container container) {
        return (Container)CraftEventFactory.callInventoryOpenEventWithTitle(player, container).getSecond();
    }

    public static Pair<@Nullable Component, @Nullable Container> callInventoryOpenEventWithTitle(EntityPlayer player, Container container) {
        return CraftEventFactory.callInventoryOpenEventWithTitle(player, container, false);
    }

    public static Pair<@Nullable Component, @Nullable Container> callInventoryOpenEventWithTitle(EntityPlayer player, Container container, boolean cancelled) {
        container.startOpen();
        if (player.cl != player.ck) {
            player.g.handleContainerClose(new PacketPlayInCloseWindow(player.cl.l), InventoryCloseEvent.Reason.OPEN_NEW);
        }
        CraftServer server = player.A().getCraftServer();
        CraftPlayer craftPlayer = player.getBukkitEntity();
        player.cl.transferTo(container, craftPlayer);
        InventoryOpenEvent event = new InventoryOpenEvent(container.getBukkitView());
        event.setCancelled(cancelled);
        server.getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            container.transferTo(player.cl, craftPlayer);
            return Pair.of(null, null);
        }
        return Pair.of((Object)event.titleOverride(), (Object)container);
    }

    public static ItemStack callPreCraftEvent(InventoryCrafting matrix, IInventory resultInventory, ItemStack result, InventoryView lastCraftView, boolean isRepair) {
        CraftInventoryCrafting inventory = new CraftInventoryCrafting(matrix, resultInventory);
        inventory.setResult(CraftItemStack.asCraftMirror(result));
        PrepareItemCraftEvent event = new PrepareItemCraftEvent((CraftingInventory)inventory, lastCraftView, isRepair);
        Bukkit.getPluginManager().callEvent((Event)event);
        return CraftItemStack.asNMSCopy(event.getInventory().getResult());
    }

    public static CrafterCraftEvent callCrafterCraftEvent(BlockPosition pos, net.minecraft.world.level.World world, ItemStack result, RecipeHolder<RecipeCrafting> holder) {
        CraftBlock block = CraftBlock.at(world, pos);
        CraftItemStack itemStack = CraftItemStack.asCraftMirror(result);
        CraftingRecipe craftingRecipe = (CraftingRecipe)holder.toBukkitRecipe();
        CrafterCraftEvent crafterCraftEvent = new CrafterCraftEvent((Block)block, craftingRecipe, (org.bukkit.inventory.ItemStack)itemStack);
        Bukkit.getPluginManager().callEvent((Event)crafterCraftEvent);
        return crafterCraftEvent;
    }

    @Deprecated
    public static ProjectileCollideEvent callProjectileCollideEvent(net.minecraft.world.entity.Entity entity, MovingObjectPositionEntity position) {
        Projectile projectile = (Projectile)entity.getBukkitEntity();
        CraftEntity collided = position.a().getBukkitEntity();
        ProjectileCollideEvent event = new ProjectileCollideEvent(projectile, (Entity)collided);
        if (projectile.getShooter() instanceof Player && collided instanceof Player && !((Player)projectile.getShooter()).canSee((Player)collided)) {
            event.setCancelled(true);
            return event;
        }
        Bukkit.getPluginManager().callEvent((Event)event);
        return event;
    }

    public static ProjectileLaunchEvent callProjectileLaunchEvent(net.minecraft.world.entity.Entity entity) {
        Projectile bukkitEntity = (Projectile)entity.getBukkitEntity();
        ProjectileLaunchEvent event = new ProjectileLaunchEvent((Entity)bukkitEntity);
        Bukkit.getPluginManager().callEvent((Event)event);
        return event;
    }

    public static ProjectileHitEvent callProjectileHitEvent(net.minecraft.world.entity.Entity entity, MovingObjectPosition hitResult) {
        if (hitResult.d() == MovingObjectPosition.EnumMovingObjectType.a) {
            return null;
        }
        CraftBlock hitBlock = null;
        BlockFace hitFace = null;
        if (hitResult.d() == MovingObjectPosition.EnumMovingObjectType.b) {
            MovingObjectPositionBlock positionBlock = (MovingObjectPositionBlock)hitResult;
            hitBlock = CraftBlock.at(entity.an(), positionBlock.b());
            hitFace = CraftBlock.notchToBlockFace(positionBlock.c());
        }
        CraftEntity hitEntity = null;
        if (hitResult.d() == MovingObjectPosition.EnumMovingObjectType.c) {
            hitEntity = ((MovingObjectPositionEntity)hitResult).a().getBukkitEntity();
        }
        boolean cancelled = false;
        if (hitEntity != null && hitResult instanceof MovingObjectPositionEntity) {
            MovingObjectPositionEntity entityHitResult = (MovingObjectPositionEntity)hitResult;
            cancelled = CraftEventFactory.callProjectileCollideEvent(entity, entityHitResult).isCancelled();
        }
        ProjectileHitEvent event = new ProjectileHitEvent((Projectile)entity.getBukkitEntity(), (Entity)hitEntity, (Block)hitBlock, hitFace);
        event.setCancelled(cancelled);
        entity.an().getCraftServer().getPluginManager().callEvent((Event)event);
        return event;
    }

    public static ExpBottleEvent callExpBottleEvent(net.minecraft.world.entity.Entity entity, MovingObjectPosition hitResult, int exp) {
        ThrownExpBottle bottle = (ThrownExpBottle)entity.getBukkitEntity();
        CraftBlock hitBlock = null;
        BlockFace hitFace = null;
        if (hitResult.d() == MovingObjectPosition.EnumMovingObjectType.b) {
            MovingObjectPositionBlock positionBlock = (MovingObjectPositionBlock)hitResult;
            hitBlock = CraftBlock.at(entity.an(), positionBlock.b());
            hitFace = CraftBlock.notchToBlockFace(positionBlock.c());
        }
        CraftEntity hitEntity = null;
        if (hitResult.d() == MovingObjectPosition.EnumMovingObjectType.c) {
            hitEntity = ((MovingObjectPositionEntity)hitResult).a().getBukkitEntity();
        }
        ExpBottleEvent event = new ExpBottleEvent(bottle, (Entity)hitEntity, (Block)hitBlock, hitFace, exp);
        Bukkit.getPluginManager().callEvent((Event)event);
        return event;
    }

    public static boolean callBinaryRedstoneChange(GeneratorAccess level, BlockPosition pos, boolean willBePowered) {
        int oldCurrent = willBePowered ? 0 : 15;
        int newCurrent = willBePowered ? 15 : 0;
        return CraftEventFactory.callRedstoneChange(level, pos, oldCurrent, newCurrent).getNewCurrent() == newCurrent;
    }

    public static BlockRedstoneEvent callRedstoneChange(GeneratorAccess level, BlockPosition pos, int oldCurrent, int newCurrent) {
        BlockRedstoneEvent event = new BlockRedstoneEvent((Block)CraftBlock.at(level, pos), oldCurrent, newCurrent);
        event.callEvent();
        return event;
    }

    public static NotePlayEvent callNotePlayEvent(net.minecraft.world.level.World world, BlockPosition pos, BlockPropertyInstrument instrument, int note) {
        NotePlayEvent event = new NotePlayEvent((Block)CraftBlock.at(world, pos), Instrument.getByType((byte)((byte)instrument.ordinal())), new Note(note));
        world.getCraftServer().getPluginManager().callEvent((Event)event);
        return event;
    }

    public static void callPlayerItemBreakEvent(EntityPlayer human, ItemStack brokenItem) {
        CraftItemStack item = CraftItemStack.asCraftMirror(brokenItem);
        PlayerItemBreakEvent event = new PlayerItemBreakEvent((Player)human.getBukkitEntity(), (org.bukkit.inventory.ItemStack)item);
        Bukkit.getPluginManager().callEvent((Event)event);
    }

    public static BlockIgniteEvent callBlockIgniteEvent(net.minecraft.world.level.World world, BlockPosition pos, BlockPosition sourcePos) {
        CraftBlock igniter = CraftBlock.at(world, sourcePos);
        BlockIgniteEvent event = new BlockIgniteEvent((Block)CraftBlock.at(world, pos), switch (igniter.getType()) {
            case Material.LAVA -> BlockIgniteEvent.IgniteCause.LAVA;
            case Material.DISPENSER -> BlockIgniteEvent.IgniteCause.FLINT_AND_STEEL;
            default -> BlockIgniteEvent.IgniteCause.SPREAD;
        }, (Block)igniter);
        world.getCraftServer().getPluginManager().callEvent((Event)event);
        return event;
    }

    public static BlockIgniteEvent callBlockIgniteEvent(net.minecraft.world.level.World world, BlockPosition pos, net.minecraft.world.entity.Entity igniter) {
        net.minecraft.world.entity.Entity shooter;
        BlockIgniteEvent.IgniteCause cause;
        CraftEntity bukkitIgniter = igniter.getBukkitEntity();
        switch (bukkitIgniter.getType()) {
            case END_CRYSTAL: {
                BlockIgniteEvent.IgniteCause igniteCause = BlockIgniteEvent.IgniteCause.ENDER_CRYSTAL;
                break;
            }
            case LIGHTNING_BOLT: {
                BlockIgniteEvent.IgniteCause igniteCause = BlockIgniteEvent.IgniteCause.LIGHTNING;
                break;
            }
            case SMALL_FIREBALL: 
            case FIREBALL: {
                BlockIgniteEvent.IgniteCause igniteCause = BlockIgniteEvent.IgniteCause.FIREBALL;
                break;
            }
            case ARROW: {
                BlockIgniteEvent.IgniteCause igniteCause = BlockIgniteEvent.IgniteCause.ARROW;
                break;
            }
            default: {
                BlockIgniteEvent.IgniteCause igniteCause = cause = BlockIgniteEvent.IgniteCause.FLINT_AND_STEEL;
            }
        }
        if (igniter instanceof IProjectile && (shooter = ((IProjectile)igniter).ai_()) != null) {
            bukkitIgniter = shooter.getBukkitEntity();
        }
        BlockIgniteEvent event = new BlockIgniteEvent((Block)CraftBlock.at(world, pos), cause, (Entity)bukkitIgniter);
        world.getCraftServer().getPluginManager().callEvent((Event)event);
        return event;
    }

    public static BlockIgniteEvent callBlockIgniteEvent(net.minecraft.world.level.World world, BlockPosition pos, Explosion explosion) {
        CraftEntity igniter = explosion.d() == null ? null : explosion.d().getBukkitEntity();
        BlockIgniteEvent event = new BlockIgniteEvent((Block)CraftBlock.at(world, pos), BlockIgniteEvent.IgniteCause.EXPLOSION, (Entity)igniter);
        world.getCraftServer().getPluginManager().callEvent((Event)event);
        return event;
    }

    public static BlockIgniteEvent callBlockIgniteEvent(net.minecraft.world.level.World world, BlockPosition pos, BlockIgniteEvent.IgniteCause cause, net.minecraft.world.entity.Entity igniter) {
        BlockIgniteEvent event = new BlockIgniteEvent((Block)CraftBlock.at(world, pos), cause, (Entity)igniter.getBukkitEntity());
        world.getCraftServer().getPluginManager().callEvent((Event)event);
        return event;
    }

    public static void handleInventoryCloseEvent(EntityHuman human, InventoryCloseEvent.Reason reason) {
        InventoryCloseEvent event = new InventoryCloseEvent(human.cl.getBukkitView(), reason);
        human.an().getCraftServer().getPluginManager().callEvent((Event)event);
        human.cl.transferTo(human.ck, human.getBukkitEntity());
    }

    public static ItemStack handleEditBookEvent(EntityPlayer player, int itemInHandIndex, ItemStack itemInHand, ItemStack newBookItem) {
        PlayerEditBookEvent editBookEvent = new PlayerEditBookEvent((Player)player.getBukkitEntity(), itemInHandIndex >= 0 && itemInHandIndex <= 8 ? itemInHandIndex : -1, (BookMeta)CraftItemStack.getItemMeta(itemInHand), (BookMeta)CraftItemStack.getItemMeta(newBookItem), newBookItem.a(Items.wh));
        player.A().getCraftServer().getPluginManager().callEvent((Event)editBookEvent);
        if (itemInHand != null && itemInHand.a(Items.wg)) {
            if (!editBookEvent.isCancelled()) {
                if (editBookEvent.isSigning()) {
                    itemInHand.setItem(Items.wh);
                }
                BookMeta meta = editBookEvent.getNewBookMeta();
                CraftItemStack.setItemMeta(itemInHand, (ItemMeta)meta);
            } else {
                player.cl.forceSlot(player.gB(), itemInHandIndex);
            }
        }
        return itemInHand;
    }

    public static void callRecipeBookSettingsEvent(EntityPlayer player, RecipeBookType type, boolean open, boolean filter) {
        PlayerRecipeBookSettingsChangeEvent.RecipeBookType bukkitType = PlayerRecipeBookSettingsChangeEvent.RecipeBookType.values()[type.ordinal()];
        Bukkit.getPluginManager().callEvent((Event)new PlayerRecipeBookSettingsChangeEvent((Player)player.getBukkitEntity(), bukkitType, open, filter));
    }

    public static boolean handlePlayerUnleashEntityEvent(Leashable leashable, @Nullable EntityHuman player, @Nullable EnumHand hand, boolean dropLeash, boolean resendState) {
        if (!(leashable instanceof net.minecraft.world.entity.Entity)) {
            return true;
        }
        net.minecraft.world.entity.Entity entity = (net.minecraft.world.entity.Entity)((Object)leashable);
        return CraftEventFactory.handlePlayerUnleashEntityEvent(entity, player, hand, dropLeash, resendState);
    }

    public static boolean handlePlayerUnleashEntityEvent(net.minecraft.world.entity.Entity entity, @Nullable EntityHuman player, @Nullable EnumHand hand, boolean dropLeash, boolean resendState) {
        if (player == null || hand == null) {
            if (entity instanceof Leashable) {
                Leashable leashable = (Leashable)((Object)entity);
                if (dropLeash) {
                    leashable.w();
                } else {
                    leashable.x();
                }
            }
            return true;
        }
        PlayerUnleashEntityEvent event = new PlayerUnleashEntityEvent((Entity)entity.getBukkitEntity(), (Player)player.getBukkitEntity(), CraftEquipmentSlot.getHand(hand), dropLeash);
        entity.an().getCraftServer().getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            if (resendState && entity instanceof Leashable) {
                Leashable leashable = (Leashable)((Object)entity);
                ((EntityPlayer)player).g.b(new PacketPlayOutAttachEntity(entity, leashable.ak_()));
            }
            return false;
        }
        if (entity instanceof Leashable) {
            Leashable leashable = (Leashable)((Object)entity);
            if (event.isDropLeash()) {
                leashable.w();
            } else {
                leashable.x();
            }
        }
        return true;
    }

    public static boolean handlePlayerLeashEntityEvent(Leashable leashed, net.minecraft.world.entity.Entity leashHolder, EntityHuman player, EnumHand hand) {
        if (!(leashed instanceof net.minecraft.world.entity.Entity)) {
            return true;
        }
        net.minecraft.world.entity.Entity leashedEntity = (net.minecraft.world.entity.Entity)((Object)leashed);
        return !CraftEventFactory.callPlayerLeashEntityEvent(leashedEntity, leashHolder, player, hand).isCancelled();
    }

    @Nullable
    public static PlayerLeashEntityEvent callPlayerLeashEntityEvent(Leashable leashed, net.minecraft.world.entity.Entity leashHolder, EntityHuman player, EnumHand hand) {
        if (!(leashed instanceof net.minecraft.world.entity.Entity)) {
            return null;
        }
        net.minecraft.world.entity.Entity leashedEntity = (net.minecraft.world.entity.Entity)((Object)leashed);
        return CraftEventFactory.callPlayerLeashEntityEvent(leashedEntity, leashHolder, player, hand);
    }

    public static PlayerLeashEntityEvent callPlayerLeashEntityEvent(net.minecraft.world.entity.Entity entity, net.minecraft.world.entity.Entity leashHolder, EntityHuman player, EnumHand hand) {
        PlayerLeashEntityEvent event = new PlayerLeashEntityEvent((Entity)entity.getBukkitEntity(), (Entity)leashHolder.getBukkitEntity(), (Player)player.getBukkitEntity(), CraftEquipmentSlot.getHand(hand));
        entity.an().getCraftServer().getPluginManager().callEvent((Event)event);
        return event;
    }

    public static boolean callPlayerRiptideEvent(EntityHuman player, ItemStack tridentItemStack, float velocityX, float velocityY, float velocityZ) {
        PlayerRiptideEvent event = new PlayerRiptideEvent((Player)player.getBukkitEntity(), (org.bukkit.inventory.ItemStack)CraftItemStack.asCraftMirror(tridentItemStack), new Vector(velocityX, velocityY, velocityZ));
        return event.callEvent();
    }

    public static BlockShearEntityEvent callBlockShearEntityEvent(net.minecraft.world.entity.Entity animal, Block dispenser, CraftItemStack is, List<ItemStack> drops) {
        BlockShearEntityEvent bse = new BlockShearEntityEvent(dispenser, (Entity)animal.getBukkitEntity(), (org.bukkit.inventory.ItemStack)is, Lists.transform(drops, CraftItemStack::asCraftMirror));
        Bukkit.getPluginManager().callEvent((Event)bse);
        return bse;
    }

    public static PlayerShearEntityEvent handlePlayerShearEntityEvent(EntityHuman player, net.minecraft.world.entity.Entity sheared, ItemStack shears, EnumHand hand, List<ItemStack> drops) {
        if (!(player instanceof EntityPlayer)) {
            return null;
        }
        PlayerShearEntityEvent event = new PlayerShearEntityEvent((Player)player.getBukkitEntity(), (Entity)sheared.getBukkitEntity(), (org.bukkit.inventory.ItemStack)CraftItemStack.asCraftMirror(shears), hand == EnumHand.b ? EquipmentSlot.OFF_HAND : EquipmentSlot.HAND, Lists.transform(drops, CraftItemStack::asCraftMirror));
        Bukkit.getPluginManager().callEvent((Event)event);
        return event;
    }

    public static Cancellable handleStatisticsIncrease(EntityHuman entityHuman, net.minecraft.stats.Statistic<?> statistic, int current, int newValue) {
        PlayerStatisticIncrementEvent event;
        CraftPlayer player = ((EntityPlayer)entityHuman).getBukkitEntity();
        Statistic stat = CraftStatistic.getBukkitStatistic(statistic);
        if (stat == null) {
            System.err.println("Unhandled statistic: " + String.valueOf(statistic));
            return null;
        }
        switch (stat) {
            case FALL_ONE_CM: 
            case BOAT_ONE_CM: 
            case CLIMB_ONE_CM: 
            case WALK_ON_WATER_ONE_CM: 
            case WALK_UNDER_WATER_ONE_CM: 
            case FLY_ONE_CM: 
            case HORSE_ONE_CM: 
            case MINECART_ONE_CM: 
            case PIG_ONE_CM: 
            case PLAY_ONE_MINUTE: 
            case SWIM_ONE_CM: 
            case WALK_ONE_CM: 
            case SPRINT_ONE_CM: 
            case CROUCH_ONE_CM: 
            case TIME_SINCE_DEATH: 
            case SNEAK_TIME: 
            case TOTAL_WORLD_TIME: 
            case TIME_SINCE_REST: 
            case AVIATE_ONE_CM: 
            case STRIDER_ONE_CM: {
                return null;
            }
        }
        if (stat.getType() == Statistic.Type.UNTYPED) {
            event = new PlayerStatisticIncrementEvent((Player)player, stat, current, newValue);
        } else if (stat.getType() == Statistic.Type.ENTITY) {
            EntityType entityType = CraftStatistic.getEntityTypeFromStatistic(statistic);
            event = new PlayerStatisticIncrementEvent((Player)player, stat, current, newValue, entityType);
        } else {
            Material material = CraftStatistic.getMaterialFromStatistic(statistic);
            event = new PlayerStatisticIncrementEvent((Player)player, stat, current, newValue, material);
        }
        event.callEvent();
        return (Cancellable)event;
    }

    public static boolean callFireworkExplodeEvent(EntityFireworks firework) {
        FireworkExplodeEvent event = new FireworkExplodeEvent((Firework)firework.getBukkitEntity());
        if (!event.callEvent()) {
            firework.discard(null);
            return false;
        }
        return true;
    }

    public static PrepareAnvilEvent callPrepareAnvilEvent(AnvilView view, ItemStack item) {
        view.getTopInventory().setItem(2, (org.bukkit.inventory.ItemStack)CraftItemStack.asCraftMirror(item));
        return null;
    }

    public static PrepareGrindstoneEvent callPrepareGrindstoneEvent(InventoryView view, ItemStack item) {
        view.getTopInventory().setItem(2, (org.bukkit.inventory.ItemStack)CraftItemStack.asCraftMirror(item));
        return null;
    }

    public static PrepareSmithingEvent callPrepareSmithingEvent(InventoryView view, ItemStack item) {
        view.getTopInventory().setItem(3, (org.bukkit.inventory.ItemStack)CraftItemStack.asCraftMirror(item));
        return null;
    }

    public static void callPrepareResultEvent(Container container, int resultSlot) {
        Object event;
        CraftItemStack result;
        InventoryView view = container.getBukkitView();
        org.bukkit.inventory.ItemStack origItem = view.getTopInventory().getItem(resultSlot);
        CraftItemStack craftItemStack = result = origItem != null ? CraftItemStack.asCraftCopy(origItem) : null;
        if (view.getTopInventory() instanceof AnvilInventory && view instanceof AnvilView) {
            AnvilView anvilView = (AnvilView)view;
            event = new PrepareAnvilEvent(anvilView, (org.bukkit.inventory.ItemStack)result);
        } else {
            event = view.getTopInventory() instanceof GrindstoneInventory ? new PrepareGrindstoneEvent(view, (org.bukkit.inventory.ItemStack)result) : (view.getTopInventory() instanceof SmithingInventory ? new PrepareSmithingEvent(view, (org.bukkit.inventory.ItemStack)result) : new PrepareResultEvent(view, (org.bukkit.inventory.ItemStack)result));
        }
        event.callEvent();
        event.getInventory().setItem(resultSlot, event.getResult());
        container.d();
    }

    public static SpawnerSpawnEvent callSpawnerSpawnEvent(net.minecraft.world.entity.Entity spawnee, BlockPosition pos) {
        CraftEntity entity = spawnee.getBukkitEntity();
        BlockState state = CraftBlock.at(spawnee.an(), pos).getState();
        if (!(state instanceof CreatureSpawner)) {
            state = null;
        }
        SpawnerSpawnEvent event = new SpawnerSpawnEvent((Entity)entity, (CreatureSpawner)state);
        entity.getServer().getPluginManager().callEvent((Event)event);
        return event;
    }

    public static TrialSpawnerSpawnEvent callTrialSpawnerSpawnEvent(net.minecraft.world.entity.Entity spawnee, BlockPosition pos) {
        CraftEntity entity = spawnee.getBukkitEntity();
        BlockState state = CraftBlock.at(spawnee.an(), pos).getState();
        if (!(state instanceof TrialSpawner)) {
            state = null;
        }
        TrialSpawnerSpawnEvent event = new TrialSpawnerSpawnEvent((Entity)entity, (TrialSpawner)state);
        entity.getServer().getPluginManager().callEvent((Event)event);
        return event;
    }

    public static BlockDispenseLootEvent callBlockDispenseLootEvent(WorldServer level, BlockPosition pos, EntityHuman player, List<ItemStack> rewardLoot, net.minecraft.world.level.storage.loot.LootTable lootTable) {
        List craftItemStacks = rewardLoot.stream().map(CraftItemStack::asBukkitCopy).collect(Collectors.toList());
        BlockDispenseLootEvent event = new BlockDispenseLootEvent(player == null ? null : (Player)player.getBukkitEntity(), (Block)CraftBlock.at(level, pos), craftItemStacks, (LootTable)lootTable.craftLootTable);
        Bukkit.getPluginManager().callEvent((Event)event);
        return event;
    }

    public static VaultDisplayItemEvent callVaultDisplayItemEvent(WorldServer level, BlockPosition pos, ItemStack displayitemStack) {
        VaultDisplayItemEvent event = new VaultDisplayItemEvent((Block)CraftBlock.at(level, pos), CraftItemStack.asBukkitCopy(displayitemStack));
        Bukkit.getPluginManager().callEvent((Event)event);
        return event;
    }

    public static EntityToggleGlideEvent callToggleGlideEvent(EntityLiving entity, boolean gliding) {
        EntityToggleGlideEvent event = new EntityToggleGlideEvent((LivingEntity)entity.getBukkitEntity(), gliding);
        entity.an().getCraftServer().getPluginManager().callEvent((Event)event);
        return event;
    }

    public static EntityToggleSwimEvent callToggleSwimEvent(EntityLiving entity, boolean swimming) {
        EntityToggleSwimEvent event = new EntityToggleSwimEvent((LivingEntity)entity.getBukkitEntity(), swimming);
        entity.an().getCraftServer().getPluginManager().callEvent((Event)event);
        return event;
    }

    public static AreaEffectCloudApplyEvent callAreaEffectCloudApplyEvent(EntityAreaEffectCloud cloud, List<LivingEntity> entities) {
        AreaEffectCloudApplyEvent event = new AreaEffectCloudApplyEvent((AreaEffectCloud)cloud.getBukkitEntity(), entities);
        cloud.an().getCraftServer().getPluginManager().callEvent((Event)event);
        return event;
    }

    public static VehicleCreateEvent callVehicleCreateEvent(net.minecraft.world.entity.Entity entity) {
        Vehicle bukkitEntity = (Vehicle)entity.getBukkitEntity();
        VehicleCreateEvent event = new VehicleCreateEvent(bukkitEntity);
        Bukkit.getPluginManager().callEvent((Event)event);
        return event;
    }

    public static EntityBreedEvent callEntityBreedEvent(EntityLiving child, EntityLiving mother, EntityLiving father, EntityLiving breeder, ItemStack bredWith, int experience) {
        LivingEntity breederEntity = breeder == null ? null : (LivingEntity)breeder.getBukkitEntity();
        CraftItemStack bredWithStack = bredWith == null ? null : CraftItemStack.asCraftMirror(bredWith).clone();
        EntityBreedEvent event = new EntityBreedEvent((LivingEntity)child.getBukkitEntity(), (LivingEntity)mother.getBukkitEntity(), (LivingEntity)father.getBukkitEntity(), breederEntity, (org.bukkit.inventory.ItemStack)bredWithStack, experience);
        event.callEvent();
        return event;
    }

    public static BlockPhysicsEvent callBlockPhysicsEvent(GeneratorAccess world, BlockPosition pos) {
        CraftBlock block = CraftBlock.at(world, pos);
        BlockPhysicsEvent event = new BlockPhysicsEvent((Block)block, block.getBlockData());
        if (world instanceof net.minecraft.world.level.World) {
            event.callEvent();
        }
        return event;
    }

    public static EntityPotionEffectEvent callEntityPotionEffectChangeEvent(EntityLiving entity, @Nullable MobEffect oldEffect, @Nullable MobEffect newEffect, EntityPotionEffectEvent.Cause cause) {
        return CraftEventFactory.callEntityPotionEffectChangeEvent(entity, oldEffect, newEffect, cause, true);
    }

    public static EntityPotionEffectEvent callEntityPotionEffectChangeEvent(EntityLiving entity, @Nullable MobEffect oldEffect, @Nullable MobEffect newEffect, EntityPotionEffectEvent.Cause cause, EntityPotionEffectEvent.Action action) {
        return CraftEventFactory.callEntityPotionEffectChangeEvent(entity, oldEffect, newEffect, cause, action, true);
    }

    public static EntityPotionEffectEvent callEntityPotionEffectChangeEvent(EntityLiving entity, @Nullable MobEffect oldEffect, @Nullable MobEffect newEffect, EntityPotionEffectEvent.Cause cause, boolean willOverride) {
        EntityPotionEffectEvent.Action action = EntityPotionEffectEvent.Action.CHANGED;
        if (oldEffect == null) {
            action = EntityPotionEffectEvent.Action.ADDED;
        } else if (newEffect == null) {
            action = EntityPotionEffectEvent.Action.REMOVED;
        }
        return CraftEventFactory.callEntityPotionEffectChangeEvent(entity, oldEffect, newEffect, cause, action, willOverride);
    }

    public static EntityPotionEffectEvent callEntityPotionEffectChangeEvent(EntityLiving entity, @Nullable MobEffect oldEffect, @Nullable MobEffect newEffect, EntityPotionEffectEvent.Cause cause, EntityPotionEffectEvent.Action action, boolean willOverride) {
        PotionEffect bukkitOldEffect = oldEffect == null ? null : CraftPotionUtil.toBukkit(oldEffect);
        PotionEffect bukkitNewEffect = newEffect == null ? null : CraftPotionUtil.toBukkit(newEffect);
        Preconditions.checkState((bukkitOldEffect != null || bukkitNewEffect != null ? 1 : 0) != 0, (Object)"Old and new potion effect are both null");
        EntityPotionEffectEvent event = new EntityPotionEffectEvent((LivingEntity)entity.getBukkitEntity(), bukkitOldEffect, bukkitNewEffect, cause, action, willOverride);
        Bukkit.getPluginManager().callEvent((Event)event);
        return event;
    }

    public static boolean handleBlockFormEvent(net.minecraft.world.level.World world, BlockPosition pos, IBlockData state, int flags) {
        return CraftEventFactory.handleBlockFormEvent(world, pos, state, flags, null);
    }

    public static boolean handleBlockFormEvent(net.minecraft.world.level.World world, BlockPosition pos, IBlockData state, int flags, @Nullable net.minecraft.world.entity.Entity entity) {
        return CraftEventFactory.handleBlockFormEvent(world, pos, state, flags, entity, false);
    }

    public static boolean handleBlockFormEvent(net.minecraft.world.level.World world, BlockPosition pos, IBlockData state, int flags, @Nullable net.minecraft.world.entity.Entity entity, boolean checkSetResult) {
        BlockFormEvent event;
        CraftBlockState snapshot = CraftBlockStates.getBlockState(world, pos);
        snapshot.setData(state);
        Object object = event = entity == null ? new BlockFormEvent((Block)snapshot.getBlock(), (BlockState)snapshot) : new EntityBlockFormEvent((Entity)entity.getBukkitEntity(), (Block)snapshot.getBlock(), (BlockState)snapshot);
        if (event.callEvent()) {
            boolean result = snapshot.place(flags);
            return !checkSetResult || result;
        }
        return false;
    }

    public static boolean handleBatToggleSleepEvent(net.minecraft.world.entity.Entity bat, boolean awake) {
        BatToggleSleepEvent event = new BatToggleSleepEvent((Bat)bat.getBukkitEntity(), awake);
        Bukkit.getPluginManager().callEvent((Event)event);
        return !event.isCancelled();
    }

    public static PlayerRecipeDiscoverEvent callPlayerRecipeListUpdateEvent(EntityHuman player, RecipeHolder<?> recipeHolder) {
        PlayerRecipeDiscoverEvent event = new PlayerRecipeDiscoverEvent((Player)player.getBukkitEntity(), CraftNamespacedKey.fromMinecraft(recipeHolder.a().a()), recipeHolder.b().i());
        event.callEvent();
        return event;
    }

    public static EntityPickupItemEvent callEntityPickupItemEvent(net.minecraft.world.entity.Entity entity, EntityItem item, int remaining, boolean cancelled) {
        EntityPickupItemEvent event = new EntityPickupItemEvent((LivingEntity)entity.getBukkitEntity(), (Item)item.getBukkitEntity(), remaining);
        event.setCancelled(cancelled);
        Bukkit.getPluginManager().callEvent((Event)event);
        return event;
    }

    public static LightningStrikeEvent callLightningStrikeEvent(LightningStrike entity, LightningStrikeEvent.Cause cause) {
        LightningStrikeEvent event = new LightningStrikeEvent(entity.getWorld(), entity, cause);
        Bukkit.getPluginManager().callEvent((Event)event);
        return event;
    }

    public static boolean callRaidTriggerEvent(net.minecraft.world.level.World level, net.minecraft.world.entity.raid.Raid raid, EntityPlayer player) {
        RaidTriggerEvent event = new RaidTriggerEvent((Raid)new CraftRaid(raid, level), (World)level.getWorld(), (Player)player.getBukkitEntity());
        Bukkit.getPluginManager().callEvent((Event)event);
        return !event.isCancelled();
    }

    public static void callRaidFinishEvent(net.minecraft.world.level.World level, net.minecraft.world.entity.raid.Raid raid, List<Player> players) {
        RaidFinishEvent event = new RaidFinishEvent((Raid)new CraftRaid(raid, level), (World)level.getWorld(), players);
        Bukkit.getPluginManager().callEvent((Event)event);
    }

    public static void callRaidStopEvent(net.minecraft.world.level.World level, net.minecraft.world.entity.raid.Raid raid, RaidStopEvent.Reason reason) {
        RaidStopEvent event = new RaidStopEvent((Raid)new CraftRaid(raid, level), (World)level.getWorld(), reason);
        Bukkit.getPluginManager().callEvent((Event)event);
    }

    public static void callRaidSpawnWaveEvent(net.minecraft.world.level.World level, net.minecraft.world.entity.raid.Raid raid, EntityRaider leader, Set<EntityRaider> raiders) {
        Raider bukkitLeader = (Raider)leader.getBukkitEntity();
        ArrayList<Raider> bukkitRaiders = new ArrayList<Raider>(raiders.size());
        for (EntityRaider raider : raiders) {
            bukkitRaiders.add((Raider)raider.getBukkitEntity());
        }
        RaidSpawnWaveEvent event = new RaidSpawnWaveEvent((Raid)new CraftRaid(raid, level), (World)level.getWorld(), bukkitLeader, bukkitRaiders);
        event.callEvent();
    }

    public static LootGenerateEvent callLootGenerateEvent(IInventory inventory, net.minecraft.world.level.storage.loot.LootTable lootTable, LootTableInfo lootInfo, List<ItemStack> loot, boolean plugin) {
        CraftWorld world = lootInfo.d().getWorld();
        net.minecraft.world.entity.Entity entity = lootInfo.c(LootContextParameters.a);
        List bukkitLoot = loot.stream().map(CraftItemStack::asCraftMirror).collect(Collectors.toCollection(ArrayList::new));
        LootGenerateEvent event = new LootGenerateEvent((World)world, (Entity)(entity != null ? entity.getBukkitEntity() : null), inventory.getOwner(), (LootTable)lootTable.craftLootTable, CraftLootTable.convertContext(lootInfo), bukkitLoot, plugin);
        Bukkit.getPluginManager().callEvent((Event)event);
        return event;
    }

    public static boolean callStriderTemperatureChangeEvent(EntityStrider strider, boolean shivering) {
        StriderTemperatureChangeEvent event = new StriderTemperatureChangeEvent((Strider)strider.getBukkitEntity(), shivering);
        Bukkit.getPluginManager().callEvent((Event)event);
        return !event.isCancelled();
    }

    public static boolean handleEntitySpellCastEvent(EntityIllagerWizard caster, EntityIllagerWizard.Spell spell) {
        EntitySpellCastEvent event = new EntitySpellCastEvent((Spellcaster)caster.getBukkitEntity(), CraftSpellcaster.toBukkitSpell(spell));
        Bukkit.getPluginManager().callEvent((Event)event);
        return !event.isCancelled();
    }

    public static ArrowBodyCountChangeEvent callArrowBodyCountChangeEvent(EntityLiving entity, int oldAmount, int newAmount, boolean isReset) {
        LivingEntity bukkitEntity = (LivingEntity)entity.getBukkitEntity();
        ArrowBodyCountChangeEvent event = new ArrowBodyCountChangeEvent(bukkitEntity, oldAmount, newAmount, isReset);
        Bukkit.getPluginManager().callEvent((Event)event);
        return event;
    }

    public static EntityExhaustionEvent callPlayerExhaustionEvent(EntityHuman humanEntity, EntityExhaustionEvent.ExhaustionReason exhaustionReason, float exhaustion) {
        EntityExhaustionEvent event = new EntityExhaustionEvent((HumanEntity)humanEntity.getBukkitEntity(), exhaustionReason, exhaustion);
        Bukkit.getPluginManager().callEvent((Event)event);
        return event;
    }

    public static PiglinBarterEvent callPiglinBarterEvent(EntityPiglin piglin, List<ItemStack> outcome, ItemStack input) {
        PiglinBarterEvent event = new PiglinBarterEvent((Piglin)piglin.getBukkitEntity(), CraftItemStack.asBukkitCopy(input), outcome.stream().map(CraftItemStack::asBukkitCopy).collect(Collectors.toList()));
        Bukkit.getPluginManager().callEvent((Event)event);
        return event;
    }

    public static void callEntitiesLoadEvent(net.minecraft.world.level.World world, ChunkCoordIntPair coords, List<net.minecraft.world.entity.Entity> entities) {
        List bukkitEntities = Collections.unmodifiableList(entities.stream().map(net.minecraft.world.entity.Entity::getBukkitEntity).collect(Collectors.toList()));
        EntitiesLoadEvent event = new EntitiesLoadEvent((Chunk)new CraftChunk((WorldServer)world, coords.h, coords.i), bukkitEntities);
        Bukkit.getPluginManager().callEvent((Event)event);
    }

    public static void callEntitiesUnloadEvent(net.minecraft.world.level.World world, ChunkCoordIntPair coords, List<net.minecraft.world.entity.Entity> entities) {
        List bukkitEntities = Collections.unmodifiableList(entities.stream().map(net.minecraft.world.entity.Entity::getBukkitEntity).collect(Collectors.toList()));
        EntitiesUnloadEvent event = new EntitiesUnloadEvent((Chunk)new CraftChunk((WorldServer)world, coords.h, coords.i), bukkitEntities);
        Bukkit.getPluginManager().callEvent((Event)event);
    }

    public static boolean callTNTPrimeEvent(net.minecraft.world.level.World world, BlockPosition pos, TNTPrimeEvent.PrimeCause cause, net.minecraft.world.entity.Entity causingEntity, BlockPosition causePosition) {
        CraftEntity bukkitEntity = causingEntity == null ? null : causingEntity.getBukkitEntity();
        CraftBlock bukkitBlock = causePosition == null ? null : CraftBlock.at(world, causePosition);
        TNTPrimeEvent event = new TNTPrimeEvent((Block)CraftBlock.at(world, pos), cause, (Entity)bukkitEntity, (Block)bukkitBlock);
        Bukkit.getPluginManager().callEvent((Event)event);
        return !event.isCancelled();
    }

    public static PlayerRecipeBookClickEvent callRecipeBookClickEvent(EntityPlayer player, Recipe recipe, boolean shiftClick) {
        PlayerRecipeBookClickEvent event = new PlayerRecipeBookClickEvent((Player)player.getBukkitEntity(), recipe, shiftClick);
        Bukkit.getPluginManager().callEvent((Event)event);
        return event;
    }

    public static EntityTeleportEvent callEntityTeleportEvent(net.minecraft.world.entity.Entity nmsEntity, double x2, double y2, double z2) {
        CraftEntity entity = nmsEntity.getBukkitEntity();
        Location to = new Location(entity.getWorld(), x2, y2, z2, nmsEntity.dX(), nmsEntity.dZ());
        return CraftEventFactory.callEntityTeleportEvent(nmsEntity, to);
    }

    public static EntityTeleportEvent callEntityTeleportEvent(net.minecraft.world.entity.Entity nmsEntity, Location to) {
        CraftEntity entity = nmsEntity.getBukkitEntity();
        EntityTeleportEvent event = new EntityTeleportEvent((Entity)entity, entity.getLocation(), to);
        Bukkit.getPluginManager().callEvent((Event)event);
        return event;
    }

    @Nullable
    public static PortalEventResult handlePortalEvents(net.minecraft.world.entity.Entity entity, Location to, PortalType type, int searchRadius, int createRadius) {
        PortalEventResult result;
        if (entity instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)entity;
            PlayerTeleportEvent.TeleportCause cause = switch (type) {
                default -> throw new MatchException(null, null);
                case PortalType.ENDER -> PlayerTeleportEvent.TeleportCause.END_PORTAL;
                case PortalType.NETHER -> PlayerTeleportEvent.TeleportCause.NETHER_PORTAL;
                case PortalType.END_GATEWAY -> PlayerTeleportEvent.TeleportCause.END_GATEWAY;
                case PortalType.CUSTOM -> PlayerTeleportEvent.TeleportCause.PLUGIN;
            };
            result = CraftEventFactory.callPlayerPortalEvent(player, to, cause, searchRadius, createRadius);
        } else {
            result = CraftEventFactory.callEntityPortalEvent(entity, to, type, searchRadius, createRadius);
        }
        return result;
    }

    @Nullable
    public static PortalEventResult callPlayerPortalEvent(EntityPlayer player, Location to, PlayerTeleportEvent.TeleportCause cause, int searchRadius, int createRadius) {
        CraftPlayer bukkitPlayer = player.getBukkitEntity();
        Location from = bukkitPlayer.getLocation();
        PlayerPortalEvent event = new PlayerPortalEvent((Player)bukkitPlayer, from, to, cause, searchRadius, true, createRadius);
        event.callEvent();
        if (event.isCancelled() || event.getTo() == null || event.getTo().getWorld() == null || !player.bX()) {
            return null;
        }
        return new PortalEventResult(event.getTo(), event.getSearchRadius(), event.getCreationRadius(), event.getCanCreatePortal());
    }

    @Nullable
    public static PortalEventResult callEntityPortalEvent(net.minecraft.world.entity.Entity entity, Location to, PortalType type, int searchRadius, int createRadius) {
        CraftEntity bukkitEntity = entity.getBukkitEntity();
        Location from = bukkitEntity.getLocation();
        EntityPortalEvent event = new EntityPortalEvent((Entity)bukkitEntity, from, to, searchRadius, true, createRadius, type);
        event.callEvent();
        if (event.isCancelled() || event.getTo() == null || event.getTo().getWorld() == null || !entity.bX()) {
            return null;
        }
        return new PortalEventResult(event.getTo(), event.getSearchRadius(), event.getCreationRadius(), event.getCanCreatePortal());
    }

    public static boolean callEntityInteractEvent(net.minecraft.world.entity.Entity nmsEntity, Block block) {
        EntityInteractEvent event = new EntityInteractEvent((Entity)nmsEntity.getBukkitEntity(), block);
        Bukkit.getPluginManager().callEvent((Event)event);
        return !event.isCancelled();
    }

    public static EntityExplodeEvent callEntityExplodeEvent(net.minecraft.world.entity.Entity entity, List<Block> blocks, float yield, Explosion.Effect effect) {
        EntityExplodeEvent event = new EntityExplodeEvent((Entity)entity.getBukkitEntity(), entity.getBukkitEntity().getLocation(), blocks, yield, CraftExplosionResult.toExplosionResult(effect));
        Bukkit.getPluginManager().callEvent((Event)event);
        return event;
    }

    public static BlockExplodeEvent callBlockExplodeEvent(Block block, BlockState state, List<Block> blocks, float yield, Explosion.Effect effect) {
        BlockExplodeEvent event = new BlockExplodeEvent(block, state, blocks, yield, CraftExplosionResult.toExplosionResult(effect));
        Bukkit.getPluginManager().callEvent((Event)event);
        return event;
    }

    public static ExplosionPrimeEvent callExplosionPrimeEvent(Explosive explosive) {
        ExplosionPrimeEvent event = new ExplosionPrimeEvent(explosive);
        Bukkit.getPluginManager().callEvent((Event)event);
        return event;
    }

    public static ExplosionPrimeEvent callExplosionPrimeEvent(net.minecraft.world.entity.Entity nmsEntity, float size, boolean fire) {
        ExplosionPrimeEvent event = new ExplosionPrimeEvent((Entity)nmsEntity.getBukkitEntity(), size, fire);
        Bukkit.getPluginManager().callEvent((Event)event);
        return event;
    }

    public static io.papermc.paper.event.entity.EntityKnockbackEvent callEntityKnockbackEvent(CraftLivingEntity entity, net.minecraft.world.entity.Entity pusher, net.minecraft.world.entity.Entity attacker, EntityKnockbackEvent.Cause cause, double force, Vec3D knockback) {
        Vector apiKnockback = CraftVector.toBukkit(knockback);
        Vector currentVelocity = entity.getVelocity();
        Vector legacyFinalKnockback = currentVelocity.clone().add(apiKnockback);
        EntityKnockbackEvent.KnockbackCause legacyCause = EntityKnockbackEvent.KnockbackCause.valueOf((String)cause.name());
        Object legacyEvent = pusher != null ? new org.bukkit.event.entity.EntityKnockbackByEntityEvent((LivingEntity)entity, (Entity)pusher.getBukkitEntity(), legacyCause, force, apiKnockback, legacyFinalKnockback) : new EntityKnockbackEvent((LivingEntity)entity, legacyCause, force, apiKnockback, legacyFinalKnockback);
        legacyEvent.callEvent();
        apiKnockback = legacyEvent.getFinalKnockback().subtract(currentVelocity);
        Object event = attacker != null ? new EntityKnockbackByEntityEvent((LivingEntity)entity, (Entity)attacker.getBukkitEntity(), cause, (float)force, apiKnockback) : new io.papermc.paper.event.entity.EntityKnockbackEvent((Entity)entity, cause, apiKnockback);
        event.setCancelled(legacyEvent.isCancelled());
        event.callEvent();
        return event;
    }

    public static void callEntityRemoveEvent(net.minecraft.world.entity.Entity entity, EntityRemoveEvent.Cause cause) {
        if (entity instanceof EntityPlayer) {
            return;
        }
        if (cause == null) {
            return;
        }
        if (entity.generation) {
            return;
        }
        Bukkit.getPluginManager().callEvent((Event)new EntityRemoveEvent((Entity)entity.getBukkitEntity(), cause));
    }

    public static void callPlayerUseUnknownEntityEvent(EntityHuman player, PacketPlayInUseEntity packet, EnumHand hand, @Nullable Vec3D vector) {
        new PlayerUseUnknownEntityEvent((Player)player.getBukkitEntity(), packet.getEntityId(), packet.isAttack(), CraftEquipmentSlot.getHand(hand), vector != null ? CraftVector.toBukkit(vector) : null).callEvent();
    }

    public static ItemStack handleWitchReadyPotionEvent(EntityWitch witch, @Nullable ItemStack potion) {
        WitchReadyPotionEvent event = new WitchReadyPotionEvent((Witch)witch.getBukkitEntity(), (org.bukkit.inventory.ItemStack)CraftItemStack.asCraftMirror(potion));
        if (!event.callEvent() || event.getPotion() == null) {
            return ItemStack.l;
        }
        return CraftItemStack.asNMSCopy(event.getPotion());
    }

    public static boolean handleBlockFailedDispenseEvent(WorldServer serverLevel, BlockPosition pos) {
        CraftBlock block = CraftBlock.at(serverLevel, pos);
        BlockFailedDispenseEvent event = new BlockFailedDispenseEvent((Block)block);
        return event.callEvent();
    }

    public static boolean handleBlockPreDispenseEvent(WorldServer serverLevel, BlockPosition pos, ItemStack itemStack, int slot) {
        CraftBlock block = CraftBlock.at(serverLevel, pos);
        BlockPreDispenseEvent event = new BlockPreDispenseEvent((Block)block, (org.bukkit.inventory.ItemStack)CraftItemStack.asCraftMirror(itemStack), slot);
        return event.callEvent();
    }

    @Nullable
    public static ItemStack handleBlockDispenseEvent(SourceBlock pointer, BlockPosition to, ItemStack itemStack, IDispenseBehavior instance) {
        ItemStack eventStack;
        IDispenseBehavior itemBehavior;
        CraftItemStack craftItem;
        CraftBlock bukkitBlock = CraftBlock.at(pointer.b(), pointer.c());
        BlockDispenseEvent event = new BlockDispenseEvent((Block)bukkitBlock, (org.bukkit.inventory.ItemStack)(craftItem = CraftItemStack.asCraftMirror(itemStack.m() ? itemStack : itemStack.c(1))).clone(), CraftVector.toBukkit(to));
        if (!event.callEvent()) {
            return itemStack;
        }
        if (!event.getItem().equals((Object)craftItem) && (itemBehavior = BlockDispenser.getDispenseBehavior(pointer, eventStack = CraftItemStack.asNMSCopy(event.getItem()))) != IDispenseBehavior.b && itemBehavior != instance) {
            itemBehavior.dispense(pointer, eventStack);
            return itemStack;
        }
        return null;
    }

    public static EntityFertilizeEggEvent callEntityFertilizeEggEvent(EntityAnimal breeding, EntityAnimal partner) {
        EntityPlayer serverPlayer = breeding.gR();
        if (serverPlayer == null) {
            serverPlayer = partner.gR();
        }
        int experience = breeding.ek().a(7) + 1;
        EntityFertilizeEggEvent event = new EntityFertilizeEggEvent((LivingEntity)breeding.getBukkitEntity(), (LivingEntity)partner.getBukkitEntity(), (Player)(serverPlayer == null ? null : serverPlayer.getBukkitEntity()), breeding.breedItem == null ? null : CraftItemStack.asCraftMirror(breeding.breedItem).clone(), experience);
        if (!event.callEvent()) {
            breeding.gT();
            partner.gT();
        }
        return event;
    }

    public static IChatBaseComponent handleLoginResult(PlayerList.LoginResult result, PlayerConnection paperConnection, NetworkManager connection, GameProfile profile, MinecraftServer server, boolean loginPhase) {
        PlayerConnectionValidateLoginEvent event = new PlayerConnectionValidateLoginEvent(paperConnection, result.isAllowed() ? null : PaperAdventure.asAdventure(result.message()));
        event.callEvent();
        IChatBaseComponent disconnectReason = PaperAdventure.asVanilla(event.getKickMessage());
        if (loginPhase) {
            disconnectReason = HorriblePlayerLoginEventHack.execute(connection, server, profile, disconnectReason == null ? PlayerList.LoginResult.ALLOW : new PlayerList.LoginResult(disconnectReason, disconnectReason == null ? PlayerLoginEvent.Result.KICK_OTHER : result.result()));
        } else if (connection.legacySavedLoginEventResultOverride != null) {
            disconnectReason = connection.legacySavedLoginEventResultOverride.orElse(null);
        }
        return disconnectReason;
    }

    public static boolean callTransporterValidateTarget(EntityCreature mob, net.minecraft.world.level.World level, BlockPosition transportItemTarget) {
        if (ItemTransportingEntityValidateTargetEvent.getHandlerList().getRegisteredListeners().length == 0) {
            return true;
        }
        ItemTransportingEntityValidateTargetEvent event = new ItemTransportingEntityValidateTargetEvent((Entity)mob.getBukkitEntity(), (Block)CraftBlock.at(level, transportItemTarget));
        event.callEvent();
        return event.isAllowed();
    }
}

