/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R6.inventory;

import com.google.common.base.Preconditions;
import net.minecraft.world.IInventory;
import net.minecraft.world.item.ItemStack;
import org.apache.commons.lang3.ArrayUtils;
import org.bukkit.craftbukkit.v1_21_R6.inventory.CraftInventory;
import org.bukkit.craftbukkit.v1_21_R6.inventory.CraftItemStack;
import org.bukkit.inventory.AbstractHorseInventory;

public class CraftInventoryAbstractHorse
extends CraftInventory
implements AbstractHorseInventory {
    private final IInventory bodyArmorInventory;
    private final IInventory saddleInventory;

    public CraftInventoryAbstractHorse(IInventory inventory, IInventory bodyArmorInventory, IInventory saddleInventory) {
        super(inventory);
        this.bodyArmorInventory = bodyArmorInventory;
        this.saddleInventory = saddleInventory;
    }

    public org.bukkit.inventory.ItemStack getSaddle() {
        return this.getItem(0);
    }

    public void setSaddle(org.bukkit.inventory.ItemStack stack) {
        this.setItem(0, stack);
    }

    public IInventory getMainInventory() {
        return this.inventory;
    }

    public IInventory getArmorInventory() {
        return this.bodyArmorInventory;
    }

    public IInventory getSaddleInventory() {
        return this.saddleInventory;
    }

    public org.bukkit.inventory.ItemStack getArmor() {
        return this.getItem(1);
    }

    public void setArmor(org.bukkit.inventory.ItemStack armor) {
        this.setItem(1, armor);
    }

    @Override
    public int getSize() {
        return this.getMainInventory().b() + this.getArmorInventory().b() + this.getSaddleInventory().b();
    }

    @Override
    public boolean isEmpty() {
        return this.getMainInventory().c() && this.getArmorInventory().c() && this.getSaddleInventory().c();
    }

    @Override
    public org.bukkit.inventory.ItemStack[] getContents() {
        org.bukkit.inventory.ItemStack[] items = new org.bukkit.inventory.ItemStack[this.getSize()];
        items[0] = this.getSaddle();
        items[1] = this.getArmor();
        for (int i2 = 2; i2 < items.length; ++i2) {
            ItemStack item = this.getMainInventory().a(i2 - 2);
            items[i2] = item.f() ? null : CraftItemStack.asCraftMirror(item);
        }
        return items;
    }

    @Override
    public void setContents(org.bukkit.inventory.ItemStack[] items) {
        Preconditions.checkArgument((items.length <= this.getSize() ? 1 : 0) != 0, (String)"Invalid inventory size (%s); expected %s or less", (int)items.length, (int)this.getSize());
        this.setSaddle((org.bukkit.inventory.ItemStack)ArrayUtils.get((Object[])items, (int)0));
        this.setArmor((org.bukkit.inventory.ItemStack)ArrayUtils.get((Object[])items, (int)1));
        for (int i2 = 2; i2 < this.getSize(); ++i2) {
            ItemStack item = i2 >= items.length ? ItemStack.l : CraftItemStack.asNMSCopy(items[i2]);
            this.getMainInventory().a(i2 - 2, item);
        }
    }

    @Override
    public org.bukkit.inventory.ItemStack getItem(int index) {
        ItemStack item;
        if (index == 0) {
            ItemStack item2 = this.getSaddleInventory().a(0);
            return item2.f() ? null : CraftItemStack.asCraftMirror(item2);
        }
        if (index == 1) {
            ItemStack item3 = this.getArmorInventory().a(0);
            return item3.f() ? null : CraftItemStack.asCraftMirror(item3);
        }
        int shiftedIndex = index;
        if (index > 0) {
            --shiftedIndex;
        }
        if (index > 1) {
            --shiftedIndex;
        }
        return (item = this.getMainInventory().a(shiftedIndex)).f() ? null : CraftItemStack.asCraftMirror(item);
    }

    @Override
    public void setItem(int index, org.bukkit.inventory.ItemStack item) {
        if (index == 0) {
            this.getSaddleInventory().a(0, CraftItemStack.asNMSCopy(item));
        } else if (index == 1) {
            this.getArmorInventory().a(0, CraftItemStack.asNMSCopy(item));
        } else {
            int shiftedIndex = index;
            if (index > 0) {
                --shiftedIndex;
            }
            if (index > 1) {
                --shiftedIndex;
            }
            this.getMainInventory().a(shiftedIndex, CraftItemStack.asNMSCopy(item));
        }
    }
}

