/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R6.inventory;

import com.google.common.base.Preconditions;
import com.google.common.collect.Multimap;
import io.papermc.paper.adventure.PaperAdventure;
import io.papermc.paper.datacomponent.DataComponentType;
import io.papermc.paper.datacomponent.DataComponentTypes;
import io.papermc.paper.datacomponent.PaperDataComponentType;
import io.papermc.paper.datacomponent.item.ItemEnchantments;
import io.papermc.paper.persistence.PaperPersistentDataContainerView;
import io.papermc.paper.persistence.PersistentDataContainerView;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.ThreadLocalRandom;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.kyori.adventure.text.Component;
import net.minecraft.advancements.critereon.CriterionConditionItem;
import net.minecraft.advancements.critereon.CriterionConditionValue;
import net.minecraft.advancements.critereon.DataComponentMatchers;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.component.DataComponentExactPredicate;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.component.PatchedDataComponentMap;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.item.component.ResolvableProfile;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentManager;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import org.bukkit.Material;
import org.bukkit.attribute.Attribute;
import org.bukkit.attribute.AttributeModifier;
import org.bukkit.block.data.BlockData;
import org.bukkit.configuration.serialization.DelegateDeserialization;
import org.bukkit.craftbukkit.v1_21_R6.enchantments.CraftEnchantment;
import org.bukkit.craftbukkit.v1_21_R6.entity.CraftLivingEntity;
import org.bukkit.craftbukkit.v1_21_R6.inventory.CraftItemFactory;
import org.bukkit.craftbukkit.v1_21_R6.inventory.CraftItemType;
import org.bukkit.craftbukkit.v1_21_R6.inventory.CraftMetaItem;
import org.bukkit.craftbukkit.v1_21_R6.persistence.CraftPersistentDataContainer;
import org.bukkit.craftbukkit.v1_21_R6.persistence.CraftPersistentDataTypeRegistry;
import org.bukkit.craftbukkit.v1_21_R6.util.CraftMagicNumbers;
import org.bukkit.entity.LivingEntity;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.ItemType;
import org.bukkit.inventory.meta.BlockDataMeta;
import org.bukkit.inventory.meta.Damageable;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.Repairable;
import org.bukkit.material.MaterialData;
import org.bukkit.persistence.PersistentDataContainer;
import org.jetbrains.annotations.NotNull;

@DelegateDeserialization(value=ItemStack.class)
public final class CraftItemStack
extends ItemStack {
    private static final VarHandle API_ITEM_STACK_CRAFT_DELEGATE_FIELD;
    public net.minecraft.world.item.ItemStack handle;
    public static final String PDC_CUSTOM_DATA_KEY = "PublicBukkitValues";
    private static final CraftPersistentDataTypeRegistry REGISTRY;
    private final PaperPersistentDataContainerView pdcView = new PaperPersistentDataContainerView(REGISTRY){

        public int getSize() {
            return CraftItemStack.this.getPdcTag().i();
        }

        @Override
        public NBTTagCompound toTagCompound() {
            return CraftItemStack.this.getPdcTag();
        }

        @Override
        public NBTBase getTag(String key) {
            return CraftItemStack.this.getPdcTag().a(key);
        }
    };

    private static CraftItemStack getCraftStack(ItemStack bukkit) {
        if (bukkit instanceof CraftItemStack) {
            CraftItemStack craftItemStack = (CraftItemStack)bukkit;
            return craftItemStack;
        }
        return API_ITEM_STACK_CRAFT_DELEGATE_FIELD.get(bukkit);
    }

    public int hashCode() {
        if (this.handle == null || this.handle.f()) {
            return net.minecraft.world.item.ItemStack.l.hashCode();
        }
        int hash = net.minecraft.world.item.ItemStack.b(this.handle);
        hash = hash * 31 + this.handle.M();
        return hash;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ItemStack)) {
            return false;
        }
        ItemStack bukkit = (ItemStack)obj;
        CraftItemStack craftStack = CraftItemStack.getCraftStack(bukkit);
        if (this.handle == craftStack.handle) {
            return true;
        }
        if (this.handle == null || craftStack.handle == null) {
            return false;
        }
        if (this.handle.f() && craftStack.handle.f()) {
            return true;
        }
        return net.minecraft.world.item.ItemStack.a(this.handle, craftStack.handle);
    }

    public static net.minecraft.world.item.ItemStack unwrap(ItemStack bukkit) {
        CraftItemStack craftItemStack = CraftItemStack.getCraftStack(bukkit);
        return craftItemStack.handle == null ? net.minecraft.world.item.ItemStack.l : craftItemStack.handle;
    }

    public static net.minecraft.world.item.ItemStack getOrCloneOnMutation(ItemStack old, ItemStack newInstance) {
        return old == newInstance ? CraftItemStack.unwrap(old) : CraftItemStack.asNMSCopy(newInstance);
    }

    public boolean isEmpty() {
        return this.handle == null || this.handle.f();
    }

    public static net.minecraft.world.item.ItemStack asNMSCopy(ItemStack original) {
        if (original == null || original.isEmpty()) {
            return net.minecraft.world.item.ItemStack.l;
        }
        CraftItemStack stack = CraftItemStack.getCraftStack(original);
        return stack.handle == null ? net.minecraft.world.item.ItemStack.l : stack.handle.v();
    }

    public static List<net.minecraft.world.item.ItemStack> asNMSCopy(List<? extends ItemStack> originals) {
        ArrayList<net.minecraft.world.item.ItemStack> items = new ArrayList<net.minecraft.world.item.ItemStack>(originals.size());
        for (ItemStack itemStack : originals) {
            items.add(CraftItemStack.asNMSCopy(itemStack));
        }
        return items;
    }

    public static net.minecraft.world.item.ItemStack copyNMSStack(net.minecraft.world.item.ItemStack original, int amount) {
        net.minecraft.world.item.ItemStack stack = original.v();
        stack.e(amount);
        return stack;
    }

    public static ItemStack asBukkitCopy(net.minecraft.world.item.ItemStack original) {
        return CraftItemStack.asCraftMirror(original.v());
    }

    public static CraftItemStack asCraftMirror(net.minecraft.world.item.ItemStack original) {
        return new CraftItemStack(original == null || original.f() ? null : original);
    }

    public static CraftItemStack asCraftCopy(ItemStack original) {
        if (original instanceof CraftItemStack) {
            CraftItemStack stack = (CraftItemStack)original;
            return new CraftItemStack(stack.handle == null ? null : stack.handle.v());
        }
        return new CraftItemStack(original);
    }

    public static CraftItemStack asNewCraftStack(Item item) {
        return CraftItemStack.asNewCraftStack(item, 1);
    }

    public static CraftItemStack asNewCraftStack(Item item, int amount) {
        return new CraftItemStack(CraftItemType.minecraftToBukkit(item), amount, 0, null);
    }

    public static CriterionConditionItem asCriterionConditionItem(ItemStack original) {
        net.minecraft.world.item.ItemStack nms = CraftItemStack.asNMSCopy(original);
        DataComponentExactPredicate predicate = DataComponentExactPredicate.a(PatchedDataComponentMap.a(DataComponentMap.a, nms.d()));
        return new CriterionConditionItem(Optional.of(HolderSet.a(nms.i())), CriterionConditionValue.IntegerRange.c, new DataComponentMatchers(predicate, Collections.emptyMap()));
    }

    private CraftItemStack(net.minecraft.world.item.ItemStack item) {
        this.handle = item;
    }

    private CraftItemStack(ItemStack item) {
        this(item.getType(), item.getAmount(), item.getDurability(), item.hasItemMeta() ? item.getItemMeta() : null);
    }

    private CraftItemStack(Material type, int amount, short durability, ItemMeta itemMeta) {
        this.setType(type);
        this.setAmount(amount);
        this.setDurability(durability);
        this.setItemMeta(itemMeta);
    }

    public MaterialData getData() {
        return this.handle != null ? CraftMagicNumbers.getMaterialData(this.handle.h()) : super.getData();
    }

    public Material getType() {
        return this.handle != null ? CraftItemType.minecraftToBukkit(this.handle.h()) : Material.AIR;
    }

    public void setType(Material type) {
        if (this.getType() == type) {
            return;
        }
        if (type == Material.AIR) {
            this.handle = null;
        } else if (CraftItemType.bukkitToMinecraft(type) == null) {
            this.handle = null;
        } else if (this.handle == null) {
            this.handle = new net.minecraft.world.item.ItemStack(CraftItemType.bukkitToMinecraft(type), 1);
        } else {
            Material oldType = CraftMagicNumbers.getMaterial(this.handle.h());
            this.handle.setItem(CraftItemType.bukkitToMinecraft(type));
            if (this.hasItemMeta()) {
                this.adjustTagForItemMeta(oldType);
            }
        }
        this.setData(null);
    }

    public int getAmount() {
        return this.handle != null ? this.handle.M() : 0;
    }

    public void setAmount(int amount) {
        if (this.handle == null) {
            return;
        }
        this.handle.e(amount);
    }

    public void setDurability(short durability) {
        if (this.handle != null) {
            this.handle.b(durability);
        }
    }

    public short getDurability() {
        if (this.handle != null) {
            return (short)this.handle.o();
        }
        return -1;
    }

    public int getMaxStackSize() {
        return this.handle == null ? 64 : this.handle.k();
    }

    public int getMaxItemUseDuration(LivingEntity entity) {
        if (this.handle == null) {
            return 0;
        }
        if (entity == null && (this.handle.a(Items.yi) || this.handle.a(Items.yv))) {
            throw new UnsupportedOperationException("This item requires an entity to determine the max use duration");
        }
        return this.handle.a(entity != null ? ((CraftLivingEntity)entity).getHandle() : null);
    }

    public void addUnsafeEnchantment(org.bukkit.enchantments.Enchantment enchant, int level) {
        Preconditions.checkArgument((enchant != null ? 1 : 0) != 0, (Object)"Enchantment cannot be null");
        if (this.handle == null) {
            return;
        }
        EnchantmentManager.updateEnchantments(this.handle, mutable -> mutable.a(CraftEnchantment.bukkitToMinecraftHolder(enchant), level), true);
    }

    public boolean containsEnchantment(org.bukkit.enchantments.Enchantment enchant) {
        return this.getEnchantmentLevel(enchant) > 0;
    }

    public int getEnchantmentLevel(org.bukkit.enchantments.Enchantment enchant) {
        Preconditions.checkArgument((enchant != null ? 1 : 0) != 0, (Object)"Enchantment cannot be null");
        if (this.handle == null) {
            return 0;
        }
        return EnchantmentManager.a(CraftEnchantment.bukkitToMinecraftHolder(enchant), this.handle);
    }

    public int removeEnchantment(org.bukkit.enchantments.Enchantment enchant) {
        Preconditions.checkArgument((enchant != null ? 1 : 0) != 0, (Object)"Enchantment cannot be null");
        if (this.handle == null) {
            return 0;
        }
        net.minecraft.world.item.enchantment.ItemEnchantments itemEnchantments = this.handle.a(DataComponents.l, net.minecraft.world.item.enchantment.ItemEnchantments.a);
        if (itemEnchantments.d()) {
            return 0;
        }
        Holder<Enchantment> removedEnchantment = CraftEnchantment.bukkitToMinecraftHolder(enchant);
        if (itemEnchantments.a().contains(removedEnchantment)) {
            int previousLevel = itemEnchantments.a(removedEnchantment);
            ItemEnchantments.a mutable = new ItemEnchantments.a(itemEnchantments);
            mutable.a(enchantment -> enchantment.equals(removedEnchantment));
            this.handle.b(DataComponents.l, mutable.b());
            return previousLevel;
        }
        return 0;
    }

    public void removeEnchantments() {
        if (this.handle != null) {
            this.handle.b(DataComponents.l, net.minecraft.world.item.enchantment.ItemEnchantments.a);
        }
    }

    public Map<org.bukkit.enchantments.Enchantment, Integer> getEnchantments() {
        ItemEnchantments itemEnchantments = (ItemEnchantments)this.getData(DataComponentTypes.ENCHANTMENTS);
        if (itemEnchantments == null) {
            return Collections.emptyMap();
        }
        return itemEnchantments.enchantments();
    }

    public CraftItemStack clone() {
        return new CraftItemStack(this.handle != null ? this.handle.v() : null);
    }

    public ItemMeta getItemMeta() {
        return CraftItemStack.getItemMeta(this.handle);
    }

    public void adjustTagForItemMeta(Material oldType) {
        ItemMeta newMeta;
        CraftMetaItem oldMeta = (CraftMetaItem)CraftItemFactory.instance().getItemMeta(oldType);
        if (oldMeta == null) {
            newMeta = CraftItemStack.getItemMeta(this.handle);
        } else {
            HashSet extraHandledDcts = new HashSet(CraftMetaItem.getTopLevelHandledDcts(oldMeta.getClass()));
            newMeta = CraftItemStack.getItemMeta(this.handle, CraftItemType.minecraftToBukkitNew(this.handle.h()), extraHandledDcts);
        }
        this.setItemMeta(newMeta);
    }

    public static void applyMetaToItem(final net.minecraft.world.item.ItemStack itemStack, ItemMeta itemMeta) {
        CraftMetaItem.Applicator tag = new CraftMetaItem.Applicator(){

            @Override
            void skullCallback(ResolvableProfile profile) {
                itemStack.b(DataComponents.ak, profile);
            }
        };
        ((CraftMetaItem)itemMeta).applyToItem(tag);
        itemStack.b(tag.build());
    }

    public static ItemMeta getItemMeta(net.minecraft.world.item.ItemStack item) {
        return CraftItemStack.getItemMeta(item, null);
    }

    public static ItemMeta getItemMeta(net.minecraft.world.item.ItemStack item, ItemType metaForType) {
        return CraftItemStack.getItemMeta(item, metaForType, null);
    }

    public static ItemMeta getItemMeta(net.minecraft.world.item.ItemStack item, ItemType metaForType, Set<DataComponentType<?>> extraHandledDcts) {
        if (!CraftItemStack.hasItemMeta(item)) {
            return CraftItemFactory.instance().getItemMeta(CraftItemStack.getType(item));
        }
        if (metaForType != null) {
            return ((CraftItemType)metaForType).getItemMeta(item, extraHandledDcts);
        }
        return ((CraftItemType)CraftItemType.minecraftToBukkitNew(item.h())).getItemMeta(item, extraHandledDcts);
    }

    static Material getType(net.minecraft.world.item.ItemStack item) {
        return item == null ? Material.AIR : CraftItemType.minecraftToBukkit(item.h());
    }

    public boolean setItemMeta(ItemMeta itemMeta) {
        return CraftItemStack.setItemMeta(this.handle, itemMeta);
    }

    public static boolean setItemMeta(final net.minecraft.world.item.ItemStack item, ItemMeta itemMeta) {
        if (item == null) {
            return false;
        }
        if (CraftItemFactory.instance().equals(itemMeta, null)) {
            item.restorePatch(DataComponentPatch.a);
            return true;
        }
        if (!CraftItemFactory.instance().isApplicable(itemMeta, CraftItemStack.getType(item))) {
            return false;
        }
        itemMeta = CraftItemFactory.instance().asMetaFor(itemMeta, CraftItemStack.getType(item));
        if (itemMeta == null) {
            return true;
        }
        if (!((CraftMetaItem)itemMeta).isEmpty()) {
            CraftMetaItem.Applicator tag = new CraftMetaItem.Applicator(){

                @Override
                void skullCallback(ResolvableProfile resolvableProfile) {
                    item.b(DataComponents.ak, resolvableProfile);
                }
            };
            ((CraftMetaItem)itemMeta).applyToItem(tag);
            item.restorePatch(DataComponentPatch.a);
            item.b(tag.build());
        }
        return true;
    }

    @NotNull
    public Component effectiveName() {
        return this.handle == null ? Component.empty() : PaperAdventure.asAdventure(this.handle.B());
    }

    public boolean isSimilar(ItemStack stack) {
        if (stack == null) {
            return false;
        }
        if (stack == this) {
            return true;
        }
        CraftItemStack that = CraftItemStack.getCraftStack(stack);
        if (this.handle == that.handle) {
            return true;
        }
        if (this.handle == null || that.handle == null) {
            return false;
        }
        return net.minecraft.world.item.ItemStack.c(this.handle, that.handle);
    }

    public boolean hasItemMeta() {
        return CraftItemStack.hasItemMeta(this.handle) && !CraftItemFactory.instance().equals(this.getItemMeta(), null);
    }

    static boolean hasItemMeta(net.minecraft.world.item.ItemStack item) {
        return item != null && !item.d().d();
    }

    public ItemStack withType(Material type) {
        if (type == Material.AIR) {
            return CraftItemStack.asCraftMirror(null);
        }
        net.minecraft.world.item.ItemStack copy = new net.minecraft.world.item.ItemStack(CraftItemType.bukkitToMinecraft(type), this.getAmount());
        if (this.handle != null) {
            copy.b(this.handle.d());
        }
        CraftItemStack mirrored = CraftItemStack.asCraftMirror(copy);
        mirrored.setItemMeta(mirrored.getItemMeta());
        return mirrored;
    }

    private NBTTagCompound getPdcTag() {
        if (this.handle == null) {
            return new NBTTagCompound();
        }
        CustomData customData = this.handle.a(DataComponents.b, CustomData.a);
        return customData.getUnsafe().n(PDC_CUSTOM_DATA_KEY);
    }

    public PersistentDataContainerView getPersistentDataContainer() {
        return this.pdcView;
    }

    public boolean editPersistentDataContainer(Consumer<PersistentDataContainer> consumer) {
        if (this.handle == null || this.handle.f()) {
            return false;
        }
        CraftPersistentDataContainer container = new CraftPersistentDataContainer(REGISTRY);
        CustomData customData = this.handle.a(DataComponents.b, CustomData.a);
        NBTTagCompound pdcTag = customData.getUnsafe().n(PDC_CUSTOM_DATA_KEY).l();
        container.putAll(pdcTag);
        consumer.accept(container);
        NBTTagCompound newPdcTag = container.toTagCompound();
        if (!newPdcTag.j()) {
            customData = customData.a(tag -> tag.a(PDC_CUSTOM_DATA_KEY, newPdcTag));
        } else if (customData.contains(PDC_CUSTOM_DATA_KEY)) {
            customData = customData.a(tag -> tag.r(PDC_CUSTOM_DATA_KEY));
        }
        this.handle.b(DataComponents.b, customData.a() ? null : customData);
        return true;
    }

    public <T> T getData(DataComponentType.Valued<T> type) {
        if (this.isEmpty()) {
            return null;
        }
        return (T)PaperDataComponentType.convertDataComponentValue(this.handle.a(), (PaperDataComponentType.ValuedImpl)type);
    }

    public boolean hasData(io.papermc.paper.datacomponent.DataComponentType type) {
        if (this.isEmpty()) {
            return false;
        }
        return this.handle.c(PaperDataComponentType.bukkitToMinecraft(type));
    }

    public Set<io.papermc.paper.datacomponent.DataComponentType> getDataTypes() {
        if (this.isEmpty()) {
            return Collections.emptySet();
        }
        return PaperDataComponentType.minecraftToBukkit(this.handle.a().b());
    }

    public <T> void setData(DataComponentType.Valued<T> type, T value) {
        Preconditions.checkArgument((value != null ? 1 : 0) != 0, (Object)"value cannot be null");
        if (this.isEmpty()) {
            return;
        }
        this.setDataInternal((PaperDataComponentType.ValuedImpl)type, value);
    }

    public void setData(DataComponentType.NonValued type) {
        if (this.isEmpty()) {
            return;
        }
        this.setDataInternal((PaperDataComponentType.NonValuedImpl)type, null);
    }

    private <A, V> void setDataInternal(PaperDataComponentType<A, V> type, A value) {
        this.handle.b((DataComponentType)type.getHandle(), type.getAdapter().toVanilla(value, type.getHolder()));
    }

    public void unsetData(io.papermc.paper.datacomponent.DataComponentType type) {
        if (this.isEmpty()) {
            return;
        }
        this.handle.e(PaperDataComponentType.bukkitToMinecraft(type));
    }

    public void resetData(io.papermc.paper.datacomponent.DataComponentType type) {
        if (this.isEmpty()) {
            return;
        }
        this.resetData((PaperDataComponentType)type);
    }

    private <M> void resetData(PaperDataComponentType<?, M> type) {
        DataComponentType nms = PaperDataComponentType.bukkitToMinecraft(type);
        Object nmsValue = this.handle.h().f().a(nms);
        this.handle.b(nms, nmsValue);
    }

    public void copyDataFrom(ItemStack source, Predicate<io.papermc.paper.datacomponent.DataComponentType> filter) {
        Preconditions.checkArgument((source != null ? 1 : 0) != 0, (Object)"source cannot be null");
        Preconditions.checkArgument((filter != null ? 1 : 0) != 0, (Object)"filter cannot be null");
        if (this.isEmpty() || source.isEmpty()) {
            return;
        }
        Predicate<DataComponentType<?>> nmsFilter = nms -> filter.test(PaperDataComponentType.minecraftToBukkit(nms));
        net.minecraft.world.item.ItemStack sourceNmsStack = CraftItemStack.getCraftStack((ItemStack)source).handle;
        this.handle.b(sourceNmsStack.c().a(nmsType -> !sourceNmsStack.d((DataComponentType<?>)nmsType) && nmsFilter.test((DataComponentType<?>)nmsType)));
        DataComponentPatch.d split = sourceNmsStack.d().e();
        this.handle.b(split.a().a(nmsFilter));
        split.b().stream().filter(nmsFilter).forEach(this.handle::e);
    }

    public boolean isDataOverridden(io.papermc.paper.datacomponent.DataComponentType type) {
        if (this.isEmpty()) {
            return false;
        }
        DataComponentType nms = PaperDataComponentType.bukkitToMinecraft(type);
        return this.handle.d(nms);
    }

    public boolean matchesWithoutData(ItemStack item, Set<io.papermc.paper.datacomponent.DataComponentType> exclude, boolean ignoreCount) {
        CraftItemStack craftStack = CraftItemStack.getCraftStack(item);
        if (this.handle == craftStack.handle) {
            return true;
        }
        if (this.handle == null || craftStack.handle == null) {
            return false;
        }
        if (this.handle.f() && craftStack.handle.f()) {
            return true;
        }
        net.minecraft.world.item.ItemStack left = this.handle;
        net.minecraft.world.item.ItemStack right = craftStack.handle;
        if (!ignoreCount && left.M() != right.M()) {
            return false;
        }
        if (!left.a(right.h())) {
            return false;
        }
        if (exclude.isEmpty()) {
            return left.d().equals(right.d());
        }
        HashSet skippingTypes = new HashSet(exclude.size());
        for (io.papermc.paper.datacomponent.DataComponentType api : exclude) {
            skippingTypes.add(PaperDataComponentType.bukkitToMinecraft(api));
        }
        return left.d().a(skippingTypes::contains).equals(right.d().a(skippingTypes::contains));
    }

    public String getDisplayName() {
        return this.getItemMeta().getDisplayName();
    }

    public void setDisplayName(String name) {
        ItemMeta itemMeta = this.getItemMeta();
        itemMeta.setDisplayName(name);
        this.setItemMeta(itemMeta);
    }

    public boolean hasDisplayName() {
        return this.hasItemMeta() && this.getItemMeta().hasDisplayName();
    }

    public String getLocalizedName() {
        return this.getItemMeta().getLocalizedName();
    }

    public void setLocalizedName(String name) {
        ItemMeta itemMeta = this.getItemMeta();
        itemMeta.setLocalizedName(name);
        this.setItemMeta(itemMeta);
    }

    public boolean hasLocalizedName() {
        return this.hasItemMeta() && this.getItemMeta().hasLocalizedName();
    }

    public boolean hasLore() {
        return this.hasItemMeta() && this.getItemMeta().hasLore();
    }

    public boolean hasEnchant(org.bukkit.enchantments.Enchantment ench) {
        return this.hasItemMeta() && this.getItemMeta().hasEnchant(ench);
    }

    public int getEnchantLevel(org.bukkit.enchantments.Enchantment ench) {
        return this.getItemMeta().getEnchantLevel(ench);
    }

    public Map<org.bukkit.enchantments.Enchantment, Integer> getEnchants() {
        return this.getItemMeta().getEnchants();
    }

    public boolean addEnchant(org.bukkit.enchantments.Enchantment ench, int level, boolean ignoreLevelRestriction) {
        ItemMeta itemMeta = this.getItemMeta();
        boolean result = itemMeta.addEnchant(ench, level, ignoreLevelRestriction);
        this.setItemMeta(itemMeta);
        return result;
    }

    public boolean removeEnchant(org.bukkit.enchantments.Enchantment ench) {
        ItemMeta itemMeta = this.getItemMeta();
        boolean result = itemMeta.removeEnchant(ench);
        this.setItemMeta(itemMeta);
        return result;
    }

    public boolean hasEnchants() {
        return this.hasItemMeta() && this.getItemMeta().hasEnchants();
    }

    public boolean hasConflictingEnchant(org.bukkit.enchantments.Enchantment ench) {
        return this.hasItemMeta() && this.getItemMeta().hasConflictingEnchant(ench);
    }

    public void setCustomModelData(Integer data) {
        ItemMeta itemMeta = this.getItemMeta();
        itemMeta.setCustomModelData(data);
        this.setItemMeta(itemMeta);
    }

    public int getCustomModelData() {
        return this.getItemMeta().getCustomModelData();
    }

    public boolean hasCustomModelData() {
        return this.hasItemMeta() && this.getItemMeta().hasCustomModelData();
    }

    public boolean hasBlockData() {
        return this.hasItemMeta() && ((BlockDataMeta)this.getItemMeta()).hasBlockData();
    }

    public BlockData getBlockData(Material material) {
        return ((BlockDataMeta)this.getItemMeta()).getBlockData(material);
    }

    public void setBlockData(BlockData blockData) {
        ItemMeta itemMeta = this.getItemMeta();
        ((BlockDataMeta)itemMeta).setBlockData(blockData);
        this.setItemMeta(itemMeta);
    }

    public int getRepairCost() {
        return ((Repairable)this.getItemMeta()).getRepairCost();
    }

    public void setRepairCost(int cost) {
        ItemMeta itemMeta = this.getItemMeta();
        ((Repairable)itemMeta).setRepairCost(cost);
        this.setItemMeta(itemMeta);
    }

    public boolean hasRepairCost() {
        return this.hasItemMeta() && ((Repairable)this.getItemMeta()).hasRepairCost();
    }

    public boolean isUnbreakable() {
        return this.hasItemMeta() && this.getItemMeta().isUnbreakable();
    }

    public void setUnbreakable(boolean unbreakable) {
        ItemMeta itemMeta = this.getItemMeta();
        itemMeta.setUnbreakable(unbreakable);
        this.setItemMeta(itemMeta);
    }

    public boolean hasAttributeModifiers() {
        return this.hasItemMeta() && this.getItemMeta().hasAttributeModifiers();
    }

    public Multimap<Attribute, AttributeModifier> getAttributeModifiers() {
        return this.getItemMeta().getAttributeModifiers();
    }

    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(EquipmentSlot slot) {
        return this.getItemMeta().getAttributeModifiers(slot);
    }

    public Collection<AttributeModifier> getAttributeModifiers(Attribute attribute) {
        return this.getItemMeta().getAttributeModifiers(attribute);
    }

    public boolean addAttributeModifier(Attribute attribute, AttributeModifier modifier) {
        ItemMeta itemMeta = this.getItemMeta();
        boolean result = itemMeta.addAttributeModifier(attribute, modifier);
        this.setItemMeta(itemMeta);
        return result;
    }

    public void setAttributeModifiers(Multimap<Attribute, AttributeModifier> attributeModifiers) {
        ItemMeta itemMeta = this.getItemMeta();
        itemMeta.setAttributeModifiers(attributeModifiers);
        this.setItemMeta(itemMeta);
    }

    public boolean removeAttributeModifier(Attribute attribute) {
        ItemMeta itemMeta = this.getItemMeta();
        boolean result = itemMeta.removeAttributeModifier(attribute);
        this.setItemMeta(itemMeta);
        return result;
    }

    public boolean removeAttributeModifier(EquipmentSlot slot) {
        ItemMeta itemMeta = this.getItemMeta();
        boolean result = itemMeta.removeAttributeModifier(slot);
        this.setItemMeta(itemMeta);
        return result;
    }

    public boolean removeAttributeModifier(Attribute attribute, AttributeModifier modifier) {
        ItemMeta itemMeta = this.getItemMeta();
        boolean result = itemMeta.removeAttributeModifier(attribute, modifier);
        this.setItemMeta(itemMeta);
        return result;
    }

    public boolean hasDamage() {
        return this.hasItemMeta() && ((Damageable)this.getItemMeta()).hasDamage();
    }

    public int getDamage() {
        return ((Damageable)this.getItemMeta()).getDamage();
    }

    public void setDamage(int damage) {
        ItemMeta itemMeta = this.getItemMeta();
        ((Damageable)itemMeta).setDamage(damage);
        this.setItemMeta(itemMeta);
    }

    public void repair() {
        this.repair(1);
    }

    public boolean damage() {
        return this.damage(1);
    }

    public void repair(int amount) {
        this.damage(-amount);
    }

    public boolean damage(int amount) {
        return this.damage(amount, false);
    }

    public boolean damage(int amount, boolean ignoreUnbreaking) {
        Damageable damageable = (Damageable)this.getItemMeta();
        if (amount > 0) {
            int unbreaking = this.getEnchantLevel(org.bukkit.enchantments.Enchantment.UNBREAKING);
            int reduce = 0;
            for (int i2 = 0; unbreaking > 0 && i2 < amount; ++i2) {
                if (!this.reduceDamage(ThreadLocalRandom.current(), unbreaking)) continue;
                ++reduce;
            }
            if ((amount -= reduce) <= 0) {
                return this.isBroke(damageable.getDamage());
            }
        }
        int damage = damageable.getDamage() + amount;
        damageable.setDamage(damage);
        this.setItemMeta((ItemMeta)damageable);
        return this.isBroke(damage);
    }

    private boolean isBroke(int damage) {
        if (damage > this.getType().getMaxDurability()) {
            if (this.getAmount() > 0) {
                this.setAmount(0);
            }
            return true;
        }
        return false;
    }

    private boolean reduceDamage(Random random, int unbreaking) {
        if (this.getType().isArmor()) {
            return random.nextFloat() < 0.6f;
        }
        return random.nextInt(unbreaking + 1) > 0;
    }

    static {
        try {
            API_ITEM_STACK_CRAFT_DELEGATE_FIELD = MethodHandles.privateLookupIn(ItemStack.class, MethodHandles.lookup()).findVarHandle(ItemStack.class, "craftDelegate", ItemStack.class);
        }
        catch (IllegalAccessException | NoSuchFieldException exception) {
            throw new RuntimeException(exception);
        }
        REGISTRY = new CraftPersistentDataTypeRegistry();
    }
}

