/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R6.inventory;

import com.google.common.base.Preconditions;
import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import io.papermc.paper.datacomponent.DataComponentType;
import io.papermc.paper.datacomponent.PaperDataComponentType;
import io.papermc.paper.registry.HolderableBase;
import io.papermc.paper.world.flag.PaperFeatureDependent;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.Registries;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.item.EnumItemRarity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemBlock;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import net.minecraft.world.level.IMaterial;
import net.minecraft.world.level.block.BlockComposter;
import net.minecraft.world.level.block.entity.FuelValues;
import org.bukkit.Material;
import org.bukkit.Registry;
import org.bukkit.World;
import org.bukkit.attribute.Attribute;
import org.bukkit.attribute.AttributeModifier;
import org.bukkit.block.BlockType;
import org.bukkit.craftbukkit.v1_21_R6.CraftEquipmentSlot;
import org.bukkit.craftbukkit.v1_21_R6.CraftRegistry;
import org.bukkit.craftbukkit.v1_21_R6.CraftWorld;
import org.bukkit.craftbukkit.v1_21_R6.attribute.CraftAttribute;
import org.bukkit.craftbukkit.v1_21_R6.attribute.CraftAttributeInstance;
import org.bukkit.craftbukkit.v1_21_R6.block.CraftBlockType;
import org.bukkit.craftbukkit.v1_21_R6.inventory.CraftItemMetas;
import org.bukkit.craftbukkit.v1_21_R6.inventory.CraftItemStack;
import org.bukkit.craftbukkit.v1_21_R6.inventory.CraftMetaItem;
import org.bukkit.craftbukkit.v1_21_R6.util.CraftMagicNumbers;
import org.bukkit.inventory.CreativeCategory;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemRarity;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.ItemType;
import org.bukkit.inventory.meta.ItemMeta;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

@NullMarked
public class CraftItemType<M extends ItemMeta>
extends HolderableBase<Item>
implements ItemType.Typed<M>,
PaperFeatureDependent<Item> {
    private final Supplier<CraftItemMetas.ItemMetaData<M>> itemMetaData = Suppliers.memoize(() -> CraftItemMetas.getItemMetaData(this));

    public static Material minecraftToBukkit(Item item) {
        return CraftMagicNumbers.getMaterial(item);
    }

    public static Item bukkitToMinecraft(Material material) {
        return CraftMagicNumbers.getItem(material);
    }

    public static ItemType minecraftToBukkitNew(Item minecraft) {
        return (ItemType)CraftRegistry.minecraftToBukkit(minecraft, Registries.O);
    }

    public static Item bukkitToMinecraftNew(ItemType bukkit) {
        return (Item)CraftRegistry.bukkitToMinecraft(bukkit);
    }

    public CraftItemType(Holder<Item> holder) {
        super(holder);
    }

    public ItemType.Typed<ItemMeta> typed() {
        return this.typed(ItemMeta.class);
    }

    public <Other extends ItemMeta> ItemType.Typed<Other> typed(Class<Other> itemMetaType) {
        if (itemMetaType.isAssignableFrom(this.itemMetaData.get().metaClass())) {
            return this;
        }
        throw new IllegalArgumentException("Cannot type item type " + String.valueOf(this) + " to meta type " + itemMetaType.getSimpleName());
    }

    public ItemStack createItemStack() {
        return this.createItemStack(1, null);
    }

    public ItemStack createItemStack(int amount) {
        return this.createItemStack(amount, null);
    }

    public ItemStack createItemStack(@Nullable Consumer<? super M> metaConfigurator) {
        return this.createItemStack(1, metaConfigurator);
    }

    public ItemStack createItemStack(int amount, @Nullable Consumer<? super M> metaConfigurator) {
        net.minecraft.world.item.ItemStack stack = new net.minecraft.world.item.ItemStack((IMaterial)this.getHandle(), amount);
        CraftItemStack mirror = CraftItemStack.asCraftMirror(stack);
        if (metaConfigurator != null) {
            mirror.editMeta(this.getItemMetaClass(), metaConfigurator);
        }
        return mirror;
    }

    public M getItemMeta(net.minecraft.world.item.ItemStack itemStack, Set<DataComponentType<?>> extraHandledDcts) {
        return (M)((ItemMeta)this.itemMetaData.get().fromItemStack().apply(itemStack, extraHandledDcts));
    }

    public M getItemMeta(ItemMeta itemMeta) {
        return (M)((ItemMeta)this.itemMetaData.get().fromItemMeta().apply(this, (CraftMetaItem)itemMeta));
    }

    public boolean hasBlockType() {
        return this.getHandle() instanceof ItemBlock;
    }

    public BlockType getBlockType() {
        Object m2 = this.getHandle();
        if (!(m2 instanceof ItemBlock)) {
            throw new IllegalStateException("The item type " + String.valueOf(this.getKey()) + " has no corresponding block type");
        }
        ItemBlock block = (ItemBlock)m2;
        return CraftBlockType.minecraftToBukkitNew(block.c());
    }

    public Class<M> getItemMetaClass() {
        if (this == ItemType.AIR) {
            throw new UnsupportedOperationException("Air does not have ItemMeta");
        }
        return this.itemMetaData.get().metaClass();
    }

    public int getMaxStackSize() {
        return ((Item)this.getHandle()).f().a(DataComponents.c, 64);
    }

    public short getMaxDurability() {
        return ((Item)this.getHandle()).f().a(DataComponents.d, 0).shortValue();
    }

    public boolean isEdible() {
        return ((Item)this.getHandle()).f().c(DataComponents.v);
    }

    public boolean isRecord() {
        return ((Item)this.getHandle()).f().c(DataComponents.ae);
    }

    public boolean isFuel() {
        return MinecraftServer.getServer().bw().a(new net.minecraft.world.item.ItemStack((IMaterial)this.getHandle()));
    }

    public int getBurnDuration() {
        net.minecraft.world.item.ItemStack stack;
        FuelValues fuelValues = MinecraftServer.getServer().bw();
        if (!fuelValues.a(stack = new net.minecraft.world.item.ItemStack((IMaterial)this.getHandle()))) {
            return 0;
        }
        return fuelValues.b(stack);
    }

    public boolean isCompostable() {
        return BlockComposter.f.containsKey(this.getHandle());
    }

    public float getCompostChance() {
        Preconditions.checkArgument((boolean)this.isCompostable(), (Object)("The item type " + String.valueOf(this.getKey()) + " is not compostable"));
        return BlockComposter.f.getFloat(this.getHandle());
    }

    public @Nullable ItemType getCraftingRemainingItem() {
        net.minecraft.world.item.ItemStack expectedItem = ((Item)this.getHandle()).i();
        return expectedItem.f() ? null : CraftItemType.minecraftToBukkitNew(expectedItem.h());
    }

    public Multimap<Attribute, AttributeModifier> getDefaultAttributeModifiers() {
        return this.getDefaultAttributeModifiers((EquipmentSlotGroup sg) -> true);
    }

    public Multimap<Attribute, AttributeModifier> getDefaultAttributeModifiers(EquipmentSlot slot) {
        EnumItemSlot nmsSlot = CraftEquipmentSlot.getNMS(slot);
        return this.getDefaultAttributeModifiers((EquipmentSlotGroup sg) -> sg.b(nmsSlot));
    }

    private Multimap<Attribute, AttributeModifier> getDefaultAttributeModifiers(Predicate<EquipmentSlotGroup> slotPredicate) {
        ImmutableMultimap.Builder defaultAttributes = ImmutableMultimap.builder();
        ItemAttributeModifiers nmsDefaultAttributes = ((Item)this.getHandle()).f().a(DataComponents.o, ItemAttributeModifiers.a);
        for (ItemAttributeModifiers.c entry : nmsDefaultAttributes.b()) {
            if (!slotPredicate.test(entry.c())) continue;
            Attribute attribute = CraftAttribute.minecraftHolderToBukkit(entry.a());
            AttributeModifier modifier = CraftAttributeInstance.convert(entry.b(), entry.c());
            defaultAttributes.put((Object)attribute, (Object)modifier);
        }
        return defaultAttributes.build();
    }

    public CreativeCategory getCreativeCategory() {
        return CreativeCategory.BUILDING_BLOCKS;
    }

    public boolean isEnabledByFeature(World world) {
        Preconditions.checkArgument((world != null ? 1 : 0) != 0, (Object)"World cannot be null");
        return ((Item)this.getHandle()).a(((CraftWorld)world).getHandle().O());
    }

    public String getTranslationKey() {
        return ((Item)this.getHandle()).j();
    }

    public @Nullable Material asMaterial() {
        return (Material)Registry.MATERIAL.get(this.getKey());
    }

    public String translationKey() {
        return ((Item)this.getHandle()).j();
    }

    public @Nullable ItemRarity getItemRarity() {
        EnumItemRarity rarity = ((Item)this.getHandle()).f().a(DataComponents.k);
        return rarity == null ? null : ItemRarity.valueOf((String)rarity.name());
    }

    public <T> @Nullable T getDefaultData(DataComponentType.Valued<T> type) {
        return (T)PaperDataComponentType.convertDataComponentValue(((Item)this.getHandle()).f(), (PaperDataComponentType.ValuedImpl)type);
    }

    public boolean hasDefaultData(io.papermc.paper.datacomponent.DataComponentType type) {
        return ((Item)this.getHandle()).f().c(PaperDataComponentType.bukkitToMinecraft(type));
    }

    public Set<io.papermc.paper.datacomponent.DataComponentType> getDefaultDataTypes() {
        return PaperDataComponentType.minecraftToBukkit(((Item)this.getHandle()).f().b());
    }
}

