/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R6.inventory;

import com.destroystokyo.paper.inventory.meta.ArmorStandMeta;
import com.google.common.collect.ImmutableMap;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Base64;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.NBTCompressedStreamTools;
import net.minecraft.nbt.NBTReadLimiter;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.item.component.TypedEntityData;
import org.bukkit.Material;
import org.bukkit.configuration.serialization.DelegateDeserialization;
import org.bukkit.craftbukkit.v1_21_R6.inventory.CraftMetaItem;
import org.bukkit.craftbukkit.v1_21_R6.inventory.SerializableMeta;

@DelegateDeserialization(value=SerializableMeta.class)
public class CraftMetaArmorStand
extends CraftMetaItem
implements ArmorStandMeta {
    static final CraftMetaItem.ItemMetaKeyType<TypedEntityData<EntityTypes<?>>> ENTITY_TAG = new CraftMetaItem.ItemMetaKeyType(DataComponents.Y, "entity-tag");
    static final CraftMetaItem.ItemMetaKey ENTITY_ID = new CraftMetaItem.ItemMetaKey("id", "entity-id");
    static final CraftMetaItem.ItemMetaKey INVISIBLE = new CraftMetaItem.ItemMetaKey("Invisible", "invisible");
    static final CraftMetaItem.ItemMetaKey NO_BASE_PLATE = new CraftMetaItem.ItemMetaKey("NoBasePlate", "no-base-plate");
    static final CraftMetaItem.ItemMetaKey SHOW_ARMS = new CraftMetaItem.ItemMetaKey("ShowArms", "show-arms");
    static final CraftMetaItem.ItemMetaKey SMALL = new CraftMetaItem.ItemMetaKey("Small", "small");
    static final CraftMetaItem.ItemMetaKey MARKER = new CraftMetaItem.ItemMetaKey("Marker", "marker");
    NBTTagCompound entityTag;

    CraftMetaArmorStand(CraftMetaItem meta) {
        super(meta);
        if (!(meta instanceof CraftMetaArmorStand)) {
            return;
        }
        CraftMetaArmorStand armorStand = (CraftMetaArmorStand)meta;
        this.entityTag = armorStand.entityTag;
    }

    CraftMetaArmorStand(DataComponentPatch tag, Set<DataComponentType<?>> extraHandledDcts) {
        super(tag, extraHandledDcts);
        CraftMetaArmorStand.getOrEmpty(tag, ENTITY_TAG).ifPresent(nbt -> {
            this.entityTag = nbt.copyTagWithEntityId();
        });
    }

    CraftMetaArmorStand(Map<String, Object> map) {
        super(map);
        String entityTag = SerializableMeta.getString(map, CraftMetaArmorStand.ENTITY_TAG.BUKKIT, true);
        if (entityTag != null) {
            ByteArrayInputStream buf = new ByteArrayInputStream(Base64.getDecoder().decode(entityTag));
            try {
                this.entityTag = NBTCompressedStreamTools.a(buf, NBTReadLimiter.a());
            }
            catch (IOException ex) {
                Logger.getLogger(CraftMetaItem.class.getName()).log(Level.SEVERE, null, ex);
            }
            return;
        }
        SerializableMeta.getObjectOptionally(Boolean.class, map, CraftMetaArmorStand.INVISIBLE.BUKKIT, true).ifPresent(value -> {
            this.populateTagIfNull();
            this.entityTag.a(CraftMetaArmorStand.INVISIBLE.NBT, (boolean)value);
        });
        SerializableMeta.getObjectOptionally(Boolean.class, map, CraftMetaArmorStand.NO_BASE_PLATE.BUKKIT, true).ifPresent(value -> {
            this.populateTagIfNull();
            this.entityTag.a(CraftMetaArmorStand.NO_BASE_PLATE.NBT, (boolean)value);
        });
        SerializableMeta.getObjectOptionally(Boolean.class, map, CraftMetaArmorStand.SHOW_ARMS.BUKKIT, true).ifPresent(value -> {
            this.populateTagIfNull();
            this.entityTag.a(CraftMetaArmorStand.SHOW_ARMS.NBT, (boolean)value);
        });
        SerializableMeta.getObjectOptionally(Boolean.class, map, CraftMetaArmorStand.SMALL.BUKKIT, true).ifPresent(value -> {
            this.populateTagIfNull();
            this.entityTag.a(CraftMetaArmorStand.SMALL.NBT, (boolean)value);
        });
        SerializableMeta.getObjectOptionally(Boolean.class, map, CraftMetaArmorStand.MARKER.BUKKIT, true).ifPresent(value -> {
            this.populateTagIfNull();
            this.entityTag.a(CraftMetaArmorStand.MARKER.NBT, (boolean)value);
        });
        SerializableMeta.getObjectOptionally(String.class, map, ENTITY_ID, true).ifPresent(value -> {
            this.populateTagIfNull();
            this.entityTag.a(CraftMetaArmorStand.ENTITY_ID.NBT, (String)value);
        });
    }

    @Override
    void deserializeInternal(NBTTagCompound tag, Object context) {
        super.deserializeInternal(tag, context);
        tag.m(CraftMetaArmorStand.ENTITY_TAG.NBT).ifPresent(entityTag -> {
            if (!entityTag.b(CraftMetaArmorStand.ENTITY_ID.NBT)) {
                entityTag.a(CraftMetaArmorStand.ENTITY_ID.NBT, EntityTypes.a(EntityTypes.h).toString());
            }
            this.entityTag = entityTag;
        });
    }

    @Override
    void applyToItem(CraftMetaItem.Applicator tag) {
        super.applyToItem(tag);
        if (this.entityTag != null) {
            tag.put(ENTITY_TAG, TypedEntityData.decodeEntity(this.entityTag));
        }
    }

    @Override
    boolean applicableTo(Material type) {
        return type == Material.ARMOR_STAND;
    }

    @Override
    boolean isEmpty() {
        return super.isEmpty() && this.isArmorStandEmpty();
    }

    boolean isArmorStandEmpty() {
        return this.entityTag == null || this.entityTag.i() == 1 && this.entityTag.b("id");
    }

    @Override
    boolean equalsCommon(CraftMetaItem meta) {
        if (!super.equalsCommon(meta)) {
            return false;
        }
        if (meta instanceof CraftMetaArmorStand) {
            CraftMetaArmorStand other = (CraftMetaArmorStand)meta;
            return Objects.equals(this.entityTag, other.entityTag);
        }
        return true;
    }

    @Override
    boolean notUncommon(CraftMetaItem meta) {
        return super.notUncommon(meta) && (meta instanceof CraftMetaArmorStand || this.isArmorStandEmpty());
    }

    @Override
    int applyHash() {
        int original;
        int hash = original = super.applyHash();
        if (this.entityTag != null) {
            hash = 73 * hash + this.entityTag.hashCode();
        }
        return original != hash ? CraftMetaArmorStand.class.hashCode() ^ hash : hash;
    }

    @Override
    ImmutableMap.Builder<String, Object> serialize(ImmutableMap.Builder<String, Object> builder) {
        super.serialize(builder);
        if (this.entityTag != null) {
            ByteArrayOutputStream buf = new ByteArrayOutputStream();
            try {
                NBTCompressedStreamTools.a(this.entityTag, buf);
            }
            catch (IOException ex) {
                Logger.getLogger(CraftMetaItem.class.getName()).log(Level.SEVERE, null, ex);
            }
            builder.put((Object)CraftMetaArmorStand.ENTITY_TAG.BUKKIT, (Object)Base64.getEncoder().encodeToString(buf.toByteArray()));
        }
        return builder;
    }

    @Override
    public CraftMetaArmorStand clone() {
        CraftMetaArmorStand clone = (CraftMetaArmorStand)super.clone();
        if (this.entityTag != null) {
            clone.entityTag = this.entityTag.l();
        }
        return clone;
    }

    private void populateTagIfNull() {
        if (this.entityTag == null) {
            this.entityTag = new NBTTagCompound();
            this.entityTag.a(CraftMetaArmorStand.ENTITY_ID.NBT, EntityTypes.a(EntityTypes.h).toString());
        }
    }

    public boolean isInvisible() {
        return this.entityTag != null && this.entityTag.b(CraftMetaArmorStand.INVISIBLE.NBT, false);
    }

    public boolean hasNoBasePlate() {
        return this.entityTag != null && this.entityTag.b(CraftMetaArmorStand.NO_BASE_PLATE.NBT, false);
    }

    public boolean shouldShowArms() {
        return this.entityTag != null && this.entityTag.b(CraftMetaArmorStand.SHOW_ARMS.NBT, false);
    }

    public boolean isSmall() {
        return this.entityTag != null && this.entityTag.b(CraftMetaArmorStand.SMALL.NBT, false);
    }

    public boolean isMarker() {
        return this.entityTag != null && this.entityTag.b(CraftMetaArmorStand.MARKER.NBT, false);
    }

    public void setInvisible(boolean invisible) {
        this.populateTagIfNull();
        this.entityTag.a(CraftMetaArmorStand.INVISIBLE.NBT, invisible);
    }

    public void setNoBasePlate(boolean noBasePlate) {
        this.populateTagIfNull();
        this.entityTag.a(CraftMetaArmorStand.NO_BASE_PLATE.NBT, noBasePlate);
    }

    public void setShowArms(boolean showArms) {
        this.populateTagIfNull();
        this.entityTag.a(CraftMetaArmorStand.SHOW_ARMS.NBT, showArms);
    }

    public void setSmall(boolean small) {
        this.populateTagIfNull();
        this.entityTag.a(CraftMetaArmorStand.SMALL.NBT, small);
    }

    public void setMarker(boolean marker) {
        this.populateTagIfNull();
        this.entityTag.a(CraftMetaArmorStand.MARKER.NBT, marker);
    }
}

