/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R6.inventory;

import com.google.common.base.Preconditions;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.item.alchemy.PotionRegistry;
import org.bukkit.Color;
import org.bukkit.configuration.serialization.DelegateDeserialization;
import org.bukkit.craftbukkit.v1_21_R6.inventory.CraftMetaItem;
import org.bukkit.craftbukkit.v1_21_R6.inventory.SerializableMeta;
import org.bukkit.craftbukkit.v1_21_R6.potion.CraftPotionEffectType;
import org.bukkit.craftbukkit.v1_21_R6.potion.CraftPotionType;
import org.bukkit.craftbukkit.v1_21_R6.potion.CraftPotionUtil;
import org.bukkit.inventory.meta.PotionMeta;
import org.bukkit.potion.PotionData;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.potion.PotionType;
import org.jetbrains.annotations.NotNull;

@DelegateDeserialization(value=SerializableMeta.class)
class CraftMetaPotion
extends CraftMetaItem
implements PotionMeta {
    static final CraftMetaItem.ItemMetaKeyType<PotionContents> POTION_CONTENTS = new CraftMetaItem.ItemMetaKeyType<PotionContents>(DataComponents.R);
    static final CraftMetaItem.ItemMetaKey POTION_EFFECTS = new CraftMetaItem.ItemMetaKey("custom-effects");
    static final CraftMetaItem.ItemMetaKey POTION_COLOR = new CraftMetaItem.ItemMetaKey("custom-color");
    static final CraftMetaItem.ItemMetaKey CUSTOM_NAME = new CraftMetaItem.ItemMetaKey("custom-name");
    static final CraftMetaItem.ItemMetaKey DEFAULT_POTION = new CraftMetaItem.ItemMetaKey("potion-type");
    private PotionType type;
    private List<PotionEffect> customEffects;
    private Integer color;
    private String customName;

    CraftMetaPotion(CraftMetaItem meta) {
        super(meta);
        if (!(meta instanceof CraftMetaPotion)) {
            return;
        }
        CraftMetaPotion potionMeta = (CraftMetaPotion)meta;
        this.type = potionMeta.type;
        this.color = potionMeta.color;
        this.customName = potionMeta.customName;
        if (potionMeta.hasCustomEffects()) {
            this.customEffects = new ArrayList<PotionEffect>(potionMeta.customEffects);
        }
    }

    CraftMetaPotion(DataComponentPatch tag, Set<DataComponentType<?>> extraHandledDcts) {
        super(tag, extraHandledDcts);
        CraftMetaPotion.getOrEmpty(tag, POTION_CONTENTS).ifPresent(potionContents -> {
            potionContents.e().ifPresent(potion -> {
                this.type = CraftPotionType.minecraftHolderToBukkit(potion);
            });
            potionContents.f().ifPresent(customColor -> {
                try {
                    this.color = customColor;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            });
            potionContents.g().ifPresent(name -> {
                this.customName = name;
            });
            List<MobEffect> list = potionContents.d();
            int length = list.size();
            this.customEffects = new ArrayList<PotionEffect>(length);
            for (int i2 = 0; i2 < length; ++i2) {
                MobEffect effect = list.get(i2);
                PotionEffectType type = CraftPotionEffectType.minecraftHolderToBukkit(effect.c());
                if (type == null) continue;
                int amp = effect.e();
                int duration = effect.d();
                boolean ambient = effect.f();
                boolean particles = effect.g();
                boolean icon = effect.h();
                this.customEffects.add(new PotionEffect(type, duration, amp, ambient, particles, icon));
            }
        });
    }

    CraftMetaPotion(Map<String, Object> map) {
        super(map);
        Iterable rawEffectList;
        String name;
        Color color;
        String typeString = SerializableMeta.getString(map, CraftMetaPotion.DEFAULT_POTION.BUKKIT, true);
        if (typeString != null) {
            this.type = CraftPotionType.stringToBukkit(typeString);
        }
        if ((color = SerializableMeta.getObject(Color.class, map, CraftMetaPotion.POTION_COLOR.BUKKIT, true)) != null) {
            this.setColor(color);
        }
        if ((name = SerializableMeta.getString(map, CraftMetaPotion.CUSTOM_NAME.BUKKIT, true)) != null) {
            this.setCustomPotionName(name);
        }
        if ((rawEffectList = SerializableMeta.getObject(Iterable.class, map, CraftMetaPotion.POTION_EFFECTS.BUKKIT, true)) == null) {
            return;
        }
        for (Object obj : rawEffectList) {
            Preconditions.checkArgument((boolean)(obj instanceof PotionEffect), (String)"Object (%s) in effect list is not valid", obj.getClass());
            this.addCustomEffect((PotionEffect)obj, true);
        }
    }

    @Override
    void applyToItem(CraftMetaItem.Applicator tag) {
        super.applyToItem(tag);
        if (this.isPotionEmpty()) {
            return;
        }
        Optional<Holder<PotionRegistry>> defaultPotion = this.hasBasePotionType() ? Optional.of(CraftPotionType.bukkitToMinecraftHolder(this.type)) : Optional.empty();
        Optional<Integer> potionColor = this.hasColor() ? Optional.of(this.color) : Optional.empty();
        Optional<String> customName = Optional.ofNullable(this.customName);
        ArrayList<MobEffect> effectList = new ArrayList<MobEffect>();
        if (this.customEffects != null) {
            for (PotionEffect effect : this.customEffects) {
                effectList.add(new MobEffect(CraftPotionEffectType.bukkitToMinecraftHolder(effect.getType()), effect.getDuration(), effect.getAmplifier(), effect.isAmbient(), effect.hasParticles(), effect.hasIcon()));
            }
        }
        tag.put(POTION_CONTENTS, new PotionContents(defaultPotion, potionColor, effectList, customName));
    }

    @Override
    boolean isEmpty() {
        return super.isEmpty() && this.isPotionEmpty();
    }

    boolean isPotionEmpty() {
        return this.type == null && !this.hasCustomEffects() && !this.hasColor() && !this.hasCustomPotionName();
    }

    @Override
    public CraftMetaPotion clone() {
        CraftMetaPotion clone = (CraftMetaPotion)super.clone();
        clone.type = this.type;
        if (this.customEffects != null) {
            clone.customEffects = new ArrayList<PotionEffect>(this.customEffects);
        }
        return clone;
    }

    public void setBasePotionData(PotionData data) {
        this.setBasePotionType(CraftPotionUtil.fromBukkit(data));
    }

    public PotionData getBasePotionData() {
        return CraftPotionUtil.toBukkit(this.getBasePotionType());
    }

    public void setBasePotionType(PotionType potionType) {
        this.type = potionType;
    }

    public PotionType getBasePotionType() {
        return this.type;
    }

    public boolean hasBasePotionType() {
        return this.type != null;
    }

    public boolean hasCustomEffects() {
        return this.customEffects != null && !this.customEffects.isEmpty();
    }

    public List<PotionEffect> getCustomEffects() {
        if (this.hasCustomEffects()) {
            return ImmutableList.copyOf(this.customEffects);
        }
        return ImmutableList.of();
    }

    @NotNull
    public List<PotionEffect> getAllEffects() {
        ImmutableList.Builder builder = ImmutableList.builder();
        if (this.hasBasePotionType()) {
            builder.addAll((Iterable)this.getBasePotionType().getPotionEffects());
        }
        if (this.hasCustomEffects()) {
            builder.addAll(this.customEffects);
        }
        return builder.build();
    }

    public boolean addCustomEffect(PotionEffect effect, boolean overwrite) {
        Preconditions.checkArgument((effect != null ? 1 : 0) != 0, (Object)"Potion effect cannot be null");
        int index = this.indexOfEffect(effect.getType());
        if (index != -1) {
            if (overwrite) {
                PotionEffect old = this.customEffects.get(index);
                if (old.getAmplifier() == effect.getAmplifier() && old.getDuration() == effect.getDuration() && old.isAmbient() == effect.isAmbient()) {
                    return false;
                }
                this.customEffects.set(index, effect);
                return true;
            }
            return false;
        }
        if (this.customEffects == null) {
            this.customEffects = new ArrayList<PotionEffect>();
        }
        this.customEffects.add(effect);
        return true;
    }

    public boolean removeCustomEffect(PotionEffectType type) {
        Preconditions.checkArgument((type != null ? 1 : 0) != 0, (Object)"Potion effect type cannot be null");
        if (!this.hasCustomEffects()) {
            return false;
        }
        boolean changed = false;
        Iterator<PotionEffect> iterator = this.customEffects.iterator();
        while (iterator.hasNext()) {
            PotionEffect effect = iterator.next();
            if (!type.equals(effect.getType())) continue;
            iterator.remove();
            changed = true;
        }
        if (this.customEffects.isEmpty()) {
            this.customEffects = null;
        }
        return changed;
    }

    public boolean hasCustomEffect(PotionEffectType type) {
        Preconditions.checkArgument((type != null ? 1 : 0) != 0, (Object)"Potion effect type cannot be null");
        return this.indexOfEffect(type) != -1;
    }

    public boolean setMainEffect(PotionEffectType type) {
        Preconditions.checkArgument((type != null ? 1 : 0) != 0, (Object)"Potion effect type cannot be null");
        int index = this.indexOfEffect(type);
        if (index == -1 || index == 0) {
            return false;
        }
        PotionEffect old = this.customEffects.get(0);
        this.customEffects.set(0, this.customEffects.get(index));
        this.customEffects.set(index, old);
        return true;
    }

    private int indexOfEffect(PotionEffectType type) {
        if (!this.hasCustomEffects()) {
            return -1;
        }
        for (int i2 = 0; i2 < this.customEffects.size(); ++i2) {
            if (!this.customEffects.get(i2).getType().equals(type)) continue;
            return i2;
        }
        return -1;
    }

    public boolean clearCustomEffects() {
        boolean changed = this.hasCustomEffects();
        this.customEffects = null;
        return changed;
    }

    public boolean hasColor() {
        return this.color != null;
    }

    public Color getColor() {
        return this.color == null ? null : Color.fromRGB((int)(this.color & 0xFFFFFF));
    }

    public void setColor(Color color) {
        this.color = color == null ? null : Integer.valueOf(color.asRGB());
    }

    @NotNull
    public Color computeEffectiveColor() {
        if (this.hasColor()) {
            return this.getColor();
        }
        return Color.fromRGB((int)(PotionContents.a(Collections2.transform(this.getAllEffects(), CraftPotionUtil::fromBukkit)).orElse(-13083194) & 0xFFFFFF));
    }

    public boolean hasCustomPotionName() {
        return this.customName != null;
    }

    public String getCustomPotionName() {
        return this.customName;
    }

    public void setCustomPotionName(String customName) {
        Preconditions.checkArgument((customName == null || customName.length() <= Short.MAX_VALUE ? 1 : 0) != 0, (Object)"Custom name is longer than 32767 characters");
        this.customName = customName;
    }

    @Override
    int applyHash() {
        int original;
        int hash = original = super.applyHash();
        if (this.type != null) {
            hash = 73 * hash + this.type.hashCode();
        }
        if (this.hasColor()) {
            hash = 73 * hash + this.color.hashCode();
        }
        if (this.hasCustomPotionName()) {
            hash = 73 * hash + this.customName.hashCode();
        }
        if (this.hasCustomEffects()) {
            hash = 73 * hash + this.customEffects.hashCode();
        }
        return original != hash ? CraftMetaPotion.class.hashCode() ^ hash : hash;
    }

    @Override
    public boolean equalsCommon(CraftMetaItem meta) {
        if (!super.equalsCommon(meta)) {
            return false;
        }
        if (meta instanceof CraftMetaPotion) {
            CraftMetaPotion other = (CraftMetaPotion)meta;
            return Objects.equals(this.type, other.type) && (this.hasCustomEffects() ? other.hasCustomEffects() && this.customEffects.equals(other.customEffects) : !other.hasCustomEffects()) && Objects.equals(this.color, other.color) && Objects.equals(this.customName, other.customName);
        }
        return true;
    }

    @Override
    boolean notUncommon(CraftMetaItem meta) {
        return super.notUncommon(meta) && (meta instanceof CraftMetaPotion || this.isPotionEmpty());
    }

    @Override
    ImmutableMap.Builder<String, Object> serialize(ImmutableMap.Builder<String, Object> builder) {
        super.serialize(builder);
        if (this.type != null) {
            builder.put((Object)CraftMetaPotion.DEFAULT_POTION.BUKKIT, (Object)CraftPotionType.bukkitToString(this.type));
        }
        if (this.hasColor()) {
            builder.put((Object)CraftMetaPotion.POTION_COLOR.BUKKIT, (Object)this.getColor());
        }
        if (this.hasCustomPotionName()) {
            builder.put((Object)CraftMetaPotion.CUSTOM_NAME.BUKKIT, (Object)this.getCustomPotionName());
        }
        if (this.hasCustomEffects()) {
            builder.put((Object)CraftMetaPotion.POTION_EFFECTS.BUKKIT, (Object)ImmutableList.copyOf(this.customEffects));
        }
        return builder;
    }
}

