/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R6.inventory.components;

import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.ResourceKey;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.item.equipment.EquipmentAssets;
import net.minecraft.world.item.equipment.Equippable;
import org.bukkit.Keyed;
import org.bukkit.NamespacedKey;
import org.bukkit.Registry;
import org.bukkit.Sound;
import org.bukkit.Tag;
import org.bukkit.configuration.serialization.SerializableAs;
import org.bukkit.craftbukkit.v1_21_R6.CraftEquipmentSlot;
import org.bukkit.craftbukkit.v1_21_R6.CraftSound;
import org.bukkit.craftbukkit.v1_21_R6.configuration.ConfigSerializationUtil;
import org.bukkit.craftbukkit.v1_21_R6.entity.CraftEntityType;
import org.bukkit.craftbukkit.v1_21_R6.inventory.SerializableMeta;
import org.bukkit.craftbukkit.v1_21_R6.tag.CraftEntityTag;
import org.bukkit.craftbukkit.v1_21_R6.util.CraftNamespacedKey;
import org.bukkit.entity.EntityType;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.meta.components.EquippableComponent;

@SerializableAs(value="Equippable")
public final class CraftEquippableComponent
implements EquippableComponent {
    private Equippable handle;

    public CraftEquippableComponent(Equippable handle) {
        this.handle = handle;
    }

    public CraftEquippableComponent(CraftEquippableComponent craft) {
        this.handle = craft.handle;
    }

    public CraftEquippableComponent(Map<String, Object> map) {
        EnumItemSlot slot = CraftEquipmentSlot.getNMS(EquipmentSlot.valueOf((String)SerializableMeta.getString(map, "slot", false)));
        Sound equipSound = null;
        String equipSoundKey = SerializableMeta.getString(map, "equip-sound", true);
        if (equipSoundKey != null) {
            equipSound = (Sound)Registry.SOUNDS.get(NamespacedKey.fromString((String)equipSoundKey));
        }
        String model = SerializableMeta.getString(map, "model", true);
        String cameraOverlay = SerializableMeta.getString(map, "camera-overlay", true);
        HolderSet allowedEntities = null;
        Object allowed = SerializableMeta.getObject(Object.class, map, "allowed-entities", true);
        if (allowed != null) {
            allowedEntities = ConfigSerializationUtil.getHolderSet(allowed, Registries.E);
        }
        Boolean dispensable = SerializableMeta.getObject(Boolean.class, map, "dispensable", true);
        Boolean swappable = SerializableMeta.getObject(Boolean.class, map, "swappable", true);
        Boolean damageOnHurt = SerializableMeta.getObject(Boolean.class, map, "damage-on-hurt", true);
        Boolean equipOnInteract = SerializableMeta.getObject(Boolean.class, map, "equip-on-interact", true);
        this.handle = new Equippable(slot, equipSound != null ? CraftSound.bukkitToMinecraftHolder(equipSound) : SoundEffects.as, Optional.ofNullable(model).map(MinecraftKey::a).map(k2 -> ResourceKey.a(EquipmentAssets.a, k2)), Optional.ofNullable(cameraOverlay).map(MinecraftKey::a), Optional.ofNullable(allowedEntities), dispensable != null ? dispensable : true, swappable != null ? swappable : true, damageOnHurt != null ? damageOnHurt : true, equipOnInteract != null ? equipOnInteract : false, false, BuiltInRegistries.b.e(SoundEffects.yw));
    }

    public Map<String, Object> serialize() {
        NamespacedKey cameraOverlay;
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        result.put("slot", this.getSlot().name());
        result.put("equip-sound", Registry.SOUND_EVENT.getKeyOrThrow((Keyed)this.getEquipSound()).toString());
        NamespacedKey model = this.getModel();
        if (model != null) {
            result.put("model", model.toString());
        }
        if ((cameraOverlay = this.getCameraOverlay()) != null) {
            result.put("camera-overlay", cameraOverlay.toString());
        }
        this.handle.f().ifPresent(holders -> ConfigSerializationUtil.setHolderSet(result, "allowed-entities", holders));
        result.put("dispensable", this.isDispensable());
        result.put("swappable", this.isSwappable());
        result.put("damage-on-hurt", this.isDamageOnHurt());
        result.put("equip-on-interact", this.isEquipOnInteract());
        return result;
    }

    public Equippable getHandle() {
        return this.handle;
    }

    public EquipmentSlot getSlot() {
        return CraftEquipmentSlot.getSlot(this.handle.b());
    }

    public void setSlot(EquipmentSlot slot) {
        this.handle = new Equippable(CraftEquipmentSlot.getNMS(slot), this.handle.c(), this.handle.d(), this.handle.e(), this.handle.f(), this.handle.g(), this.handle.h(), this.handle.i(), this.handle.j(), this.handle.k(), this.handle.l());
    }

    public Sound getEquipSound() {
        return CraftSound.minecraftToBukkit(this.handle.c().a());
    }

    public void setEquipSound(Sound sound) {
        this.handle = new Equippable(this.handle.b(), sound != null ? CraftSound.bukkitToMinecraftHolder(sound) : SoundEffects.as, this.handle.d(), this.handle.e(), this.handle.f(), this.handle.g(), this.handle.h(), this.handle.i(), this.handle.j(), this.handle.k(), this.handle.l());
    }

    public NamespacedKey getModel() {
        return this.handle.d().map(a2 -> CraftNamespacedKey.fromMinecraft(a2.a())).orElse(null);
    }

    public void setModel(NamespacedKey key) {
        this.handle = new Equippable(this.handle.b(), this.handle.c(), Optional.ofNullable(key).map(CraftNamespacedKey::toMinecraft).map(k2 -> ResourceKey.a(EquipmentAssets.a, k2)), this.handle.e(), this.handle.f(), this.handle.g(), this.handle.h(), this.handle.i(), this.handle.j(), this.handle.k(), this.handle.l());
    }

    public NamespacedKey getCameraOverlay() {
        return this.handle.e().map(CraftNamespacedKey::fromMinecraft).orElse(null);
    }

    public void setCameraOverlay(NamespacedKey key) {
        this.handle = new Equippable(this.handle.b(), this.handle.c(), this.handle.d(), Optional.ofNullable(key).map(CraftNamespacedKey::toMinecraft), this.handle.f(), this.handle.g(), this.handle.h(), this.handle.i(), this.handle.j(), this.handle.k(), this.handle.l());
    }

    public Collection<EntityType> getAllowedEntities() {
        return this.handle.f().map(HolderSet::a).map(stream -> stream.map(Holder::a).map(CraftEntityType::minecraftToBukkit).collect(Collectors.toList())).orElse(null);
    }

    public void setAllowedEntities(EntityType entities) {
        this.handle = new Equippable(this.handle.b(), this.handle.c(), this.handle.d(), this.handle.e(), entities != null ? Optional.of(HolderSet.a(CraftEntityType.bukkitToMinecraftHolder(entities))) : Optional.empty(), this.handle.g(), this.handle.h(), this.handle.i(), this.handle.j(), this.handle.k(), this.handle.l());
    }

    public void setAllowedEntities(Collection<EntityType> entities) {
        this.handle = new Equippable(this.handle.b(), this.handle.c(), this.handle.d(), this.handle.e(), entities != null ? Optional.of(HolderSet.a(entities.stream().map(CraftEntityType::bukkitToMinecraftHolder).collect(Collectors.toList()))) : Optional.empty(), this.handle.g(), this.handle.h(), this.handle.i(), this.handle.j(), this.handle.k(), this.handle.l());
    }

    public void setAllowedEntities(Tag<EntityType> tag) {
        Preconditions.checkArgument((tag == null || tag instanceof CraftEntityTag ? 1 : 0) != 0, (Object)"tag must be an entity tag");
        this.handle = new Equippable(this.handle.b(), this.handle.c(), this.handle.d(), this.handle.e(), tag != null ? Optional.of(((CraftEntityTag)tag).getHandle()) : Optional.empty(), this.handle.g(), this.handle.h(), this.handle.i(), this.handle.j(), this.handle.k(), this.handle.l());
    }

    public boolean isDispensable() {
        return this.handle.g();
    }

    public void setDispensable(boolean dispensable) {
        this.handle = new Equippable(this.handle.b(), this.handle.c(), this.handle.d(), this.handle.e(), this.handle.f(), dispensable, this.handle.h(), this.handle.i(), this.handle.j(), this.handle.k(), this.handle.l());
    }

    public boolean isSwappable() {
        return this.handle.h();
    }

    public void setSwappable(boolean swappable) {
        this.handle = new Equippable(this.handle.b(), this.handle.c(), this.handle.d(), this.handle.e(), this.handle.f(), this.handle.g(), swappable, this.handle.i(), this.handle.j(), this.handle.k(), this.handle.l());
    }

    public boolean isDamageOnHurt() {
        return this.handle.i();
    }

    public void setDamageOnHurt(boolean damage) {
        this.handle = new Equippable(this.handle.b(), this.handle.c(), this.handle.d(), this.handle.e(), this.handle.f(), this.handle.g(), this.handle.h(), damage, this.handle.j(), this.handle.k(), this.handle.l());
    }

    public boolean isEquipOnInteract() {
        return this.handle.j();
    }

    public void setEquipOnInteract(boolean equip) {
        this.handle = new Equippable(this.handle.b(), this.handle.c(), this.handle.d(), this.handle.e(), this.handle.f(), this.handle.g(), this.handle.h(), this.handle.i(), equip, this.handle.k(), this.handle.l());
    }

    public int hashCode() {
        int hash = 7;
        hash = 19 * hash + this.handle.hashCode();
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        CraftEquippableComponent other = (CraftEquippableComponent)obj;
        return this.handle.equals(other.handle);
    }

    public String toString() {
        return "CraftEquippableComponent{component" + String.valueOf(this.handle) + "}";
    }
}

