/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R6.inventory.components;

import com.google.common.base.Preconditions;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.world.item.component.UseCooldown;
import org.bukkit.NamespacedKey;
import org.bukkit.configuration.serialization.SerializableAs;
import org.bukkit.craftbukkit.v1_21_R6.inventory.SerializableMeta;
import org.bukkit.craftbukkit.v1_21_R6.util.CraftNamespacedKey;
import org.bukkit.inventory.meta.components.UseCooldownComponent;

@SerializableAs(value="UseCooldown")
public final class CraftUseCooldownComponent
implements UseCooldownComponent {
    private UseCooldown handle;

    public CraftUseCooldownComponent(UseCooldown cooldown) {
        this.handle = cooldown;
    }

    public CraftUseCooldownComponent(CraftUseCooldownComponent food) {
        this.handle = food.handle;
    }

    public CraftUseCooldownComponent(Map<String, Object> map) {
        Float seconds = SerializableMeta.getObject(Float.class, map, "seconds", false);
        String cooldownGroup = SerializableMeta.getString(map, "cooldown-group", true);
        this.handle = new UseCooldown(seconds.floatValue(), Optional.ofNullable(cooldownGroup).map(MinecraftKey::a));
    }

    public Map<String, Object> serialize() {
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        result.put("seconds", Float.valueOf(this.getCooldownSeconds()));
        if (this.getCooldownGroup() != null) {
            result.put("cooldown-group", this.getCooldownGroup().toString());
        }
        return result;
    }

    public UseCooldown getHandle() {
        return this.handle;
    }

    public float getCooldownSeconds() {
        return this.handle.b();
    }

    public void setCooldownSeconds(float cooldown) {
        Preconditions.checkArgument((cooldown > 0.0f ? 1 : 0) != 0, (Object)"cooldown must be greater than 0");
        this.handle = new UseCooldown(cooldown, this.handle.c());
    }

    public NamespacedKey getCooldownGroup() {
        return this.handle.c().map(CraftNamespacedKey::fromMinecraft).orElse(null);
    }

    public void setCooldownGroup(NamespacedKey song) {
        this.handle = new UseCooldown(this.handle.b(), Optional.ofNullable(song).map(CraftNamespacedKey::toMinecraft));
    }

    public int hashCode() {
        int hash = 7;
        hash = 73 * hash + this.handle.hashCode();
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        CraftUseCooldownComponent other = (CraftUseCooldownComponent)obj;
        return this.handle.equals(other.handle);
    }

    public String toString() {
        return "CraftUseCooldownComponent{component=" + String.valueOf(this.handle) + "}";
    }
}

