/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R6.inventory.tags;

import com.google.common.base.Preconditions;
import org.bukkit.craftbukkit.v1_21_R6.inventory.tags.DeprecatedCustomTagContainer;
import org.bukkit.craftbukkit.v1_21_R6.inventory.tags.DeprecatedItemAdapterContext;
import org.bukkit.craftbukkit.v1_21_R6.persistence.CraftPersistentDataContainer;
import org.bukkit.inventory.meta.tags.CustomItemTagContainer;
import org.bukkit.inventory.meta.tags.ItemTagAdapterContext;
import org.bukkit.inventory.meta.tags.ItemTagType;
import org.bukkit.persistence.PersistentDataAdapterContext;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;
import org.jetbrains.annotations.NotNull;

public final class DeprecatedContainerTagType<C>
implements PersistentDataType<PersistentDataContainer, C> {
    private final ItemTagType<CustomItemTagContainer, C> deprecated;

    DeprecatedContainerTagType(ItemTagType<CustomItemTagContainer, C> deprecated) {
        this.deprecated = deprecated;
    }

    @NotNull
    public Class<PersistentDataContainer> getPrimitiveType() {
        return PersistentDataContainer.class;
    }

    @NotNull
    public Class<C> getComplexType() {
        return this.deprecated.getComplexType();
    }

    @NotNull
    public PersistentDataContainer toPrimitive(@NotNull C complex, @NotNull PersistentDataAdapterContext context) {
        CustomItemTagContainer deprecated = (CustomItemTagContainer)this.deprecated.toPrimitive(complex, (ItemTagAdapterContext)new DeprecatedItemAdapterContext(context));
        Preconditions.checkArgument((boolean)(deprecated instanceof DeprecatedCustomTagContainer), (String)"Could not wrap deprecated API due to foreign CustomItemTagContainer implementation %s", (Object)deprecated.getClass().getSimpleName());
        DeprecatedCustomTagContainer tagContainer = (DeprecatedCustomTagContainer)deprecated;
        PersistentDataContainer wrapped = tagContainer.getWrapped();
        Preconditions.checkArgument((boolean)(wrapped instanceof CraftPersistentDataContainer), (String)"Could not wrap deprecated API due to wrong deprecation wrapper %s", (Object)deprecated.getClass().getSimpleName());
        CraftPersistentDataContainer craftTagContainer = (CraftPersistentDataContainer)wrapped;
        return new CraftPersistentDataContainer(craftTagContainer.getRaw(), craftTagContainer.getDataTagTypeRegistry());
    }

    @NotNull
    public C fromPrimitive(@NotNull PersistentDataContainer primitive, @NotNull PersistentDataAdapterContext context) {
        Preconditions.checkArgument((boolean)(primitive instanceof CraftPersistentDataContainer), (String)"Could not wrap deprecated API due to foreign PersistentMetadataContainer implementation %s", (Object)primitive.getClass().getSimpleName());
        return (C)this.deprecated.fromPrimitive((Object)new DeprecatedCustomTagContainer(primitive), (ItemTagAdapterContext)new DeprecatedItemAdapterContext(context));
    }
}

