/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R6.inventory.view.builder;

import net.minecraft.core.BlockPosition;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.world.ITileInventory;
import net.minecraft.world.inventory.Container;
import net.minecraft.world.inventory.Containers;
import net.minecraft.world.inventory.ITileEntityContainer;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.state.IBlockData;
import org.bukkit.craftbukkit.v1_21_R6.inventory.view.builder.CraftAbstractLocationInventoryViewBuilder;
import org.bukkit.inventory.InventoryView;
import org.bukkit.inventory.view.builder.LocationInventoryViewBuilder;
import org.jspecify.annotations.Nullable;

public class CraftBlockEntityInventoryViewBuilder<V extends InventoryView>
extends CraftAbstractLocationInventoryViewBuilder<V> {
    private final Block block;
    private final boolean useFakeBlockEntity;
    private final @Nullable CraftBlockInventoryBuilder builder;

    public CraftBlockEntityInventoryViewBuilder(Containers<?> handle, Block block, @Nullable CraftBlockInventoryBuilder builder) {
        this(handle, block, builder, true);
    }

    public CraftBlockEntityInventoryViewBuilder(Containers<?> handle, Block block, @Nullable CraftBlockInventoryBuilder builder, boolean useFakeBlockEntity) {
        super(handle);
        this.useFakeBlockEntity = useFakeBlockEntity;
        this.block = block;
        this.builder = builder;
    }

    @Override
    protected Container buildContainer(EntityPlayer player) {
        if (this.world == null) {
            this.world = player.A();
        }
        if (this.position == null) {
            this.position = player.dF();
            return this.buildFakeBlockEntity(player);
        }
        TileEntity entity = this.world.c_(this.position);
        if (!(entity instanceof ITileEntityContainer)) {
            return this.buildFakeBlockEntity(player);
        }
        ITileEntityContainer container = (ITileEntityContainer)((Object)entity);
        Container atBlock = container.createMenu(player.nextContainerCounter(), player.gB(), player);
        if (atBlock.a() != this.handle) {
            return this.buildFakeBlockEntity(player);
        }
        if (!(entity instanceof ITileInventory)) {
            throw new IllegalStateException("Provided blockEntity during MenuType creation can not find a default title! This is a bug!");
        }
        ITileInventory provider = (ITileInventory)((Object)entity);
        this.defaultTitle = provider.S_();
        return atBlock;
    }

    private Container buildFakeBlockEntity(EntityPlayer player) {
        ITileInventory inventory = this.builder.build(this.position, this.block.m());
        if (inventory instanceof TileEntity) {
            TileEntity blockEntity = (TileEntity)((Object)inventory);
            blockEntity.a(this.world);
            this.defaultTitle = inventory.S_();
        }
        if (!this.useFakeBlockEntity) {
            return this.handle.a(player.nextContainerCounter(), player.gB());
        }
        return inventory.createMenu(player.nextContainerCounter(), player.gB(), player);
    }

    @Override
    public LocationInventoryViewBuilder<V> copy() {
        CraftBlockEntityInventoryViewBuilder<V> copy = new CraftBlockEntityInventoryViewBuilder<V>(this.handle, this.block, this.builder, this.useFakeBlockEntity);
        copy.world = this.world;
        copy.position = this.position;
        copy.checkReachable = this.checkReachable;
        copy.title = this.title;
        return copy;
    }

    public static interface CraftBlockInventoryBuilder {
        public ITileInventory build(BlockPosition var1, IBlockData var2);
    }
}

